/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNamedTupleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeCheckerExtension;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyTypingNewType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypeChecker {
    private PyTypeChecker() {
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(0);
        }
        return PyTypeChecker.match(expected, actual, new MatchContext(context, new HashMap<PyGenericType, PyType>())).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull Map<PyGenericType, PyType> substitutions) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(1);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(2);
        }
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions)).orElse(true);
    }

    @NotNull
    private static Optional<Boolean> match(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> result;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(3);
        }
        Optional<Boolean> optional = (result = (Optional<Boolean>)RecursionManager.doPreventingRecursion((Object)com.intellij.openapi.util.Pair.create((Object)expected, (Object)actual), (boolean)false, () -> PyTypeChecker.matchImpl(expected, actual, context))) == null ? Optional.of(true) : result;
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(4);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchImpl(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        PyCallableType actualCallable;
        PyCallableType expectedCallable;
        Optional<Boolean> match;
        Optional<Boolean> match2;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(5);
        }
        for (PyTypeCheckerExtension extension : PyTypeCheckerExtension.EP_NAME.getExtensionList()) {
            Optional<Boolean> result = extension.match(expected, actual, context.context, context.substitutions);
            if (!result.isPresent()) continue;
            Optional<Boolean> optional = result;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(6);
            }
            return optional;
        }
        if (expected instanceof PyClassType && (match2 = PyTypeChecker.matchObject((PyClassType)expected, actual)).isPresent()) {
            Optional<Boolean> optional = match2;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(7);
            }
            return optional;
        }
        if (actual instanceof PyGenericType && context.reversedSubstitutions) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyGenericType)actual, expected, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(8);
            }
            return optional;
        }
        if (expected instanceof PyGenericType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyGenericType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(9);
            }
            return optional;
        }
        if (expected == null || actual == null || PyTypeChecker.isUnknown(actual, context.context)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(10);
            }
            return optional;
        }
        if (actual instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(expected, (PyUnionType)actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(11);
            }
            return optional;
        }
        if (expected instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyUnionType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(12);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyClassType && (match2 = PyTypeChecker.match((PyClassType)expected, (PyClassType)actual, context)).isPresent()) {
            Optional<Boolean> optional = match2;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(13);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && ((PyStructuralType)actual).isInferredFromUsages()) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(14);
            }
            return optional;
        }
        if (expected instanceof PyStructuralType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyStructuralType)expected, actual, context.context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(15);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && expected instanceof PyClassType) {
            Set<String> expectedAttributes = ((PyClassType)expected).getMemberNames(true, context.context);
            Optional<Boolean> optional = Optional.of(expectedAttributes.containsAll(((PyStructuralType)actual).getAttributeNames()));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(16);
            }
            return optional;
        }
        if (actual instanceof PyCallableType && expected instanceof PyCallableType && (match = PyTypeChecker.match(expectedCallable = (PyCallableType)expected, actualCallable = (PyCallableType)actual, context)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(17);
            }
            return optional;
        }
        if (expected instanceof PyNoneType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyNoneType);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(18);
            }
            return optional;
        }
        if (expected instanceof PyModuleType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyModuleType && ((PyModuleType)expected).getModule() == ((PyModuleType)actual).getModule());
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(19);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyModuleType) {
            return PyTypeChecker.match(expected, (PyType)((PyModuleType)actual).getModuleClassType(), context);
        }
        Optional<Boolean> optional = Optional.of(PyTypeChecker.matchNumericTypes(expected, actual));
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(20);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchObject(@NotNull PyClassType expected, @Nullable PyType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(21);
        }
        if (ArrayUtil.contains((String)expected.getName(), (String[])new String[]{"object", "type"})) {
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)expected.getPyClass());
            if (expected.equals(builtinCache.getObjectType())) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(22);
                }
                return optional;
            }
            if (expected.equals(builtinCache.getTypeType()) && actual instanceof PyInstantiableType && ((PyInstantiableType)actual).isDefinition()) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(23);
                }
                return optional;
            }
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(24);
        }
        return optional;
    }

    private static boolean match(@NotNull PyGenericType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(26);
        }
        if (expected.isDefinition() && actual instanceof PyInstantiableType && !((PyInstantiableType)actual).isDefinition()) {
            return false;
        }
        PyType substitution = context.substitutions.get(expected);
        PyType bound = expected.getBound();
        if (expected.isDefinition()) {
            Function<PyType, PyType> toDefinition = t -> t instanceof PyInstantiableType ? ((PyInstantiableType)t).toClass() : t;
            bound = PyUnionType.union(PyTypeUtil.toStream(bound).map(toDefinition).toList());
        }
        if ((match = PyTypeChecker.match(bound, actual, context)).isPresent() && !match.get().booleanValue()) {
            return false;
        }
        if (substitution != null) {
            if (expected.equals(actual) || substitution.equals(expected)) {
                return true;
            }
            Optional recursiveMatch = (Optional)RecursionManager.doPreventingRecursion((Object)expected, (boolean)false, (Computable)(context.reversedSubstitutions ? () -> PyTypeChecker.match(actual, substitution, context) : () -> PyTypeChecker.match(substitution, actual, context)));
            return recursiveMatch != null ? recursiveMatch.orElse(false) : false;
        }
        if (actual != null) {
            context.substitutions.put(expected, actual);
        } else if (bound != null) {
            context.substitutions.put(expected, PyUnionType.createWeakType(bound));
        }
        return true;
    }

    private static boolean match(@NotNull PyType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(27);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(28);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(29);
        }
        if (expected instanceof PyTupleType && (match = PyTypeChecker.match((PyTupleType)expected, actual, context)).isPresent()) {
            return match.get();
        }
        return ContainerUtil.or(actual.getMembers(), type -> PyTypeChecker.match(expected, type, context).orElse(false));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(30);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(32);
        }
        int elementCount = expected.getElementCount();
        if (!expected.isHomogeneous() && PyTypeChecker.consistsOfSameElementNumberTuples(actual, elementCount)) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.substituteExpectedElementsWithUnions(expected, elementCount, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(33);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(34);
        }
        return optional;
    }

    private static boolean match(@NotNull PyUnionType expected, @NotNull PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(35);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(36);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(37);
        }
        return ContainerUtil.or(expected.getMembers(), type -> PyTypeChecker.match(type, actual, context).orElse(true));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(38);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(39);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(40);
        }
        if (expected.equals(actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(41);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected.isDefinition() ^ actual.isDefinition() && !PyProtocolsKt.isProtocol(expected, context)) {
            if (!expected.isDefinition() && actual.isDefinition()) {
                PyClassLikeType metaClass = actual.getMetaClassType(context, true);
                Optional<Boolean> optional = Optional.of(metaClass != null && PyTypeChecker.match((PyType)expected, metaClass.toInstance(), matchContext).orElse(true) != false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(42);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(43);
            }
            return optional;
        }
        if (expected instanceof PyTupleType && actual instanceof PyTupleType) {
            return PyTypeChecker.match((PyTupleType)expected, (PyTupleType)actual, matchContext);
        }
        if (expected instanceof PyLiteralType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyLiteralType && PyLiteralType.Companion.match((PyLiteralType)expected, (PyLiteralType)actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(44);
            }
            return optional;
        }
        if (actual instanceof PyTypedDictType && (match = PyTypedDictType.Companion.match(expected, (PyTypedDictType)actual, context)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(45);
            }
            return optional;
        }
        PyClass superClass = expected.getPyClass();
        PyClass subClass = actual.getPyClass();
        boolean matchClasses = PyTypeChecker.matchClasses(superClass, subClass, context);
        if (PyProtocolsKt.isProtocol(expected, context) && !matchClasses) {
            if (expected instanceof PyCollectionType && !PyTypeChecker.matchGenerics((PyCollectionType)expected, actual, matchContext)) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(46);
                }
                return optional;
            }
            StreamEx.of((Collection)PyTypeProvider.EP_NAME.getExtensionList()).map(provider -> provider.getGenericType(superClass, context)).select(PyCollectionType.class).findFirst().ifPresent(it -> PyTypeChecker.matchGenerics(it, expected, matchContext));
            for (Pair<PyTypedElement, List<RatedResolveResult>> pair : PyProtocolsKt.inspectProtocolSubclass(expected, actual, context)) {
                List subclassElements = (List)pair.getSecond();
                if (ContainerUtil.isEmpty((Collection)subclassElements)) {
                    Optional<Boolean> optional = Optional.of(false);
                    if (optional == null) {
                        PyTypeChecker.$$$reportNull$$$0(47);
                    }
                    return optional;
                }
                PyType protocolElementType = PyTypeChecker.dropSelfIfNeeded(expected, context.getType((PyTypedElement)pair.getFirst()), context);
                boolean elementResult = StreamEx.of((Collection)subclassElements).map(ResolveResult::getElement).select(PyTypedElement.class).map(context::getType).anyMatch(subclassElementType -> PyTypeChecker.match(protocolElementType, PyTypeChecker.dropSelfIfNeeded(actual, subclassElementType, context), matchContext).orElse(true));
                if (elementResult) continue;
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(48);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(49);
            }
            return optional;
        }
        if (expected instanceof PyCollectionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyCollectionType)expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(50);
            }
            return optional;
        }
        if (matchClasses) {
            if (expected instanceof PyTypingNewType && !expected.equals(actual) && superClass.equals(subClass)) {
                Optional<Boolean> optional = Optional.of(actual.getAncestorTypes(context).contains(expected));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(51);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(52);
            }
            return optional;
        }
        if (expected.equals(actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(53);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(54);
        }
        return optional;
    }

    @Nullable
    private static PyType dropSelfIfNeeded(@NotNull PyClassType classType, @Nullable PyType elementType, @NotNull TypeEvalContext context) {
        PyFunctionType functionType;
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(55);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(56);
        }
        if (elementType instanceof PyFunctionType && (PyUtil.isInitOrNewMethod((PsiElement)(functionType = (PyFunctionType)elementType).getCallable()) || !classType.isDefinition())) {
            return functionType.dropSelf(context);
        }
        return elementType;
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(57);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(58);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(59);
        }
        if (!expected.isHomogeneous() && !actual.isHomogeneous()) {
            if (expected.getElementCount() != actual.getElementCount()) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(60);
                }
                return optional;
            }
            for (int i = 0; i < expected.getElementCount(); ++i) {
                if (PyTypeChecker.match(expected.getElementType(i), actual.getElementType(i), context).orElse(true).booleanValue()) continue;
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(61);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(62);
            }
            return optional;
        }
        if (expected.isHomogeneous() && !actual.isHomogeneous()) {
            PyType expectedElementType = expected.getIteratedItemType();
            for (int i = 0; i < actual.getElementCount(); ++i) {
                if (PyTypeChecker.match(expectedElementType, actual.getElementType(i), context).orElse(true).booleanValue()) continue;
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(63);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(64);
            }
            return optional;
        }
        if (!expected.isHomogeneous() && actual.isHomogeneous()) {
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(65);
            }
            return optional;
        }
        return PyTypeChecker.match(expected.getIteratedItemType(), actual.getIteratedItemType(), context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        PyClass subClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(66);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(67);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(68);
        }
        if (actual instanceof PyTupleType) {
            return PyTypeChecker.match(expected, (PyTupleType)actual, context);
        }
        PyClass superClass = expected.getPyClass();
        return PyTypeChecker.matchClasses(superClass, subClass = actual.getPyClass(), context.context) && PyTypeChecker.matchGenerics(expected, actual, context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(69);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(70);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(71);
        }
        if (!PyTypeChecker.matchClasses(expected.getPyClass(), actual.getPyClass(), context.context)) {
            return false;
        }
        PyType superElementType = expected.getIteratedItemType();
        PyType subElementType = actual.getIteratedItemType();
        return PyTypeChecker.match(superElementType, subElementType, context).orElse(true);
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyType actual, @NotNull TypeEvalContext context) {
        PyFile module;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(72);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(73);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(74);
        }
        if (actual instanceof PyStructuralType) {
            return PyTypeChecker.match(expected, (PyStructuralType)actual);
        }
        if (actual instanceof PyClassType) {
            return PyTypeChecker.match(expected, (PyClassType)actual, context);
        }
        if (actual instanceof PyModuleType && (module = ((PyModuleType)actual).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37) && PyTypeChecker.definesGetAttr(module, context)) {
            return true;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return !ContainerUtil.exists(expected.getAttributeNames(), attribute -> ContainerUtil.isEmpty(actual.resolveMember((String)attribute, null, AccessDirection.READ, resolveContext)));
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyStructuralType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(75);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(76);
        }
        if (expected.isInferredFromUsages()) {
            return true;
        }
        return expected.getAttributeNames().containsAll(actual.getAttributeNames());
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyClassType actual, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(77);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(78);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(79);
        }
        if (PyTypeChecker.overridesGetAttr(actual.getPyClass(), context)) {
            return true;
        }
        Set<String> actualAttributes = actual.getMemberNames(true, context);
        return actualAttributes.containsAll(expected.getAttributeNames());
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyCallableType expected, @NotNull PyCallableType actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(80);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(81);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(82);
        }
        if (actual instanceof PyFunctionType && expected instanceof PyClassType && "function".equals(expected.getName()) && expected.equals(PyBuiltinCache.getInstance((PsiElement)actual.getCallable()).getObjectType("function"))) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(83);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected instanceof PyClassLikeType && !PyTypeChecker.isCallableProtocol((PyClassLikeType)expected, context)) {
            Optional<Boolean> optional = "typing.Callable".equals(((PyClassLikeType)expected).getClassQName()) ? Optional.of(actual.isCallable()) : Optional.empty();
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(84);
            }
            return optional;
        }
        if (expected.isCallable() && actual.isCallable()) {
            List<PyCallableParameter> expectedParameters = expected.getParameters(context);
            List<PyCallableParameter> actualParameters = actual.getParameters(context);
            if (expectedParameters != null && actualParameters != null) {
                int size = Math.min(expectedParameters.size(), actualParameters.size());
                for (int i = 0; i < size; ++i) {
                    PyType actualParamType;
                    PyCallableParameter expectedParam = expectedParameters.get(i);
                    PyCallableParameter actualParam = actualParameters.get(i);
                    if (expectedParam.isSelf() && actualParam.isSelf()) {
                        if (PyTypeChecker.match(expectedParam.getType(context), actualParam.getType(context), matchContext).orElse(true).booleanValue()) continue;
                        Optional<Boolean> optional = Optional.of(false);
                        if (optional == null) {
                            PyTypeChecker.$$$reportNull$$$0(85);
                        }
                        return optional;
                    }
                    PyType pyType = actualParamType = actualParam.isPositionalContainer() && PyTypeChecker.couldBeMappedOntoPositionalContainer(expectedParam) ? actualParam.getArgumentType(context) : actualParam.getType(context);
                    if (PyTypeChecker.match(actualParamType, expectedParam.getType(context), matchContext.reverseSubstitutions()).orElse(true).booleanValue()) continue;
                    Optional<Boolean> optional = Optional.of(false);
                    if (optional == null) {
                        PyTypeChecker.$$$reportNull$$$0(86);
                    }
                    return optional;
                }
            }
            if (!PyTypeChecker.match(expected.getReturnType(context), PyTypeChecker.getActualReturnType(actual, context), matchContext).orElse(true).booleanValue()) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(87);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(88);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(89);
        }
        return optional;
    }

    private static boolean isCallableProtocol(@NotNull PyClassLikeType expected, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(90);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(91);
        }
        return PyProtocolsKt.isProtocol(expected, context) && expected.getMemberNames(false, context).contains("__call__");
    }

    @Nullable
    private static PyType getActualReturnType(@NotNull PyCallableType actual, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(92);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(93);
        }
        if ((callable = actual.getCallable()) instanceof PyFunction) {
            return PyUtil.getReturnTypeToAnalyzeAsCallType((PyFunction)callable, context);
        }
        return actual.getReturnType(context);
    }

    private static boolean couldBeMappedOntoPositionalContainer(@NotNull PyCallableParameter parameter) {
        PyNamedParameter namedPsi;
        if (parameter == null) {
            PyTypeChecker.$$$reportNull$$$0(94);
        }
        if (parameter.isPositionalContainer() || parameter.isKeywordContainer()) {
            return false;
        }
        PyParameter psi = parameter.getParameter();
        return psi == null || (namedPsi = psi.getAsNamed()) == null || !namedPsi.isKeywordOnly();
    }

    private static boolean consistsOfSameElementNumberTuples(@NotNull PyUnionType unionType, int elementCount) {
        if (unionType == null) {
            PyTypeChecker.$$$reportNull$$$0(95);
        }
        for (PyType type : unionType.getMembers()) {
            if (type instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)type;
                if (tupleType.isHomogeneous() || elementCount == tupleType.getElementCount()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean substituteExpectedElementsWithUnions(@NotNull PyTupleType expected, int elementCount, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(96);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(97);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(98);
        }
        for (int i = 0; i < elementCount; ++i) {
            int currentIndex = i;
            PyType elementType = PyUnionType.union(StreamEx.of(actual.getMembers()).select(PyTupleType.class).map(type -> type.getElementType(currentIndex)).toList());
            if (PyTypeChecker.match(expected.getElementType(i), elementType, context).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean matchGenerics(@NotNull PyCollectionType expected, @NotNull PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(99);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(100);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(101);
        }
        List<PyType> superElementTypes = expected.getElementTypes();
        PyCollectionType actualCollectionType = PyUtil.as(actual, PyCollectionType.class);
        List<Object> subElementTypes = actualCollectionType != null ? actualCollectionType.getElementTypes() : Collections.emptyList();
        for (int i = 0; i < superElementTypes.size(); ++i) {
            PyType subElementType;
            PyType pyType = subElementType = i < subElementTypes.size() ? (PyType)subElementTypes.get(i) : null;
            if (PyTypeChecker.match(superElementTypes.get(i), subElementType, context).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean matchNumericTypes(PyType expected, PyType actual) {
        if (expected instanceof PyClassType && actual instanceof PyClassType) {
            String superName = ((PyClassType)expected).getPyClass().getName();
            String subName = ((PyClassType)actual).getPyClass().getName();
            boolean subIsBool = "bool".equals(subName);
            boolean subIsInt = "int".equals(subName);
            boolean subIsLong = "long".equals(subName);
            boolean subIsFloat = "float".equals(subName);
            boolean subIsComplex = "complex".equals(subName);
            if (superName == null || subName == null || superName.equals(subName) || "int".equals(superName) && subIsBool || ("long".equals(superName) || "Integral".equals(superName)) && (subIsBool || subIsInt) || ("float".equals(superName) || "Real".equals(superName)) && (subIsBool || subIsInt || subIsLong) || ("complex".equals(superName) || "Complex".equals(superName)) && (subIsBool || subIsInt || subIsLong || subIsFloat) || "Number".equals(superName) && (subIsBool || subIsInt || subIsLong || subIsFloat || subIsComplex)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnknown(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(102);
        }
        return PyTypeChecker.isUnknown(type, true, context);
    }

    public static boolean isUnknown(@Nullable PyType type, boolean genericsAreUnknown, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(103);
        }
        if (type == null || genericsAreUnknown && type instanceof PyGenericType) {
            return true;
        }
        if (type instanceof PyFunctionType && (callable = ((PyFunctionType)type).getCallable()) instanceof PyDecoratable && PyKnownDecoratorUtil.hasChangingReturnTypeDecorator((PyDecoratable)((Object)callable), context)) {
            return true;
        }
        if (type instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type;
            for (PyType t : union.getMembers()) {
                if (!PyTypeChecker.isUnknown(t, genericsAreUnknown, context)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Map<PyGenericType, PyType> getSubstitutionsWithUnresolvedReturnGenerics(@NotNull Collection<PyCallableParameter> parameters, @Nullable PyType returnType, @Nullable Map<PyGenericType, PyType> substitutions, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyTypeChecker.$$$reportNull$$$0(104);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(105);
        }
        HashMap<PyGenericType, PyType> result = ContainerUtil.isEmpty(substitutions) ? new HashMap<PyGenericType, PyType>() : new HashMap<PyGenericType, PyType>(substitutions);
        HashSet visited = new HashSet();
        HashSet returnTypeGenerics = new HashSet();
        PyTypeChecker.collectGenerics(returnType, context, returnTypeGenerics, visited);
        if (returnTypeGenerics.isEmpty()) {
            HashMap<PyGenericType, PyType> hashMap = result;
            if (hashMap == null) {
                PyTypeChecker.$$$reportNull$$$0(106);
            }
            return hashMap;
        }
        for (PyGenericType alreadyKnown : result.keySet()) {
            if (returnTypeGenerics.remove(alreadyKnown)) continue;
            returnTypeGenerics.remove(PyTypeChecker.invert(alreadyKnown));
        }
        if (returnTypeGenerics.isEmpty()) {
            HashMap<PyGenericType, PyType> hashMap = result;
            if (hashMap == null) {
                PyTypeChecker.$$$reportNull$$$0(107);
            }
            return hashMap;
        }
        visited.clear();
        HashSet paramGenerics = new HashSet();
        for (PyCallableParameter parameter : parameters) {
            PyType paramType = parameter.getArgumentType(context);
            PyTypeChecker.collectGenerics(paramType, context, paramGenerics, visited);
        }
        for (PyGenericType returnTypeGeneric : returnTypeGenerics) {
            if (paramGenerics.contains(returnTypeGeneric) || paramGenerics.contains(PyTypeChecker.invert(returnTypeGeneric))) continue;
            result.put(returnTypeGeneric, returnTypeGeneric);
        }
        HashMap<PyGenericType, PyType> hashMap = result;
        if (hashMap == null) {
            PyTypeChecker.$$$reportNull$$$0(108);
        }
        return hashMap;
    }

    @NotNull
    private static <T extends PyInstantiableType<T>> T invert(@NotNull PyInstantiableType<T> instantiable) {
        if (instantiable == null) {
            PyTypeChecker.$$$reportNull$$$0(109);
        }
        T t = instantiable.isDefinition() ? instantiable.toInstance() : instantiable.toClass();
        if (t == null) {
            PyTypeChecker.$$$reportNull$$$0(110);
        }
        return t;
    }

    public static boolean hasGenerics(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(111);
        }
        HashSet collected = new HashSet();
        PyTypeChecker.collectGenerics(type, context, collected, new HashSet());
        return !collected.isEmpty();
    }

    private static void collectGenerics(@Nullable PyType type, @NotNull TypeEvalContext context, @NotNull Set<? super PyGenericType> collected, @NotNull Set<? super PyType> visited) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(112);
        }
        if (collected == null) {
            PyTypeChecker.$$$reportNull$$$0(113);
        }
        if (visited == null) {
            PyTypeChecker.$$$reportNull$$$0(114);
        }
        if (visited.contains(type)) {
            return;
        }
        visited.add(type);
        if (type instanceof PyGenericType) {
            collected.add((PyGenericType)type);
        } else if (type instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type;
            for (PyType t : union.getMembers()) {
                PyTypeChecker.collectGenerics(t, context, collected, visited);
            }
        } else if (type instanceof PyTupleType) {
            PyTupleType tuple = (PyTupleType)type;
            int n = tuple.isHomogeneous() ? 1 : tuple.getElementCount();
            for (int i = 0; i < n; ++i) {
                PyTypeChecker.collectGenerics(tuple.getElementType(i), context, collected, visited);
            }
        } else if (type instanceof PyCollectionType) {
            PyCollectionType collection = (PyCollectionType)type;
            for (PyType elementType : collection.getElementTypes()) {
                PyTypeChecker.collectGenerics(elementType, context, collected, visited);
            }
        } else if (type instanceof PyCallableType && !(type instanceof PyClassLikeType)) {
            PyCallableType callable = (PyCallableType)type;
            List<PyCallableParameter> parameters = callable.getParameters(context);
            if (parameters != null) {
                for (PyCallableParameter parameter : parameters) {
                    if (parameter == null) continue;
                    PyTypeChecker.collectGenerics(parameter.getType(context), context, collected, visited);
                }
            }
            PyTypeChecker.collectGenerics(callable.getReturnType(context), context, collected, visited);
        }
    }

    @Nullable
    public static PyType substitute(@Nullable PyType type, @NotNull Map<PyGenericType, PyType> substitutions, @NotNull TypeEvalContext context) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(115);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(116);
        }
        if (PyTypeChecker.hasGenerics(type, context)) {
            if (type instanceof PyGenericType) {
                PyGenericType invertedTypeVar;
                PyInstantiableType invertedSubstitution;
                PyGenericType typeVar = (PyGenericType)type;
                PyType substitution = substitutions.get(typeVar);
                if (substitution == null && (invertedSubstitution = PyUtil.as(substitutions.get(invertedTypeVar = PyTypeChecker.invert(typeVar)), PyInstantiableType.class)) != null) {
                    substitution = PyTypeChecker.invert(invertedSubstitution);
                }
                if (substitution instanceof PyGenericType && !typeVar.equals(substitution) && substitutions.containsKey(substitution)) {
                    return PyTypeChecker.substitute(substitution, substitutions, context);
                }
                return substitution;
            }
            if (type instanceof PyUnionType) {
                return ((PyUnionType)type).map(member -> PyTypeChecker.substitute(member, substitutions, context));
            }
            if (type instanceof PyCollectionTypeImpl) {
                PyCollectionTypeImpl collection = (PyCollectionTypeImpl)type;
                List<PyType> elementTypes = collection.getElementTypes();
                ArrayList<PyType> substitutes = new ArrayList<PyType>();
                for (PyType elementType2 : elementTypes) {
                    substitutes.add(PyTypeChecker.substitute(elementType2, substitutions, context));
                }
                return new PyCollectionTypeImpl(collection.getPyClass(), collection.isDefinition(), substitutes);
            }
            if (type instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)type;
                PyClass tupleClass = tupleType.getPyClass();
                List<PyType> oldElementTypes = tupleType.isHomogeneous() ? Collections.singletonList(tupleType.getIteratedItemType()) : tupleType.getElementTypes();
                List newElementTypes = ContainerUtil.map(oldElementTypes, elementType -> PyTypeChecker.substitute(elementType, substitutions, context));
                return new PyTupleType(tupleClass, newElementTypes, tupleType.isHomogeneous());
            }
            if (type instanceof PyCallableType && !(type instanceof PyClassLikeType)) {
                PyCallableType callable = (PyCallableType)type;
                ArrayList<PyCallableParameter> substParams = null;
                List<PyCallableParameter> parameters = callable.getParameters(context);
                if (parameters != null) {
                    substParams = new ArrayList<PyCallableParameter>();
                    for (PyCallableParameter parameter : parameters) {
                        PyType substType = PyTypeChecker.substitute(parameter.getType(context), substitutions, context);
                        PyParameter psi = parameter.getParameter();
                        PyCallableParameter subst = psi != null ? PyCallableParameterImpl.psi(psi, substType) : PyCallableParameterImpl.nonPsi(parameter.getName(), substType, parameter.getDefaultValue());
                        substParams.add(subst);
                    }
                }
                PyType substResult = PyTypeChecker.substitute(callable.getReturnType(context), substitutions, context);
                return new PyCallableTypeImpl(substParams, substResult);
            }
        }
        return type;
    }

    @Nullable
    public static Map<PyGenericType, PyType> unifyGenericCall(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(117);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(118);
        }
        Map<PyGenericType, PyType> substitutions = PyTypeChecker.unifyReceiver(receiver, context);
        for (Map.Entry<PyExpression, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(arguments).entrySet()) {
            PyType actualType;
            PyCallableParameter paramWrapper = entry.getValue();
            PyType expectedType = paramWrapper.getArgumentType(context);
            PyType promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(entry.getKey(), expectedType, context, substitutions);
            PyType pyType = actualType = promotedToLiteral != null ? promotedToLiteral : context.getType(entry.getKey());
            if (paramWrapper.isSelf()) {
                PyParameter param = paramWrapper.getParameter();
                PyFunction function = PyUtil.as(ScopeUtil.getScopeOwner((PsiElement)param), PyFunction.class);
                if (function != null && function.getModifier() == PyFunction.Modifier.CLASSMETHOD) {
                    actualType = PyTypeUtil.toStream(actualType).select(PyClassLikeType.class).map(PyInstantiableType::toClass).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
                } else if (PyUtil.isInitMethod(function)) {
                    actualType = PyTypeUtil.toStream(actualType).select(PyInstantiableType.class).map(PyInstantiableType::toInstance).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
                }
            }
            if (PyTypeChecker.match(expectedType, actualType, context, substitutions)) continue;
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedPositionalContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(arguments), substitutions, context)) {
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedKeywordContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(arguments), substitutions, context)) {
            return null;
        }
        return substitutions;
    }

    private static boolean matchContainer(@Nullable PyCallableParameter container, @NotNull List<? extends PyExpression> arguments, @NotNull Map<PyGenericType, PyType> substitutions, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(119);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(120);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(121);
        }
        if (container == null) {
            return true;
        }
        List types = ContainerUtil.map(arguments, context::getType);
        return PyTypeChecker.match(container.getArgumentType(context), PyUnionType.union(types), context, substitutions);
    }

    @NotNull
    public static Map<PyGenericType, PyType> unifyReceiver(@Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(122);
        }
        LinkedHashMap<PyGenericType, PyType> substitutions = new LinkedHashMap<PyGenericType, PyType>();
        LinkedHashSet generics = new LinkedHashSet();
        PyType qualifierType = receiver != null ? context.getType(receiver) : null;
        PyTypeChecker.collectGenerics(qualifierType, context, generics, new HashSet());
        for (PyGenericType t : generics) {
            substitutions.put(t, t);
        }
        if (qualifierType != null) {
            for (PyClassType type : PyTypeUtil.toStream(qualifierType).select(PyClassType.class)) {
                for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
                    PyType genericType = provider.getGenericType(type.getPyClass(), context);
                    LinkedHashSet providedTypeGenerics = new LinkedHashSet();
                    if (genericType != null) {
                        PyTypeChecker.match(genericType, type, context, substitutions);
                        PyTypeChecker.collectGenerics(genericType, context, providedTypeGenerics, new HashSet());
                    }
                    for (Map.Entry<PyType, PyType> entry : provider.getGenericSubstitutions(type.getPyClass(), context).entrySet()) {
                        PyGenericType genericKey = PyUtil.as(entry.getKey(), PyGenericType.class);
                        PyType value = entry.getValue();
                        if (genericKey == null || value == null || substitutions.containsKey(genericKey) || providedTypeGenerics.contains(genericKey)) continue;
                        substitutions.put(genericKey, value);
                    }
                }
            }
        }
        PyTypeChecker.replaceUnresolvedGenericsWithAny(substitutions);
        LinkedHashMap<PyGenericType, PyType> linkedHashMap = substitutions;
        if (linkedHashMap == null) {
            PyTypeChecker.$$$reportNull$$$0(123);
        }
        return linkedHashMap;
    }

    private static void replaceUnresolvedGenericsWithAny(@NotNull Map<PyGenericType, PyType> substitutions) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(124);
        }
        List unresolvedGenerics = ContainerUtil.filter(substitutions.values(), type -> type instanceof PyGenericType && !substitutions.containsKey(type));
        for (PyType unresolvedGeneric : unresolvedGenerics) {
            substitutions.put((PyGenericType)unresolvedGeneric, null);
        }
    }

    private static boolean matchClasses(@Nullable PyClass superClass, @Nullable PyClass subClass, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(125);
        }
        if (superClass == null || subClass == null || subClass.isSubclass(superClass, context) || PyABCUtil.isSubclass(subClass, superClass, context) || PyTypeChecker.isStrUnicodeMatch(subClass, superClass) || PyTypeChecker.isBytearrayBytesStringMatch(subClass, superClass) || PyUtil.hasUnresolvedAncestors(subClass, context)) {
            return true;
        }
        String superName = superClass.getName();
        return superName != null && superName.equals(subClass.getName());
    }

    private static boolean isStrUnicodeMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(126);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(127);
        }
        return "str".equals(subClass.getName()) && "unicode".equals(superClass.getName());
    }

    private static boolean isBytearrayBytesStringMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(128);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(129);
        }
        if (!"bytearray".equals(subClass.getName())) {
            return false;
        }
        PsiFile subClassFile = subClass.getContainingFile();
        boolean isPy2 = subClassFile instanceof PyiFile ? PythonRuntimeService.getInstance().getLanguageLevelForSdk(PythonSdkUtil.findPythonSdk((PsiElement)subClassFile)).isPython2() : LanguageLevel.forElement((PsiElement)subClass).isPython2();
        String superClassName = superClass.getName();
        return isPy2 && "str".equals(superClassName) || !isPy2 && "bytes".equals(superClassName);
    }

    @Nullable
    public static Boolean isCallable(@Nullable PyType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PyUnionType) {
            return PyTypeChecker.isUnionCallable((PyUnionType)type);
        }
        if (type instanceof PyCallableType) {
            return ((PyCallableType)type).isCallable();
        }
        if (type instanceof PyStructuralType && ((PyStructuralType)type).isInferredFromUsages()) {
            return true;
        }
        if (type instanceof PyGenericType) {
            if (((PyGenericType)type).isDefinition()) {
                return true;
            }
            return PyTypeChecker.isCallable(((PyGenericType)type).getBound());
        }
        return false;
    }

    @Nullable
    private static Boolean isUnionCallable(@NotNull PyUnionType type) {
        if (type == null) {
            PyTypeChecker.$$$reportNull$$$0(130);
        }
        for (PyType member : type.getMembers()) {
            Boolean callable = PyTypeChecker.isCallable(member);
            if (callable == null) {
                return null;
            }
            if (!callable.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean definesGetAttr(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        PyType type;
        if (file == null) {
            PyTypeChecker.$$$reportNull$$$0(131);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(132);
        }
        if (file instanceof PyTypedElement && (type = context.getType((PyTypedElement)((Object)file))) != null) {
            return PyTypeChecker.resolveTypeMember(type, "__getattr__", context) != null;
        }
        return false;
    }

    public static boolean overridesGetAttr(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyType type;
        if (cls == null) {
            PyTypeChecker.$$$reportNull$$$0(133);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(134);
        }
        if ((type = context.getType(cls)) != null) {
            if (PyTypeChecker.resolveTypeMember(type, "__getattr__", context) != null) {
                return true;
            }
            PsiElement method = PyTypeChecker.resolveTypeMember(type, "__getattribute__", context);
            if (method != null && !PyBuiltinCache.getInstance((PsiElement)cls).isBuiltin(method)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement resolveTypeMember(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (type == null) {
            PyTypeChecker.$$$reportNull$$$0(135);
        }
        if (name == null) {
            PyTypeChecker.$$$reportNull$$$0(136);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(137);
        }
        return !ContainerUtil.isEmpty(results = type.resolveMember(name, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext(context))) ? results.get(0).getElement() : null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyTargetExpression target, @NotNull PyTupleExpression parentTuple, @NotNull PyType assignedType, @NotNull TypeEvalContext context) {
        if (target == null) {
            PyTypeChecker.$$$reportNull$$$0(138);
        }
        if (parentTuple == null) {
            PyTypeChecker.$$$reportNull$$$0(139);
        }
        if (assignedType == null) {
            PyTypeChecker.$$$reportNull$$$0(140);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(141);
        }
        if (assignedType instanceof PyTupleType) {
            return PyTypeChecker.getTargetTypeFromTupleAssignment(target, parentTuple, (PyTupleType)assignedType);
        }
        if (assignedType instanceof PyClassLikeType) {
            return StreamEx.of(((PyClassLikeType)assignedType).getAncestorTypes(context)).select(PyNamedTupleType.class).findFirst().map(t -> PyTypeChecker.getTargetTypeFromTupleAssignment(target, parentTuple, t)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyTargetExpression target, @NotNull PyTupleExpression parentTuple, @NotNull PyTupleType assignedTupleType) {
        if (target == null) {
            PyTypeChecker.$$$reportNull$$$0(142);
        }
        if (parentTuple == null) {
            PyTypeChecker.$$$reportNull$$$0(143);
        }
        if (assignedTupleType == null) {
            PyTypeChecker.$$$reportNull$$$0(144);
        }
        int count = assignedTupleType.getElementCount();
        Object[] elements = parentTuple.getElements();
        if (elements.length == count || assignedTupleType.isHomogeneous()) {
            int index = ArrayUtil.indexOf((Object[])elements, (Object)target);
            if (index >= 0) {
                return assignedTupleType.getElementType(index);
            }
            for (int i = 0; i < count; ++i) {
                PyType result;
                PyType elementType;
                Object element = elements[i];
                while (element instanceof PyParenthesizedExpression) {
                    element = ((PyParenthesizedExpression)element).getContainedExpression();
                }
                if (!(element instanceof PyTupleExpression) || !((elementType = assignedTupleType.getElementType(i)) instanceof PyTupleType) || (result = PyTypeChecker.getTargetTypeFromTupleAssignment(target, (PyTupleExpression)element, (PyTupleType)elementType)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 123: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 123: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 115: 
            case 120: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 21: 
            case 25: 
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 57: 
            case 66: 
            case 69: 
            case 72: 
            case 75: 
            case 77: 
            case 80: 
            case 90: 
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 28: 
            case 31: 
            case 36: 
            case 39: 
            case 58: 
            case 67: 
            case 70: 
            case 73: 
            case 76: 
            case 78: 
            case 81: 
            case 92: 
            case 97: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 40: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchContext";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiable";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collected";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 126: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 127: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 130: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 138: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 139: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTuple";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedType";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedTupleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 4: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "matchImpl";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "matchObject";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "invert";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 123: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchImpl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "matchObject";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "dropSelfIfNeeded";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isCallableProtocol";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getActualReturnType";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "couldBeMappedOntoPositionalContainer";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "consistsOfSameElementNumberTuples";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "substituteExpectedElementsWithUnions";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "matchGenerics";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "invert";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "hasGenerics";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "collectGenerics";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "unifyGenericCall";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "matchContainer";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "unifyReceiver";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "replaceUnresolvedGenericsWithAny";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "matchClasses";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isStrUnicodeMatch";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "isBytearrayBytesStringMatch";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "isUnionCallable";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "definesGetAttr";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "overridesGetAttr";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeMember";
                break;
            }
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeFromTupleAssignment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 123: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MatchContext {
        @NotNull
        private final TypeEvalContext context;
        @NotNull
        private final Map<PyGenericType, PyType> substitutions;
        private final boolean reversedSubstitutions;

        MatchContext(@NotNull TypeEvalContext context, @NotNull Map<PyGenericType, PyType> substitutions) {
            if (context == null) {
                MatchContext.$$$reportNull$$$0(0);
            }
            if (substitutions == null) {
                MatchContext.$$$reportNull$$$0(1);
            }
            this(context, substitutions, false);
        }

        private MatchContext(@NotNull TypeEvalContext context, @NotNull Map<PyGenericType, PyType> substitutions, boolean reversedSubstitutions) {
            if (context == null) {
                MatchContext.$$$reportNull$$$0(2);
            }
            if (substitutions == null) {
                MatchContext.$$$reportNull$$$0(3);
            }
            this.context = context;
            this.substitutions = substitutions;
            this.reversedSubstitutions = reversedSubstitutions;
        }

        @NotNull
        public MatchContext reverseSubstitutions() {
            return new MatchContext(this.context, this.substitutions, !this.reversedSubstitutions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/types/PyTypeChecker$MatchContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

