/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallableTypeImpl
implements PyCallableType {
    @Nullable
    private final List<PyCallableParameter> myParameters;
    @Nullable
    private final PyType myReturnType;
    @Nullable
    private final PyCallable myCallable;
    @Nullable
    private final PyFunction.Modifier myModifier;
    private final int myImplicitOffset;

    public PyCallableTypeImpl(@Nullable List<PyCallableParameter> parameters, @Nullable PyType returnType) {
        this(parameters, returnType, null, null, 0);
    }

    public PyCallableTypeImpl(@Nullable List<PyCallableParameter> parameters, @Nullable PyType returnType, @Nullable PyCallable callable, @Nullable PyFunction.Modifier modifier, int offset) {
        this.myParameters = parameters;
        this.myReturnType = returnType;
        this.myCallable = callable;
        this.myModifier = modifier;
        this.myImplicitOffset = offset;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(0);
        }
        return this.myReturnType;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(1);
        }
        if (callSite == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(2);
        }
        if (!PyTypeChecker.hasGenerics(this.myReturnType, context)) {
            return this.myReturnType;
        }
        PyCallExpression.PyArgumentsMapping fullMapping = PyCallExpressionHelper.mapArguments(callSite, this, context);
        Map<PyExpression, PyCallableParameter> actualParameters = fullMapping.getMappedParameters();
        List allParameters = ContainerUtil.notNullize(this.getParameters(context));
        return PyCallableTypeImpl.analyzeCallType(this.myReturnType, actualParameters, allParameters, context);
    }

    @Nullable
    private static PyType analyzeCallType(@Nullable PyType type, @NotNull Map<PyExpression, PyCallableParameter> actualParameters, @NotNull Collection<PyCallableParameter> allParameters, @NotNull TypeEvalContext context) {
        if (actualParameters == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(3);
        }
        if (allParameters == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(5);
        }
        Map<PyGenericType, PyType> substitutions = PyTypeChecker.unifyGenericCall(null, actualParameters, context);
        Map<PyGenericType, PyType> substitutionsWithUnresolvedReturnGenerics = PyTypeChecker.getSubstitutionsWithUnresolvedReturnGenerics(allParameters, type, substitutions, context);
        return PyTypeChecker.substitute(type, substitutionsWithUnresolvedReturnGenerics, context);
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(6);
        }
        return this.myParameters;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(7);
        }
        if (direction == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(8);
        }
        if (resolveContext == null) {
            PyCallableTypeImpl.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @Nullable
    public String getName() {
        TypeEvalContext context = TypeEvalContext.codeInsightFallback(null);
        return String.format("(%s) -> %s", this.myParameters != null ? StringUtil.join(this.myParameters, param -> {
            if (param != null) {
                StringBuilder builder = new StringBuilder();
                String name = param.getName();
                PyType type = param.getType(context);
                if (name != null) {
                    builder.append(name);
                    if (type != null) {
                        builder.append(": ");
                    }
                }
                builder.append(type != null ? type.getName() : "Any");
                return builder.toString();
            }
            return "Any";
        }, (String)", ") : "...", this.myReturnType != null ? this.myReturnType.getName() : "Any");
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    @Override
    @Nullable
    public PyCallable getCallable() {
        return this.myCallable;
    }

    @Override
    @Nullable
    public PyFunction.Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public int getImplicitOffset() {
        return this.myImplicitOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/types/PyCallableTypeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getReturnType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeCallType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameters";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

