/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyFunctionStubImpl;
import com.jetbrains.python.psi.stubs.PyExportedModuleAttributeIndex;
import com.jetbrains.python.psi.stubs.PyFileStub;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyFunctionElementType
extends PyStubElementType<PyFunctionStub, PyFunction> {
    public PyFunctionElementType() {
        this("FUNCTION_DECLARATION");
    }

    public PyFunctionElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            PyFunctionElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            PyFunctionElementType.$$$reportNull$$$0(1);
        }
        return new PyFunctionImpl(node);
    }

    public PyFunction createPsi(@NotNull PyFunctionStub stub) {
        if (stub == null) {
            PyFunctionElementType.$$$reportNull$$$0(2);
        }
        return new PyFunctionImpl(stub);
    }

    @NotNull
    public PyFunctionStub createStub(@NotNull PyFunction psi, StubElement parentStub) {
        if (psi == null) {
            PyFunctionElementType.$$$reportNull$$$0(3);
        }
        PyFunctionImpl function = (PyFunctionImpl)psi;
        String message = function.extractDeprecationMessage();
        PyStringLiteralExpression docStringExpression = function.getDocStringExpression();
        String typeComment = function.getTypeCommentAnnotation();
        String annotationContent = function.getAnnotationValue();
        return new PyFunctionStubImpl(psi.getName(), PyPsiUtils.strValue(docStringExpression), message, function.isAsync(), function.isGenerator(), function.onlyRaisesNotImplementedError(), typeComment, annotationContent, parentStub, this.getStubElementType());
    }

    public void serialize(@NotNull PyFunctionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PyFunctionElementType.$$$reportNull$$$0(4);
        }
        if (dataStream == null) {
            PyFunctionElementType.$$$reportNull$$$0(5);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeUTFFast(StringUtil.notNullize((String)stub.getDocString()));
        dataStream.writeName(stub.getDeprecationMessage());
        dataStream.writeBoolean(stub.isAsync());
        dataStream.writeBoolean(stub.isGenerator());
        dataStream.writeBoolean(stub.onlyRaisesNotImplementedError());
        dataStream.writeName(stub.getTypeComment());
        dataStream.writeName(stub.getAnnotation());
    }

    @NotNull
    public PyFunctionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PyFunctionElementType.$$$reportNull$$$0(6);
        }
        String name = dataStream.readNameString();
        String docString = dataStream.readUTFFast();
        String deprecationMessage = dataStream.readNameString();
        boolean isAsync = dataStream.readBoolean();
        boolean isGenerator = dataStream.readBoolean();
        boolean onlyRaisesNotImplementedError = dataStream.readBoolean();
        String typeComment = dataStream.readNameString();
        String annotationContent = dataStream.readNameString();
        return new PyFunctionStubImpl(name, StringUtil.nullize((String)docString), deprecationMessage, isAsync, isGenerator, onlyRaisesNotImplementedError, typeComment, annotationContent, parentStub, this.getStubElementType());
    }

    @Override
    public void indexStub(@NotNull PyFunctionStub stub, @NotNull IndexSink sink) {
        String name;
        if (stub == null) {
            PyFunctionElementType.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            PyFunctionElementType.$$$reportNull$$$0(8);
        }
        if ((name = stub.getName()) != null) {
            sink.occurrence(PyFunctionNameIndex.KEY, (Object)name);
            if (stub.getParentStub() instanceof PyFileStub && PyUtil.getInitialUnderscores(name) == 0) {
                sink.occurrence(PyExportedModuleAttributeIndex.KEY, (Object)name);
            }
        }
    }

    protected IStubElementType getStubElementType() {
        return PyElementTypes.FUNCTION_DECLARATION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

