/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unresolvedReference;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.AutoImportHintAction;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.PythonImportUtils;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.inspections.quickfix.AddIgnoredIdentifierQuickFix;
import com.jetbrains.python.inspections.quickfix.GenerateBinaryStubsFix;
import com.jetbrains.python.inspections.unresolvedReference.PyPackageAliasesProvider;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspectionBase;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesVisitor;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnresolvedReferencesInspection
extends PyUnresolvedReferencesInspectionBase {
    public static final Key<PyUnresolvedReferencesInspection> SHORT_NAME_KEY = Key.create((String)PyUnresolvedReferencesInspection.class.getSimpleName());
    public List<String> ignoredIdentifiers = new ArrayList<String>();

    public static PyUnresolvedReferencesInspection getInstance(PsiElement element) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        return (PyUnresolvedReferencesInspection)inspectionProfile.getUnwrappedTool(SHORT_NAME_KEY.toString(), element);
    }

    @Override
    @NotNull
    protected PyUnresolvedReferencesVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session, this.ignoredIdentifiers);
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm(PyPsiBundle.message("INSP.unresolved.refs.column.name.ignore.references", new Object[0]), PyPsiBundle.message("INSP.unresolved.refs.ignore.references.label", new Object[0]), this.ignoredIdentifiers);
        return form.getContentPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyUnresolvedReferencesVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, List<String> ignoredIdentifiers) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session, ignoredIdentifiers);
        }

        @Override
        public Iterable<LocalQuickFix> getInstallPackageQuickFixes(@NotNull PyElement node, @NotNull PsiReference reference, String refName) {
            QualifiedName qname;
            List components;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (reference == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (reference instanceof PyImportReference && !(components = (qname = QualifiedName.fromDottedString((String)refName)).getComponents()).isEmpty()) {
                String packageName = (String)components.get(0);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
                Sdk sdk = PythonSdkUtil.findPythonSdk(module);
                if (module != null && sdk != null && PyPackageUtil.packageManagementEnabled(sdk)) {
                    return ((StreamEx)StreamEx.of((Object)packageName).append((Collection)PyPsiPackageUtil.PACKAGES_TOPLEVEL.getOrDefault((Object)packageName, Collections.emptyList())).filter(PyPIPackageUtil.INSTANCE::isInPyPI)).map(pkg -> Visitor.getInstallPackageAction(pkg, module, sdk));
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Iterable<LocalQuickFix> getAddIgnoredIdentifierQuickFixes(List<QualifiedName> qualifiedNames) {
            ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>(2);
            if (qualifiedNames.size() == 1) {
                QualifiedName qualifiedName = qualifiedNames.get(0);
                result.add(new AddIgnoredIdentifierQuickFix(qualifiedName, false));
                if (qualifiedName.getComponentCount() > 1) {
                    result.add(new AddIgnoredIdentifierQuickFix(qualifiedName.removeLastComponent(), true));
                }
            }
            return result;
        }

        @Override
        public Iterable<LocalQuickFix> getImportStatementQuickFixes(PsiElement element) {
            PyImportStatementBase importStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class);
            if (importStatementBase != null && GenerateBinaryStubsFix.isApplicable(importStatementBase)) {
                return GenerateBinaryStubsFix.generateFixes(importStatementBase);
            }
            return Collections.emptyList();
        }

        private static LocalQuickFix getInstallPackageAction(String packageName, Module module, Sdk sdk) {
            List<PyRequirement> requirements2 = Collections.singletonList(PyRequirementsKt.pyRequirement(packageName));
            String name = PyBundle.message("python.unresolved.reference.inspection.install.package", packageName);
            return new PyPackageRequirementsInspection.PyInstallRequirementsFix(name, module, sdk, requirements2);
        }

        @Override
        protected Iterable<LocalQuickFix> getAutoImportFixes(PyElement node, PsiReference reference, PsiElement element) {
            if (!PythonImportUtils.isImportable(element)) {
                return Collections.emptyList();
            }
            PsiFile file = InjectedLanguageManager.getInstance((Project)node.getProject()).getTopLevelFile((PsiElement)node);
            if (!(file instanceof PyFile)) {
                return Collections.emptyList();
            }
            ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
            AutoImportQuickFix importFix = PythonImportUtils.proposeImportFix(node, reference);
            if (importFix != null) {
                if (!Visitor.suppressHintForAutoImport(node, importFix) && PyCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP) {
                    AutoImportHintAction autoImportHintAction = new AutoImportHintAction(importFix);
                    result.add(autoImportHintAction);
                } else {
                    result.add((LocalQuickFix)importFix);
                }
                if (ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyFunction) {
                    result.add((LocalQuickFix)importFix.forLocalImport());
                }
            } else {
                String refName;
                String string = refName = node instanceof PyQualifiedExpression ? ((PyQualifiedExpression)node).getReferencedName() : node.getText();
                if (refName == null) {
                    return result;
                }
                QualifiedName qname = QualifiedName.fromDottedString((String)refName);
                List components = qname.getComponents();
                if (!components.isEmpty()) {
                    String packageName = (String)components.get(0);
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
                    if (PyPIPackageUtil.INSTANCE.isInPyPI(packageName) && PythonSdkUtil.findPythonSdk(module) != null) {
                        result.add(new PyPackageRequirementsInspection.InstallAndImportQuickFix(packageName, packageName, node));
                    } else {
                        String packageAlias = PyPackageAliasesProvider.commonImportAliases.get(packageName);
                        if (packageAlias != null && PyPIPackageUtil.INSTANCE.isInPyPI(packageName) && PythonSdkUtil.findPythonSdk(module) != null) {
                            result.add(new PyPackageRequirementsInspection.InstallAndImportQuickFix(packageAlias, packageName, node));
                        }
                    }
                }
            }
            return result;
        }

        private static boolean suppressHintForAutoImport(PyElement node, AutoImportQuickFix importFix) {
            if (!Visitor.isCall(node) && importFix.hasOnlyFunctions()) {
                return true;
            }
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            return containingClass != null && (containingClass.findMethodByName(importFix.getNameToImport(), true, null) != null || containingClass.findInstanceAttribute(importFix.getNameToImport(), true) != null);
        }

        private static boolean isCall(PyElement node) {
            PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PyCallExpression.class);
            return callExpression != null && node == callExpression.getCallee();
        }

        @Override
        void getPluginQuickFixes(List<LocalQuickFix> fixes, PsiReference reference) {
            for (PyUnresolvedReferenceQuickFixProvider provider : PyUnresolvedReferenceQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerQuickFixes(reference, fixes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstallPackageQuickFixes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

