/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyReplaceTupleWithListQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.make.list", new Object[0]);
        if (string == null) {
            PyReplaceTupleWithListQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PySubscriptionExpression subscriptionExpression;
        if (project == null) {
            PyReplaceTupleWithListQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyReplaceTupleWithListQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement element = descriptor2.getPsiElement();
        assert (element instanceof PyAssignmentStatement);
        PyExpression[] targets = ((PyAssignmentStatement)element).getTargets();
        if (targets.length == 1 && targets[0] instanceof PySubscriptionExpression && (subscriptionExpression = (PySubscriptionExpression)targets[0]).getOperand() instanceof PyReferenceExpression) {
            TypeEvalContext context;
            PyResolveContext resolveContext;
            PyReferenceExpression referenceExpression = (PyReferenceExpression)subscriptionExpression.getOperand();
            element = referenceExpression.followAssignmentsChain(resolveContext = PyResolveContext.defaultContext(context = TypeEvalContext.userInitiated(project, element.getContainingFile()))).getElement();
            if (element instanceof PyParenthesizedExpression) {
                PyExpression expression = ((PyParenthesizedExpression)element).getContainedExpression();
                PyReplaceTupleWithListQuickFix.replaceWithListLiteral(element, (PyTupleExpression)expression);
            } else if (element instanceof PyTupleExpression) {
                PyReplaceTupleWithListQuickFix.replaceWithListLiteral(element, (PyTupleExpression)element);
            }
        }
    }

    private static void replaceWithListLiteral(PsiElement element, PyTupleExpression expression) {
        String expressionText = expression.isEmpty() ? "" : expression.getText();
        PyExpression literal = PyElementGenerator.getInstance(element.getProject()).createExpressionFromText(LanguageLevel.forElement(element), "[" + expressionText + "]");
        element.replace((PsiElement)literal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyReplaceTupleWithListQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyReplaceTupleWithListQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

