/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyAsyncCallInspection$PyAddAwaitCallForCoroutineFix$WhenMappings;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "PyAddAwaitCallForCoroutineFix", "Visitor", "intellij.python.psi.impl"})
public final class PyAsyncCallInspection
extends PyInspection {
    @NotNull
    private static final List<String> ignoreReturnedType;
    @NotNull
    private static final List<String> ignoreBuiltinFunctions;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new Visitor(holder, session);
    }

    static {
        Companion = new Companion(null);
        ignoreReturnedType = CollectionsKt.listOf((Object)"asyncio.tasks.Task");
        ignoreBuiltinFunctions = CollectionsKt.listOf((Object[])new String[]{"asyncio.events.AbstractEventLoop.run_in_executor", "asyncio.tasks.ensure_future", "asyncio.ensure_future"});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "isAwaitableCall", "", "callExpr", "Lcom/jetbrains/python/psi/PyCallExpression;", "isIgnored", "visitPyExpressionStatement", "", "node", "Lcom/jetbrains/python/psi/PyExpressionStatement;", "intellij.python.psi.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyExpressionStatement(@NotNull PyExpressionStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression pyExpression = node.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"node.expression");
            PyExpression expr = pyExpression;
            if (expr instanceof PyCallExpression && this.isAwaitableCall((PyCallExpression)expr) && !this.isIgnored((PyCallExpression)expr)) {
                Companion.AwaitableType awaitableType;
                if (Companion.isOuterFunctionAsync(expr)) {
                    awaitableType = Companion.AwaitableType.AWAITABLE;
                } else {
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (Companion.isOuterFunctionCoroutine(expr, typeEvalContext)) {
                        awaitableType = Companion.AwaitableType.COROUTINE;
                    } else {
                        return;
                    }
                }
                Companion.AwaitableType awaitableType2 = awaitableType;
                PyCallExpression pyCallExpression = (PyCallExpression)expr;
                PyResolveContext pyResolveContext = this.getResolveContext();
                Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"resolveContext");
                String string = Companion.getCalledCoroutineName(pyCallExpression, pyResolveContext);
                if (string == null) {
                    return;
                }
                String functionName = string;
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.NAME.coroutine.is.not.awaited", functionName), new PyAddAwaitCallForCoroutineFix(awaitableType2));
            }
        }

        private final boolean isIgnored(PyCallExpression callExpr) {
            String typeQName;
            PyType pyType = this.myTypeEvalContext.getType(callExpr);
            if (pyType == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pyType, (String)"myTypeEvalContext.getType(callExpr) ?: return true");
            PyType type = pyType;
            String string = typeQName = type instanceof PyClassLikeType ? ((PyClassLikeType)type).getClassQName() : null;
            if (CollectionsKt.contains((Iterable)Companion.getIgnoreReturnedType(), (Object)typeQName)) {
                return true;
            }
            List<PyCallable> list = callExpr.multiResolveCalleeFunction(this.getResolveContext());
            Intrinsics.checkNotNullExpressionValue(list, (String)"callExpr.multiResolveCal\u2026eFunction(resolveContext)");
            PyCallable pyCallable = (PyCallable)CollectionsKt.firstOrNull(list);
            String qualifiedName = pyCallable != null ? pyCallable.getQualifiedName() : null;
            return CollectionsKt.contains((Iterable)Companion.getIgnoreBuiltinFunctions(), (Object)qualifiedName);
        }

        private final boolean isAwaitableCall(PyCallExpression callExpr) {
            PyType pyType = this.myTypeEvalContext.getType(callExpr);
            if (pyType == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pyType, (String)"myTypeEvalContext.getTyp\u2026callExpr) ?: return false");
            PyType type = pyType;
            return PyABCUtil.isSubtype(type, "Awaitable", this.myTypeEvalContext) || PyTypingTypeProvider.isGenerator(type) && PyKnownDecoratorUtil.isResolvedToGeneratorBasedCoroutine(callExpr, this.getResolveContext(), this.myTypeEvalContext);
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            super(holder, session);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection$PyAddAwaitCallForCoroutineFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "type", "Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion$AwaitableType;", "(Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion$AwaitableType;)V", "getType", "()Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion$AwaitableType;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.python.psi.impl"})
    private static final class PyAddAwaitCallForCoroutineFix
    implements LocalQuickFix {
        @NotNull
        private final Companion.AwaitableType type;

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.coroutine.is.not.awaited", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyPsiBundle.message(\"QFI\u2026oroutine.is.not.awaited\")");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement instanceof PyExpressionStatement) {
                StringBuilder sb = new StringBuilder();
                switch (PyAsyncCallInspection$PyAddAwaitCallForCoroutineFix$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                    case 1: {
                        sb.append("async def foo():\n    ").append("await").append(" ").append(((PyExpressionStatement)psiElement).getText());
                        break;
                    }
                    case 2: {
                        sb.append("def foo():\n    ").append("yield").append(" ").append("from").append(" ").append(((PyExpressionStatement)psiElement).getText());
                        break;
                    }
                }
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                PyFunction pyFunction = generator.createFromText(LanguageLevel.forElement(psiElement), PyFunction.class, sb.toString());
                Intrinsics.checkNotNullExpressionValue((Object)pyFunction, (String)"generator.createFromText\u2026lass.java, sb.toString())");
                PyFunction function = pyFunction;
                PyStatementList pyStatementList = function.getStatementList();
                Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"function.statementList");
                Object[] objectArray = pyStatementList.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"function.statementList.statements");
                PyStatement awaitedStatement = (PyStatement)ArraysKt.firstOrNull((Object[])objectArray);
                if (awaitedStatement != null) {
                    PyReplaceExpressionUtil.replaceExpression(psiElement, (PsiElement)awaitedStatement);
                }
            }
        }

        @NotNull
        public final Companion.AwaitableType getType() {
            return this.type;
        }

        public PyAddAwaitCallForCoroutineFix(@NotNull Companion.AwaitableType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion;", "", "()V", "ignoreBuiltinFunctions", "", "", "getIgnoreBuiltinFunctions", "()Ljava/util/List;", "ignoreReturnedType", "getIgnoreReturnedType", "getCalledCoroutineName", "callExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "resolveContext", "Lcom/jetbrains/python/psi/resolve/PyResolveContext;", "isOuterFunctionAsync", "", "node", "Lcom/jetbrains/python/psi/PyExpression;", "isOuterFunctionCoroutine", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "AwaitableType", "intellij.python.psi.impl"})
    public static final class Companion {
        @NotNull
        public final List<String> getIgnoreReturnedType() {
            return ignoreReturnedType;
        }

        @NotNull
        public final List<String> getIgnoreBuiltinFunctions() {
            return ignoreBuiltinFunctions;
        }

        private final String getCalledCoroutineName(PyCallExpression callExpression, PyResolveContext resolveContext) {
            PyExpression pyExpression = callExpression.getCallee();
            if (!(pyExpression instanceof PyReferenceExpression)) {
                pyExpression = null;
            }
            PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)pyExpression;
            if (pyReferenceExpression == null) {
                return null;
            }
            PyReferenceExpression callee = pyReferenceExpression;
            List<PyCallable> list = callExpression.multiResolveCalleeFunction(resolveContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"callExpression.multiReso\u2026eFunction(resolveContext)");
            Object object = CollectionsKt.firstOrNull(list);
            if (!(object instanceof PyFunction)) {
                object = null;
            }
            PyFunction pyFunction = (PyFunction)object;
            if (pyFunction == null) {
                return null;
            }
            PyFunction function = pyFunction;
            return PyUtil.isInitMethod(function) ? callee.getName() : function.getName();
        }

        public final boolean isOuterFunctionAsync(@NotNull PyExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
            if (!(scopeOwner instanceof PyFunction)) {
                scopeOwner = null;
            }
            PyFunction pyFunction = (PyFunction)scopeOwner;
            return pyFunction != null ? pyFunction.isAsync() : false;
        }

        private final boolean isOuterFunctionCoroutine(PyExpression node, TypeEvalContext typeEvalContext) {
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
            if (!(scopeOwner instanceof PyFunction)) {
                scopeOwner = null;
            }
            PyFunction pyFunction = (PyFunction)scopeOwner;
            if (pyFunction == null) {
                return false;
            }
            PyFunction pyFunction2 = pyFunction;
            return PyKnownDecoratorUtil.hasGeneratorBasedCoroutineDecorator(pyFunction2, typeEvalContext);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion$AwaitableType;", "", "(Ljava/lang/String;I)V", "AWAITABLE", "COROUTINE", "intellij.python.psi.impl"})
        public static final class AwaitableType
        extends Enum<AwaitableType> {
            public static final /* enum */ AwaitableType AWAITABLE;
            public static final /* enum */ AwaitableType COROUTINE;
            private static final /* synthetic */ AwaitableType[] $VALUES;

            static {
                AwaitableType[] awaitableTypeArray = new AwaitableType[2];
                AwaitableType[] awaitableTypeArray2 = awaitableTypeArray;
                awaitableTypeArray[0] = AWAITABLE = new AwaitableType();
                awaitableTypeArray[1] = COROUTINE = new AwaitableType();
                $VALUES = awaitableTypeArray;
            }

            public static AwaitableType[] values() {
                return (AwaitableType[])$VALUES.clone();
            }

            public static AwaitableType valueOf(String string) {
                return Enum.valueOf(AwaitableType.class, string);
            }
        }
    }
}

