/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ift;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.ift.PythonLessonsBundle;
import com.jetbrains.python.newProject.steps.ProjectSpecificSettingsStep;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import com.jetbrains.python.sdk.configuration.PyProjectVirtualEnvConfiguration;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.project.ProjectUtils;
import training.project.ReadMeCreator;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020 0#H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0002J\u001c\u0010+\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010,\u001a\u0004\u0018\u00010\u0017H\u0016J=\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u00192!\u00101\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020 0#H\u0016J\u001e\u00105\u001a\u00020 2\u0014\u00106\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020 0#H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/python/ift/PythonLangSupport;", "Ltraining/lang/AbstractLangSupport;", "()V", "defaultProductName", "", "getDefaultProductName", "()Ljava/lang/String;", "defaultProjectName", "getDefaultProjectName", "filename", "getFilename", "langCourseFeedback", "getLangCourseFeedback", "primaryLanguage", "getPrimaryLanguage", "projectSandboxRelativePath", "getProjectSandboxRelativePath", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "sourcesDirectoryName", "applyBaseSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "preferredSdk", "existingSdks", "", "module", "Lcom/intellij/openapi/module/Module;", "applyProjectSdk", "", "sdk", "applyToProjectAfterConfigure", "Lkotlin/Function1;", "blockProjectFileModification", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkSdk", "createVenv", "getExistingSdks", "getSdkForProject", "selectedSdk", "installAndOpenLearningProject", "projectPath", "Ljava/nio/file/Path;", "projectToClose", "postInitCallback", "Lkotlin/ParameterName;", "name", "learnProject", "startFromWelcomeFrame", "startCallback", "intellij.python.featuresTrainer"})
public final class PythonLangSupport
extends AbstractLangSupport {
    @NotNull
    private final String defaultProjectName;
    @NotNull
    private final String primaryLanguage;
    @NotNull
    private final String defaultProductName;
    private final String sourcesDirectoryName;
    @NotNull
    private final String filename;
    @NotNull
    private final ReadMeCreator readMeCreator = new ReadMeCreator();
    @NotNull
    private final String projectSandboxRelativePath;

    @NotNull
    public String getDefaultProjectName() {
        return this.defaultProjectName;
    }

    @NotNull
    public String getPrimaryLanguage() {
        return this.primaryLanguage;
    }

    @NotNull
    public String getDefaultProductName() {
        return this.defaultProductName;
    }

    @NotNull
    public String getFilename() {
        return this.filename;
    }

    @Nullable
    public String getLangCourseFeedback() {
        return UtilsKt.getFeedbackLink((LangSupport)((LangSupport)this), (boolean)false);
    }

    @NotNull
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    @NotNull
    public Function1<Project, Unit> applyToProjectAfterConfigure() {
        return (Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ PythonLangSupport this$0;

            public final void invoke(@NotNull Project project) {
                ContentEntry contentEntry;
                boolean bl;
                Object object;
                ModifiableRootModel rootsModel;
                VirtualFile sourcesRoot;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Object[] objectArray = PyStatisticToolsKt.getModules(project);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
                    Module module = (Module)ArraysKt.first((Object[])objectArray);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = project.getBasePath();
                    Intrinsics.checkNotNull((Object)string);
                    String sourcesPath = stringBuilder.append(string).append('/').append(PythonLangSupport.access$getSourcesDirectoryName$p(this.this$0)).toString();
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(sourcesPath);
                    if (virtualFile == null) {
                        String string2 = "Failed to find directory with source files: " + sourcesPath;
                        boolean bl2 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026rce files: $sourcesPath\")");
                    sourcesRoot = virtualFile;
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    ModifiableRootModel modifiableRootModel = moduleRootManager.getModifiableModel();
                    Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"ModuleRootManager.getIns\u2026e(module).modifiableModel");
                    rootsModel = modifiableRootModel;
                    ContentEntry[] contentEntryArray = rootsModel.getContentEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"rootsModel.contentEntries");
                    object = contentEntryArray;
                    bl = false;
                    ContentEntry[] contentEntryArray2 = object;
                    boolean bl3 = false;
                    ContentEntry[] contentEntryArray3 = contentEntryArray2;
                    int n = contentEntryArray3.length;
                    for (int i = 0; i < n; ++i) {
                        ContentEntry contentEntry2;
                        ContentEntry it = contentEntry2 = contentEntryArray3[i];
                        boolean bl4 = false;
                        ContentEntry contentEntry3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntry3, (String)"it");
                        VirtualFile contentEntryFile = contentEntry3.getFile();
                        if (!(contentEntryFile != null && VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)sourcesRoot, (boolean)false))) continue;
                        contentEntry = contentEntry2;
                        break block3;
                    }
                    contentEntry = null;
                }
                if (contentEntry == null) {
                    object = "Failed to find content entry for file: " + sourcesRoot.getName();
                    bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                ContentEntry contentEntry4 = contentEntry;
                contentEntry4.addSourceFolder(sourcesRoot, false);
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction(new Computable(rootsModel, project){
                    final /* synthetic */ ModifiableRootModel $rootsModel$inlined;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$rootsModel$inlined = modifiableRootModel;
                        this.$project$inlined = project;
                    }

                    public final T compute() {
                        boolean bl = false;
                        this.$rootsModel$inlined.commit();
                        this.$project$inlined.save();
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = pythonLangSupport;
                super(1);
            }
        };
    }

    public void installAndOpenLearningProject(@NotNull Path projectPath, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        OpenProjectTask openProjectTask = new OpenProjectTask(false, projectToClose, false, false, null, null, false, null, null, 0, 0, false, false, false, null, true, false, null, null, null, 1015805, null);
        ProjectUtils.INSTANCE.simpleInstallAndOpenLearningProject(projectPath, (LangSupport)this, openProjectTask, postInitCallback);
    }

    @Nullable
    public Sdk getSdkForProject(@NotNull Project project, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (selectedSdk != null) {
            Object[] objectArray = PyStatisticToolsKt.getModules(project);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
            Module module = (Module)ArraysKt.first((Object[])objectArray);
            List<Sdk> existingSdks = this.getExistingSdks();
            return this.applyBaseSdk(project, selectedSdk, existingSdks, module);
        }
        if (PySdkExtKt.getPythonSdk(project) != null) {
            return null;
        }
        return this.createVenv(project);
    }

    private final Sdk createVenv(Project project) {
        Object[] objectArray = PyStatisticToolsKt.getModules(project);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
        Module module = (Module)ArraysKt.first((Object[])objectArray);
        List<Sdk> existingSdks = this.getExistingSdks();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks, module, (UserDataHolder)project);
        Sdk preferredSdk = PyProjectVirtualEnvConfiguration.INSTANCE.findPreferredVirtualEnvBaseSdk(baseSdks);
        return this.applyBaseSdk(project, preferredSdk, existingSdks, module);
    }

    private final Sdk applyBaseSdk(Project project, Sdk preferredSdk, List<? extends Sdk> existingSdks, Module module) {
        Sdk sdk;
        Sdk venvSdk;
        String string = FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(project.getBasePath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDepende\u2026sePath(project.basePath))");
        String venvRoot = string;
        Sdk sdk2 = venvSdk = PyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously$default(PyProjectVirtualEnvConfiguration.INSTANCE, preferredSdk, existingSdks, venvRoot, project.getBasePath(), project, module, (UserDataHolder)project, false, false, 384, null);
        if (sdk2 != null) {
            Sdk sdk3 = sdk2;
            boolean bl = false;
            boolean bl2 = false;
            Sdk it = sdk3;
            boolean bl3 = false;
            SdkConfigurationUtil.addSdk((Sdk)it);
            sdk = sdk3;
        } else {
            sdk = null;
        }
        return sdk;
    }

    public void applyProjectSdk(@NotNull Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = PyStatisticToolsKt.getModules(project);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.modules");
        Object object = ArraysKt.first((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.modules.first()");
        PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, (Module)object, sdk);
    }

    private final List<Sdk> getExistingSdks() {
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(null)");
        List<Sdk> list = pyConfigurableInterpreterList.getAllPythonSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"PyConfigurableInterprete\u2026tance(null).allPythonSdks");
        Iterable iterable = list;
        PreferredSdkComparator preferredSdkComparator = PreferredSdkComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)preferredSdkComparator, (String)"PreferredSdkComparator.INSTANCE");
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)preferredSdkComparator);
    }

    public void checkSdk(@Nullable Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public boolean blockProjectFileModification(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)this.getProjectSandboxRelativePath()) ^ true;
    }

    @NotNull
    public String getProjectSandboxRelativePath() {
        return this.projectSandboxRelativePath;
    }

    public void startFromWelcomeFrame(@NotNull Function1<? super Sdk, Unit> startCallback) {
        Intrinsics.checkNotNullParameter(startCallback, (String)"startCallback");
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(null)");
        ProjectSdksModel projectSdksModel = pyConfigurableInterpreterList.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)projectSdksModel, (String)"PyConfigurableInterprete\u2026t.getInstance(null).model");
        Sdk[] sdkArray = projectSdksModel.getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"PyConfigurableInterprete\u2026Instance(null).model.sdks");
        List allExistingSdks = CollectionsKt.listOf((Object[])Arrays.copyOf(sdkArray, sdkArray.length));
        List<Sdk> list = ProjectSpecificSettingsStep.getValidPythonSdks(allExistingSdks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"ProjectSpecificSettingsS\u2026thonSdks(allExistingSdks)");
        List<Sdk> existingSdks = list;
        UserDataHolderBase context = new UserDataHolderBase();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks, null, (UserDataHolder)context);
        if (baseSdks.isEmpty()) {
            JPanel formPanel;
            PySdkPathChoosingComboBox baseSdkField = new PySdkPathChoosingComboBox(null, null, 3, null);
            JLabel warningPlaceholder = new JLabel();
            FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)warningPlaceholder).addLabeledComponent(PySdkBundle.message("python.venv.base.label", new Object[0]), (JComponent)((Object)baseSdkField));
            Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026se.label\"), baseSdkField)");
            JPanel jPanel = formPanel = formBuilder.getPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"formPanel");
            int n = formPanel.getPreferredSize().width;
            int n2 = 500;
            boolean bl = false;
            jPanel.setPreferredSize(new Dimension(Math.max(n, n2), formPanel.getPreferredSize().height));
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            DialogWrapper dialog2 = new DialogWrapper(formPanel, projectManager.getDefaultProject()){
                final /* synthetic */ JPanel $formPanel;

                @NotNull
                protected JComponent createCenterPanel() {
                    JPanel jPanel = this.$formPanel;
                    Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"formPanel");
                    return jPanel;
                }
                {
                    this.$formPanel = $captured_local_variable$0;
                    super($super_call_param$1);
                    this.setTitle(PyBundle.message("sdk.select.path", new Object[0]));
                    this.init();
                }
            };
            PyAddSdkPanelKt.addBaseInterpretersAsync(baseSdkField, existingSdks, null, (UserDataHolder)context, (Function0<Unit>)((Function0)new Function0<Unit>(baseSdkField, warningPlaceholder){
                final /* synthetic */ PySdkPathChoosingComboBox $baseSdkField;
                final /* synthetic */ JLabel $warningPlaceholder;

                public final void invoke() {
                    Sdk selectedSdk = this.$baseSdkField.getSelectedSdk();
                    if (selectedSdk instanceof PySdkToInstall) {
                        PySdkToInstall pySdkToInstall = (PySdkToInstall)selectedSdk;
                        String string = Messages.getOkButton();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Messages.getOkButton()");
                        String installationWarning = pySdkToInstall.getInstallationWarning(string);
                        this.$warningPlaceholder.setText("<html>" + installationWarning + "</html>");
                    } else {
                        this.$warningPlaceholder.setText("");
                    }
                }
                {
                    this.$baseSdkField = pySdkPathChoosingComboBox;
                    this.$warningPlaceholder = jLabel;
                    super(0);
                }
            }));
            dialog2.setTitle(PythonLessonsBundle.INSTANCE.message("choose.python.sdk.to.start.learning.header", new Object[0]));
            if (dialog2.showAndGet()) {
                Sdk selectedSdk = baseSdkField.getSelectedSdk();
                if (selectedSdk == null) {
                    return;
                }
                startCallback.invoke((Object)selectedSdk);
            }
        } else {
            startCallback.invoke(null);
        }
    }

    public PythonLangSupport() {
        this.defaultProjectName = "PyCharmLearningProject";
        this.primaryLanguage = "Python";
        this.defaultProductName = "PyCharm";
        this.sourcesDirectoryName = "src";
        this.filename = "Learning.py";
        this.projectSandboxRelativePath = "src/sandbox.py";
    }

    public static final /* synthetic */ String access$getSourcesDirectoryName$p(PythonLangSupport $this) {
        return $this.sourcesDirectoryName;
    }
}

