/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.highlighting.PyRainbowVisitor;
import com.jetbrains.python.highlighting.PyRainbowVisitor$getTargetContext$;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\f\u001a\u00020\u0000H\u0016J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0006H\u0016\u00a8\u0006'"}, d2={"Lcom/jetbrains/python/highlighting/PyRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "()V", "addInfo", "", "context", "Lcom/intellij/psi/PsiElement;", "rainbowElement", "name", "", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "clone", "getLeastCommonScope", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "elements", "", "getNamedParameterContext", "namedParameter", "Lcom/jetbrains/python/psi/PyNamedParameter;", "getReferenceContext", "referenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitedReferenceExpressions", "", "getTargetContext", "targetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "processNamedParameter", "processReference", "processTarget", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "updateNameIfGlobal", "visit", "element", "Holder", "intellij.python.community.impl"})
public final class PyRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof PyFile;
    }

    public void visit(@NotNull PsiElement element) {
        block1: {
            PsiElement psiElement;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    psiElement = element;
                    if (!(psiElement instanceof PyReferenceExpression)) break block0;
                    this.processReference((PyReferenceExpression)element);
                    break block1;
                }
                if (!(psiElement instanceof PyTargetExpression)) break block2;
                this.processTarget((PyTargetExpression)element);
                break block1;
            }
            if (!(psiElement instanceof PyNamedParameter)) break block1;
            this.processNamedParameter((PyNamedParameter)element);
        }
    }

    @NotNull
    public PyRainbowVisitor clone() {
        return new PyRainbowVisitor();
    }

    private final void processReference(PyReferenceExpression referenceExpression) {
        boolean bl = false;
        PsiElement psiElement = this.getReferenceContext(referenceExpression, new LinkedHashSet());
        if (psiElement == null) {
            return;
        }
        PsiElement context = psiElement;
        String string = this.updateNameIfGlobal(context, referenceExpression.getName());
        if (string == null) {
            return;
        }
        String name = string;
        PyRainbowVisitor.addInfo$default(this, context, (PsiElement)referenceExpression, name, null, 8, null);
    }

    private final void processTarget(PyTargetExpression targetExpression) {
        PsiElement psiElement = this.getTargetContext(targetExpression);
        if (psiElement == null) {
            return;
        }
        PsiElement context = psiElement;
        String string = this.updateNameIfGlobal(context, targetExpression.getName());
        if (string == null) {
            return;
        }
        String name = string;
        PyRainbowVisitor.addInfo$default(this, context, targetExpression, name, null, 8, null);
    }

    private final void processNamedParameter(PyNamedParameter namedParameter) {
        PsiElement psiElement = this.getNamedParameterContext(namedParameter);
        if (psiElement == null) {
            return;
        }
        PsiElement context = psiElement;
        String string = namedParameter.getName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"namedParameter.name ?: return");
        String name = string;
        PsiElement psiElement2 = namedParameter.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"namedParameter.nameIdentifier ?: return");
        PsiElement element = psiElement2;
        this.addInfo(context, element, name, PyHighlighter.PY_PARAMETER);
    }

    private final PsiElement getReferenceContext(PyReferenceExpression referenceExpression, Set<PyReferenceExpression> visitedReferenceExpressions) {
        PsiElement psiElement;
        if (referenceExpression.isQualified() || CollectionsKt.contains((Iterable)Holder.INSTANCE.getIGNORED_NAMES(), (Object)referenceExpression.getName())) {
            return null;
        }
        PsiElement resolved = referenceExpression.getReference().resolve();
        PsiElement psiElement2 = resolved;
        if (psiElement2 instanceof PyTargetExpression) {
            psiElement = this.getTargetContext((PyTargetExpression)resolved);
        } else if (psiElement2 instanceof PyNamedParameter) {
            psiElement = this.getNamedParameterContext((PyNamedParameter)resolved);
        } else {
            if (psiElement2 instanceof PyReferenceExpression) {
                if (!visitedReferenceExpressions.add((PyReferenceExpression)resolved)) {
                    return (PsiElement)this.getLeastCommonScope((Collection<? extends PsiElement>)visitedReferenceExpressions);
                }
                return ((PyReferenceExpression)resolved).getParent() instanceof PyAugAssignmentStatement ? this.getReferenceContext((PyReferenceExpression)resolved, visitedReferenceExpressions) : null;
            }
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement getTargetContext(PyTargetExpression targetExpression) {
        Object v2;
        block9: {
            Sequence $this$filterIsInstance$iv;
            boolean resolvesToGlobal2;
            Object[] resolveResults;
            block8: {
                boolean bl;
                void $this$any$iv;
                if (targetExpression.isQualified() || CollectionsKt.contains((Iterable)Holder.INSTANCE.getIGNORED_NAMES(), (Object)targetExpression.getName())) {
                    return null;
                }
                PsiElement parent = targetExpression.getParent();
                if (parent instanceof PyGlobalStatement) {
                    return (PsiElement)targetExpression.getContainingFile();
                }
                if (parent instanceof PyNonlocalStatement) {
                    PsiElement outerResolved = targetExpression.getReference().resolve();
                    return outerResolved instanceof PyTargetExpression ? this.getTargetContext((PyTargetExpression)outerResolved) : null;
                }
                TypeEvalContext context = TypeEvalContext.codeInsightFallback(targetExpression.getProject());
                resolveResults = targetExpression.getReference(PyResolveContext.defaultContext(context)).multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResults, (String)"resolveResults");
                Sequence sequence = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])resolveResults), (Function1)getTargetContext.resolvesToGlobal.1.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PyTargetExpression && ((PyTargetExpression)it).getParent() instanceof PyGlobalStatement)) continue;
                    bl = true;
                    break block8;
                }
                bl = resolvesToGlobal2 = false;
            }
            if (resolvesToGlobal2) {
                return (PsiElement)targetExpression.getContainingFile();
            }
            Sequence $i$f$any = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])resolveResults), (Function1)getTargetContext.resolvedNonLocal.1.INSTANCE);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getTargetContext$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            $this$filterIsInstance$iv = sequence;
            boolean bl = false;
            Sequence sequence2 = $this$filterIsInstance$iv;
            boolean bl3 = false;
            for (Object e : sequence2) {
                PyTargetExpression it = (PyTargetExpression)e;
                boolean bl4 = false;
                if (!(it.getParent() instanceof PyNonlocalStatement)) continue;
                v2 = e;
                break block9;
            }
            v2 = null;
        }
        PyTargetExpression resolvedNonLocal2 = v2;
        if (resolvedNonLocal2 != null) {
            return this.getTargetContext(resolvedNonLocal2);
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(targetExpression);
        return scopeOwner instanceof PyFile || scopeOwner instanceof PyFunction || scopeOwner instanceof PyLambdaExpression ? (PsiElement)scopeOwner : null;
    }

    private final PsiElement getNamedParameterContext(PyNamedParameter namedParameter) {
        if (namedParameter.isSelf()) {
            return null;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(namedParameter);
        return scopeOwner instanceof PyLambdaExpression || scopeOwner instanceof PyFunction ? (PsiElement)scopeOwner : null;
    }

    private final String updateNameIfGlobal(PsiElement context, String name) {
        return context instanceof PyFile && name != null ? "global_" + name : name;
    }

    private final void addInfo(PsiElement context, PsiElement rainbowElement, String name, TextAttributesKey key) {
        this.addInfo(this.getInfo(context, rainbowElement, name, key));
    }

    static /* synthetic */ void addInfo$default(PyRainbowVisitor pyRainbowVisitor, PsiElement psiElement, PsiElement psiElement2, String string, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 8) != 0) {
            textAttributesKey = Holder.INSTANCE.getDEFAULT_HIGHLIGHTING_KEY();
        }
        pyRainbowVisitor.addInfo(psiElement, psiElement2, string, textAttributesKey);
    }

    private final ScopeOwner getLeastCommonScope(Collection<? extends PsiElement> elements) {
        ScopeOwner result = null;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            ScopeOwner currentScopeOwner = ScopeUtil.getScopeOwner(it);
            if (result == null) {
                result = currentScopeOwner;
                continue;
            }
            if (!(Intrinsics.areEqual((Object)result, (Object)currentScopeOwner) ^ true) || currentScopeOwner == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)result), (PsiElement)((PsiElement)currentScopeOwner), (boolean)true)) continue;
            result = currentScopeOwner;
        }
        return result;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/highlighting/PyRainbowVisitor$Holder;", "", "()V", "DEFAULT_HIGHLIGHTING_KEY", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "kotlin.jvm.PlatformType", "getDEFAULT_HIGHLIGHTING_KEY", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "HIGHLIGHTING_KEYS", "", "getHIGHLIGHTING_KEYS$annotations", "getHIGHLIGHTING_KEYS", "()Ljava/util/Set;", "IGNORED_NAMES", "", "getIGNORED_NAMES", "intellij.python.community.impl"})
    public static final class Holder {
        @NotNull
        private static final Set<String> IGNORED_NAMES;
        private static final TextAttributesKey DEFAULT_HIGHLIGHTING_KEY;
        @NotNull
        private static final Set<TextAttributesKey> HIGHLIGHTING_KEYS;
        @NotNull
        public static final Holder INSTANCE;

        @NotNull
        public final Set<String> getIGNORED_NAMES() {
            return IGNORED_NAMES;
        }

        public final TextAttributesKey getDEFAULT_HIGHLIGHTING_KEY() {
            return DEFAULT_HIGHLIGHTING_KEY;
        }

        @JvmStatic
        public static /* synthetic */ void getHIGHLIGHTING_KEYS$annotations() {
        }

        @NotNull
        public static final Set<TextAttributesKey> getHIGHLIGHTING_KEYS() {
            return HIGHLIGHTING_KEYS;
        }

        private Holder() {
        }

        static {
            Holder holder;
            INSTANCE = holder = new Holder();
            IGNORED_NAMES = SetsKt.setOf((Object[])new String[]{"None", "True", "False"});
            DEFAULT_HIGHLIGHTING_KEY = DefaultLanguageHighlighterColors.LOCAL_VARIABLE;
            HIGHLIGHTING_KEYS = SetsKt.setOf((Object[])new TextAttributesKey[]{PyHighlighter.PY_PARAMETER, DEFAULT_HIGHLIGHTING_KEY});
        }
    }
}

