/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.doctest;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingLexer;

public class PyDocstringLexer
extends PythonIndentingLexer {
    static final TokenSet ourIgnoreSet = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.DOT, PyTokenTypes.GTGT, PyTokenTypes.GT});

    @Override
    public void advance() {
        if (super.getTokenType() == PyTokenTypes.DOT) {
            this.advanceBase();
            if (super.getTokenType() == PyTokenTypes.DOT) {
                this.advanceBase();
                if (super.getTokenType() == PyTokenTypes.DOT) {
                    super.advance();
                }
            }
        } else if (super.getTokenType() == PyTokenTypes.GTGT) {
            this.advanceBase();
            if (super.getTokenType() == PyTokenTypes.GT) {
                this.advanceBase();
            }
        } else {
            super.advance();
        }
    }

    @Override
    protected int getNextLineIndent() {
        int indent = super.getNextLineIndent();
        if (!ourIgnoreSet.contains(this.getBaseTokenType())) {
            return indent;
        }
        indent = 0;
        while (this.getBaseTokenType() != null && ourIgnoreSet.contains(this.getBaseTokenType())) {
            this.advanceBase();
        }
        while (this.getBaseTokenType() != null && (PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(this.getBaseTokenType()) || ourIgnoreSet.contains(this.getBaseTokenType()))) {
            if (this.getBaseTokenType() == PyTokenTypes.TAB) {
                indent = (indent / 8 + 1) * 8;
            } else if (this.getBaseTokenType() == PyTokenTypes.SPACE) {
                ++indent;
            } else if (this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
                indent = 0;
                super.getNextLineIndent();
            }
            this.advanceBase();
        }
        if (this.getBaseTokenType() == null) {
            return 0;
        }
        return indent > 0 ? indent - 1 : indent;
    }

    @Override
    protected void checkSignificantTokens() {
        IElementType tokenType = this.getBaseTokenType();
        if (!PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(tokenType) && tokenType != this.getCommentTokenType() && !ourIgnoreSet.contains(tokenType)) {
            this.myLineHasSignificantTokens = true;
        }
    }

    @Override
    protected void checkStartState(int startOffset, int initialState) {
    }
}

