/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyDebuggerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myMainPanel;
    private JCheckBox myAttachToSubprocess;
    private JCheckBox mySaveSignatures;
    private JCheckBox mySupportGevent;
    private JBCheckBox mySupportQt;
    private JCheckBox myDropIntoDebuggerOnFailedTests;
    private JBLabel warningIcon;
    private ComboBox<PyQtBackend> myPyQtBackend;
    private ActionLink myActionLink;
    private JBTextField myAttachProcessFilter;
    private JBLabel myAttachFilterLabel;
    private final Project myProject;

    public PyDebuggerConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        Arrays.stream(PyQtBackend.values()).forEach(e -> this.myPyQtBackend.addItem((Object)e));
        this.mySupportQt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PyDebuggerConfigurable.this.myPyQtBackend.setEnabled(PyDebuggerConfigurable.this.mySupportQt.isSelected());
            }
        });
        this.myAttachFilterLabel.setText(PyBundle.message("debugger.attach.to.process.filter.names", new Object[0]));
    }

    public String getDisplayName() {
        return PyBundle.message("configurable.PyDebuggerConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger.python";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            PyDebuggerConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        PyDebuggerOptionsProvider settings = PyDebuggerOptionsProvider.getInstance(this.myProject);
        return this.myAttachToSubprocess.isSelected() != settings.isAttachToSubprocess() || this.mySaveSignatures.isSelected() != settings.isSaveCallSignatures() || this.mySupportGevent.isSelected() != settings.isSupportGeventDebugging() || this.myDropIntoDebuggerOnFailedTests.isSelected() != settings.isDropIntoDebuggerOnFailedTest() || this.mySupportQt.isSelected() != settings.isSupportQtDebugging() || this.myPyQtBackend.getSelectedItem() != null && !StringUtil.toLowerCase((String)((PyQtBackend)((Object)this.myPyQtBackend.getSelectedItem())).name()).equals(settings.getPyQtBackend()) || !this.myAttachProcessFilter.getText().equals(settings.getAttachProcessFilter());
    }

    public void apply() {
        PyDebuggerOptionsProvider settings = PyDebuggerOptionsProvider.getInstance(this.myProject);
        settings.setAttachToSubprocess(this.myAttachToSubprocess.isSelected());
        settings.setSaveCallSignatures(this.mySaveSignatures.isSelected());
        settings.setSupportGeventDebugging(this.mySupportGevent.isSelected());
        settings.setDropIntoDebuggerOnFailedTest(this.myDropIntoDebuggerOnFailedTests.isSelected());
        settings.setSupportQtDebugging(this.mySupportQt.isSelected());
        Object selectedBackend = this.myPyQtBackend.getSelectedItem();
        if (selectedBackend != null) {
            settings.setPyQtBackend(StringUtil.toLowerCase((String)((PyQtBackend)((Object)selectedBackend)).name()));
        }
        settings.setAttachProcessFilter(this.myAttachProcessFilter.getText());
    }

    public void reset() {
        PyDebuggerOptionsProvider settings = PyDebuggerOptionsProvider.getInstance(this.myProject);
        this.myAttachToSubprocess.setSelected(settings.isAttachToSubprocess());
        this.mySaveSignatures.setSelected(settings.isSaveCallSignatures());
        this.mySupportGevent.setSelected(settings.isSupportGeventDebugging());
        this.myDropIntoDebuggerOnFailedTests.setSelected(settings.isDropIntoDebuggerOnFailedTest());
        this.mySupportQt.setSelected(settings.isSupportQtDebugging());
        this.myPyQtBackend.setSelectedItem((Object)PyQtBackend.valueOf(StringUtil.toUpperCase((String)settings.getPyQtBackend())));
        this.myAttachProcessFilter.setText(settings.getAttachProcessFilter());
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.warningIcon = new JBLabel(AllIcons.General.BalloonWarning);
        IdeTooltipManager.getInstance().setCustomTooltip((JComponent)this.warningIcon, (IdeTooltip)new TooltipWithClickableLinks.ForBrowser((JComponent)this.warningIcon, PyBundle.message("debugger.warning.message", new Object[0])));
        this.myActionLink = new ActionLink(PyBundle.message("form.debugger.clear.caches.action", new Object[0]), e -> {
            boolean cleared = PySignatureCacheManager.getInstance(this.myProject).clearCache();
            String message = cleared ? PyBundle.message("python.debugger.collection.signatures.deleted", new Object[0]) : PyBundle.message("python.debugger.nothing.to.delete", new Object[0]);
            Messages.showInfoMessage((Project)this.myProject, (String)message, (String)PyBundle.message("debugger.delete.signature.cache", new Object[0]));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebuggerConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myAttachToSubprocess = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerConfigurable.class).getString("form.debugger.attach.to.subprocess.automatically.while.debugging"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 5, 8, 0, 3, 3, null, null, null));
        this.mySaveSignatures = jCheckBox3 = new JCheckBox();
        jCheckBox3.setActionCommand(ResourceBundle.getBundle("messages/PyBundle").getString("form.debugger.save.call.signatures"));
        jCheckBox3.setLabel(ResourceBundle.getBundle("messages/PyBundle").getString("form.debugger.collect.run.time.types.information.for.code.insight"));
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerConfigurable.class).getString("form.debugger.collect.run.time.types.information.for.code.insight"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 3, null, null, null));
        this.mySupportGevent = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerConfigurable.class).getString("form.debugger.gevent.compatible"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 5, 8, 0, 3, 3, null, null, null));
        this.mySupportQt = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerConfigurable.class).getString("form.debugger.pyqt.compatible"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel2 = this.warningIcon;
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myPyQtBackend = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(4, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("                                             ");
        jPanel2.add((Component)jBLabel3, new GridConstraints(4, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.myActionLink;
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerConfigurable.class).getString("form.debugger.clear.caches"));
        jPanel2.add((Component)actionLink, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 5, 1, 1, 0, 1, 6, 1, null, new Dimension(75, 11), null));
        this.myDropIntoDebuggerOnFailedTests = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerConfigurable.class).getString("form.debugger.drop.into.debugger.on.failed.tests"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myAttachFilterLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerConfigurable.class).getString("form.debugger.for.attach.to.process.show.processes.with.names.containing"));
        jBLabel.putClientProperty((Object)"html.disable", (Object)Boolean.FALSE);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAttachProcessFilter = jBTextField = new JBTextField();
        jBTextField.setEnabled(true);
        jBTextField.setText(DynamicBundle.getBundle((String)"messages/PyBundle", PyDebuggerConfigurable.class).getString("form.debugger.remote.interpreter.docker.default.interpreter.path"));
        jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 3, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 2, 1, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static enum PyQtBackend {
        AUTO(PyBundle.messagePointer("python.debugger.qt.backend.auto", new Object[0])),
        PYQT4("PyQt4"),
        PYQT5("PyQt5"),
        PYSIDE("PySide"),
        PYSIDE2("PySide2");

        private final Supplier<@Nls String> myDisplayNameSupplier;

        private PyQtBackend(String displayName) {
            if (displayName == null) {
                PyQtBackend.$$$reportNull$$$0(0);
            }
            this.myDisplayNameSupplier = () -> displayName;
        }

        private PyQtBackend(Supplier<String> displayNamePointer) {
            this.myDisplayNameSupplier = displayNamePointer;
        }

        @Nls
        public String toString() {
            return this.myDisplayNameSupplier.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/jetbrains/python/debugger/PyDebuggerConfigurable$PyQtBackend", "<init>"));
        }
    }
}

