/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.Comparing;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PyConfigurableInterpreterList {
    private ProjectSdksModel myModel;

    public static PyConfigurableInterpreterList getInstance(@Nullable Project project) {
        Project effectiveProject = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        PyConfigurableInterpreterList instance = (PyConfigurableInterpreterList)effectiveProject.getService(PyConfigurableInterpreterList.class);
        if (effectiveProject != project) {
            instance.disposeModel();
        }
        return instance;
    }

    public ProjectSdksModel getModel() {
        if (this.myModel == null) {
            this.myModel = new ProjectSdksModel();
            this.myModel.reset(null);
        }
        return this.myModel;
    }

    public void disposeModel() {
        if (this.myModel != null) {
            this.myModel.disposeUIResources();
            this.myModel = null;
        }
    }

    public List<Sdk> getAllPythonSdks(@Nullable Project project) {
        ArrayList<Sdk> result = new ArrayList<Sdk>();
        for (Sdk sdk : this.getModel().getSdks()) {
            if (!(sdk.getSdkType() instanceof PythonSdkType)) continue;
            result.add(sdk);
        }
        result.sort(new PyInterpreterComparator(project));
        return result;
    }

    public List<Sdk> getAllPythonSdks() {
        return this.getAllPythonSdks(null);
    }

    private static class PyInterpreterComparator
    implements Comparator<Sdk> {
        @Nullable
        private final Project myProject;

        PyInterpreterComparator(@Nullable Project project) {
            this.myProject = project;
        }

        @Override
        public int compare(Sdk o1, Sdk o2) {
            if (!(o1.getSdkType() instanceof PythonSdkType) || !(o2.getSdkType() instanceof PythonSdkType)) {
                return -Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
            boolean isVEnv1 = PythonSdkUtil.isVirtualEnv(o1) || PythonSdkUtil.isCondaVirtualEnv(o1);
            boolean isVEnv2 = PythonSdkUtil.isVirtualEnv(o2) || PythonSdkUtil.isCondaVirtualEnv(o2);
            boolean isRemote1 = PythonSdkUtil.isRemote(o1);
            boolean isRemote2 = PythonSdkUtil.isRemote(o2);
            if (isVEnv1) {
                if (isVEnv2) {
                    if (this.myProject != null && PyInterpreterComparator.associatedWithCurrent(o1, this.myProject)) {
                        if (PyInterpreterComparator.associatedWithCurrent(o2, this.myProject)) {
                            return PyInterpreterComparator.compareSdk(o1, o2);
                        }
                        return -1;
                    }
                    return PyInterpreterComparator.compareSdk(o1, o2);
                }
                return -1;
            }
            if (isVEnv2) {
                return 1;
            }
            if (isRemote1) {
                if (isRemote2) {
                    return PyInterpreterComparator.compareSdk(o1, o2);
                }
                return 1;
            }
            if (isRemote2) {
                return -1;
            }
            return PyInterpreterComparator.compareSdk(o1, o2);
        }

        private static int compareSdk(Sdk o1, Sdk o2) {
            PythonSdkFlavor flavor2;
            LanguageLevel level2;
            PythonSdkFlavor flavor1 = PythonSdkFlavor.getFlavor(o1);
            LanguageLevel level1 = flavor1 != null ? flavor1.getLanguageLevel(o1) : LanguageLevel.getDefault();
            int compare = Comparing.compare((Comparable)((Object)level1), (Comparable)((Object)(level2 = (flavor2 = PythonSdkFlavor.getFlavor(o2)) != null ? flavor2.getLanguageLevel(o2) : LanguageLevel.getDefault())));
            if (compare != 0) {
                return -compare;
            }
            return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }

        private static boolean associatedWithCurrent(Sdk o1, Project project) {
            PythonSdkAdditionalData data = (PythonSdkAdditionalData)o1.getSdkAdditionalData();
            if (data != null) {
                String path = data.getAssociatedModulePath();
                String projectBasePath = project.getBasePath();
                if (path != null && path.equals(projectBasePath)) {
                    return true;
                }
            }
            return false;
        }
    }
}

