/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.codeInsight.imports.ImportFromExistingAction;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoImportQuickFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    private final List<ImportCandidateHolder> myImports;
    private final String myInitialName;
    private final boolean myUseQualifiedImport;
    @NotNull
    private final Class<? extends PsiReference> myReferenceType;
    private boolean myExpended;

    public AutoImportQuickFix(@NotNull PsiElement node, @NotNull Class<? extends PsiReference> referenceType, @NotNull String name, boolean qualify) {
        if (node == null) {
            AutoImportQuickFix.$$$reportNull$$$0(0);
        }
        if (referenceType == null) {
            AutoImportQuickFix.$$$reportNull$$$0(1);
        }
        if (name == null) {
            AutoImportQuickFix.$$$reportNull$$$0(2);
        }
        this(node, referenceType, name, qualify, Collections.emptyList());
    }

    private AutoImportQuickFix(@NotNull PsiElement node, @NotNull Class<? extends PsiReference> referenceType, @NotNull String name, boolean qualify, @NotNull Collection<ImportCandidateHolder> candidates) {
        if (node == null) {
            AutoImportQuickFix.$$$reportNull$$$0(3);
        }
        if (referenceType == null) {
            AutoImportQuickFix.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AutoImportQuickFix.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            AutoImportQuickFix.$$$reportNull$$$0(6);
        }
        super(node);
        this.myExpended = false;
        this.myReferenceType = referenceType;
        this.myInitialName = name;
        this.myUseQualifiedImport = qualify;
        this.myImports = new ArrayList<ImportCandidateHolder>(candidates);
    }

    public void addImport(@NotNull PsiNamedElement importable, @NotNull PsiFile file, @Nullable PyImportElement importElement) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(8);
        }
        this.myImports.add(new ImportCandidateHolder(importable, (PsiFileSystemItem)file, importElement, null));
    }

    public void addImport(@NotNull PsiNamedElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(9);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(10);
        }
        this.myImports.add(new ImportCandidateHolder(importable, file, null, path));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void addImport(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(11);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(12);
        }
        if (importable instanceof PsiNamedElement) {
            this.addImport((PsiNamedElement)importable, file, path);
        }
    }

    public void addImport(@NotNull PsiNamedElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path, @Nullable String asName) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(13);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(14);
        }
        this.addImport(importable, file, null, path, asName);
    }

    public void addImport(@NotNull PsiNamedElement importable, @NotNull PsiFileSystemItem file, @Nullable PyImportElement importElement, @Nullable QualifiedName path, @Nullable String asName) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(15);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(16);
        }
        this.myImports.add(new ImportCandidateHolder(importable, file, importElement, path, asName));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void addImport(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path, @Nullable String asName) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(17);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(18);
        }
        if (importable instanceof PsiNamedElement) {
            this.addImport((PsiNamedElement)importable, file, path, asName);
        }
    }

    @NotNull
    public String getText() {
        if (this.myUseQualifiedImport) {
            String string = PyPsiBundle.message("ACT.qualify.with.module", new Object[0]);
            if (string == null) {
                AutoImportQuickFix.$$$reportNull$$$0(19);
            }
            return string;
        }
        if (this.myImports.size() == 1) {
            String string = PyPsiBundle.message("QFIX.auto.import.import.name", this.myImports.get(0).getPresentableText());
            if (string == null) {
                AutoImportQuickFix.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = PyPsiBundle.message("QFIX.auto.import.import.this.name", new Object[0]);
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.auto.import", new Object[0]);
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public ImportFromExistingAction createAction(PsiElement element) {
        ImportFromExistingAction action = new ImportFromExistingAction(element, this.myImports, this.myInitialName, null, this.myUseQualifiedImport, false);
        action.onDone(() -> {
            this.myExpended = true;
        });
        ImportFromExistingAction importFromExistingAction = action;
        if (importFromExistingAction == null) {
            AutoImportQuickFix.$$$reportNull$$$0(23);
        }
        return importFromExistingAction;
    }

    public boolean isAvailable() {
        PsiElement element = this.getStartElement();
        if (element == null) {
            return false;
        }
        PyPsiUtils.assertValid(element);
        return !this.myExpended && element.isValid() && !this.myImports.isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AutoImportQuickFix.$$$reportNull$$$0(24);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(25);
        }
        if (startElement == null) {
            AutoImportQuickFix.$$$reportNull$$$0(26);
        }
        if (endElement == null) {
            AutoImportQuickFix.$$$reportNull$$$0(27);
        }
        this.invoke(this.getStartElement().getContainingFile());
    }

    public void invoke(PsiFile file) throws IncorrectOperationException {
        PsiElement startElement = this.getStartElement();
        if (startElement == null) {
            return;
        }
        PyPsiUtils.assertValid(startElement);
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiReference reference = this.findOriginalReference(startElement);
        if (reference == null || AutoImportQuickFix.isResolved(reference)) {
            return;
        }
        ImportFromExistingAction action = this.createAction();
        if (action != null) {
            action.execute();
        }
        this.myExpended = true;
    }

    @Nullable
    protected ImportFromExistingAction createAction() {
        return new ImportFromExistingAction(this.getStartElement(), this.myImports, this.myInitialName, null, this.myUseQualifiedImport, false);
    }

    public void sortCandidates() {
        Collections.sort(this.myImports);
    }

    @NotNull
    public List<ImportCandidateHolder> getCandidates() {
        List<ImportCandidateHolder> list = Collections.unmodifiableList(this.myImports);
        if (list == null) {
            AutoImportQuickFix.$$$reportNull$$$0(28);
        }
        return list;
    }

    public boolean hasOnlyFunctions() {
        for (ImportCandidateHolder holder : this.myImports) {
            if (holder.getImportable() instanceof PyFunction) continue;
            return false;
        }
        return true;
    }

    public boolean hasProjectImports() {
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.getStartElement().getProject());
        for (ImportCandidateHolder anImport : this.myImports) {
            PsiFileSystemItem importFile = anImport.getFile();
            VirtualFile file = importFile != null ? importFile.getVirtualFile() : null;
            if (file == null || !fileIndex.isInContent(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public AutoImportQuickFix forLocalImport() {
        return new AutoImportQuickFix(this.getStartElement(), this.myReferenceType, this.myInitialName, this.myUseQualifiedImport, this.myImports){

            @Override
            @NotNull
            public String getFamilyName() {
                String string = PyPsiBundle.message("QFIX.NAME.local.auto.import", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getText() {
                String string = PyPsiBundle.message("QFIX.local.auto.import.import.locally", super.getText());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            protected ImportFromExistingAction createAction() {
                return new ImportFromExistingAction(this.getStartElement(), AutoImportQuickFix.this.myImports, AutoImportQuickFix.this.myInitialName, null, AutoImportQuickFix.this.myUseQualifiedImport, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public String getNameToImport() {
        String string = this.myInitialName;
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public Class<? extends PsiReference> getReferenceType() {
        Class<? extends PsiReference> clazz = this.myReferenceType;
        if (clazz == null) {
            AutoImportQuickFix.$$$reportNull$$$0(30);
        }
        return clazz;
    }

    public boolean isUseQualifiedImport() {
        return this.myUseQualifiedImport;
    }

    static boolean isResolved(@NotNull PsiReference reference) {
        if (reference == null) {
            AutoImportQuickFix.$$$reportNull$$$0(31);
        }
        if (reference instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference).multiResolve(false).length > 0;
        }
        return reference.resolve() != null;
    }

    @Nullable
    PsiReference findOriginalReference(@NotNull PsiElement element) {
        if (element == null) {
            AutoImportQuickFix.$$$reportNull$$$0(32);
        }
        return (PsiReference)ContainerUtil.findInstance((Object[])element.getReferences(), this.myReferenceType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importable";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAction";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameToImport";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

