/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.impl.ConditionalInstructionImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.InstructionBuilder;
import com.jetbrains.python.codeInsight.controlflow.PyMatchStatementControlFlowBuilder;
import com.jetbrains.python.codeInsight.controlflow.PyTypeAssertionEvaluator;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionComponent;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyComprehensionIfComponent;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Triple;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyControlFlowBuilder
extends PyRecursiveElementVisitor {
    @NotNull
    private static final Set<String> EXCEPTION_SUPPRESSORS = ImmutableSet.of((Object)"suppress", (Object)"assertRaises", (Object)"assertRaisesRegex");
    private final ControlFlowBuilder myBuilder = new ControlFlowBuilder();

    public ControlFlow buildControlFlow(@NotNull ScopeOwner owner) {
        if (owner == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(0);
        }
        return this.myBuilder.build((PsiElementVisitor)this, (PsiElement)owner);
    }

    @NotNull
    protected ControlFlowBuilder getBuilder() {
        ControlFlowBuilder controlFlowBuilder = this.myBuilder;
        if (controlFlowBuilder == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(1);
        }
        return controlFlowBuilder;
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(2);
        }
        this.myBuilder.startNode((PsiElement)node);
        this.visitParameterListExpressions(node.getParameterList());
        this.visitDecorators(node.getDecoratorList());
        PyAnnotation annotation = node.getAnnotation();
        if (annotation != null) {
            annotation.accept(this);
        }
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode((Instruction)instruction);
        this.myBuilder.checkPending((Instruction)instruction);
    }

    @Override
    public void visitPyDecoratorList(@NotNull PyDecoratorList node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(3);
        }
    }

    private void visitDecorators(PyDecoratorList list) {
        if (list != null) {
            for (PyDecorator decorator : list.getDecorators()) {
                decorator.accept(this);
            }
        }
    }

    private void visitParameterListExpressions(PyParameterList parameterList) {
        ParamHelper.walkDownParamArray(parameterList.getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                PyAnnotation annotation;
                PyExpression defaultValue = param.getDefaultValue();
                if (defaultValue != null) {
                    defaultValue.accept(PyControlFlowBuilder.this);
                }
                if ((annotation = param.getAnnotation()) != null) {
                    annotation.accept(PyControlFlowBuilder.this);
                }
            }
        });
    }

    @Override
    public void visitPyClass(@NotNull PyClass node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(4);
        }
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression element : node.getSuperClassExpressions()) {
            element.accept(this);
        }
        this.visitDecorators(node.getDecoratorList());
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode((Instruction)instruction);
        this.myBuilder.checkPending((Instruction)instruction);
    }

    @Override
    public void visitPyStatement(@NotNull PyStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(5);
        }
        this.myBuilder.startNode((PsiElement)node);
        super.visitPyStatement(node);
    }

    @Override
    public void visitPyElement(@NotNull PyElement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (node instanceof PsiNamedElement && !(node instanceof PyKeywordArgument)) {
            this.myBuilder.startNode((PsiElement)node);
            this.myBuilder.addNode((Instruction)ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getName(), ReadWriteInstruction.ACCESS.WRITE));
        }
        super.visitPyElement(node);
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(7);
        }
        PyExpression callee = node.getCallee();
        String repr = PyUtil.getReadableRepr((PsiElement)callee, true);
        if (callee != null && ("sys.exit".equals(repr) || "self.fail".equals(repr))) {
            callee.accept(this);
            for (PyExpression expression : node.getArguments()) {
                expression.accept(this);
            }
            this.abruptFlow((PsiElement)node);
        } else {
            super.visitPyCallExpression(node);
        }
        if (node.isCalleeText("assertIsInstance")) {
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
            node.accept(assertionEvaluator);
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
        }
    }

    @Override
    public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(8);
        }
        this.myBuilder.startNode((PsiElement)node);
        node.getOperand().accept(this);
        PyExpression expression = node.getIndexExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        PyExpression qualifier;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(9);
        }
        if ((qualifier = node.getQualifier()) != null) {
            qualifier.accept(this);
            return;
        }
        if (PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) != null) {
            return;
        }
        ReadWriteInstruction.ACCESS access = PyAugAssignmentStatementNavigator.getStatementByTarget((PsiElement)node) != null ? ReadWriteInstruction.ACCESS.READWRITE : ReadWriteInstruction.ACCESS.READ;
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getName(), access);
        this.myBuilder.addNode((Instruction)readWriteInstruction);
        this.myBuilder.checkPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyBoolLiteralExpression(@NotNull PyBoolLiteralExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(10);
        }
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getText(), ReadWriteInstruction.ACCESS.READ);
        this.myBuilder.addNode((Instruction)readWriteInstruction);
        this.myBuilder.checkPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyNoneLiteralExpression(@NotNull PyNoneLiteralExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(11);
        }
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getText(), ReadWriteInstruction.ACCESS.READ);
        this.myBuilder.addNode((Instruction)readWriteInstruction);
        this.myBuilder.checkPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyTypeDeclarationStatement(@NotNull PyTypeDeclarationStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(12);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyAnnotation annotation = node.getAnnotation();
        if (annotation != null) {
            annotation.accept(this);
        }
        node.getTarget().accept(this);
    }

    @Override
    public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
        PyAnnotation annotation;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(13);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression value = node.getAssignedValue();
        if (value != null) {
            value.accept(this);
        }
        if ((annotation = node.getAnnotation()) != null) {
            annotation.accept(this);
        }
        for (PyExpression expression : node.getRawTargets()) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyDelStatement(@NotNull PyDelStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(14);
        }
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression target : node.getTargets()) {
            if (target instanceof PyReferenceExpression) {
                PyReferenceExpression expr = (PyReferenceExpression)target;
                this.myBuilder.addNode((Instruction)ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)target, expr.getName(), ReadWriteInstruction.ACCESS.DELETE));
                PyExpression qualifier = expr.getQualifier();
                if (qualifier == null) continue;
                qualifier.accept(this);
                continue;
            }
            target.accept(this);
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(15);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression value = node.getValue();
        if (value != null) {
            value.accept(this);
        }
        node.getTarget().accept(this);
    }

    @Override
    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        PyExpression qualifier;
        QualifiedName qName;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(16);
        }
        if ((qName = node.asQualifiedName()) != null) {
            ReadWriteInstruction instruction = ReadWriteInstruction.newInstruction(this.myBuilder, node, qName.toString(), ReadWriteInstruction.ACCESS.WRITE);
            this.myBuilder.addNode((Instruction)instruction);
            this.myBuilder.checkPending((Instruction)instruction);
        }
        if ((qualifier = node.getQualifier()) != null) {
            qualifier.accept(this);
        }
    }

    @Override
    public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
        PyExpression defaultValue;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(17);
        }
        if ((defaultValue = node.getDefaultValue()) != null) {
            defaultValue.accept(this);
        }
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode((Instruction)instruction);
        this.myBuilder.checkPending((Instruction)instruction);
    }

    @Override
    public void visitPyImportStatement(@NotNull PyImportStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(18);
        }
        this.visitPyImportStatementBase(node);
    }

    @Override
    public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(19);
        }
        this.visitPyImportStatementBase(node);
        PyStarImportElement starImportElement = node.getStarImportElement();
        if (starImportElement != null) {
            starImportElement.accept(this);
        }
    }

    @Override
    public void visitPyStarImportElement(@NotNull PyStarImportElement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(20);
        }
        this.myBuilder.startNode((PsiElement)node);
    }

    private void visitPyImportStatementBase(PyImportStatementBase node) {
        this.myBuilder.startNode((PsiElement)node);
        for (PyImportElement importElement : node.getImportElements()) {
            ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, importElement, importElement.getVisibleName());
            this.myBuilder.addNode((Instruction)instruction);
            this.myBuilder.checkPending((Instruction)instruction);
        }
    }

    @NotNull
    private List<Pair<PsiElement, Instruction>> getBranchingPoints(@Nullable PyExpression condition) {
        ArrayList<Pair<PsiElement, Instruction>> result = new ArrayList<Pair<PsiElement, Instruction>>();
        if (!PyControlFlowBuilder.isConjunctionOrDisjunction(condition)) {
            result.add(Pair.create((Object)condition, (Object)this.myBuilder.prevInstruction));
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)pendingScope, (boolean)false)) {
                result.add(Pair.create((Object)pendingScope, (Object)instruction));
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        ArrayList<Pair<PsiElement, Instruction>> arrayList = result;
        if (arrayList == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Override
    public void visitPyConditionalExpression(@NotNull PyConditionalExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(22);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression condition = node.getCondition();
        PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
        if (condition != null) {
            condition.accept(this);
            condition.accept(assertionEvaluator);
        }
        Instruction branchingPoint = this.myBuilder.prevInstruction;
        PyExpression truePart = node.getTruePart();
        PyExpression falsePart = node.getFalsePart();
        if (truePart != null) {
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
            truePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        if (falsePart != null) {
            this.myBuilder.prevInstruction = branchingPoint;
            falsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
    }

    @Override
    public void visitPyMatchStatement(@NotNull PyMatchStatement matchStatement) {
        if (matchStatement == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(23);
        }
        new PyMatchStatementControlFlowBuilder(this.myBuilder, this).build(matchStatement);
    }

    @Override
    public void visitPyIfStatement(@NotNull PyIfStatement node) {
        PyElsePart elseBranch;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(24);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression lastCondition = null;
        List lastBranchingPoints = Collections.emptyList();
        ArrayList<Boolean> conditionResults = new ArrayList<Boolean>();
        PyIfPart firstIfPart = node.getIfPart();
        for (PyIfPart part : StreamEx.of((Object)firstIfPart).append((Object[])node.getElifParts())) {
            if (part != firstIfPart) {
                if (!ContainerUtil.exists(conditionResults, Boolean.TRUE::equals)) {
                    lastBranchingPoints.forEach(pair -> this.myBuilder.addPendingEdge((PsiElement)pair.getFirst(), (Instruction)pair.getSecond()));
                }
                this.myBuilder.prevInstruction = null;
                this.myBuilder.startConditionalNode((PsiElement)part, (PsiElement)lastCondition, false);
            }
            Triple<PyExpression, List<Pair<PsiElement, Instruction>>, Boolean> currentPartResults = this.visitPyConditionalPart(part, node);
            lastCondition = (PyExpression)currentPartResults.getFirst();
            lastBranchingPoints = (List)currentPartResults.getSecond();
            conditionResults.add((Boolean)currentPartResults.getThird());
        }
        PyTypeAssertionEvaluator negativeAssertionEvaluator = new PyTypeAssertionEvaluator(false);
        PyExpression firstIfPartCondition = firstIfPart.getCondition();
        if (firstIfPartCondition != null) {
            firstIfPartCondition.accept(negativeAssertionEvaluator);
        }
        if ((elseBranch = node.getElsePart()) != null) {
            if (!ContainerUtil.exists(conditionResults, Boolean.TRUE::equals)) {
                lastBranchingPoints.forEach(pair -> this.myBuilder.addPendingEdge((PsiElement)pair.getFirst(), (Instruction)pair.getSecond()));
            }
            this.myBuilder.prevInstruction = null;
            PyStatementList statements = elseBranch.getStatementList();
            this.myBuilder.startConditionalNode((PsiElement)statements, (PsiElement)lastCondition, false);
            InstructionBuilder.addAssertInstructions(this.myBuilder, negativeAssertionEvaluator);
            statements.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        } else if (ContainerUtil.getLastItem(conditionResults) != Boolean.TRUE) {
            this.myBuilder.prevInstruction = null;
            Instruction instruction = (Instruction)ContainerUtil.getFirstItem(InstructionBuilder.addAssertInstructions(this.myBuilder, negativeAssertionEvaluator));
            if (instruction != null) {
                lastBranchingPoints.forEach(p -> this.myBuilder.addEdge((Instruction)p.getSecond(), instruction));
            } else {
                lastBranchingPoints.forEach(pair -> this.myBuilder.addPendingEdge((PsiElement)pair.getFirst(), (Instruction)pair.getSecond()));
            }
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
    }

    @NotNull
    private Triple<PyExpression, List<Pair<PsiElement, Instruction>>, Boolean> visitPyConditionalPart(@NotNull PyConditionalStatementPart part, @NotNull PyStatement node) {
        if (part == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(25);
        }
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(26);
        }
        PyExpression condition = part.getCondition();
        PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
        Boolean conditionResult = PyEvaluator.evaluateAsBooleanNoResolve(condition);
        if (condition != null) {
            condition.accept(this);
            condition.accept(assertionEvaluator);
        }
        List<Pair<PsiElement, Instruction>> branchingPoints = this.getBranchingPoints(condition);
        if (conditionResult == Boolean.FALSE) {
            this.myBuilder.flowAbrupted();
        } else if (PyControlFlowBuilder.isConjunctionOrDisjunction(condition)) {
            List<Pair<PsiElement, Instruction>> shortCircuitPositivePoints = PyControlFlowBuilder.selectShortCircuitPositivePoints(branchingPoints);
            branchingPoints.removeAll(shortCircuitPositivePoints);
            shortCircuitPositivePoints.forEach(pair -> this.myBuilder.addPendingEdge((PsiElement)pair.getFirst(), (Instruction)pair.getSecond()));
        }
        this.visitPyConditionalPartStatements(part, assertionEvaluator, node);
        return new Triple((Object)condition, branchingPoints, (Object)conditionResult);
    }

    @NotNull
    private static List<Pair<PsiElement, Instruction>> selectShortCircuitPositivePoints(@NotNull List<Pair<PsiElement, Instruction>> branchingPoints) {
        if (branchingPoints == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(27);
        }
        List list = ContainerUtil.filter(branchingPoints, it -> it.getSecond() instanceof ConditionalInstruction && ((ConditionalInstruction)it.getSecond()).getResult());
        if (list == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(28);
        }
        return list;
    }

    private void visitPyConditionalPartStatements(@NotNull PyConditionalStatementPart part, @NotNull PyTypeAssertionEvaluator assertionEvaluator, @NotNull PyStatement node) {
        if (part == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(29);
        }
        if (assertionEvaluator == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(30);
        }
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(31);
        }
        PyStatementList statements = part.getStatementList();
        this.myBuilder.startConditionalNode((PsiElement)statements, (PsiElement)part.getCondition(), true);
        InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
        statements.accept(this);
        if (!(node instanceof PyLoopStatement)) {
            this.myBuilder.processPending((pendingScope, instruction) -> {
                if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)statements, (PsiElement)pendingScope, (boolean)false)) {
                    this.myBuilder.addPendingEdge((PsiElement)node, instruction);
                } else {
                    this.myBuilder.addPendingEdge(pendingScope, instruction);
                }
            });
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
    }

    @Override
    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(32);
        }
        if (PyControlFlowBuilder.isConjunctionOrDisjunction(node)) {
            PyExpression right;
            boolean conjunction = node.getOperator() == PyTokenTypes.AND_KEYWORD;
            this.myBuilder.startNode((PsiElement)node);
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator(conjunction);
            PyExpression left = node.getLeftExpression();
            if (left != null) {
                this.visitConjunctOrDisjunct(node, left, null, assertionEvaluator, conjunction);
            }
            if ((right = node.getRightExpression()) != null) {
                this.visitConjunctOrDisjunct(node, right, assertionEvaluator, null, true);
            }
        } else {
            super.visitPyBinaryExpression(node);
        }
    }

    static boolean isConjunctionOrDisjunction(@Nullable PyExpression node) {
        if (node instanceof PyBinaryExpression) {
            PyElementType operator = ((PyBinaryExpression)node).getOperator();
            return operator == PyTokenTypes.AND_KEYWORD || operator == PyTokenTypes.OR_KEYWORD;
        }
        return false;
    }

    private void visitConjunctOrDisjunct(@NotNull PyBinaryExpression node, @NotNull PyExpression subExpression, @Nullable PyTypeAssertionEvaluator previousAssertionEvaluator, @Nullable PyTypeAssertionEvaluator assertionEvaluator, boolean conditionResultToContinue) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(33);
        }
        if (subExpression == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(34);
        }
        if (previousAssertionEvaluator != null) {
            InstructionBuilder.addAssertInstructions(this.myBuilder, previousAssertionEvaluator);
        }
        subExpression.accept(this);
        if (assertionEvaluator != null) {
            subExpression.accept(assertionEvaluator);
        }
        Instruction branchingPoint = this.myBuilder.prevInstruction;
        ConditionalInstructionImpl outside = new ConditionalInstructionImpl(this.myBuilder, null, (PsiElement)subExpression, !conditionResultToContinue);
        this.myBuilder.addNode((Instruction)outside);
        this.myBuilder.addPendingEdge((PsiElement)node, (Instruction)outside);
        this.myBuilder.prevInstruction = branchingPoint;
        ConditionalInstructionImpl toTheNext = new ConditionalInstructionImpl(this.myBuilder, null, (PsiElement)subExpression, conditionResultToContinue);
        this.myBuilder.addNode((Instruction)toTheNext);
    }

    @Override
    public void visitPyWhileStatement(@NotNull PyWhileStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(35);
        }
        Instruction instruction = this.myBuilder.startNode((PsiElement)node);
        Triple<PyExpression, List<Pair<PsiElement, Instruction>>, Boolean> mainPartResults = this.visitPyConditionalPart(node.getWhilePart(), node);
        List branchingPoints = (List)mainPartResults.getSecond();
        if (this.myBuilder.prevInstruction != null) {
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, instruction);
        }
        this.myBuilder.checkPending(instruction);
        boolean isStaticallyTrue = mainPartResults.getThird() == Boolean.TRUE;
        PyElsePart elsePart = node.getElsePart();
        if (elsePart == null) {
            if (!isStaticallyTrue) {
                for (Pair pair : branchingPoints) {
                    this.myBuilder.addPendingEdge((PsiElement)node, (Instruction)pair.getSecond());
                }
            }
        } else {
            ConditionalInstructionImpl elsePartInstruction = new ConditionalInstructionImpl(this.myBuilder, (PsiElement)elsePart, (PsiElement)mainPartResults.getFirst(), false);
            this.myBuilder.prevInstruction = null;
            this.myBuilder.addNode((Instruction)elsePartInstruction);
            if (!isStaticallyTrue) {
                for (Pair pair : branchingPoints) {
                    this.myBuilder.addEdge((Instruction)pair.getSecond(), (Instruction)elsePartInstruction);
                }
            }
            elsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyForStatement(@NotNull PyForStatement node) {
        Instruction body;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(36);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyForPart forPart = node.getForPart();
        PyExpression source = forPart.getSource();
        if (source != null) {
            source.accept(this);
        }
        Instruction head = this.myBuilder.prevInstruction;
        PyElsePart elsePart = node.getElsePart();
        if (elsePart == null && !PyControlFlowBuilder.loopHasAtLeastOneIteration(node)) {
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyStatementList list = forPart.getStatementList();
        PyExpression target = forPart.getTarget();
        if (target != null) {
            body = this.myBuilder.startNode((PsiElement)target);
            target.accept(this);
        } else {
            body = this.myBuilder.startNode((PsiElement)list);
        }
        list.accept(this);
        if (this.myBuilder.prevInstruction != null) {
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, body);
            this.myBuilder.addPendingEdge((PsiElement)list, this.myBuilder.prevInstruction);
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)list, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addEdge(instruction, body);
                this.myBuilder.addPendingEdge((PsiElement)list, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.prevInstruction = head;
        if (elsePart != null) {
            elsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    private static boolean loopHasAtLeastOneIteration(@NotNull PyLoopStatement loopStatement) {
        if (loopStatement == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(37);
        }
        PyExpression expression = loopStatement instanceof PyForStatement ? ((PyForStatement)loopStatement).getForPart().getSource() : (loopStatement instanceof PyWhileStatement ? ((PyWhileStatement)loopStatement).getWhilePart().getCondition() : null);
        return PyEvaluator.evaluateAsBooleanNoResolve(expression, false);
    }

    @Override
    public void visitPyBreakStatement(@NotNull PyBreakStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(38);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyLoopStatement loop = node.getLoopStatement();
        if (loop != null) {
            this.myBuilder.addPendingEdge((PsiElement)loop, this.myBuilder.prevInstruction);
        } else {
            this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyContinueStatement(@NotNull PyContinueStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(39);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyLoopStatement loop = node.getLoopStatement();
        if (loop != null) {
            Instruction instruction = this.myBuilder.findInstructionByElement((PsiElement)loop);
            if (instruction != null) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, instruction);
            } else {
                this.myBuilder.addPendingEdge(null, null);
            }
            if (PyControlFlowBuilder.loopHasAtLeastOneIteration(loop)) {
                this.myBuilder.addPendingEdge((PsiElement)loop, this.myBuilder.prevInstruction);
            }
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(40);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyRaiseStatement(@NotNull PyRaiseStatement node) {
        PyExpression[] expressions;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(41);
        }
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression expression : expressions = node.getExpressions()) {
            expression.accept(this);
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            PsiElement pendingElement = instruction.getElement();
            if (pendingElement != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingElement, (boolean)false)) {
                this.myBuilder.addEdge(null, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(42);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
        this.abruptFlow((PsiElement)node);
    }

    @Override
    public void visitPyTryExceptStatement(@NotNull PyTryExceptStatement node) {
        Instruction finallyFailInstruction;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(43);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyTryPart tryPart = node.getTryPart();
        this.myBuilder.startNode((PsiElement)tryPart);
        tryPart.accept(this);
        PyElsePart elsePart = node.getElsePart();
        if (elsePart != null) {
            this.myBuilder.startNode((PsiElement)elsePart);
            elsePart.accept(this);
        }
        this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        ArrayList<Instruction> exceptInstructions = new ArrayList<Instruction>();
        ArrayList pendingBackup = new ArrayList();
        for (PyExceptPart exceptPart : node.getExceptParts()) {
            pendingBackup.addAll(this.myBuilder.pending);
            this.myBuilder.pending = new ArrayList();
            this.myBuilder.flowAbrupted();
            Instruction exceptInstruction = this.myBuilder.startNode((PsiElement)exceptPart);
            exceptPart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
            exceptInstructions.add(exceptInstruction);
        }
        for (Pair pair : pendingBackup) {
            this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
        }
        ArrayList pendingNormalExits = new ArrayList();
        PyFinallyPart finallyPart = node.getFinallyPart();
        if (finallyPart != null) {
            this.myBuilder.processPending((pendingScope, instruction) -> {
                PsiElement pendingElement = instruction.getElement();
                if (pendingElement != null) {
                    boolean isPending;
                    boolean bl = isPending = PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingElement, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)finallyPart, (PsiElement)pendingElement, (boolean)false);
                    if (isPending && pendingScope != null) {
                        pendingNormalExits.add(Pair.createNonNull((Object)pendingScope, (Object)instruction));
                    } else {
                        this.myBuilder.addPendingEdge(pendingScope, instruction);
                    }
                }
            });
        }
        if (finallyPart != null) {
            this.myBuilder.flowAbrupted();
            finallyFailInstruction = this.myBuilder.startNode((PsiElement)finallyPart);
            finallyPart.accept(this);
            this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
            this.myBuilder.flowAbrupted();
        } else {
            finallyFailInstruction = null;
        }
        for (Instruction instruction2 : this.myBuilder.instructions) {
            PsiElement e = instruction2.getElement();
            if (e == null || !PyControlFlowBuilder.canRaiseExceptions(instruction2)) continue;
            if (PsiTreeUtil.getParentOfType((PsiElement)e, PyTryPart.class, (boolean)false) == tryPart) {
                for (Instruction inst : exceptInstructions) {
                    this.myBuilder.addEdge(instruction2, inst);
                }
                if (finallyPart != null) {
                    this.myBuilder.addEdge(instruction2, finallyFailInstruction);
                }
            }
            if (finallyPart == null) continue;
            for (PyExceptPart exceptPart : node.getExceptParts()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)exceptPart, (PsiElement)e, (boolean)false)) continue;
                this.myBuilder.addEdge(instruction2, finallyFailInstruction);
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)elsePart, (PsiElement)e, (boolean)false)) continue;
            this.myBuilder.addEdge(instruction2, finallyFailInstruction);
        }
        if (finallyPart != null) {
            Instruction finallyInstruction;
            this.myBuilder.processPending((pendingScope, instruction) -> {
                PsiElement e = instruction.getElement();
                if (e != null) {
                    if (PsiTreeUtil.isAncestor((PsiElement)finallyPart, (PsiElement)e, (boolean)false)) {
                        this.myBuilder.addPendingEdge(null, instruction);
                    } else if (pendingScope == null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)e, (boolean)false)) {
                        this.myBuilder.addEdge(instruction, finallyFailInstruction);
                    } else {
                        this.myBuilder.addPendingEdge(pendingScope, instruction);
                    }
                }
            });
            if (!pendingNormalExits.isEmpty()) {
                pendingBackup = new ArrayList(this.myBuilder.pending);
                this.myBuilder.pending = new ArrayList();
                this.myBuilder.flowAbrupted();
                Instruction finallySuccessInstruction = this.myBuilder.startNode((PsiElement)finallyPart);
                finallyPart.accept(this);
                for (Pair pair : pendingBackup) {
                    this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
                }
                finallyInstruction = finallySuccessInstruction;
            } else {
                finallyInstruction = finallyFailInstruction;
            }
            for (Pair pendingScopeAndInstruction : pendingNormalExits) {
                PsiElement pendingScope2 = (PsiElement)pendingScopeAndInstruction.first;
                Instruction instruction3 = (Instruction)pendingScopeAndInstruction.second;
                this.myBuilder.addEdge(instruction3, finallyInstruction);
                if (!PsiTreeUtil.isAncestor((PsiElement)pendingScope2, (PsiElement)node, (boolean)true)) continue;
                this.myBuilder.addPendingEdge(pendingScope2, this.myBuilder.prevInstruction);
            }
        }
    }

    @Override
    public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(44);
        }
        PyExpression prevCondition = null;
        this.myBuilder.startNode((PsiElement)node);
        ArrayList<Instruction> iterators = new ArrayList<Instruction>();
        for (PyComprehensionComponent component : node.getComponents()) {
            PyExpression condition;
            PyComprehensionComponent c;
            if (component instanceof PyComprehensionForComponent) {
                c = (PyComprehensionForComponent)component;
                PyExpression iteratedList = c.getIteratedList();
                PyExpression iteratorVariable = c.getIteratorVariable();
                if (prevCondition != null) {
                    this.myBuilder.startConditionalNode((PsiElement)iteratedList, prevCondition, true);
                    prevCondition = null;
                } else {
                    this.myBuilder.startNode((PsiElement)iteratedList);
                }
                iteratedList.accept(this);
                for (Instruction i : iterators) {
                    this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
                }
                this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
                Instruction iterator = this.myBuilder.startNode((PsiElement)iteratorVariable);
                iteratorVariable.accept(this);
                iterators.add(iterator);
                continue;
            }
            if (!(component instanceof PyComprehensionIfComponent) || (condition = (c = (PyComprehensionIfComponent)component).getTest()) == null) continue;
            if (prevCondition != null) {
                this.myBuilder.startConditionalNode((PsiElement)condition, prevCondition, true);
            } else {
                this.myBuilder.startNode((PsiElement)condition);
            }
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
            condition.accept(this);
            condition.accept(assertionEvaluator);
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
            prevCondition = condition;
            for (Instruction i : iterators) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
            }
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyExpression result = node.getResultExpression();
        if (result != null) {
            if (prevCondition != null) {
                this.myBuilder.startConditionalNode((PsiElement)result, prevCondition, true);
            } else {
                this.myBuilder.startNode((PsiElement)result);
            }
            result.accept(this);
            for (Instruction i : iterators) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
            }
        }
    }

    @Override
    public void visitPyAssertStatement(@NotNull PyAssertStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(45);
        }
        this.myBuilder.startNode((PsiElement)node);
        super.visitPyAssertStatement(node);
        PyExpression[] args2 = node.getArguments();
        if (args2.length >= 1 && !PyEvaluator.evaluateAsBooleanNoResolve(args2[0], true)) {
            this.abruptFlow((PsiElement)node);
            return;
        }
        PyTypeAssertionEvaluator evaluator = new PyTypeAssertionEvaluator();
        node.acceptChildren(evaluator);
        InstructionBuilder.addAssertInstructions(this.myBuilder, evaluator);
    }

    @Override
    public void visitPyLambdaExpression(@NotNull PyLambdaExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(46);
        }
        this.myBuilder.startNode((PsiElement)node);
        this.visitParameterListExpressions(node.getParameterList());
    }

    @Override
    public void visitPyWithStatement(@NotNull PyWithStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(47);
        }
        super.visitPyWithStatement(node);
        boolean suppressor = StreamEx.of((Object[])node.getWithItems()).map(PyWithItem::getExpression).select(PyCallExpression.class).map(PyCallExpression::getCallee).select(PyReferenceExpression.class).anyMatch(it -> EXCEPTION_SUPPRESSORS.contains(it.getReferencedName()));
        this.myBuilder.processPending((pendingScope, instruction) -> {
            PsiElement element = instruction.getElement();
            if (element != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)element, (boolean)true) && (suppressor && PyControlFlowBuilder.canRaiseExceptions(instruction) || PsiTreeUtil.getParentOfType((PsiElement)element, PyRaiseStatement.class) != null)) {
                this.myBuilder.addPendingEdge((PsiElement)node, instruction);
            }
            this.myBuilder.addPendingEdge(pendingScope, instruction);
        });
    }

    @Override
    public void visitPyAssignmentExpression(@NotNull PyAssignmentExpression node) {
        PyTargetExpression target;
        PyExpression assignedValue;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(48);
        }
        if ((assignedValue = node.getAssignedValue()) != null) {
            assignedValue.accept(this);
        }
        if ((target = node.getTarget()) != null) {
            target.accept(this);
        }
    }

    private void abruptFlow(PsiElement node) {
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addPendingEdge(null, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        this.myBuilder.flowAbrupted();
    }

    private static boolean canRaiseExceptions(Instruction instruction) {
        if (instruction instanceof ReadWriteInstruction) {
            return true;
        }
        return !PsiTreeUtil.instanceOf((Object)instruction.getElement(), (Class[])new Class[]{PyStatementList.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 21: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 21: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatement";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchingPoints";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertionEvaluator";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subExpression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchingPoints";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "selectShortCircuitPositivePoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildControlFlow";
                break;
            }
            case 1: 
            case 21: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFunction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDecoratorList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPyElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitPySubscriptionExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReferenceExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBoolLiteralExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNoneLiteralExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeDeclarationStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDelStatement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAugAssignmentStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTargetExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNamedParameter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitPyImportStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFromImportStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStarImportElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitPyConditionalExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitPyMatchStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitPyIfStatement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitPyConditionalPart";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "selectShortCircuitPositivePoints";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitPyConditionalPartStatements";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBinaryExpression";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitConjunctOrDisjunct";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitPyWhileStatement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitPyForStatement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loopHasAtLeastOneIteration";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBreakStatement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitPyContinueStatement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitPyYieldExpression";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitPyRaiseStatement";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReturnStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTryExceptStatement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitPyComprehensionElement";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssertStatement";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitPyLambdaExpression";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitPyWithStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 21: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

