/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.completion.PyCompletionUtilsKt;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkUtil;
import icons.PythonPsiApiIcons;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000x\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u001aJ\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u000e2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u001a\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a4\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'\u001a\u0018\u0010(\u001a\u0004\u0018\u00010\u00122\u0006\u0010)\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020*\u001a\u0016\u0010+\u001a\u00020'2\u0006\u0010)\u001a\u00020%2\u0006\u0010,\u001a\u00020#\u001a\f\u0010-\u001a\u0004\u0018\u00010%*\u00020.\u001a\f\u0010/\u001a\u0004\u0018\u00010\u0015*\u00020.\u001a\n\u00100\u001a\u00020\u0017*\u00020.\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"ELEMENT_TYPE", "", "FALLBACK_WEIGHT", "LOCATION", "LOCATION_NOT_YET_IMPORTED", "PRIVATE_API", "UNDERSCORE_IN_NAME", "addFunctionToResult", "", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "pyFile", "Lcom/jetbrains/python/psi/PyFile;", "functionName", "", "functionParentheses", "builderPostprocessor", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "addMethodToResult", "pyClass", "Lcom/jetbrains/python/psi/PyClass;", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "methodName", "methodParentheses", "autoInsertSingleItem", "Lcom/intellij/codeInsight/completion/AutoCompletionDecision;", "context", "Lcom/intellij/codeInsight/completion/AutoCompletionContext;", "computeCompletionWeight", "element", "Lcom/intellij/psi/PsiElement;", "elementName", "path", "Lcom/intellij/psi/util/QualifiedName;", "completionLocation", "Lcom/intellij/psi/PsiFile;", "nameOnly", "", "createLookupElementBuilder", "file", "Lcom/intellij/psi/PsiFileSystemItem;", "hasImportsFrom", "qName", "getFile", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getPyClass", "getTypeEvalContext", "intellij.python.psi.impl"})
public final class PyCompletionUtilsKt {
    private static final int ELEMENT_TYPE = 10;
    private static final int LOCATION = 100;
    private static final int PRIVATE_API = 1000;
    private static final int LOCATION_NOT_YET_IMPORTED = 10000;
    private static final int UNDERSCORE_IN_NAME = 100000;
    public static final int FALLBACK_WEIGHT = -1000000;

    @NotNull
    public static final AutoCompletionDecision autoInsertSingleItem(@NotNull AutoCompletionContext context) {
        AutoCompletionDecision autoCompletionDecision;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getItems().length == 1) {
            Object[] objectArray = context.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"context.items");
            AutoCompletionDecision autoCompletionDecision2 = AutoCompletionDecision.insertItem((LookupElement)((LookupElement)ArraysKt.first((Object[])objectArray)));
            autoCompletionDecision = autoCompletionDecision2;
            Intrinsics.checkNotNull((Object)autoCompletionDecision2);
        } else {
            AutoCompletionDecision autoCompletionDecision3 = AutoCompletionDecision.SHOW_LOOKUP;
            autoCompletionDecision = autoCompletionDecision3;
            Intrinsics.checkNotNull((Object)autoCompletionDecision3);
        }
        return autoCompletionDecision;
    }

    @Nullable
    public static final PyClass getPyClass(@NotNull CompletionParameters $this$getPyClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getPyClass, (String)"$this$getPyClass");
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner($this$getPyClass.getPosition());
        if (!(scopeOwner instanceof PyFunction)) {
            scopeOwner = null;
        }
        PyFunction pyFunction = (PyFunction)scopeOwner;
        return pyFunction != null ? pyFunction.getContainingClass() : null;
    }

    @Nullable
    public static final PsiFile getFile(@NotNull CompletionParameters $this$getFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getFile, (String)"$this$getFile");
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner($this$getFile.getPosition());
        if (!(scopeOwner instanceof PyFunction)) {
            scopeOwner = null;
        }
        PyFunction pyFunction = (PyFunction)scopeOwner;
        return pyFunction != null ? pyFunction.getContainingFile() : null;
    }

    @NotNull
    public static final TypeEvalContext getTypeEvalContext(@NotNull CompletionParameters $this$getTypeEvalContext) {
        Intrinsics.checkNotNullParameter((Object)$this$getTypeEvalContext, (String)"$this$getTypeEvalContext");
        PsiFile psiFile = $this$getTypeEvalContext.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"originalFile");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(psiFile.getProject(), $this$getTypeEvalContext.getOriginalFile());
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"TypeEvalContext.codeComp\u2026le.project, originalFile)");
        return typeEvalContext;
    }

    public static final void addMethodToResult(@NotNull CompletionResultSet result, @Nullable PyClass pyClass, @NotNull TypeEvalContext typeEvalContext, @NotNull String methodName, @NotNull String methodParentheses, @Nullable Function1<? super LookupElementBuilder, LookupElementBuilder> builderPostprocessor) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)typeEvalContext, (String)"typeEvalContext");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)methodParentheses, (String)"methodParentheses");
        PyClass pyClass2 = pyClass;
        if ((pyClass2 != null ? pyClass2.findMethodByName(methodName, false, typeEvalContext) : null) != null) {
            return;
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(methodName + methodParentheses)).withIcon(PythonPsiApiIcons.Nodes.CyanDot);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026siApiIcons.Nodes.CyanDot)");
        LookupElementBuilder item = lookupElementBuilder;
        LookupElementBuilder lookupElementBuilder2 = builderPostprocessor;
        if (lookupElementBuilder2 == null || (lookupElementBuilder2 = (LookupElementBuilder)lookupElementBuilder2.invoke((Object)item)) == null) {
            lookupElementBuilder2 = item;
        }
        result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)((LookupElement)lookupElementBuilder2), (TailType)TailType.CASE_COLON));
    }

    public static /* synthetic */ void addMethodToResult$default(CompletionResultSet completionResultSet, PyClass pyClass, TypeEvalContext typeEvalContext, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = "(self)";
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        PyCompletionUtilsKt.addMethodToResult(completionResultSet, pyClass, typeEvalContext, string, string2, (Function1<? super LookupElementBuilder, LookupElementBuilder>)function1);
    }

    public static final void addFunctionToResult(@NotNull CompletionResultSet result, @Nullable PyFile pyFile, @NotNull String functionName, @NotNull String functionParentheses, @Nullable Function1<? super LookupElementBuilder, LookupElementBuilder> builderPostprocessor) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        Intrinsics.checkNotNullParameter((Object)functionParentheses, (String)"functionParentheses");
        PyFile pyFile2 = pyFile;
        if ((pyFile2 != null ? pyFile2.findTopLevelFunction(functionName) : null) != null) {
            return;
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(functionName + functionParentheses)).withIcon(PythonPsiApiIcons.Nodes.CyanDot);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026siApiIcons.Nodes.CyanDot)");
        LookupElementBuilder item = lookupElementBuilder;
        LookupElementBuilder lookupElementBuilder2 = builderPostprocessor;
        if (lookupElementBuilder2 == null || (lookupElementBuilder2 = (LookupElementBuilder)lookupElementBuilder2.invoke((Object)item)) == null) {
            lookupElementBuilder2 = item;
        }
        result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)((LookupElement)lookupElementBuilder2), (TailType)TailType.CASE_COLON));
    }

    public static /* synthetic */ void addFunctionToResult$default(CompletionResultSet completionResultSet, PyFile pyFile, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "()";
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        PyCompletionUtilsKt.addFunctionToResult(completionResultSet, pyFile, string, string2, (Function1<? super LookupElementBuilder, LookupElementBuilder>)function1);
    }

    @Nullable
    public static final LookupElementBuilder createLookupElementBuilder(@NotNull PsiFile file, @NotNull PsiFileSystemItem element) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = FileUtil.getNameWithoutExtension((String)element.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.getNameWithoutExtension(element.name)");
        String name = string;
        if (!PyNames.isIdentifier(name)) {
            return null;
        }
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, (PsiElement)file);
        QualifiedName importPath = qualifiedName != null ? qualifiedName.removeLastComponent() : null;
        String tailText = importPath != null && importPath.getComponentCount() > 0 ? " (" + importPath + ')' : null;
        return LookupElementBuilder.create((Object)element, (String)name).withTailText(tailText, true).withIcon(element.getIcon(0));
    }

    public static final int computeCompletionWeight(@NotNull PsiElement element, @Nullable String elementName, @Nullable QualifiedName path, @Nullable PsiFile completionLocation, boolean nameOnly) {
        PsiElement psiElement;
        int n;
        QualifiedName qualifiedName;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int weight = 0;
        String string = elementName;
        if (string == null) {
            return -1000000;
        }
        String name = string;
        weight -= StringsKt.startsWith$default((String)name, (String)"__", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"__", (boolean)false, (int)2, null) ? 300000 : (StringsKt.startsWith$default((String)name, (String)"__", (boolean)false, (int)2, null) ? 200000 : (StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null) ? 100000 : 0));
        if (nameOnly) {
            return weight;
        }
        VirtualFile vFile = null;
        Sdk sdk = null;
        PsiFile containingFile = element.getContainingFile();
        if (element instanceof PsiDirectory) {
            vFile = ((PsiDirectory)element).getVirtualFile();
            sdk = PythonSdkUtil.findPythonSdk(element);
        } else if (containingFile != null) {
            vFile = containingFile.getVirtualFile();
            sdk = PythonSdkUtil.findPythonSdk((PsiElement)containingFile);
        }
        if ((qualifiedName = path) == null) {
            qualifiedName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)element.getContainingFile());
        }
        if (qualifiedName == null) {
            return -1000000;
        }
        QualifiedName importPath = qualifiedName;
        if (completionLocation != null && !PyCompletionUtilsKt.hasImportsFrom(completionLocation, importPath)) {
            weight -= 10000;
        }
        List list = importPath.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"importPath.components");
        Iterable $this$count$iv = list;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String string2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                if (!StringsKt.startsWith$default((String)string2, (String)"_", (boolean)false, (int)2, null)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int privatePathComponents = n * 1000;
        weight -= privatePathComponents + importPath.getComponentCount();
        if (vFile != null) {
            weight -= PythonSdkUtil.isStdLib(vFile, sdk) ? 100 : (ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)element.getProject()) == null ? 200 : 0);
        }
        return weight -= (psiElement = element) instanceof PsiDirectory ? 20 : (psiElement instanceof PyFile ? 10 : 0);
    }

    public static final boolean hasImportsFrom(@NotNull PsiFile file, @NotNull QualifiedName qName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        return file instanceof PyFile ? StreamEx.of((Collection)((PyFile)file).getFromImports()).map((Function)hasImportsFrom.1.INSTANCE).nonNull().anyMatch(new Predicate(qName){
            final /* synthetic */ QualifiedName $qName;

            public final boolean test(QualifiedName it) {
                return Intrinsics.areEqual((Object)this.$qName, (Object)it);
            }
            {
                this.$qName = qualifiedName;
            }
        }) : false;
    }
}

