/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.application.options.RegistryManager;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateDirectoryOrPackageHandler;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.namespacePackages.PyNamespacePackagesService;
import com.jetbrains.python.namespacePackages.PyNamespacePackagesStatisticsCollector;
import java.util.Properties;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CreatePackageAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(CreatePackageAction.class);
    @NonNls
    private static final String NAMESPACE_PACKAGE_TYPE = "Namespace Package";
    @NonNls
    private static final String ORDINARY_PACKAGE_TYPE = "Package";

    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        if (e == null) {
            CreatePackageAction.$$$reportNull$$$0(0);
        }
        if ((view = (IdeView)e.getData(LangDataKeys.IDE_VIEW)) == null) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        final PsiDirectory directory2 = DirectoryChooserUtil.getOrChooseDirectory((IdeView)view);
        if (directory2 == null) {
            return;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            return;
        }
        CreateFileFromTemplateDialog.Builder builder = CreatePackageAction.createDialogBuilder(project);
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        SmartPsiElementPointer directoryPointer = pointerManager.createSmartPsiElementPointer((PsiElement)directory2);
        final CreateDirectoryOrPackageHandler newOrdinaryPackageHandler = CreatePackageAction.getNewOrdinaryPackageHandler(project, directory2, (SmartPsiElementPointer<PsiDirectory>)directoryPointer);
        final CreateDirectoryOrPackageHandler newNamespacePackageHandler = CreatePackageAction.getNewNamespacePackageHandler(project, directory2, (SmartPsiElementPointer<PsiDirectory>)directoryPointer, module);
        builder.show(PyBundle.message("dialog.title.can.t.create.package", new Object[0]), ORDINARY_PACKAGE_TYPE, (CreateFileFromTemplateDialog.FileCreator)new CreateFileFromTemplateDialog.FileCreator<PsiDirectory>(){

            public PsiDirectory createFile(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (templateName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (templateName.equals(CreatePackageAction.ORDINARY_PACKAGE_TYPE)) {
                    CreatePackageAction.createNewPackage(name, newOrdinaryPackageHandler, item -> {
                        if (item != null) {
                            view.selectElement((PsiElement)item);
                        }
                    });
                } else if (templateName.equals(CreatePackageAction.NAMESPACE_PACKAGE_TYPE)) {
                    CreatePackageAction.createNewPackage(name, newNamespacePackageHandler, item -> {
                        if (item != null) {
                            view.selectElement((PsiElement)item);
                        }
                    });
                    PyNamespacePackagesStatisticsCollector.Companion.logNamespacePackageCreatedByUser();
                }
                return directory2;
            }

            public boolean startInWriteAction() {
                return false;
            }

            @NotNull
            public String getActionName(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (templateName == null) {
                    1.$$$reportNull$$$0(3);
                }
                String string = PyBundle.message("command.name.create.new.package", name);
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "templateName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/actions/CreatePackageAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/actions/CreatePackageAction$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createFile";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getActionName";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, EmptyConsumer.getInstance());
    }

    private static CreateDirectoryOrPackageHandler getNewOrdinaryPackageHandler(@NotNull Project project, @NotNull PsiDirectory directory2, final @NotNull SmartPsiElementPointer<PsiDirectory> directoryPointer) {
        if (project == null) {
            CreatePackageAction.$$$reportNull$$$0(1);
        }
        if (directory2 == null) {
            CreatePackageAction.$$$reportNull$$$0(2);
        }
        if (directoryPointer == null) {
            CreatePackageAction.$$$reportNull$$$0(3);
        }
        return new CreateDirectoryOrPackageHandler(project, directory2, false, "."){

            protected void createDirectories(String subDirName) {
                super.createDirectories(subDirName);
                PsiFileSystemItem element = this.getCreatedElement();
                PsiDirectory restoredDirectory = (PsiDirectory)directoryPointer.getElement();
                if (element instanceof PsiDirectory && restoredDirectory != null) {
                    CreatePackageAction.createInitPyInHierarchy((PsiDirectory)element, restoredDirectory);
                }
            }
        };
    }

    private static CreateDirectoryOrPackageHandler getNewNamespacePackageHandler(@NotNull Project project, @NotNull PsiDirectory directory2, final @NotNull SmartPsiElementPointer<PsiDirectory> directoryPointer, final @NotNull Module module) {
        if (project == null) {
            CreatePackageAction.$$$reportNull$$$0(4);
        }
        if (directory2 == null) {
            CreatePackageAction.$$$reportNull$$$0(5);
        }
        if (directoryPointer == null) {
            CreatePackageAction.$$$reportNull$$$0(6);
        }
        if (module == null) {
            CreatePackageAction.$$$reportNull$$$0(7);
        }
        return new CreateDirectoryOrPackageHandler(project, directory2, false, "."){

            protected void createDirectories(String subDirName) {
                PsiFileSystemItem element;
                super.createDirectories(subDirName);
                PsiDirectory restoredDirectory = (PsiDirectory)directoryPointer.getElement();
                if (restoredDirectory == null) {
                    return;
                }
                PsiFileSystemItem lastElement = element = this.getCreatedElement();
                while (element != null && !element.equals(restoredDirectory)) {
                    lastElement = element;
                    element = element.getParent();
                }
                if (element == null) {
                    return;
                }
                VirtualFile topmostCreatedDirectory = lastElement.getVirtualFile();
                if (topmostCreatedDirectory == null) {
                    return;
                }
                PyNamespacePackagesService.getInstance(module).toggleMarkingAsNamespacePackage(topmostCreatedDirectory);
            }
        };
    }

    private static void createNewPackage(@NotNull String name, @NotNull CreateDirectoryOrPackageHandler createHandler, @NotNull Consumer<PsiFileSystemItem> consumer) {
        if (name == null) {
            CreatePackageAction.$$$reportNull$$$0(8);
        }
        if (createHandler == null) {
            CreatePackageAction.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            CreatePackageAction.$$$reportNull$$$0(10);
        }
        if (createHandler.checkInput(name) && createHandler.canClose(name)) {
            consumer.accept(createHandler.getCreatedElement());
        } else {
            String errorMessage = createHandler.getErrorText(name);
            Messages.showErrorDialog((String)errorMessage, (String)PyBundle.message("dialog.title.can.t.create.package", new Object[0]));
        }
    }

    private static CreateFileFromTemplateDialog.Builder createDialogBuilder(@NotNull Project project) {
        if (project == null) {
            CreatePackageAction.$$$reportNull$$$0(11);
        }
        CreateFileFromTemplateDialog.Builder builder = CreateFileFromTemplateDialog.createDialog((Project)project);
        builder.setTitle(PyBundle.message("dialog.title.new.python.package", new Object[0])).addKind(PyBundle.message("new.package.list.item.ordinary.package", new Object[0]), PlatformIcons.PACKAGE_ICON, ORDINARY_PACKAGE_TYPE);
        if (PyNamespacePackagesService.isEnabled() && RegistryManager.getInstance().is("python.create.namespace.package.action")) {
            builder.addKind(PyBundle.message("new.package.list.item.namespace.package", new Object[0]), PlatformIcons.PACKAGE_ICON, NAMESPACE_PACKAGE_TYPE);
        }
        return builder;
    }

    public static void createInitPyInHierarchy(@NotNull PsiDirectory created, @NotNull PsiDirectory ancestor) {
        if (created == null) {
            CreatePackageAction.$$$reportNull$$$0(12);
        }
        if (ancestor == null) {
            CreatePackageAction.$$$reportNull$$$0(13);
        }
        if (created.equals(ancestor)) {
            CreatePackageAction.createInitPy(created);
            return;
        }
        do {
            CreatePackageAction.createInitPy(created);
        } while ((created = created.getParent()) != null && !created.equals(ancestor));
    }

    private static void createInitPy(@NotNull PsiDirectory directory2) {
        if (directory2 == null) {
            CreatePackageAction.$$$reportNull$$$0(14);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)directory2.getProject());
        FileTemplate template = fileTemplateManager.getInternalTemplate("Python Script");
        if (directory2.findFile("__init__.py") != null) {
            return;
        }
        try {
            FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)"__init__.py", (Properties)fileTemplateManager.getDefaultProperties(), (PsiDirectory)directory2);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePackageAction.$$$reportNull$$$0(15);
        }
        boolean enabled = CreatePackageAction.isEnabled(e);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePackageAction.$$$reportNull$$$0(16);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        IdeView ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (project == null || ideView == null) {
            return false;
        }
        PsiDirectory[] directories = ideView.getDirectories();
        return directories.length != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPointer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/actions/CreatePackageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewOrdinaryPackageHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewNamespacePackageHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewPackage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createDialogBuilder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createInitPyInHierarchy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createInitPy";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

