/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.ShareableKey;
import org.jetbrains.annotations.NotNull;

class FileChunkKey<OwnerType>
implements Comparable<FileChunkKey<OwnerType>>,
ShareableKey {
    private OwnerType owner;
    private long offset;

    FileChunkKey(OwnerType owner, long offset) {
        this.owner = owner;
        this.offset = offset;
    }

    public int hashCode() {
        return (int)((long)(this.owner.hashCode() * 31) + this.offset);
    }

    public OwnerType getOwner() {
        return this.owner;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileChunkKey k = (FileChunkKey)obj;
        return k.owner == this.owner && k.offset == this.offset;
    }

    public void setup(OwnerType owner, long offset) {
        this.owner = owner;
        this.offset = offset;
    }

    @Override
    public int compareTo(@NotNull FileChunkKey<OwnerType> o) {
        if (o == null) {
            FileChunkKey.$$$reportNull$$$0(0);
        }
        if (this.owner != o.owner) {
            return this.owner.hashCode() - o.owner.hashCode();
        }
        return this.offset == o.offset ? 0 : (this.offset - o.offset < 0L ? -1 : 1);
    }

    @Override
    public ShareableKey getStableCopy() {
        return new FileChunkKey<OwnerType>(this.owner, this.offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/io/FileChunkKey", "compareTo"));
    }
}

