/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlImpl
implements Url {
    private final String scheme;
    private final String authority;
    private final String path;
    private String decodedPath;
    private final String parameters;
    private String externalForm;
    private UrlImpl withoutParameters;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public UrlImpl(@NotNull String path) {
        if (path == null) {
            UrlImpl.$$$reportNull$$$0(0);
        }
        this(null, null, path, null);
    }

    UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path) {
        this(scheme, authority, path, null);
    }

    UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String parameters) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = StringUtil.notNullize(path);
        this.parameters = StringUtil.nullize(parameters);
    }

    @Override
    @NotNull
    public Url resolve(@NotNull String subPath) {
        if (subPath == null) {
            UrlImpl.$$$reportNull$$$0(1);
        }
        return new UrlImpl(this.scheme, this.authority, (String)(this.path.isEmpty() ? subPath : this.path + "/" + subPath), this.parameters);
    }

    @Override
    @NotNull
    public Url addParameters(@NotNull Map<String, String> parameters) {
        if (parameters == null) {
            UrlImpl.$$$reportNull$$$0(2);
        }
        if (parameters.isEmpty()) {
            UrlImpl urlImpl = this;
            if (urlImpl == null) {
                UrlImpl.$$$reportNull$$$0(3);
            }
            return urlImpl;
        }
        StringBuilder builder = new StringBuilder();
        if (this.parameters == null) {
            builder.append('?');
        } else {
            builder.append(this.parameters);
            builder.append('&');
        }
        Urls.encodeParameters(parameters, builder);
        return new UrlImpl(this.scheme, this.authority, this.path, builder.toString());
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.decodedPath == null) {
            this.decodedPath = URLUtil.unescapePercentSequences(this.path);
        }
        String string = this.decodedPath;
        if (string == null) {
            UrlImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public boolean isInLocalFileSystem() {
        return "file".equals(this.scheme);
    }

    @Override
    @Nullable
    public String getParameters() {
        return this.parameters;
    }

    @Override
    public String toDecodedForm() {
        StringBuilder builder = new StringBuilder();
        if (this.scheme != null) {
            builder.append(this.scheme);
            if (this.authority == null) {
                builder.append(':');
            } else {
                builder.append("://");
            }
            if (this.authority != null) {
                builder.append(this.authority);
            }
        }
        builder.append(this.getPath());
        if (this.parameters != null) {
            builder.append(this.parameters);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String toExternalForm() {
        Object result;
        if (this.externalForm != null) {
            String string = this.externalForm;
            if (string == null) {
                UrlImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        if ((this.authority == null || !this.path.isEmpty() && this.path.charAt(0) != '/') && !this.isInLocalFileSystem()) {
            String string = this.toDecodedForm();
            if (string == null) {
                UrlImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        Object object = result = StringUtil.isEmpty(this.authority) && StringUtil.isEmpty(this.path) ? this.scheme + "://" : Urls.toUriWithoutParameters(this).toASCIIString();
        if (this.parameters != null) {
            result = (String)result + this.parameters;
        }
        this.externalForm = result;
        String string = result;
        if (string == null) {
            UrlImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public Url trimParameters() {
        if (this.parameters == null) {
            UrlImpl urlImpl = this;
            if (urlImpl == null) {
                UrlImpl.$$$reportNull$$$0(8);
            }
            return urlImpl;
        }
        if (this.withoutParameters == null) {
            this.withoutParameters = new UrlImpl(this.scheme, this.authority, this.path, null);
        }
        UrlImpl urlImpl = this.withoutParameters;
        if (urlImpl == null) {
            UrlImpl.$$$reportNull$$$0(9);
        }
        return urlImpl;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equals(this.scheme, url.scheme) && StringUtil.equals(this.authority, url.authority) && this.getPath().equals(url.getPath()) && StringUtil.equals(this.parameters, url.parameters);
    }

    @Override
    public boolean equalsIgnoreCase(@Nullable Url o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equalsIgnoreCase(this.scheme, url.scheme) && StringUtil.equalsIgnoreCase(this.authority, url.authority) && this.getPath().equalsIgnoreCase(url.getPath()) && StringUtil.equalsIgnoreCase(this.parameters, url.parameters);
    }

    @Override
    public boolean equalsIgnoreParameters(@Nullable Url url) {
        return url != null && this.equals(url.trimParameters());
    }

    private int computeHashCode(boolean caseSensitive) {
        int result = UrlImpl.stringHashCode(this.scheme, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.authority, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.getPath(), caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.parameters, caseSensitive);
        return result;
    }

    private static int stringHashCode(@Nullable CharSequence string, boolean caseSensitive) {
        return string == null ? 0 : (caseSensitive ? string.hashCode() : StringUtil.stringHashCodeInsensitive(string));
    }

    public int hashCode() {
        return this.computeHashCode(true);
    }

    @Override
    public int hashCodeCaseInsensitive() {
        return this.computeHashCode(false);
    }

    @Override
    @NotNull
    public Url removeParameter(@NotNull String name) {
        if (name == null) {
            UrlImpl.$$$reportNull$$$0(10);
        }
        StringBuilder result = new StringBuilder();
        String parameters = this.parameters;
        if (parameters == null) {
            UrlImpl urlImpl = this;
            if (urlImpl == null) {
                UrlImpl.$$$reportNull$$$0(11);
            }
            return urlImpl;
        }
        if (parameters.startsWith("?")) {
            parameters = StringUtil.trimStart(parameters, "?");
            result.append("?");
        }
        boolean added = false;
        for (String s : parameters.split("&")) {
            String currentName = ContainerUtil.getFirstItem(StringUtil.split(s, "="));
            if (StringUtil.equals(currentName, name)) continue;
            if (added) {
                result.append("&");
            }
            result.append(s);
            added = true;
        }
        return new UrlImpl(this.scheme, this.authority, this.path, result.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/UrlImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/UrlImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toExternalForm";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "trimParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

