/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.CacheKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.Icon;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageLoader {
    public static final int ALLOW_FLOAT_SCALING = 1;
    public static final int USE_CACHE = 2;
    public static final int USE_DARK = 4;
    public static final int USE_SVG = 8;
    public static final Component ourComponent = new Component(){};

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ImageLoader.class);
        if (logger == null) {
            ImageLoader.$$$reportNull$$$0(0);
        }
        return logger;
    }

    private static void addFileNameVariant(boolean retina, boolean isDark, boolean isSvg, String name, String ext, float scale, @NotNull List<? super ImageDescriptor> list) {
        float _scale;
        String _ext;
        if (list == null) {
            ImageLoader.$$$reportNull$$$0(1);
        }
        String string = _ext = isSvg ? "svg" : ext;
        float f = isSvg ? scale : (_scale = retina ? 2.0f : 1.0f);
        if (retina && isDark) {
            list.add(new ImageDescriptor(name + "@2x_dark." + _ext, _scale, isSvg, true));
        }
        list.add(new ImageDescriptor(name + (isDark ? "_dark" : "") + (retina ? "@2x" : "") + "." + _ext, _scale, isSvg, isDark));
        if (retina) {
            list.add(new ImageDescriptor(name + (isDark ? "_dark" : "") + "." + _ext, isSvg ? scale : 1.0f, isSvg, isDark));
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static Image loadImage(@NotNull String path, @NotNull List<? extends ImageFilter> filters, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, int flags, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(2);
        }
        if (filters == null) {
            ImageLoader.$$$reportNull$$$0(3);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(4);
        }
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        List<ImageDescriptor> descriptors = ImageLoader.createImageDescriptorList(path, flags, scaleContext);
        ImageCache imageCache = ImageCache.INSTANCE;
        boolean ioExceptionThrown = false;
        boolean isHiDpiNeeded = StartupUiUtil.isJreHiDPI(scaleContext);
        Dimension2DDouble originalUserSize = new Dimension2DDouble(0.0, 0.0);
        for (int i = 0; i < descriptors.size(); ++i) {
            ImageDescriptor descriptor = descriptors.get(i);
            try {
                Image image = ImageLoader.loadByDescriptor(descriptor, flags, resourceClass, classLoader, originalUserSize, i == 0 ? imageCache.ioMissCache : null, imageCache, path);
                if (image == null) continue;
                if (start != -1L) {
                    IconLoadMeasurer.addLoading(descriptor.isSvg, start);
                }
                return ImageLoader.convertImage(image, filters, flags, scaleContext, isUpScaleNeeded, isHiDpiNeeded, descriptor.scale, descriptor.isSvg, originalUserSize);
            }
            catch (IOException e) {
                ioExceptionThrown = true;
            }
        }
        if (ioExceptionThrown) {
            imageCache.ioMissCache.add(path);
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static Image loadImageForStartUp(@NotNull String path, @NotNull ClassLoader classLoader, int flags, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(5);
        }
        if (classLoader == null) {
            ImageLoader.$$$reportNull$$$0(6);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(7);
        }
        List<ImageDescriptor> descriptors = ImageLoader.createImageDescriptorList(path, flags, scaleContext);
        boolean isHiDpiNeeded = StartupUiUtil.isJreHiDPI(scaleContext);
        Dimension2DDouble originalUserSize = new Dimension2DDouble(0.0, 0.0);
        for (ImageDescriptor descriptor : descriptors) {
            try {
                Image image = ImageLoader.loadByDescriptorWithoutCache(descriptor, null, classLoader, originalUserSize);
                if (image == null) continue;
                return ImageLoader.convertImage(image, Collections.emptyList(), flags, scaleContext, isUpScaleNeeded, isHiDpiNeeded, descriptor.scale, descriptor.isSvg, originalUserSize);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @Nullable
    private static Image loadByDescriptor(@NotNull ImageDescriptor descriptor, int flags, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, @NotNull Dimension2DDouble originalUserSize, @Nullable Set<String> ioMissCache, @NotNull ImageCache imageCache, @Nullable String ioMissCacheKey) throws IOException {
        if (descriptor == null) {
            ImageLoader.$$$reportNull$$$0(8);
        }
        if (originalUserSize == null) {
            ImageLoader.$$$reportNull$$$0(9);
        }
        if (imageCache == null) {
            ImageLoader.$$$reportNull$$$0(10);
        }
        CacheKey cacheKey = null;
        if ((flags & 2) == 2 && !SVGLoader.isSelectionContext()) {
            Dimension2DDouble dimension;
            cacheKey = new CacheKey(descriptor.path, descriptor.isSvg ? (double)descriptor.scale : 0.0);
            Pair pair = (Pair)imageCache.imageCache.get(cacheKey);
            if (pair != null) {
                originalUserSize.setSize((Dimension2DDouble)pair.second);
                return (Image)pair.first;
            }
            Image image = (Image)imageCache.largeImageCache.get(cacheKey);
            if (image != null && (dimension = (Dimension2DDouble)imageCache.largeImageDimensionMap.get(image)) != null) {
                originalUserSize.setSize(dimension);
                return image;
            }
        }
        if (ioMissCache != null && ioMissCache.contains(ioMissCacheKey)) {
            return null;
        }
        Image image = ImageLoader.loadByDescriptorWithoutCache(descriptor, resourceClass, classLoader, originalUserSize);
        if (image == null) {
            return null;
        }
        if (cacheKey != null) {
            if (4L * (long)image.getWidth(null) * (long)image.getHeight(null) <= ImageCache.CACHED_IMAGE_MAX_SIZE) {
                imageCache.imageCache.put(cacheKey, new Pair<Image, Dimension2DDouble>(image, originalUserSize));
            } else {
                imageCache.largeImageCache.put(cacheKey, image);
                imageCache.largeImageDimensionMap.put(image, originalUserSize);
            }
        }
        return image;
    }

    @Nullable
    private static Image loadByDescriptorWithoutCache(@NotNull ImageDescriptor descriptor, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, @NotNull Dimension2DDouble originalUserSize) throws IOException {
        Image image;
        if (descriptor == null) {
            ImageLoader.$$$reportNull$$$0(11);
        }
        if (originalUserSize == null) {
            ImageLoader.$$$reportNull$$$0(12);
        }
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        if (resourceClass == null && (classLoader == null || URLUtil.containsScheme(descriptor.path)) && !descriptor.path.startsWith("file://")) {
            URLConnection connection = new URL(descriptor.path).openConnection();
            if (connection instanceof HttpURLConnection) {
                if (!descriptor.original) {
                    return null;
                }
                connection.addRequestProperty("User-Agent", "IntelliJ");
            }
            try (InputStream stream = connection.getInputStream();){
                image = descriptor.isSvg ? SVGLoader.load(descriptor.path, stream, descriptor.scale, descriptor.isDark, originalUserSize) : ImageLoader.loadPng(stream, descriptor.scale, originalUserSize);
            }
            if (start != -1L) {
                IconLoadMeasurer.loadFromUrl.end(start);
            }
        } else {
            image = descriptor.isSvg ? SVGLoader.loadFromClassResource(resourceClass, classLoader, descriptor.path, 0L, descriptor.scale, descriptor.isDark, originalUserSize) : ImageLoader.loadPngFromClassResource(descriptor.path, resourceClass, classLoader, descriptor.scale, originalUserSize);
            if (start != -1L) {
                IconLoadMeasurer.loadFromResources.end(start);
            }
        }
        return image;
    }

    @Nullable
    static InputStream getResourceData(@NotNull String path, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader) {
        File file;
        InputStream stream;
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(13);
        }
        assert (resourceClass != null || classLoader != null || path.startsWith("file://"));
        if (classLoader != null && (stream = classLoader.getResourceAsStream(path.startsWith("/") ? path.substring(1) : path)) != null) {
            return stream;
        }
        if (resourceClass != null) {
            return resourceClass.getResourceAsStream(path);
        }
        if (path.startsWith("file://") && (file = new File(path.substring("file://".length()))).exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                ImageLoader.getLogger().warn(e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @Nullable
    public static Image loadPngFromClassResource(String path, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, double scale, @NotNull Dimension2DDouble dimension2DDouble) throws IOException {
        InputStream stream;
        if (dimension2DDouble == null) {
            ImageLoader.$$$reportNull$$$0(14);
        }
        if ((stream = ImageLoader.getResourceData(path, resourceClass, classLoader)) == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            void originalUserSize;
            BufferedImage bufferedImage = ImageLoader.loadPng(stream, scale, (Dimension2DDouble)originalUserSize);
            return bufferedImage;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Internal
    @NotNull
    public static Image loadFromStream(@NotNull InputStream stream, @Nullable String path, float scale, @NotNull Dimension2DDouble originalUserSize, int flags) throws IOException {
        if (stream == null) {
            ImageLoader.$$$reportNull$$$0(15);
        }
        if (originalUserSize == null) {
            ImageLoader.$$$reportNull$$$0(16);
        }
        InputStream inputStream = stream;
        if ((flags & 8) == 8) {
            Image image = SVGLoader.load(path, stream, scale, (flags & 4) == 4, originalUserSize);
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(17);
            }
            return image2;
        }
        BufferedImage bufferedImage = ImageLoader.loadPng(stream, scale, originalUserSize);
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ImageLoader.$$$reportNull$$$0(18);
        }
        return bufferedImage2;
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage loadPng(@NotNull InputStream stream, double scale, @NotNull Dimension2DDouble dimension2DDouble) throws IOException {
        void originalUserSize;
        BufferedImage image;
        if (stream == null) {
            ImageLoader.$$$reportNull$$$0(19);
        }
        if (dimension2DDouble == null) {
            ImageLoader.$$$reportNull$$$0(20);
        }
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
        try (MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(stream);){
            reader.setInput(imageInputStream, true, true);
            image = reader.read(0, null);
        }
        finally {
            reader.dispose();
        }
        originalUserSize.setSize((double)image.getWidth() / scale, (double)image.getHeight() / scale);
        if (start != -1L) {
            IconLoadMeasurer.pngDecoding.end(start);
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(21);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Image convertImage(@NotNull Image image, @NotNull List<? extends ImageFilter> filters, int flags, ScaleContext scaleContext, boolean isUpScaleNeeded, boolean isHiDpiNeeded, double imageScale, boolean isSvg, @NotNull Dimension2DDouble dimension2DDouble) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(22);
        }
        if (filters == null) {
            ImageLoader.$$$reportNull$$$0(23);
        }
        if (dimension2DDouble == null) {
            ImageLoader.$$$reportNull$$$0(24);
        }
        if (isUpScaleNeeded && !isSvg) {
            double scale = ImageLoader.adjustScaleFactor((flags & 1) == 1, (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE));
            if (imageScale > 1.0) {
                scale /= imageScale;
            }
            image = ImageLoader.scaleImage(image, scale);
        }
        if (!filters.isEmpty()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (ImageFilter imageFilter : filters) {
                if (imageFilter == null) continue;
                image = toolkit.createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image, false).getSource(), imageFilter));
            }
        }
        if (isHiDpiNeeded) {
            void originalUserSize;
            double userScale = scaleContext.getScale(DerivedScaleType.EFF_USR_SCALE);
            image = new JBHiDPIScaledImage(image, originalUserSize.getWidth() * userScale, originalUserSize.getHeight() * userScale, 2);
        }
        return image;
    }

    @NotNull
    public static List<ImageDescriptor> getImageDescriptors(@NotNull String path, int flags, @NotNull ScaleContext scaleContext) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(25);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(26);
        }
        return ImageLoader.createImageDescriptorList(path, flags, scaleContext);
    }

    @NotNull
    private static List<ImageDescriptor> createImageDescriptorList(@NotNull String path, int flags, @NotNull ScaleContext scaleContext) {
        ArrayList<ImageDescriptor> list;
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(27);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(28);
        }
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        int i = path.lastIndexOf(46);
        String name = i < 0 ? path : path.substring(0, i);
        String ext = i < 0 || i == path.length() - 1 ? "" : path.substring(i + 1);
        float scale = ImageLoader.adjustScaleFactor((flags & 1) == 1, pixScale);
        if (!path.startsWith("file:") && path.contains("://")) {
            int qI = path.lastIndexOf(63);
            boolean isSvg = StringUtilRt.endsWithIgnoreCase(qI == -1 ? path : path.substring(0, qI), ".svg");
            list = Collections.singletonList(new ImageDescriptor(name + "." + ext, 1.0f, isSvg, true));
        } else {
            boolean isSvg = "svg".equalsIgnoreCase(ext);
            boolean isDark = (flags & 4) == 4;
            boolean retina = JBUIScale.isHiDPI(pixScale);
            list = new ArrayList();
            if (!isSvg && (flags & 8) == 8) {
                ImageLoader.addFileNameVariant(retina, isDark, true, name, ext, scale, list);
            }
            ImageLoader.addFileNameVariant(retina, isDark, isSvg, name, ext, scale, list);
            if (isDark) {
                ImageLoader.addFileNameVariant(retina, false, isSvg, name, ext, scale, list);
                if (!isSvg && (flags & 8) == 8) {
                    ImageLoader.addFileNameVariant(false, false, true, name, ext, scale, list);
                }
            }
        }
        ArrayList<ImageDescriptor> arrayList = list;
        if (arrayList == null) {
            ImageLoader.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(30);
        }
        int flags = 11;
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        String path = url.toString();
        return ImageLoader.loadImage(path, Collections.emptyList(), null, null, flags, ScaleContext.create(), !path.endsWith(".svg"));
    }

    @Nullable
    public static Image loadFromUrl(@NotNull String path, @Nullable Class<?> aClass, int flags, @NotNull ScaleContext scaleContext) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(31);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(32);
        }
        return ImageLoader.loadImage(path, Collections.emptyList(), aClass, null, flags, scaleContext, !path.endsWith(".svg"));
    }

    public static float adjustScaleFactor(boolean allowFloatScaling, float scale) {
        return allowFloatScaling ? scale : (JBUIScale.isHiDPI(scale) ? 2.0f : 1.0f);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, double scale) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(33);
        }
        if (scale == 1.0) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(34);
            }
            return image2;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(35);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image3 = image;
            if (image3 == null) {
                ImageLoader.$$$reportNull$$$0(36);
            }
            return image3;
        }
        int width = (int)Math.round(scale * (double)w);
        int height = (int)Math.round(scale * (double)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image, false), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(37);
        }
        return bufferedImage;
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetSize) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(38);
        }
        return ImageLoader.scaleImage(image, targetSize, targetSize);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetWidth, int targetHeight) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(39);
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(targetWidth, targetHeight);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(40);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0 || w == targetWidth && h == targetHeight) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(41);
            }
            return image2;
        }
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(42);
        }
        return bufferedImage;
    }

    @Deprecated
    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        Class<?> callerClass;
        if (s == null) {
            ImageLoader.$$$reportNull$$$0(43);
        }
        return (callerClass = ReflectionUtil.getGrandCallerClass()) == null ? null : ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class<?> aClass) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(44);
        }
        if (aClass == null) {
            ImageLoader.$$$reportNull$$$0(45);
        }
        ScaleContext scaleContext = ScaleContext.create();
        int flags = 11;
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        return ImageLoader.loadImage(path, Collections.emptyList(), aClass, null, flags, scaleContext, false);
    }

    public static Image loadFromBytes(byte @NotNull [] bytes) {
        if (bytes == null) {
            ImageLoader.$$$reportNull$$$0(46);
        }
        return ImageLoader.loadFromStream(new ByteArrayInputStream(bytes));
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        BufferedImage bufferedImage;
        block10: {
            if (inputStream == null) {
                ImageLoader.$$$reportNull$$$0(47);
            }
            ScaleContext scaleContext = ScaleContext.create();
            InputStream inputStream2 = inputStream;
            try {
                Dimension2DDouble originalUserSize = new Dimension2DDouble(0.0, 0.0);
                double scale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
                BufferedImage image = ImageLoader.loadPng(inputStream, scale, originalUserSize);
                if (StartupUiUtil.isJreHiDPI(scaleContext)) {
                    double userScale = scaleContext.getScale(DerivedScaleType.EFF_USR_SCALE);
                    image = new JBHiDPIScaledImage((Image)image, originalUserSize.getWidth() * userScale, originalUserSize.getHeight() * userScale, 2);
                }
                bufferedImage = image;
                if (inputStream2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ImageLoader.getLogger().error(e);
                    return null;
                }
            }
            inputStream2.close();
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadCustomIcon(@NotNull File file) throws IOException {
        if (file == null) {
            ImageLoader.$$$reportNull$$$0(48);
        }
        ScaleContext scaleContext = ScaleContext.create();
        float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        ImageDescriptor imageDescriptor = new ImageDescriptor(file.toURI().toURL().toString(), scale, StringUtilRt.endsWithIgnoreCase(file.getPath(), ".svg"), file.getPath().contains("_dark."));
        Image icon = ImageUtil.ensureHiDPI(ImageLoader.loadByDescriptor(imageDescriptor, 2, null, null, new Dimension2DDouble(0.0, 0.0), null, ImageCache.INSTANCE, null), scaleContext);
        if (icon == null) {
            return null;
        }
        int w = icon.getWidth(null);
        int h = icon.getHeight(null);
        if (w <= 0 || h <= 0) {
            ImageLoader.getLogger().error("negative image size: w=" + w + ", h=" + h + ", path=" + file.getPath());
            return null;
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            double s = (double)EmptyIcon.ICON_18.getIconWidth() / (double)Math.max(w, h);
            return ImageLoader.scaleImage(icon, s);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ImageLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 25: 
            case 27: 
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 4: 
            case 7: 
            case 26: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalUserSize";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageCache";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 22: 
            case 33: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ImageLoader";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromStream";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPng";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageDescriptorList";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addFileNameVariant";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadImageForStartUp";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadByDescriptor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadByDescriptorWithoutCache";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResourceData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadPngFromClassResource";
                break;
            }
            case 15: 
            case 16: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadPng";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "convertImage";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getImageDescriptors";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createImageDescriptorList";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 33: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "scaleImage";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadFromBytes";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "loadCustomIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Dimension2DDouble {
        private double myWidth;
        private double myHeight;

        public Dimension2DDouble(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public void setSize(Dimension2DDouble size) {
            this.myWidth = size.myWidth;
            this.myHeight = size.myHeight;
        }

        public void setSize(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public double getWidth() {
            return this.myWidth;
        }

        public double getHeight() {
            return this.myHeight;
        }
    }

    @ApiStatus.Internal
    public static final class ImageCache {
        public static final ImageCache INSTANCE = new ImageCache();
        private static final long CACHED_IMAGE_MAX_SIZE = (long)(SystemProperties.getFloatProperty("ide.cached.image.max.size", 1.5f) * 1024.0f * 1024.0f);
        private final Set<String> ioMissCache = Collections.newSetFromMap(new ConcurrentHashMap());
        private final ConcurrentMap<CacheKey, Pair<Image, Dimension2DDouble>> imageCache = CollectionFactory.createConcurrentSoftValueMap();
        private final ConcurrentMap<CacheKey, Image> largeImageCache = CollectionFactory.createConcurrentWeakValueMap();
        private final ConcurrentMap<Image, Dimension2DDouble> largeImageDimensionMap = CollectionFactory.createConcurrentWeakMap();

        private ImageCache() {
        }

        @ApiStatus.Internal
        public static boolean isIconTooLargeForCache(@NotNull Icon icon) {
            if (icon == null) {
                ImageCache.$$$reportNull$$$0(0);
            }
            return 4L * (long)icon.getIconWidth() * (long)icon.getIconHeight() > CACHED_IMAGE_MAX_SIZE;
        }

        public void clearCache() {
            this.imageCache.clear();
            this.largeImageCache.clear();
            this.largeImageDimensionMap.clear();
            this.ioMissCache.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/ImageLoader$ImageCache", "isIconTooLargeForCache"));
        }
    }
}

