/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;
import org.jetbrains.integratedBinaryPacking.IntBitPacker;
import org.jetbrains.mvstore.type.DataType;

public final class ImageValue {
    final byte[] data;
    final float width;
    final float height;
    final int actualWidth;
    final int actualHeight;

    ImageValue(byte[] data, float width, float height, int actualWidth, int actualHeight) {
        this.data = data;
        this.width = width;
        this.height = height;
        this.actualWidth = actualWidth;
        this.actualHeight = actualHeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageValue value = (ImageValue)o;
        return Float.compare(value.width, this.width) == 0 && Float.compare(value.height, this.height) == 0 && this.actualWidth == value.actualWidth && this.actualHeight == value.actualHeight && Arrays.equals(this.data, value.data);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.data);
        result = 31 * result + (this.width != 0.0f ? Float.floatToIntBits(this.width) : 0);
        result = 31 * result + (this.height != 0.0f ? Float.floatToIntBits(this.height) : 0);
        result = 31 * result + this.actualWidth;
        result = 31 * result + this.actualHeight;
        return result;
    }

    public static final class ImageValueSerializer
    implements DataType<ImageValue> {
        public ImageValue[] createStorage(int size) {
            return new ImageValue[size];
        }

        @Override
        public int getMemory(ImageValue obj) {
            return 18 + obj.data.length;
        }

        @Override
        public int getFixedMemory() {
            return -1;
        }

        @Override
        public void write(ByteBuf buf, ImageValue obj) {
            buf.writeFloat(obj.width);
            buf.writeFloat(obj.height);
            IntBitPacker.writeVar(buf, obj.actualWidth);
            IntBitPacker.writeVar(buf, obj.actualHeight);
            buf.writeBytes(obj.data);
        }

        @Override
        public ImageValue read(ByteBuf buf) {
            float width = buf.readFloat();
            float height = buf.readFloat();
            int actualWidth = IntBitPacker.readVar(buf);
            int actualHeight = IntBitPacker.readVar(buf);
            int length = actualWidth * actualHeight * 4;
            byte[] data = ByteBufUtil.getBytes(buf, buf.readerIndex(), length);
            buf.readerIndex(buf.readerIndex() + length);
            return new ImageValue(data, width, height, actualWidth, actualHeight);
        }
    }
}

