/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalCommandHistoryManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

@State(name="TerminalArrangementManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public class TerminalArrangementManager
implements PersistentStateComponent<TerminalArrangementState> {
    private final TerminalWorkingDirectoryManager myWorkingDirectoryManager;
    private final Project myProject;
    private ToolWindow myTerminalToolWindow;
    private TerminalArrangementState myState;

    public TerminalArrangementManager(@NotNull Project project) {
        if (project == null) {
            TerminalArrangementManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myWorkingDirectoryManager = new TerminalWorkingDirectoryManager();
    }

    public void setToolWindow(@NotNull ToolWindow terminalToolWindow) {
        if (terminalToolWindow == null) {
            TerminalArrangementManager.$$$reportNull$$$0(1);
        }
        this.myTerminalToolWindow = terminalToolWindow;
        this.myWorkingDirectoryManager.init(terminalToolWindow);
    }

    @Nullable
    public TerminalArrangementState getState() {
        if (!TerminalArrangementManager.isAvailable() || this.myTerminalToolWindow == null) {
            return null;
        }
        TerminalArrangementState state = this.calcArrangementState(this.myTerminalToolWindow);
        TerminalCommandHistoryManager.getInstance().retainCommandHistoryFiles(TerminalArrangementManager.getCommandHistoryFileNames(state), this.myProject);
        return state;
    }

    public void loadState(@NotNull TerminalArrangementState state) {
        if (state == null) {
            TerminalArrangementManager.$$$reportNull$$$0(2);
        }
        if (TerminalArrangementManager.isAvailable()) {
            this.myState = state;
        }
    }

    @NotNull
    private static List<String> getCommandHistoryFileNames(@NotNull TerminalArrangementState state) {
        if (state == null) {
            TerminalArrangementManager.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.mapNotNull(state.myTabStates, tabState -> tabState.myCommandHistoryFileName);
        if (list == null) {
            TerminalArrangementManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public TerminalArrangementState getArrangementState() {
        return this.myState;
    }

    @NotNull
    private TerminalArrangementState calcArrangementState(@NotNull ToolWindow terminalToolWindow) {
        if (terminalToolWindow == null) {
            TerminalArrangementManager.$$$reportNull$$$0(5);
        }
        TerminalArrangementState arrangementState = new TerminalArrangementState();
        ContentManager contentManager = terminalToolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            JBTerminalWidget terminalWidget = TerminalView.getWidgetByContent(content);
            if (terminalWidget == null) continue;
            TerminalTabState tabState = new TerminalTabState();
            tabState.myTabName = content.getTabName();
            tabState.myWorkingDirectory = this.myWorkingDirectoryManager.getWorkingDirectory(content);
            tabState.myCommandHistoryFileName = TerminalCommandHistoryManager.getFilename(ShellTerminalWidget.getCommandHistoryFilePath(terminalWidget));
            arrangementState.myTabStates.add(tabState);
        }
        Content selectedContent = contentManager.getSelectedContent();
        arrangementState.mySelectedTabIndex = selectedContent == null ? -1 : contentManager.getIndexOfContent(selectedContent);
        TerminalArrangementState terminalArrangementState = arrangementState;
        if (terminalArrangementState == null) {
            TerminalArrangementManager.$$$reportNull$$$0(6);
        }
        return terminalArrangementState;
    }

    public void assignCommandHistoryFile(@NotNull JBTerminalWidget terminalWidget, @Nullable TerminalTabState tabState) {
        if (terminalWidget == null) {
            TerminalArrangementManager.$$$reportNull$$$0(7);
        }
        if (TerminalArrangementManager.isAvailable() && terminalWidget instanceof ShellTerminalWidget) {
            Path historyFile = TerminalCommandHistoryManager.getInstance().getOrCreateCommandHistoryFile(tabState != null ? tabState.myCommandHistoryFileName : null, this.myProject);
            String historyFilePath = historyFile != null ? historyFile.toAbsolutePath().toString() : null;
            ((ShellTerminalWidget)terminalWidget).setCommandHistoryFilePath(historyFilePath);
        }
    }

    @NotNull
    public static TerminalArrangementManager getInstance(@NotNull Project project) {
        if (project == null) {
            TerminalArrangementManager.$$$reportNull$$$0(8);
        }
        TerminalArrangementManager terminalArrangementManager = (TerminalArrangementManager)project.getService(TerminalArrangementManager.class);
        if (terminalArrangementManager == null) {
            TerminalArrangementManager.$$$reportNull$$$0(9);
        }
        return terminalArrangementManager;
    }

    static boolean isAvailable() {
        return Registry.is((String)"terminal.persistent.tabs");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalToolWindow";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/arrangement/TerminalArrangementManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/arrangement/TerminalArrangementManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandHistoryFileNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcArrangementState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommandHistoryFileNames";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcArrangementState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assignCommandHistoryFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

