/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.plugins.PluginUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final Logger LOG = Logger.getInstance(ID.class);
    private static final Int2ObjectMap<ID<?, ?>> ourRegistry = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private static final SimpleStringPersistentEnumerator ourNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
    private static final Map<ID<?, ?>, PluginId> ourIdToPluginId = Collections.synchronizedMap(new HashMap());
    private static final Map<ID<?, ?>, Throwable> ourIdToRegistrationStackTrace = Collections.synchronizedMap(new HashMap());
    static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private final short myUniqueId;

    @NotNull
    private static Path getEnumFile() {
        Path path2 = PathManager.getIndexRoot().resolve("indices.enum");
        if (path2 == null) {
            ID.$$$reportNull$$$0(0);
        }
        return path2;
    }

    @ApiStatus.Internal
    protected ID(@NotNull String name, @Nullable PluginId pluginId) {
        if (name == null) {
            ID.$$$reportNull$$$0(1);
        }
        super(name);
        this.myUniqueId = ID.stringToId(name);
        ID old = (ID)((Object)ourRegistry.put((int)this.myUniqueId, (Object)this));
        assert (old == null) : "ID with name '" + name + "' is already registered";
        PluginId oldPluginId = ourIdToPluginId.put(this, pluginId);
        assert (oldPluginId == null) : "ID with name '" + name + "' is already registered in " + oldPluginId + " but current caller is " + pluginId;
        ourIdToRegistrationStackTrace.put(this, new Throwable());
    }

    private static short stringToId(@NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(2);
        }
        return ourNameToIdRegistry.enumerate(name);
    }

    static void reinitializeDiskStorage() {
        ourNameToIdRegistry.forceDiskSync();
    }

    @NotNull
    public static synchronized <K, V> ID<K, V> create(@NonNls @NotNull String name) {
        PluginId pluginId;
        ID<K, V> found;
        if (name == null) {
            ID.$$$reportNull$$$0(3);
        }
        ID<K, V> iD = (found = ID.findByName(name, true, pluginId = ID.getCallerPluginId())) == null ? new ID<K, V>(name, pluginId) : found;
        if (iD == null) {
            ID.$$$reportNull$$$0(4);
        }
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(5);
        }
        return ID.findByName(name, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected static <K, V> ID<K, V> findByName(@NotNull String name, boolean checkCallerPlugin, @Nullable PluginId requiredPluginId) {
        if (name == null) {
            ID.$$$reportNull$$$0(6);
        }
        ID<?, ?> id = ID.findById(ID.stringToId(name));
        if (checkCallerPlugin && id != null) {
            String requiredPluginIdStr;
            PluginId actualPluginId = ourIdToPluginId.get(id);
            String actualPluginIdStr = actualPluginId == null ? "IDEA Core" : actualPluginId.getIdString();
            String string = requiredPluginIdStr = requiredPluginId == null ? "IDEA Core" : requiredPluginId.getIdString();
            if (!Objects.equals(actualPluginIdStr, requiredPluginIdStr)) {
                Throwable registrationStackTrace = ourIdToRegistrationStackTrace.get(id);
                String message = ID.getInvalidIdAccessMessage(name, actualPluginIdStr, requiredPluginIdStr, registrationStackTrace);
                if (registrationStackTrace != null) {
                    throw new AssertionError(message, registrationStackTrace);
                }
                throw new AssertionError((Object)message);
            }
        }
        return id;
    }

    @NotNull
    private static String getInvalidIdAccessMessage(@NotNull String name, @Nullable String actualPluginIdStr, @Nullable String requiredPluginIdStr, @Nullable Throwable registrationStackTrace) {
        if (name == null) {
            ID.$$$reportNull$$$0(7);
        }
        String string = "ID with name '" + name + "' requested for plugin " + requiredPluginIdStr + " but registered for " + actualPluginIdStr + " plugin. Please use an instance field to access corresponding ID." + (registrationStackTrace == null ? " Registration stack trace: " : "");
        if (string == null) {
            ID.$$$reportNull$$$0(8);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public Throwable getRegistrationTrace() {
        Throwable throwable = ourIdToRegistrationStackTrace.get((Object)this);
        if (throwable == null) {
            ID.$$$reportNull$$$0(9);
        }
        return throwable;
    }

    public final int hashCode() {
        return this.myUniqueId;
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginId getPluginId() {
        return ourIdToPluginId.get((Object)this);
    }

    public static ID<?, ?> findById(int id) {
        return (ID)((Object)ourRegistry.get(id));
    }

    @ApiStatus.Internal
    @Nullable
    protected static PluginId getCallerPluginId() {
        return PluginUtil.getInstance().getCallerPlugin(4);
    }

    @ApiStatus.Internal
    public static synchronized void unloadId(@NotNull ID<?, ?> id) {
        if (id == null) {
            ID.$$$reportNull$$$0(10);
        }
        ID oldID = (ID)((Object)ourRegistry.remove(id.getUniqueId()));
        LOG.assertTrue(id.equals((Object)oldID));
        ourIdToPluginId.remove(id);
        ourIdToRegistrationStackTrace.remove(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/ID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/ID";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIdAccessMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationTrace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stringToId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidIdAccessMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unloadId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

