/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.util.animation.Easing;
import java.util.Arrays;

public final class CubicBezierEasing
implements Easing {
    private final double[] xs;
    private final double[] ys;

    public CubicBezierEasing(double c1x, double c1y, double c2x, double c2y) {
        this(c1x, c1y, c2x, c2y, 1024);
    }

    public CubicBezierEasing(double c1x, double c1y, double c2x, double c2y, int size) {
        this.xs = new double[size];
        this.ys = new double[size];
        this.update(c1x, c1y, c2x, c2y);
    }

    public void update(double c1x, double c1y, double c2x, double c2y) {
        for (int i = 0; i < this.xs.length; ++i) {
            this.xs[i] = CubicBezierEasing.bezier((double)i * 1.0 / (double)this.xs.length, c1x, c2x);
            this.ys[i] = CubicBezierEasing.bezier((double)i * 1.0 / (double)this.xs.length, c1y, c2y);
        }
    }

    public int getSize() {
        assert (this.xs.length == this.ys.length);
        return this.xs.length;
    }

    @Override
    public double calc(double x) {
        int res = Arrays.binarySearch(this.xs, x);
        if (res < 0) {
            res = -res - 1;
        }
        return this.ys[Math.min(res, this.ys.length - 1)];
    }

    private static double bezier(double t, double u1, double u2) {
        double v = 1.0 - t;
        return 3.0 * u1 * v * v * t + 3.0 * u2 * v * t * t + t * t * t;
    }
}

