/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.panel.ComponentPanel;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPanelBuilder
implements GridBagPanelBuilder {
    private final JComponent myComponent;
    private @NlsContexts.Label String myLabelText;
    private boolean myLabelOnTop;
    private @NlsContexts.DetailedDescription String myCommentText;
    private Icon myCommentIcon;
    private HyperlinkListener myHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
    private boolean myCommentBelow = true;
    private boolean myCommentAllowAutoWrapping = true;
    private @NlsContexts.Tooltip String myHTDescription;
    private @NlsContexts.LinkLabel String myHTLinkText;
    private Runnable myHTAction;
    private JComponent myTopRightComponent;
    private UI.Anchor myAnchor = UI.Anchor.Center;
    private boolean myResizeY;
    private boolean myResizeX = true;
    private boolean valid = true;

    public ComponentPanelBuilder(JComponent component) {
        this.myComponent = component;
    }

    public ComponentPanelBuilder resizeY(boolean resize) {
        this.myResizeY = resize;
        return this;
    }

    public ComponentPanelBuilder resizeX(boolean resize) {
        this.myResizeX = resize;
        return this;
    }

    public ComponentPanelBuilder withLabel(@NotNull @NlsContexts.Label String labelText) {
        if (labelText == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(0);
        }
        this.myLabelText = labelText;
        return this;
    }

    public ComponentPanelBuilder moveLabelOnTop() {
        this.myLabelOnTop = true;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder anchorLabelOn(UI.Anchor anchor) {
        this.myAnchor = anchor;
        return this;
    }

    public ComponentPanelBuilder withComment(@NotNull @NlsContexts.DetailedDescription String comment) {
        if (comment == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(1);
        }
        return this.withComment(comment, true);
    }

    public ComponentPanelBuilder withComment(@NotNull @NlsContexts.DetailedDescription String comment, boolean allowAutoWrapping) {
        if (comment == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(2);
        }
        this.myCommentText = comment;
        this.myCommentAllowAutoWrapping = allowAutoWrapping;
        this.valid = StringUtil.isEmpty((String)comment) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder withCommentIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(3);
        }
        this.myCommentIcon = icon2;
        return this;
    }

    public ComponentPanelBuilder withCommentHyperlinkListener(@NotNull HyperlinkListener listener2) {
        if (listener2 == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(4);
        }
        this.myHyperlinkListener = listener2;
        return this;
    }

    public ComponentPanelBuilder withTopRightComponent(@NotNull JComponent topRightComponent) {
        if (topRightComponent == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(5);
        }
        this.myTopRightComponent = topRightComponent;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    public ComponentPanelBuilder moveCommentRight() {
        this.myCommentBelow = false;
        return this;
    }

    public ComponentPanelBuilder withTooltip(@NotNull @NlsContexts.Tooltip String description) {
        if (description == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(6);
        }
        this.myHTDescription = description;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)description);
        return this;
    }

    public ComponentPanelBuilder withTooltipLink(@NotNull @NlsContexts.LinkLabel String linkText, @NotNull Runnable action2) {
        if (linkText == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(7);
        }
        if (action2 == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(8);
        }
        this.myHTLinkText = linkText;
        this.myHTAction = action2;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        NonOpaquePanel panel2 = new NonOpaquePanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel2, gc, false);
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(9);
        }
        return nonOpaquePanel;
    }

    @Override
    public boolean constrainsValid() {
        return this.valid;
    }

    @Override
    public int gridWidth() {
        return this.myCommentBelow ? 2 : (this.myResizeX ? 4 : 3);
    }

    @Override
    public void addToPanel(JPanel panel2, GridBagConstraints gc, boolean splitColumns) {
        if (this.constrainsValid()) {
            new ComponentPanelImpl(splitColumns).addToPanel(panel2, gc);
        }
    }

    private Border getCommentBorder() {
        if (StringUtil.isNotEmpty((String)this.myCommentText)) {
            return new JBEmptyBorder(ComponentPanelBuilder.computeCommentInsets(this.myComponent, this.myCommentBelow));
        }
        return JBUI.Borders.empty();
    }

    @NotNull
    public static Insets computeCommentInsets(@NotNull JComponent component, boolean commentBelow) {
        if (component == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(10);
        }
        boolean isMacDefault = UIUtil.isUnderDefaultMacTheme();
        boolean isWin10 = UIUtil.isUnderWin10LookAndFeel();
        if (commentBelow) {
            int top = 8;
            int left = 2;
            int bottom = 0;
            if (component instanceof JRadioButton || component instanceof JCheckBox) {
                int n = isWin10 ? 10 : (bottom = isMacDefault ? 8 : 9);
                if (component instanceof JCheckBox) {
                    left = UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)((JCheckBox)component));
                    return new Insets(0, left, JBUIScale.scale((int)bottom), 0);
                }
                left = isMacDefault ? 26 : (isWin10 ? 17 : 23);
            } else if (component instanceof JTextField || component instanceof EditorTextComponent || component instanceof JComboBox || component instanceof ComponentWithBrowseButton) {
                int n = top = isWin10 ? 3 : 4;
                int n2 = isWin10 ? 2 : (left = isMacDefault ? 5 : 4);
                bottom = isWin10 ? 10 : (isMacDefault ? 8 : 9);
            } else if (component instanceof JButton) {
                int n = top = isWin10 ? 2 : 4;
                left = isWin10 ? 2 : (isMacDefault ? 5 : 4);
                bottom = 0;
            }
            JBInsets jBInsets = JBUI.insets((int)top, (int)left, (int)bottom, (int)0);
            if (jBInsets == null) {
                ComponentPanelBuilder.$$$reportNull$$$0(11);
            }
            return jBInsets;
        }
        int left = 14;
        if (component instanceof JRadioButton || component instanceof JCheckBox) {
            left = isMacDefault ? 8 : 13;
        } else if (component instanceof JTextField || component instanceof EditorTextComponent || component instanceof JComboBox || component instanceof ComponentWithBrowseButton) {
            left = isMacDefault ? 13 : 14;
        }
        JBInsets jBInsets = JBUI.insetsLeft((int)left);
        if (jBInsets == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(12);
        }
        return jBInsets;
    }

    @NotNull
    public static JLabel createCommentComponent(@Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow) {
        return ComponentPanelBuilder.createCommentComponent(commentText, isCommentBelow, 70, true);
    }

    @NotNull
    public static JLabel createCommentComponent(@Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow, int maxLineLength) {
        return ComponentPanelBuilder.createCommentComponent(commentText, isCommentBelow, maxLineLength, true);
    }

    @NotNull
    public static JLabel createCommentComponent(@Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow, int maxLineLength, boolean allowAutoWrapping) {
        JLabel jLabel = ComponentPanelBuilder.createCommentComponent(() -> new CommentLabel(""), commentText, isCommentBelow, maxLineLength, allowAutoWrapping);
        if (jLabel == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(13);
        }
        return jLabel;
    }

    private static JLabel createCommentComponent(@NotNull Supplier<? extends JBLabel> labelSupplier, @Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow, int maxLineLength, boolean allowAutoWrapping) {
        if (labelSupplier == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(14);
        }
        boolean isCopyable = SystemProperties.getBooleanProperty((String)"idea.ui.comment.copyable", (boolean)true);
        JBLabel component = labelSupplier.get().setCopyable(isCopyable).setAllowAutoWrapping(allowAutoWrapping);
        ((JLabel)component).setVerticalTextPosition(1);
        ((Component)component).setFocusable(false);
        if (isCopyable) {
            ComponentPanelBuilder.setCommentText(component, commentText, isCommentBelow, maxLineLength);
        } else {
            ((JLabel)component).setText(commentText);
        }
        return component;
    }

    public static JLabel createNonWrappingCommentComponent(@NotNull @NlsContexts.DetailedDescription String commentText) {
        if (commentText == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(15);
        }
        return new CommentLabel(commentText);
    }

    private static void setCommentText(@NotNull JLabel component, @Nullable @NlsContexts.DetailedDescription String commentText, boolean isCommentBelow, int maxLineLength) {
        if (component == null) {
            ComponentPanelBuilder.$$$reportNull$$$0(16);
        }
        if (commentText != null) {
            @NonNls String css = "<head><style type=\"text/css\">\na, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}\na:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.VISITED) + ";}\na:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}\na:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}\n</style>\n</head>";
            HtmlChunk text2 = HtmlChunk.raw((String)commentText);
            if (maxLineLength > 0 && commentText.length() > maxLineLength && isCommentBelow) {
                int width = component.getFontMetrics(component.getFont()).stringWidth(commentText.substring(0, maxLineLength));
                text2 = text2.wrapWith(HtmlChunk.div().attr("width", width));
            } else {
                text2 = text2.wrapWith(HtmlChunk.div());
            }
            component.setText(new HtmlBuilder().append(HtmlChunk.raw((String)css)).append((HtmlChunk)text2.wrapWith("body")).wrapWith("html").toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topRightComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/panel/ComponentPanelBuilder";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelSupplier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/panel/ComponentPanelBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommentInsets";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLabel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withComment";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withCommentIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withCommentHyperlinkListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withTopRightComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withTooltip";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withTooltipLink";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeCommentInsets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCommentComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNonWrappingCommentComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setCommentText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ComponentPanelImpl
    extends ComponentPanel {
        private final JLabel label;
        private final JLabel comment;
        private final boolean splitColumns;

        private ComponentPanelImpl(boolean splitColumns) {
            this.splitColumns = splitColumns;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                this.label = new JLabel();
                LabeledComponent.TextWithMnemonic.fromTextWithMnemonic(ComponentPanelBuilder.this.myLabelText).setToLabel(this.label);
                this.label.setLabelFor(ComponentPanelBuilder.this.myComponent);
            } else {
                this.label = new JLabel("");
            }
            this.comment = ComponentPanelBuilder.createCommentComponent(() -> new CommentLabel(""){

                @Override
                @NotNull
                protected HyperlinkListener createHyperlinkListener() {
                    HyperlinkListener hyperlinkListener = ComponentPanelBuilder.this.myHyperlinkListener;
                    if (hyperlinkListener == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return hyperlinkListener;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/panel/ComponentPanelBuilder$ComponentPanelImpl$1", "createHyperlinkListener"));
                }
            }, ComponentPanelBuilder.this.myCommentText, ComponentPanelBuilder.this.myCommentBelow, 70, ComponentPanelBuilder.this.myCommentAllowAutoWrapping);
            if (ComponentPanelBuilder.this.myCommentIcon != null) {
                this.comment.setIcon(ComponentPanelBuilder.this.myCommentIcon);
            }
            this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
        }

        @Override
        public String getCommentText() {
            return ComponentPanelBuilder.this.myCommentText;
        }

        @Override
        public void setCommentText(String commentText) {
            if (!StringUtil.equals((CharSequence)ComponentPanelBuilder.this.myCommentText, (CharSequence)commentText)) {
                ComponentPanelBuilder.this.myCommentText = commentText;
                this.setCommentTextImpl(commentText);
            }
        }

        private void setCommentTextImpl(String commentText) {
            ComponentPanelBuilder.setCommentText(this.comment, commentText, ComponentPanelBuilder.this.myCommentBelow, 70);
        }

        private void addToPanel(JPanel panel2, GridBagConstraints gc) {
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.anchor = 21;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                if (ComponentPanelBuilder.this.myLabelOnTop || ComponentPanelBuilder.this.myTopRightComponent != null) {
                    gc.insets = JBUI.insetsBottom((int)4);
                    gc.gridx = 1;
                    JPanel topPanel = new JPanel();
                    topPanel.setLayout(new BoxLayout(topPanel, 0));
                    if (ComponentPanelBuilder.this.myLabelOnTop) {
                        topPanel.add(this.label);
                    }
                    if (ComponentPanelBuilder.this.myTopRightComponent != null) {
                        topPanel.add(new Box.Filler((Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)Integer.MAX_VALUE)));
                        topPanel.add(ComponentPanelBuilder.this.myTopRightComponent);
                    }
                    panel2.add((Component)topPanel, gc);
                    ++gc.gridy;
                }
                if (!ComponentPanelBuilder.this.myLabelOnTop) {
                    gc.gridx = 0;
                    switch (ComponentPanelBuilder.this.myAnchor) {
                        case Top: {
                            gc.anchor = 19;
                            gc.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
                            break;
                        }
                        case Center: {
                            gc.anchor = 21;
                            gc.insets = JBUI.insetsRight((int)8);
                            break;
                        }
                        case Bottom: {
                            gc.anchor = 20;
                            gc.insets = JBUI.insets((int)0, (int)0, (int)4, (int)8);
                        }
                    }
                    panel2.add((Component)this.label, gc);
                }
            }
            gc.gridx = gc.gridx + (ComponentPanelBuilder.this.myLabelOnTop ? 0 : 1);
            gc.weightx = 1.0;
            gc.insets = JBUI.emptyInsets();
            gc.fill = ComponentPanelBuilder.this.myResizeY ? 1 : (ComponentPanelBuilder.this.myResizeX ? 2 : 0);
            double d = gc.weighty = ComponentPanelBuilder.this.myResizeY ? 1.0 : 0.0;
            if (this.splitColumns) {
                panel2.add((Component)ComponentPanelBuilder.this.myComponent, gc);
            }
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription) || !ComponentPanelBuilder.this.myCommentBelow) {
                JPanel componentPanel = new JPanel();
                componentPanel.setLayout(new BoxLayout(componentPanel, 0));
                if (!this.splitColumns) {
                    componentPanel.add(ComponentPanelBuilder.this.myComponent);
                }
                if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription)) {
                    ContextHelpLabel lbl = StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTLinkText) && ComponentPanelBuilder.this.myHTAction != null ? ContextHelpLabel.createWithLink(null, ComponentPanelBuilder.this.myHTDescription, ComponentPanelBuilder.this.myHTLinkText, ComponentPanelBuilder.this.myHTAction) : ContextHelpLabel.create(ComponentPanelBuilder.this.myHTDescription);
                    JBUI.Borders.emptyLeft((int)7).wrap((JComponent)lbl);
                    componentPanel.add(lbl);
                    ComponentValidator.getInstance(ComponentPanelBuilder.this.myComponent).ifPresent(v -> {
                        JLabel iconLabel = new JLabel();
                        JBUI.Borders.emptyLeft((int)7).wrap((JComponent)iconLabel);
                        iconLabel.setVisible(false);
                        componentPanel.add(iconLabel);
                        iconLabel.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseEntered(MouseEvent e) {
                                ComponentPanelBuilder.this.myComponent.dispatchEvent(ComponentPanelImpl.this.convertMouseEvent(e));
                                e.consume();
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                                ComponentPanelBuilder.this.myComponent.dispatchEvent(ComponentPanelImpl.this.convertMouseEvent(e));
                                e.consume();
                            }
                        });
                        ComponentPanelBuilder.this.myComponent.addPropertyChangeListener("JComponent.outline", evt -> {
                            if (evt.getNewValue() == null) {
                                iconLabel.setVisible(false);
                                lbl.setVisible(true);
                            } else if ("warning".equals(evt.getNewValue())) {
                                iconLabel.setIcon(AllIcons.General.BalloonWarning);
                                iconLabel.setVisible(true);
                                lbl.setVisible(false);
                            } else if ("error".equals(evt.getNewValue())) {
                                iconLabel.setIcon(AllIcons.General.BalloonError);
                                iconLabel.setVisible(true);
                                lbl.setVisible(false);
                            }
                            componentPanel.revalidate();
                            componentPanel.repaint();
                        });
                    });
                    panel2.add((Component)componentPanel, gc);
                } else if (!ComponentPanelBuilder.this.myCommentBelow) {
                    if (this.splitColumns) {
                        ++gc.gridx;
                        gc.weightx = 0.0;
                        gc.fill = 0;
                        gc.weighty = 0.0;
                        panel2.add((Component)this.comment, gc);
                    } else {
                        this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
                        componentPanel.add(this.comment);
                        panel2.add((Component)componentPanel, gc);
                    }
                }
            } else if (!this.splitColumns) {
                panel2.add((Component)ComponentPanelBuilder.this.myComponent, gc);
            }
            if (!this.splitColumns && !ComponentPanelBuilder.this.myResizeX) {
                ++gc.gridx;
                gc.weightx = 1.0;
                gc.fill = 0;
                panel2.add((Component)new JPanel(), gc);
            }
            gc.fill = 2;
            gc.weighty = 0.0;
            if (ComponentPanelBuilder.this.myCommentBelow) {
                gc.gridx = 1;
                ++gc.gridy;
                gc.weightx = 0.0;
                gc.anchor = 18;
                gc.insets = JBUI.emptyInsets();
                this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
                panel2.add((Component)this.comment, gc);
                if (!ComponentPanelBuilder.this.myResizeX) {
                    ++gc.gridx;
                    gc.weightx = 1.0;
                    gc.fill = 0;
                    panel2.add((Component)new JPanel(), gc);
                }
            }
            ComponentPanelBuilder.this.myComponent.putClientProperty("JComponent.decoratedPanel", this);
            ++gc.gridy;
        }

        private MouseEvent convertMouseEvent(MouseEvent e) {
            Point p = e.getPoint();
            SwingUtilities.convertPoint(e.getComponent(), p, ComponentPanelBuilder.this.myComponent);
            return new MouseEvent(ComponentPanelBuilder.this.myComponent, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }
    }

    private static class CommentLabel
    extends JBLabel {
        private CommentLabel(@NotNull @NlsContexts.Label String text2) {
            if (text2 == null) {
                CommentLabel.$$$reportNull$$$0(0);
            }
            super(text2);
            this.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        }

        @Override
        public void setUI(LabelUI ui) {
            super.setUI(ui);
            if (SystemInfo.isMac) {
                this.setFont(new FontUIResource(RelativeFont.NORMAL.fromResource("ContextHelp.fontSizeOffset", -2).derive(this.getFont())));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/ui/panel/ComponentPanelBuilder$CommentLabel", "<init>"));
        }
    }
}

