/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.OnePixelSplitter;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ,2\u00020\u0001:\u0001,B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\u0005H\u0003J6\u0010\"\u001a\u00020\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\u0006\u0010%\u001a\u00020\u000e2\b\b\u0002\u0010&\u001a\u00020\u00102\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0$H\u0002J\b\u0010(\u001a\u00020\u001fH\u0014J\b\u0010)\u001a\u00020\u001fH\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0007H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/intellij/openapi/ui/NonProportionalOnePixelSplitter;", "Lcom/intellij/ui/OnePixelSplitter;", "vertical", "", "proportionKey", "", "defaultProportion", "", "disposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(ZLjava/lang/String;FLcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;)V", "addNotifyTimestamp", "", "maxRetryCount", "", "getMaxRetryCount", "()I", "setMaxRetryCount", "(I)V", "minSize", "getMinSize", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "getPropertiesComponent", "()Lcom/intellij/ide/util/PropertiesComponent;", "size", "getSize", "addNotify", "", "checkSize", "dump", "invokeLaterWhen", "condition", "Lkotlin/Function0;", "timestamp", "count", "action", "loadProportion", "saveProportion", "setProportion", "proportion", "Companion", "intellij.platform.ide"})
public final class NonProportionalOnePixelSplitter
extends OnePixelSplitter {
    private int maxRetryCount;
    private long addNotifyTimestamp;
    private final String proportionKey;
    private final float defaultProportion;
    private final Disposable disposable;
    private final Project project;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    private final PropertiesComponent getPropertiesComponent() {
        return this.project != null ? PropertiesComponent.getInstance(this.project) : PropertiesComponent.getInstance();
    }

    private final int getSize() {
        return this.getOrientation() ? this.getHeight() : this.getWidth();
    }

    private final int getMinSize() {
        return this.getOrientation() ? this.getMinimumSize().height : this.getMinimumSize().width;
    }

    public final int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public final void setMaxRetryCount(int n) {
        this.maxRetryCount = n;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_PROPORTION);
        NonProportionalOnePixelSplitter nonProportionalOnePixelSplitter = this;
        ++nonProportionalOnePixelSplitter.addNotifyTimestamp;
        NonProportionalOnePixelSplitter.invokeLaterWhen$default(this, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ NonProportionalOnePixelSplitter this$0;

            public final boolean invoke() {
                return NonProportionalOnePixelSplitter.access$checkSize(this.this$0);
            }
            {
                this.this$0 = nonProportionalOnePixelSplitter;
                super(0);
            }
        }, nonProportionalOnePixelSplitter.addNotifyTimestamp, 0, (Function0)new Function0<Unit>(this){
            final /* synthetic */ NonProportionalOnePixelSplitter this$0;

            public final void invoke() {
                this.this$0.loadProportion();
                this.this$0.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_FIRST_SIZE);
            }
            {
                this.this$0 = nonProportionalOnePixelSplitter;
                super(0);
            }
        }, 4, null);
    }

    private final void invokeLaterWhen(Function0<Boolean> condition, long timestamp, int count, Function0<Unit> action2) {
        if (this.addNotifyTimestamp != timestamp) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(this, condition, action2, count, timestamp){
            final /* synthetic */ NonProportionalOnePixelSplitter this$0;
            final /* synthetic */ Function0 $condition;
            final /* synthetic */ Function0 $action;
            final /* synthetic */ int $count;
            final /* synthetic */ long $timestamp;

            public final void run() {
                if (Disposer.isDisposed((Disposable)NonProportionalOnePixelSplitter.access$getDisposable$p(this.this$0))) {
                    return;
                }
                if (((Boolean)this.$condition.invoke()).booleanValue()) {
                    this.$action.invoke();
                } else if (this.$count > this.this$0.getMaxRetryCount()) {
                    NonProportionalOnePixelSplitter.access$getLogger$cp().error("Could not restore proportions in " + this.this$0.getMaxRetryCount() + " times. " + NonProportionalOnePixelSplitter.access$dump(this.this$0));
                    this.$action.invoke();
                } else {
                    NonProportionalOnePixelSplitter.access$invokeLaterWhen(this.this$0, this.$condition, this.$timestamp, this.$count + 1, this.$action);
                }
            }
            {
                this.this$0 = nonProportionalOnePixelSplitter;
                this.$condition = function0;
                this.$action = function02;
                this.$count = n;
                this.$timestamp = l;
            }
        });
    }

    static /* synthetic */ void invokeLaterWhen$default(NonProportionalOnePixelSplitter nonProportionalOnePixelSplitter, Function0 function0, long l, int n, Function0 function02, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        nonProportionalOnePixelSplitter.invokeLaterWhen((Function0<Boolean>)function0, l, n, (Function0<Unit>)function02);
    }

    @NonNls
    private final String dump() {
        return "" + this.getSize() + '=' + this.getSize() + ", minSize=" + this.getMinSize();
    }

    private final boolean checkSize() {
        return this.getSize() != 0 && this.getMinSize() < this.getSize();
    }

    @Override
    public void setProportion(float proportion) {
        if (proportion < 0.0f || proportion > 1.0f) {
            return;
        }
        super.setProportion(proportion);
    }

    @Override
    protected void loadProportion() {
        if (!StringUtil.isEmpty((String)this.proportionKey)) {
            this.setProportion(this.getPropertiesComponent().getFloat(this.proportionKey, this.myProportion));
        }
    }

    @Override
    public void saveProportion() {
        if (!StringUtil.isEmpty((String)this.proportionKey)) {
            this.getPropertiesComponent().setValue(this.proportionKey, this.myProportion, this.defaultProportion);
        }
    }

    public NonProportionalOnePixelSplitter(boolean vertical, @NonNls @NotNull String proportionKey, float defaultProportion, @NotNull Disposable disposable, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)proportionKey, (String)"proportionKey");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(vertical, proportionKey, defaultProportion);
        this.proportionKey = proportionKey;
        this.defaultProportion = defaultProportion;
        this.disposable = disposable;
        this.project = project;
        this.maxRetryCount = 100;
        Disposer.register((Disposable)this.disposable, (Disposable)new Disposable(){

            public final void dispose() {
                this.saveProportion();
            }
        });
        this.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_FIRST_SIZE);
    }

    public /* synthetic */ NonProportionalOnePixelSplitter(boolean bl, String string, float f, Disposable disposable, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 0.5f;
        }
        this(bl, string, f, disposable, project);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NonProportionalOnePixelSplitter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        NonProportionalOnePixelSplitter.logger = logger;
    }

    public static final /* synthetic */ boolean access$checkSize(NonProportionalOnePixelSplitter $this) {
        return $this.checkSize();
    }

    public static final /* synthetic */ Disposable access$getDisposable$p(NonProportionalOnePixelSplitter $this) {
        return $this.disposable;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$dump(NonProportionalOnePixelSplitter $this) {
        return $this.dump();
    }

    public static final /* synthetic */ void access$invokeLaterWhen(NonProportionalOnePixelSplitter $this, Function0 condition, long timestamp, int count, Function0 action2) {
        $this.invokeLaterWhen((Function0<Boolean>)condition, timestamp, count, (Function0<Unit>)action2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/ui/NonProportionalOnePixelSplitter$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

