/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeymapManager {
    public static final String DEFAULT_IDEA_KEYMAP = "$default";
    public static final String MAC_OS_X_KEYMAP = "Mac OS X";
    public static final String MAC_OS_X_10_5_PLUS_KEYMAP = "Mac OS X 10.5+";
    public static final String X_WINDOW_KEYMAP = "Default for XWin";
    public static final String KDE_KEYMAP = "Default for KDE";
    public static final String GNOME_KEYMAP = "Default for GNOME";
    private static volatile KeymapManager INSTANCE;

    @NotNull
    public abstract Keymap getActiveKeymap();

    @Nullable
    public abstract Keymap getKeymap(@NotNull String var1);

    public static KeymapManager getInstance() {
        Application app = ApplicationManager.getApplication();
        if (app == null || !LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred()) {
            return null;
        }
        KeymapManager instance = INSTANCE;
        if (instance == null) {
            INSTANCE = instance = (KeymapManager)app.getService(KeymapManager.class);
        }
        return instance;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void addKeymapManagerListener(@NotNull KeymapManagerListener var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void addKeymapManagerListener(@NotNull KeymapManagerListener var1, @NotNull Disposable var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void removeKeymapManagerListener(@NotNull KeymapManagerListener var1);

    public abstract void bindShortcuts(@NotNull String var1, @NotNull String var2);

    public abstract void unbindShortcuts(String var1);
}

