/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.experimental.toolbar;

import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.ide.ui.experimental.toolbar.ExperimentalToolbarStateEnum;
import com.intellij.ide.ui.experimental.toolbar.ExperimentalToolbarStateWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@State(name="ToolbarSettingsService", storages={@Storage(value="other.xml")})
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 &2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002&'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rJ\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010$\u001a\u00020\rH\u0016J\b\u0010%\u001a\u00020 H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings;", "Lcom/intellij/ide/ui/ToolbarSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarStateWrapper;", "()V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "newToolbarEnabled", "", "getNewToolbarEnabled", "()Z", "value", "showNewToolbar", "getShowNewToolbar", "setShowNewToolbar", "(Z)V", "toolbarState", "getShowToolbarInNavigationBar", "getState", "getToolbarStateByVisibilityFlags", "Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarStateEnum;", "oldToolbarVisible", "newToolbarVisible", "navBarVisible", "isNavBarVisible", "isToolbarVisible", "loadState", "", "state", "setNavBarVisible", "setToolbarVisible", "showSettingsEntryPointInStatusBar", "updateSettingsState", "Companion", "ToolbarRegistryListener", "intellij.platform.editor"})
public final class ExperimentalToolbarSettings
implements ToolbarSettings,
PersistentStateComponent<ExperimentalToolbarStateWrapper> {
    @NotNull
    private final Logger logger;
    private ExperimentalToolbarStateWrapper toolbarState;
    private final Disposable disposable;
    @JvmField
    @NotNull
    public static String newToolbarRegistryKey;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final boolean getNewToolbarEnabled() {
        return Registry.is((String)newToolbarRegistryKey, (boolean)false);
    }

    @Override
    @NotNull
    public ExperimentalToolbarStateWrapper getState() {
        return this.toolbarState;
    }

    @Override
    public void loadState(@NotNull ExperimentalToolbarStateWrapper state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.getNewToolbarEnabled()) {
            UISettingsState oldState = UISettings.Companion.getInstance().getState();
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(false, oldState.getShowMainToolbar(), false, oldState.getShowNavigationBar()));
            this.logger.info("Loading old state, main toolbar: " + oldState.getShowMainToolbar() + " navBar " + oldState.getShowNavigationBar());
        } else {
            this.toolbarState = state;
            this.updateSettingsState();
        }
    }

    @NotNull
    public final ExperimentalToolbarStateEnum getToolbarStateByVisibilityFlags(boolean newToolbarEnabled, boolean oldToolbarVisible, boolean newToolbarVisible, boolean navBarVisible) {
        if (oldToolbarVisible && newToolbarVisible) {
            this.logger.error("Illegal double toolbar visible state");
            throw (Throwable)new IllegalStateException();
        }
        if (newToolbarEnabled && newToolbarVisible) {
            if (navBarVisible) {
                return ExperimentalToolbarStateEnum.NEW_TOOLBAR_WITH_NAVBAR;
            }
            return ExperimentalToolbarStateEnum.NEW_TOOLBAR_WITHOUT_NAVBAR;
        }
        if (oldToolbarVisible) {
            if (navBarVisible) {
                return ExperimentalToolbarStateEnum.OLD_TOOLBAR_WITH_NAVBAR_SEPARATE;
            }
            return ExperimentalToolbarStateEnum.OLD_TOOLBAR_WITHOUT_NAVBAR;
        }
        if (navBarVisible) {
            return ExperimentalToolbarStateEnum.OLD_NAVBAR;
        }
        return ExperimentalToolbarStateEnum.NO_TOOLBAR_NO_NAVBAR;
    }

    @Override
    public boolean isNavBarVisible() {
        return this.toolbarState.getState().getNavBarVisible();
    }

    @Override
    public void setNavBarVisible(boolean value2) {
        this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), this.toolbarState.getState().getOldToolbarVisible(), this.toolbarState.getState().getNewToolbarVisible(), value2));
        this.updateSettingsState();
        UISettings.Companion.getInstance().fireUISettingsChanged();
    }

    private final void updateSettingsState() {
        UISettings.Companion.getInstance().getState().setShowNavigationBar(this.toolbarState.getState().getNavBarVisible());
        UISettings.Companion.getInstance().getState().setShowMainToolbar(this.toolbarState.getState().getOldToolbarVisible());
        this.logger.info("showNavigationBar: " + UISettings.Companion.getInstance().getState().getShowNavigationBar() + " showMainToolbar: " + UISettings.Companion.getInstance().getState().getShowMainToolbar());
    }

    @Override
    public boolean isToolbarVisible() {
        return this.toolbarState.getState().getOldToolbarVisible();
    }

    @Override
    public boolean showSettingsEntryPointInStatusBar() {
        return !this.isToolbarVisible() && !this.getShowToolbarInNavigationBar() && !this.toolbarState.getState().getNewToolbarVisible();
    }

    @Override
    public void setToolbarVisible(boolean value2) {
        if (value2) {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), value2, false, this.toolbarState.getState().getNavBarVisible()));
        } else {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), value2, this.toolbarState.getState().getNewToolbarVisible(), this.toolbarState.getState().getNavBarVisible()));
        }
        this.updateSettingsState();
        UISettings.Companion.getInstance().fireUISettingsChanged();
    }

    @Override
    public boolean getShowToolbarInNavigationBar() {
        return this.toolbarState.getState() == ExperimentalToolbarStateEnum.OLD_NAVBAR;
    }

    public final boolean getShowNewToolbar() {
        return this.toolbarState.getState().getNewToolbarVisible();
    }

    public final void setShowNewToolbar(boolean value2) {
        if (value2) {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), false, value2, this.toolbarState.getState().getNavBarVisible()));
        } else {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), this.toolbarState.getState().getOldToolbarVisible(), value2, this.toolbarState.getState().getNavBarVisible()));
        }
        this.updateSettingsState();
        UISettings.Companion.getInstance().fireUISettingsChanged();
    }

    private ExperimentalToolbarSettings() {
        Logger logger = Logger.getInstance(ExperimentalToolbarSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Exper\u2026lbarSettings::class.java)");
        this.logger = logger;
        this.toolbarState = new ExperimentalToolbarStateWrapper();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
        this.disposable = disposable;
        if (!this.getNewToolbarEnabled()) {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(false, UISettings.Companion.getInstance().getState().getShowMainToolbar(), false, UISettings.Companion.getInstance().getState().getShowNavigationBar()));
        }
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)this.disposable);
        Registry.get((String)newToolbarRegistryKey).addListener((RegistryValueListener)new ToolbarRegistryListener(), this.disposable);
    }

    static {
        Companion = new Companion(null);
        newToolbarRegistryKey = "ide.new.navbar";
    }

    public static final /* synthetic */ void access$setToolbarState$p(ExperimentalToolbarSettings $this, ExperimentalToolbarStateWrapper experimentalToolbarStateWrapper) {
        $this.toolbarState = experimentalToolbarStateWrapper;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings$ToolbarRegistryListener;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "(Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings;)V", "afterValueChanged", "", "value", "Lcom/intellij/openapi/util/registry/RegistryValue;", "intellij.platform.editor"})
    public final class ToolbarRegistryListener
    implements RegistryValueListener {
        public void afterValueChanged(@NotNull RegistryValue value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            boolean v = value2.asBoolean();
            ExperimentalToolbarSettings.this.toolbarState.setState(ExperimentalToolbarSettings.this.getToolbarStateByVisibilityFlags(v, v ? false : ExperimentalToolbarSettings.this.isToolbarVisible(), v, v ? false : ExperimentalToolbarSettings.this.isNavBarVisible()));
            ExperimentalToolbarSettings.this.getLogger().info("Registry value new.navbar was changed to " + v + ", toolbar state is " + (Object)((Object)ExperimentalToolbarSettings.this.toolbarState.getState()));
            ExperimentalToolbarSettings.this.updateSettingsState();
            UISettings.Companion.getInstance().fireUISettingsChanged();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings$Companion;", "", "()V", "newToolbarRegistryKey", "", "intellij.platform.editor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

