/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationWithSeparator;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PresentationData
implements ColoredItemPresentation,
ComparableObject,
LocationPresentation {
    protected final List<PresentableNodeDescriptor.ColoredFragment> myColoredText = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private Color myBackground;
    private Icon myIcon;
    @NlsSafe
    private String myLocationString;
    @NlsSafe
    private String myPresentableText;
    private @NlsContexts.Tooltip String myTooltip;
    private TextAttributesKey myAttributesKey;
    private Color myForcedTextForeground;
    private Font myFont;
    private boolean mySeparatorAbove = false;
    private boolean myChanged;
    @NlsSafe
    private String myLocationPrefix;
    @NlsSafe
    private String myLocationSuffix;

    public PresentationData(@NlsSafe String presentableText, @NlsSafe String locationString, Icon icon2, @Nullable TextAttributesKey attributesKey) {
        this.myIcon = icon2;
        this.myLocationString = locationString;
        this.myPresentableText = presentableText;
        this.myAttributesKey = attributesKey;
    }

    public PresentationData() {
    }

    @Nullable
    public final Color getBackground() {
        return this.myBackground;
    }

    public final void setBackground(@Nullable Color background) {
        this.myBackground = background;
    }

    @Override
    public Icon getIcon(boolean open) {
        return this.myIcon;
    }

    @Nullable
    public Color getForcedTextForeground() {
        return this.myForcedTextForeground;
    }

    public void setForcedTextForeground(@Nullable Color forcedTextForeground) {
        this.myForcedTextForeground = forcedTextForeground;
    }

    @Override
    public String getLocationString() {
        return this.myLocationString;
    }

    @Override
    public String getPresentableText() {
        return this.myPresentableText;
    }

    public void setIcon(Icon icon2) {
        this.myIcon = icon2;
    }

    public void setLocationString(@NlsSafe String locationString) {
        this.myLocationString = locationString;
    }

    public void setPresentableText(@NlsSafe String presentableText) {
        this.myPresentableText = presentableText;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void setClosedIcon(Icon closedIcon) {
        this.setIcon(closedIcon);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void setOpenIcon(Icon openIcon) {
    }

    public void updateFrom(ItemPresentation presentation) {
        if (presentation instanceof PresentationData) {
            this.setBackground(((PresentationData)presentation).getBackground());
        }
        this.setIcon(presentation.getIcon(false));
        this.setPresentableText(presentation.getPresentableText());
        this.setLocationString(presentation.getLocationString());
        if (presentation instanceof ColoredItemPresentation) {
            this.setAttributesKey(((ColoredItemPresentation)presentation).getTextAttributesKey());
        }
        this.setSeparatorAbove(presentation instanceof ItemPresentationWithSeparator);
        if (presentation instanceof LocationPresentation) {
            this.myLocationPrefix = ((LocationPresentation)((Object)presentation)).getLocationPrefix();
            this.myLocationSuffix = ((LocationPresentation)((Object)presentation)).getLocationSuffix();
        }
    }

    public boolean hasSeparatorAbove() {
        return this.mySeparatorAbove;
    }

    public void setSeparatorAbove(boolean b) {
        this.mySeparatorAbove = b;
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return this.myAttributesKey;
    }

    public void setAttributesKey(TextAttributesKey attributesKey) {
        this.myAttributesKey = attributesKey;
    }

    @NlsContexts.Tooltip
    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(@Nullable @NlsContexts.Tooltip String tooltip) {
        this.myTooltip = tooltip;
    }

    public boolean isChanged() {
        return this.myChanged;
    }

    public void setChanged(boolean changed) {
        this.myChanged = changed;
    }

    @NotNull
    public List<PresentableNodeDescriptor.ColoredFragment> getColoredText() {
        List<PresentableNodeDescriptor.ColoredFragment> list = this.myColoredText;
        if (list == null) {
            PresentationData.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void addText(PresentableNodeDescriptor.ColoredFragment coloredFragment) {
        this.myColoredText.add(coloredFragment);
    }

    public void addText(@NlsContexts.Label String text2, SimpleTextAttributes attributes) {
        this.myColoredText.add(new PresentableNodeDescriptor.ColoredFragment(text2, attributes));
    }

    public void clearText() {
        this.myColoredText.clear();
    }

    public void clear() {
        this.myBackground = null;
        this.myIcon = null;
        this.clearText();
        this.myAttributesKey = null;
        this.myFont = null;
        this.myForcedTextForeground = null;
        this.myLocationString = null;
        this.myPresentableText = null;
        this.myTooltip = null;
        this.myChanged = false;
        this.mySeparatorAbove = false;
        this.myLocationSuffix = null;
        this.myLocationPrefix = null;
    }

    public Object @NotNull [] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myBackground, this.myIcon, this.myColoredText, this.myAttributesKey, this.myFont, this.myForcedTextForeground, this.myPresentableText, this.myLocationString, this.mySeparatorAbove, this.myLocationPrefix, this.myLocationSuffix};
        if (objectArray == null) {
            PresentationData.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    public boolean equals(Object obj) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)obj);
    }

    public void copyFrom(PresentationData from) {
        if (from == this) {
            return;
        }
        this.myBackground = from.myBackground;
        this.myAttributesKey = from.myAttributesKey;
        this.myIcon = from.myIcon;
        this.clearText();
        this.myColoredText.addAll(from.myColoredText);
        this.myFont = from.myFont;
        this.myForcedTextForeground = from.myForcedTextForeground;
        this.myLocationString = from.myLocationString;
        this.myPresentableText = from.myPresentableText;
        this.myTooltip = from.myTooltip;
        this.mySeparatorAbove = from.mySeparatorAbove;
        this.myLocationPrefix = from.myLocationPrefix;
        this.myLocationSuffix = from.myLocationSuffix;
    }

    public PresentationData clone() {
        PresentationData clone = new PresentationData();
        clone.copyFrom(this);
        return clone;
    }

    public void applyFrom(PresentationData from) {
        this.myBackground = PresentationData.getValue(this.myBackground, from.myBackground);
        this.myAttributesKey = PresentationData.getValue(this.myAttributesKey, from.myAttributesKey);
        this.myIcon = PresentationData.getValue(this.myIcon, from.myIcon);
        if (this.myColoredText.isEmpty()) {
            this.myColoredText.addAll(from.myColoredText);
        }
        this.myFont = PresentationData.getValue(this.myFont, from.myFont);
        this.myForcedTextForeground = PresentationData.getValue(this.myForcedTextForeground, from.myForcedTextForeground);
        this.myLocationString = PresentationData.getValue(this.myLocationString, from.myLocationString);
        this.myPresentableText = PresentationData.getValue(this.myPresentableText, from.myPresentableText);
        this.myTooltip = PresentationData.getValue(this.myTooltip, from.myTooltip);
        this.mySeparatorAbove = this.mySeparatorAbove || from.mySeparatorAbove;
        this.myLocationPrefix = PresentationData.getValue(this.myLocationPrefix, from.myLocationPrefix);
        this.myLocationSuffix = PresentationData.getValue(this.myLocationSuffix, from.myLocationSuffix);
    }

    private static <T> T getValue(T ownValue, T fromValue) {
        return ownValue != null ? ownValue : fromValue;
    }

    @Override
    public String getLocationPrefix() {
        return this.myLocationPrefix == null ? FontUtil.spaceAndThinSpace() : this.myLocationPrefix;
    }

    @Override
    public String getLocationSuffix() {
        return StringUtil.notNullize((String)this.myLocationSuffix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/projectView/PresentationData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getColoredText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

