/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.TooltipTitle;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelpTooltip {
    private static final Color INFO_COLOR = JBColor.namedColor((String)"ToolTip.infoForeground", (Color)UIUtil.getContextHelpForeground());
    private static final JBValue MAX_WIDTH = new JBValue.UIInteger("HelpTooltip.maxWidth", 250);
    private static final JBValue X_OFFSET = new JBValue.UIInteger("HelpTooltip.xOffset", 0);
    private static final JBValue Y_OFFSET = new JBValue.UIInteger("HelpTooltip.yOffset", 0);
    private static final JBValue HEADER_FONT_SIZE_DELTA = new JBValue.UIInteger("HelpTooltip.fontSizeDelta", 0);
    private static final JBValue DESCRIPTION_FONT_SIZE_DELTA = new JBValue.UIInteger("HelpTooltip.descriptionSizeDelta", 0);
    private static final JBValue CURSOR_OFFSET = new JBValue.UIInteger("HelpTooltip.mouseCursorOffset", 20);
    private static final String PARAGRAPH_SPLITTER = "<p/?>";
    private static final String TOOLTIP_PROPERTY = "JComponent.helpTooltip";
    private @TooltipTitle String title;
    @NlsSafe
    private String shortcut;
    private @NlsContexts.Tooltip String description;
    private ActionLink link;
    private boolean neverHide;
    @NotNull
    private Alignment alignment = Alignment.CURSOR;
    private BooleanSupplier masterPopupOpenCondition;
    protected ComponentPopupBuilder myPopupBuilder;
    private Dimension myPopupSize;
    private JBPopup myPopup;
    private final Alarm popupAlarm = new Alarm();
    private boolean isOverPopup;
    private boolean isMultiline;
    private int myInitialDelay = -1;
    private int myHideDelay = -1;
    private String myToolTipText;
    private boolean initialShowScheduled;
    protected MouseAdapter myMouseListener;

    public HelpTooltip setTitle(@Nullable @TooltipTitle String title) {
        this.title = title;
        return this;
    }

    public HelpTooltip setShortcut(@Nullable @NlsSafe String shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public HelpTooltip setShortcut(@Nullable Shortcut shortcut) {
        this.shortcut = shortcut == null ? null : KeymapUtil.getShortcutText(shortcut);
        return this;
    }

    public HelpTooltip setInitialDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Negative delay is not allowed");
        }
        this.myInitialDelay = delay;
        return this;
    }

    public HelpTooltip setHideDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Negative delay is not allowed");
        }
        this.myHideDelay = delay;
        return this;
    }

    public HelpTooltip setDescription(@Nullable @NlsContexts.Tooltip String description) {
        this.description = description;
        return this;
    }

    public HelpTooltip setLink(@NlsContexts.LinkLabel String linkText, Runnable linkAction) {
        this.link = new ActionLink(linkText, e -> {
            this.hidePopup(true);
            linkAction.run();
        });
        return this;
    }

    public HelpTooltip setBrowserLink(@NlsContexts.LinkLabel String linkLabel, URL url) {
        this.link = new BrowserLink(linkLabel, url.toExternalForm());
        this.link.setHorizontalTextPosition(2);
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        HelpTooltip tooltip = (HelpTooltip)that;
        return this.neverHide == tooltip.neverHide && Objects.equals(this.title, tooltip.title) && Objects.equals(this.shortcut, tooltip.shortcut) && Objects.equals(this.description, tooltip.description) && Objects.equals(this.link, tooltip.link) && this.alignment == tooltip.alignment && Objects.equals(this.masterPopupOpenCondition, tooltip.masterPopupOpenCondition);
    }

    public HelpTooltip setNeverHideOnTimeout(boolean neverHide) {
        this.neverHide = neverHide;
        return this;
    }

    public HelpTooltip setLocation(@NotNull Alignment alignment) {
        if (alignment == null) {
            HelpTooltip.$$$reportNull$$$0(0);
        }
        this.alignment = alignment;
        return this;
    }

    public void installOn(@NotNull JComponent component) {
        HelpTooltip installed;
        if (component == null) {
            HelpTooltip.$$$reportNull$$$0(1);
        }
        if ((installed = (HelpTooltip)component.getClientProperty(TOOLTIP_PROPERTY)) == null) {
            this.installImpl(component);
        } else if (!this.equals(installed)) {
            installed.hideAndDispose(component);
            this.installImpl(component);
        }
    }

    private void installImpl(@NotNull JComponent component) {
        if (component == null) {
            HelpTooltip.$$$reportNull$$$0(2);
        }
        this.neverHide = this.neverHide || UIUtil.isHelpButton((Component)component);
        this.createMouseListeners();
        this.initPopupBuilder();
        component.putClientProperty(TOOLTIP_PROPERTY, this);
        this.installMouseListeners(component);
    }

    protected final void createMouseListeners() {
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (HelpTooltip.this.myPopup != null && !HelpTooltip.this.myPopup.isDisposed()) {
                    HelpTooltip.this.myPopup.cancel();
                }
                HelpTooltip.this.initialShowScheduled = true;
                int delay = HelpTooltip.this.myInitialDelay;
                if (delay == -1) {
                    delay = Registry.intValue((String)"ide.tooltip.initialReshowDelay", (int)500);
                }
                HelpTooltip.this.scheduleShow(e, delay);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                int delay = HelpTooltip.this.myHideDelay;
                if (delay == -1) {
                    delay = Registry.intValue((String)"ide.tooltip.initialDelay.highlighter", (int)150);
                }
                HelpTooltip.this.scheduleHide(HelpTooltip.this.link == null, delay);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!HelpTooltip.this.initialShowScheduled) {
                    HelpTooltip.this.scheduleShow(e, Registry.intValue((String)"ide.tooltip.reshowDelay"));
                }
            }
        };
    }

    private void initPopupBuilder() {
        JPanel tipPanel = this.createTipPanel();
        tipPanel.addMouseListener(this.createIsOverTipMouseListener());
        this.myPopupSize = tipPanel.getPreferredSize();
        this.myPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(tipPanel, null).setShowBorder(UIManager.getBoolean("ToolTip.paintBorder")).setBorderColor(JBUI.CurrentTheme.Tooltip.borderColor()).setShowShadow(true);
    }

    protected void initPopupBuilder(@NotNull HelpTooltip instance) {
        if (instance == null) {
            HelpTooltip.$$$reportNull$$$0(3);
        }
        instance.initPopupBuilder();
        this.myPopupSize = instance.myPopupSize;
        this.myPopupBuilder = instance.myPopupBuilder;
        this.initialShowScheduled = false;
    }

    @NotNull
    private MouseListener createIsOverTipMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HelpTooltip.this.isOverPopup = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (HelpTooltip.this.link == null || !HelpTooltip.this.link.getBounds().contains(e.getPoint())) {
                    HelpTooltip.this.isOverPopup = false;
                    HelpTooltip.this.hidePopup(false);
                }
            }
        };
    }

    @NotNull
    protected final JPanel createTipPanel() {
        JPanel tipPanel = new JPanel();
        tipPanel.setLayout(new VerticalLayout(JBUI.getInt((String)"HelpTooltip.verticalGap", (int)4)));
        tipPanel.setBackground(UIUtil.getToolTipBackground());
        boolean hasTitle = StringUtil.isNotEmpty((String)this.title);
        boolean hasDescription = StringUtil.isNotEmpty((String)this.description);
        if (hasTitle) {
            tipPanel.add((Component)new Header(hasDescription), "TOP");
        }
        if (hasDescription) {
            @Nls String[] pa = this.description.split(PARAGRAPH_SPLITTER);
            this.isMultiline = pa.length > 1;
            Arrays.stream(pa).filter(p -> !p.isEmpty()).forEach(p -> tipPanel.add((Component)new Paragraph((String)p, hasTitle), "TOP"));
        }
        if (!hasTitle && StringUtil.isNotEmpty((String)this.shortcut)) {
            JLabel shortcutLabel = new JLabel(this.shortcut);
            shortcutLabel.setFont(HelpTooltip.deriveDescriptionFont(shortcutLabel.getFont(), false));
            shortcutLabel.setForeground(JBUI.CurrentTheme.Tooltip.shortcutForeground());
            tipPanel.add((Component)shortcutLabel, "TOP");
        }
        if (this.link != null) {
            this.link.setFont(HelpTooltip.deriveDescriptionFont(this.link.getFont(), hasTitle));
            tipPanel.add((Component)this.link, "TOP");
        }
        this.isMultiline = this.isMultiline || StringUtil.isNotEmpty((String)this.description) && (StringUtil.isNotEmpty((String)this.title) || this.link != null);
        tipPanel.setBorder(HelpTooltip.textBorder(this.isMultiline));
        JPanel jPanel = tipPanel;
        if (jPanel == null) {
            HelpTooltip.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private void installMouseListeners(@NotNull JComponent owner) {
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(5);
        }
        owner.addMouseListener(this.myMouseListener);
        owner.addMouseMotionListener(this.myMouseListener);
    }

    private void uninstallMouseListeners(@NotNull JComponent owner) {
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(6);
        }
        owner.removeMouseListener(this.myMouseListener);
        owner.removeMouseMotionListener(this.myMouseListener);
    }

    public static void dispose(@NotNull Component owner) {
        JComponent component;
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(7);
        }
        if (owner instanceof JComponent && (instance = (HelpTooltip)(component = (JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance.hideAndDispose(component);
        }
    }

    private void hideAndDispose(@NotNull JComponent owner) {
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(8);
        }
        this.hidePopup(true);
        this.uninstallMouseListeners(owner);
        this.masterPopupOpenCondition = null;
        owner.putClientProperty(TOOLTIP_PROPERTY, null);
    }

    public static void hide(@NotNull Component owner) {
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(9);
        }
        if (owner instanceof JComponent && (instance = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance.hidePopup(true);
        }
    }

    public static void setMasterPopup(@NotNull Component owner, JBPopup master) {
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(10);
        }
        if (owner instanceof JComponent && (instance = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null && instance.myPopup != master) {
            instance.masterPopupOpenCondition = () -> master == null || !master.isVisible();
        }
    }

    public static void setMasterPopupOpenCondition(@NotNull Component owner, @Nullable BooleanSupplier condition) {
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(11);
        }
        if (owner instanceof JComponent && (instance = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance.masterPopupOpenCondition = condition;
        }
    }

    private void scheduleShow(MouseEvent e, int delay) {
        this.popupAlarm.cancelAllRequests();
        if (ScreenReader.isActive()) {
            return;
        }
        this.popupAlarm.addRequest(() -> {
            this.initialShowScheduled = false;
            if (this.masterPopupOpenCondition == null || this.masterPopupOpenCondition.getAsBoolean()) {
                String text2;
                Component owner = e.getComponent();
                String string = text2 = owner instanceof JComponent ? ((JComponent)owner).getToolTipText(e) : null;
                if (this.myPopup != null && !this.myPopup.isDisposed()) {
                    if (StringUtil.isEmpty((String)text2) && StringUtil.isEmpty((String)this.myToolTipText)) {
                        return;
                    }
                    if (StringUtil.equals((CharSequence)text2, (CharSequence)this.myToolTipText)) {
                        return;
                    }
                    this.myPopup.cancel();
                }
                this.myToolTipText = text2;
                this.myPopup = this.myPopupBuilder.createPopup();
                this.myPopup.show(new RelativePoint(owner, this.alignment.getPointFor(owner, this.myPopupSize, e.getPoint())));
                if (!this.neverHide) {
                    int dismissDelay = Registry.intValue((String)(this.isMultiline ? "ide.helptooltip.full.dismissDelay" : "ide.helptooltip.regular.dismissDelay"));
                    this.scheduleHide(true, dismissDelay);
                }
            }
        }, delay);
    }

    private void scheduleHide(boolean force, int delay) {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> this.hidePopup(force), delay);
    }

    protected void hidePopup(boolean force) {
        this.initialShowScheduled = false;
        this.popupAlarm.cancelAllRequests();
        if (this.myPopup != null && this.myPopup.isVisible() && (!this.isOverPopup || force)) {
            this.myPopup.cancel();
            this.myPopup = null;
            this.myToolTipText = null;
        }
    }

    private static Border textBorder(boolean multiline) {
        Insets i = UIManager.getInsets(multiline ? "HelpTooltip.defaultTextBorderInsets" : "HelpTooltip.smallTextBorderInsets");
        return i != null ? new JBEmptyBorder(i) : JBUI.Borders.empty();
    }

    private static Font deriveHeaderFont(Font font) {
        return font.deriveFont((float)font.getSize() + (float)HEADER_FONT_SIZE_DELTA.get());
    }

    private static Font deriveDescriptionFont(Font font, boolean hasTitle) {
        return hasTitle ? font.deriveFont((float)font.getSize() + (float)DESCRIPTION_FONT_SIZE_DELTA.get()) : HelpTooltip.deriveHeaderFont(font);
    }

    @Contract(pure=true)
    @NotNull
    public static String getShortcutAsHtml(@Nullable String shortcut) {
        String string = StringUtil.isEmpty((String)shortcut) ? "" : String.format("&nbsp;&nbsp;<font color=\"%s\">%s</font>", ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Tooltip.shortcutForeground()), shortcut);
        if (string == null) {
            HelpTooltip.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/HelpTooltip";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/HelpTooltip";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTipPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutAsHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installOn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initPopupBuilder";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installMouseListeners";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "uninstallMouseListeners";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hideAndDispose";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hide";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setMasterPopup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMasterPopupOpenCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Paragraph
    extends BoundWidthLabel {
        private Paragraph(String text2, boolean hasTitle) {
            this.setForeground(hasTitle ? INFO_COLOR : UIUtil.getToolTipForeground());
            this.setFont(HelpTooltip.deriveDescriptionFont(this.getFont(), hasTitle));
            View v = BasicHTML.createHTMLView(this, HtmlChunk.raw((String)text2).wrapWith(HtmlChunk.html()).toString());
            float width = v.getPreferredSpan(0);
            HelpTooltip.this.isMultiline = HelpTooltip.this.isMultiline || width > (float)MAX_WIDTH.get();
            HtmlChunk.Element div = width > (float)MAX_WIDTH.get() ? HtmlChunk.div().attr("width", MAX_WIDTH.get()) : HtmlChunk.div();
            this.setText(div.addRaw(text2).wrapWith(HtmlChunk.html()).toString());
            this.setSizeForWidth(width);
        }
    }

    private final class Header
    extends BoundWidthLabel {
        private Header(boolean obeyWidth) {
            this.setFont(HelpTooltip.deriveHeaderFont(this.getFont()));
            this.setForeground(UIUtil.getToolTipForeground());
            if (obeyWidth || HelpTooltip.this.title.length() > MAX_WIDTH.get()) {
                View v = BasicHTML.createHTMLView(this, String.format("<html>%s%s</html>", HelpTooltip.this.title, this.getShortcutAsHTML()));
                float width = v.getPreferredSpan(0);
                HelpTooltip.this.isMultiline = HelpTooltip.this.isMultiline || width > (float)MAX_WIDTH.get();
                HtmlChunk.Element div = width > (float)MAX_WIDTH.get() ? HtmlChunk.div().attr("width", MAX_WIDTH.get()) : HtmlChunk.div();
                this.setText(div.children(new HtmlChunk[]{HtmlChunk.raw((String)HelpTooltip.this.title), HtmlChunk.raw((String)this.getShortcutAsHTML())}).wrapWith(HtmlChunk.html()).toString());
                this.setSizeForWidth(width);
            } else {
                this.setText(BasicHTML.isHTMLString(HelpTooltip.this.title) ? HelpTooltip.this.title : HtmlChunk.div().addRaw(HelpTooltip.this.title).addRaw(this.getShortcutAsHTML()).wrapWith(HtmlChunk.html()).toString());
            }
        }

        @NlsSafe
        private String getShortcutAsHTML() {
            return HelpTooltip.getShortcutAsHtml(HelpTooltip.this.shortcut);
        }
    }

    private static class BoundWidthLabel
    extends JLabel {
        private BoundWidthLabel() {
        }

        private static Collection<View> getRows(@NotNull View root) {
            if (root == null) {
                BoundWidthLabel.$$$reportNull$$$0(0);
            }
            ArrayList<View> rows = new ArrayList<View>();
            BoundWidthLabel.visit(root, rows);
            return rows;
        }

        private static void visit(@NotNull View v, Collection<? super View> result) {
            String cname;
            if (v == null) {
                BoundWidthLabel.$$$reportNull$$$0(1);
            }
            if ((cname = v.getClass().getCanonicalName()) != null && cname.contains("ParagraphView.Row")) {
                result.add(v);
            }
            for (int i = 0; i < v.getViewCount(); ++i) {
                BoundWidthLabel.visit(v.getView(i), result);
            }
        }

        void setSizeForWidth(float width) {
            View v;
            if (width > (float)MAX_WIDTH.get() && (v = (View)this.getClientProperty("html")) != null) {
                width = 0.0f;
                for (View row : BoundWidthLabel.getRows(v)) {
                    float rWidth = row.getPreferredSpan(0);
                    if (!(width < rWidth)) continue;
                    width = rWidth;
                }
                v.setSize(width, v.getPreferredSpan(1));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/HelpTooltip$BoundWidthLabel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRows";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Alignment {
        RIGHT{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                Dimension size = owner.getSize();
                return new Point(size.width + JBUIScale.scale((int)5) - X_OFFSET.get(), JBUIScale.scale((int)1) + Y_OFFSET.get());
            }
        }
        ,
        LEFT{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                return new Point(-popupSize.width - JBUIScale.scale((int)5) + X_OFFSET.get(), JBUIScale.scale((int)1) + Y_OFFSET.get());
            }
        }
        ,
        BOTTOM{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                Dimension size = owner.getSize();
                return new Point(JBUIScale.scale((int)1) + X_OFFSET.get(), JBUIScale.scale((int)5) + size.height - Y_OFFSET.get());
            }
        }
        ,
        HELP_BUTTON{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                Insets i = ((JComponent)owner).getInsets();
                return new Point(X_OFFSET.get() - JBUIScale.scale((int)40), i.top + Y_OFFSET.get() - JBUIScale.scale((int)6) - popupSize.height);
            }
        }
        ,
        CURSOR{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                Point location = mouseLocation.getLocation();
                location.y += CURSOR_OFFSET.get();
                SwingUtilities.convertPointToScreen(location, owner);
                Rectangle r = new Rectangle(location, popupSize);
                ScreenUtil.fitToScreen((Rectangle)r);
                location = r.getLocation();
                SwingUtilities.convertPointFromScreen(location, owner);
                r.setLocation(location);
                if (r.contains(mouseLocation)) {
                    location.y = mouseLocation.y - r.height - JBUI.scale((int)5);
                }
                return location;
            }
        };


        public abstract Point getPointFor(Component var1, Dimension var2, Point var3);
    }
}

