/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class AbstractDocumentFormattingService
implements FormattingService {
    @Override
    @NotNull
    public final PsiElement formatElement(@NotNull PsiElement element, boolean canChangeWhiteSpaceOnly) {
        if (element == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(0);
        }
        return this.formatElement(element, element.getTextRange(), canChangeWhiteSpaceOnly);
    }

    @Override
    @NotNull
    public final PsiElement formatElement(@NotNull PsiElement element, @NotNull TextRange range2, boolean canChangeWhiteSpaceOnly) {
        if (element == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(1);
        }
        if (range2 == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(2);
        }
        PsiFile file = element.getContainingFile();
        FormattingContext formattingContext = FormattingContext.create(file, range2, CodeStyle.getSettings(file), FormattingMode.REFORMAT);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(file.getProject());
        Document document = documentManager.getDocument(file);
        if (document != null) {
            int offset = element.getTextOffset();
            this.formatDocument(document, Collections.singletonList(range2), formattingContext, canChangeWhiteSpaceOnly, false);
            documentManager.commitDocument(document);
            PsiElement resultingElement = file.findElementAt(offset);
            if (resultingElement != null) {
                PsiElement psiElement = resultingElement;
                if (psiElement == null) {
                    AbstractDocumentFormattingService.$$$reportNull$$$0(3);
                }
                return psiElement;
            }
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Override
    public final void formatRanges(@NotNull PsiFile file, FormattingRangesInfo rangesInfo, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        if (file == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(5);
        }
        TextRange boundRange = (TextRange)ObjectUtils.notNull((Object)rangesInfo.getBoundRange(), (Object)file.getTextRange());
        FormattingContext formattingContext = FormattingContext.create(file, boundRange, CodeStyle.getSettings(file), FormattingMode.REFORMAT);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(file.getProject());
        Document document = documentManager.getDocument(file);
        if (document != null) {
            this.formatDocument(document, rangesInfo.getTextRanges(), formattingContext, canChangeWhiteSpaceOnly, quickFormat);
            documentManager.commitDocument(document);
        }
    }

    public abstract void formatDocument(@NotNull Document var1, @NotNull List<TextRange> var2, @NotNull FormattingContext var3, boolean var4, boolean var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/AbstractDocumentFormattingService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/AbstractDocumentFormattingService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

