/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ExecutionEnvironment
extends UserDataHolderBase
implements Disposable {
    private static final AtomicLong myIdHolder = new AtomicLong(1L);
    @NotNull
    private final Project myProject;
    @NotNull
    private final RunProfile myRunProfile;
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final ExecutionTarget myTarget;
    private TargetEnvironmentRequest myTargetEnvironmentRequest;
    private volatile TargetEnvironment myPrepareRemoteEnvironment;
    @Nullable
    private RunnerSettings myRunnerSettings;
    @Nullable
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    @Nullable
    private final RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    @Nullable
    private RunContentDescriptor myContentToReuse;
    private final ProgramRunner<?> myRunner;
    private long myExecutionId;
    @Nullable
    private DataContext myDataContext;
    @Nullable
    private String myModulePath;
    @Nullable
    private ProgramRunner.Callback callback;
    private boolean isHeadless;

    @TestOnly
    public ExecutionEnvironment() {
        this.myExecutionId = 0L;
        this.isHeadless = false;
        this.myProject = null;
        this.myContentToReuse = null;
        this.myRunnerAndConfigurationSettings = null;
        this.myExecutor = null;
        this.myRunner = null;
        this.myRunProfile = null;
        this.myTarget = null;
    }

    public ExecutionEnvironment(@NotNull Executor executor, @NotNull ProgramRunner runner, @NotNull RunnerAndConfigurationSettings settings, @NotNull Project project) {
        if (executor == null) {
            ExecutionEnvironment.$$$reportNull$$$0(0);
        }
        if (runner == null) {
            ExecutionEnvironment.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            ExecutionEnvironment.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ExecutionEnvironment.$$$reportNull$$$0(3);
        }
        this(settings.getConfiguration(), executor, DefaultExecutionTarget.INSTANCE, project, (RunnerSettings)settings.getRunnerSettings(runner), settings.getConfigurationSettings(runner), null, settings, runner, null);
    }

    ExecutionEnvironment(@NotNull RunProfile runProfile, @NotNull Executor executor, @NotNull ExecutionTarget target, @NotNull Project project, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationSettings, @Nullable RunContentDescriptor contentToReuse, @Nullable RunnerAndConfigurationSettings settings, @NotNull ProgramRunner<?> runner, @Nullable ProgramRunner.Callback callback) {
        if (runProfile == null) {
            ExecutionEnvironment.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            ExecutionEnvironment.$$$reportNull$$$0(5);
        }
        if (target == null) {
            ExecutionEnvironment.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ExecutionEnvironment.$$$reportNull$$$0(7);
        }
        if (runner == null) {
            ExecutionEnvironment.$$$reportNull$$$0(8);
        }
        this.myExecutionId = 0L;
        this.isHeadless = false;
        this.myExecutor = executor;
        this.myTarget = target;
        this.myRunProfile = runProfile;
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSettings = configurationSettings;
        this.myProject = project;
        this.setContentToReuse(contentToReuse);
        this.myRunnerAndConfigurationSettings = settings;
        this.myRunner = runner;
        this.callback = callback;
    }

    @NotNull
    public TargetEnvironmentRequest getTargetEnvironmentRequest() {
        if (this.myTargetEnvironmentRequest != null) {
            TargetEnvironmentRequest targetEnvironmentRequest = this.myTargetEnvironmentRequest;
            if (targetEnvironmentRequest == null) {
                ExecutionEnvironment.$$$reportNull$$$0(9);
            }
            return targetEnvironmentRequest;
        }
        this.myTargetEnvironmentRequest = this.createTargetEnvironmentRequest();
        if (this.myTargetEnvironmentRequest == null) {
            ExecutionEnvironment.$$$reportNull$$$0(10);
        }
        return this.myTargetEnvironmentRequest;
    }

    @NotNull
    private TargetEnvironmentRequest createTargetEnvironmentRequest() {
        TargetEnvironmentConfiguration config;
        String targetName;
        if (this.myRunProfile instanceof TargetEnvironmentAwareRunProfile && (targetName = ((TargetEnvironmentAwareRunProfile)this.myRunProfile).getDefaultTargetName()) != null && (config = TargetEnvironmentsManager.getInstance(this.myProject).getTargets().findByName(targetName)) != null) {
            TargetEnvironmentRequest targetEnvironmentRequest = config.createEnvironmentRequest(this.myProject);
            if (targetEnvironmentRequest == null) {
                ExecutionEnvironment.$$$reportNull$$$0(11);
            }
            return targetEnvironmentRequest;
        }
        return new LocalTargetEnvironmentRequest();
    }

    @ApiStatus.Experimental
    @NotNull
    public TargetEnvironment getPreparedTargetEnvironment(@NotNull RunProfileState runProfileState, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        if (runProfileState == null) {
            ExecutionEnvironment.$$$reportNull$$$0(12);
        }
        if (targetProgressIndicator == null) {
            ExecutionEnvironment.$$$reportNull$$$0(13);
        }
        if (this.myPrepareRemoteEnvironment != null) {
            TargetEnvironment targetEnvironment = this.myPrepareRemoteEnvironment;
            if (targetEnvironment == null) {
                ExecutionEnvironment.$$$reportNull$$$0(14);
            }
            return targetEnvironment;
        }
        TargetEnvironment targetEnvironment = this.prepareTargetEnvironment(runProfileState, targetProgressIndicator);
        if (targetEnvironment == null) {
            ExecutionEnvironment.$$$reportNull$$$0(15);
        }
        return targetEnvironment;
    }

    @ApiStatus.Experimental
    @NotNull
    public TargetEnvironment prepareTargetEnvironment(@NotNull RunProfileState runProfileState, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        if (runProfileState == null) {
            ExecutionEnvironment.$$$reportNull$$$0(16);
        }
        if (targetProgressIndicator == null) {
            ExecutionEnvironment.$$$reportNull$$$0(17);
        }
        TargetEnvironmentRequest request = null;
        if (runProfileState instanceof TargetEnvironmentAwareRunProfileState && this.myRunProfile instanceof TargetEnvironmentAwareRunProfile && ((TargetEnvironmentAwareRunProfile)this.myRunProfile).getDefaultTargetName() == null) {
            request = ((TargetEnvironmentAwareRunProfileState)runProfileState).createCustomTargetEnvironmentRequest();
        }
        if (request == null) {
            request = this.getTargetEnvironmentRequest();
        }
        if (runProfileState instanceof TargetEnvironmentAwareRunProfileState) {
            ((TargetEnvironmentAwareRunProfileState)runProfileState).prepareTargetEnvironmentRequest(request, targetProgressIndicator);
        }
        this.myPrepareRemoteEnvironment = request.prepareEnvironment(targetProgressIndicator);
        if (runProfileState instanceof TargetEnvironmentAwareRunProfileState) {
            ((TargetEnvironmentAwareRunProfileState)runProfileState).handleCreatedTargetEnvironment(this.myPrepareRemoteEnvironment, targetProgressIndicator);
        }
        TargetEnvironment targetEnvironment = this.myPrepareRemoteEnvironment;
        if (targetEnvironment == null) {
            ExecutionEnvironment.$$$reportNull$$$0(18);
        }
        return targetEnvironment;
    }

    @ApiStatus.Internal
    public void setCallback(@Nullable ProgramRunner.Callback callback) {
        this.callback = callback;
    }

    @Nullable
    public ProgramRunner.Callback getCallback() {
        return this.callback;
    }

    public void dispose() {
        this.myContentToReuse = null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExecutionEnvironment.$$$reportNull$$$0(19);
        }
        return project;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myTarget;
        if (executionTarget == null) {
            ExecutionEnvironment.$$$reportNull$$$0(20);
        }
        return executionTarget;
    }

    @NotNull
    public RunProfile getRunProfile() {
        RunProfile runProfile = this.myRunProfile;
        if (runProfile == null) {
            ExecutionEnvironment.$$$reportNull$$$0(21);
        }
        return runProfile;
    }

    @Nullable
    public RunnerAndConfigurationSettings getRunnerAndConfigurationSettings() {
        return this.myRunnerAndConfigurationSettings;
    }

    @Nullable
    public RunContentDescriptor getContentToReuse() {
        return this.myContentToReuse;
    }

    public void setContentToReuse(@Nullable RunContentDescriptor contentToReuse) {
        this.myContentToReuse = contentToReuse;
        if (contentToReuse != null) {
            Disposer.register((Disposable)contentToReuse, (Disposable)this);
        }
    }

    @NotNull
    public ProgramRunner<?> getRunner() {
        ProgramRunner<?> programRunner = this.myRunner;
        if (programRunner == null) {
            ExecutionEnvironment.$$$reportNull$$$0(22);
        }
        return programRunner;
    }

    @Nullable
    public RunnerSettings getRunnerSettings() {
        return this.myRunnerSettings;
    }

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings() {
        return this.myConfigurationSettings;
    }

    @Nullable
    public RunProfileState getState() throws ExecutionException {
        return this.myRunProfile.getState(this.myExecutor, this);
    }

    public long assignNewExecutionId() {
        this.myExecutionId = myIdHolder.incrementAndGet();
        return this.myExecutionId;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    @NotNull
    public Executor getExecutor() {
        Executor executor = this.myExecutor;
        if (executor == null) {
            ExecutionEnvironment.$$$reportNull$$$0(23);
        }
        return executor;
    }

    public String toString() {
        if (this.myRunnerAndConfigurationSettings != null) {
            return this.myRunnerAndConfigurationSettings.getName();
        }
        return this.myRunProfile.getName();
    }

    @ApiStatus.Experimental
    public boolean isHeadless() {
        return this.isHeadless;
    }

    @ApiStatus.Experimental
    public void setHeadless() {
        this.isHeadless = true;
    }

    void setDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ExecutionEnvironment.$$$reportNull$$$0(24);
        }
        this.myDataContext = CachingDataContext.cacheIfNeeded(dataContext);
    }

    @Nullable
    public DataContext getDataContext() {
        return this.myDataContext;
    }

    void setModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            ExecutionEnvironment.$$$reportNull$$$0(25);
        }
        this.myModulePath = modulePath;
    }

    @Nullable
    public String getModulePath() {
        return this.myModulePath;
    }

    public static long getNextUnusedExecutionId() {
        return myIdHolder.incrementAndGet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/ExecutionEnvironment";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfileState";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/ExecutionEnvironment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetEnvironmentRequest";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetEnvironmentRequest";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedTargetEnvironment";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTargetEnvironment";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionTarget";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunProfile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedTargetEnvironment";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironment";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setDataContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setModulePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CachingDataContext
    implements DataContext {
        private static final DataKey[] keys = new DataKey[]{LangDataKeys.PROJECT, LangDataKeys.PROJECT_FILE_DIRECTORY, LangDataKeys.EDITOR, LangDataKeys.VIRTUAL_FILE, LangDataKeys.MODULE, LangDataKeys.PSI_FILE};
        private final Map<String, Object> values = new HashMap<String, Object>();

        @NotNull
        static CachingDataContext cacheIfNeeded(@NotNull DataContext context) {
            if (context == null) {
                CachingDataContext.$$$reportNull$$$0(0);
            }
            if (context instanceof CachingDataContext) {
                CachingDataContext cachingDataContext = (CachingDataContext)context;
                if (cachingDataContext == null) {
                    CachingDataContext.$$$reportNull$$$0(1);
                }
                return cachingDataContext;
            }
            return new CachingDataContext(context);
        }

        private CachingDataContext(DataContext context) {
            for (DataKey key : keys) {
                this.values.put(key.getName(), key.getData(context));
            }
        }

        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                CachingDataContext.$$$reportNull$$$0(2);
            }
            return this.values.get(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/runners/ExecutionEnvironment$CachingDataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/runners/ExecutionEnvironment$CachingDataContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cacheIfNeeded";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "cacheIfNeeded";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

