/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RunnerAndConfigurationSettings {
    @NotNull
    public ConfigurationType getType();

    @NotNull
    public ConfigurationFactory getFactory();

    public boolean isTemplate();

    public boolean isTemporary();

    default public boolean isShared() {
        return this.isStoredInDotIdeaFolder() || this.isStoredInArbitraryFileInProject();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    default public void setShared(boolean value2) {
        if (value2) {
            this.storeInDotIdeaFolder();
        } else {
            this.storeInLocalWorkspace();
        }
    }

    public void storeInLocalWorkspace();

    public boolean isStoredInLocalWorkspace();

    public void storeInDotIdeaFolder();

    public boolean isStoredInDotIdeaFolder();

    public void storeInArbitraryFileInProject(@NonNls @NotNull String var1);

    public boolean isStoredInArbitraryFileInProject();

    @Nullable
    @NonNls
    public String getPathIfStoredInArbitraryFileInProject();

    public void setTemporary(boolean var1);

    @NotNull
    public RunConfiguration getConfiguration();

    public void setName(@NlsSafe String var1);

    @NotNull
    @NlsSafe
    public String getName();

    @NotNull
    public String getUniqueID();

    @Nullable
    public <Settings extends RunnerSettings> Settings getRunnerSettings(@NotNull ProgramRunner<Settings> var1);

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings(@NotNull ProgramRunner var1);

    default public void checkSettings() throws RuntimeConfigurationException {
        this.checkSettings(null);
    }

    public void checkSettings(@Nullable Executor var1) throws RuntimeConfigurationException;

    @NotNull
    public Factory<RunnerAndConfigurationSettings> createFactory();

    public void setEditBeforeRun(boolean var1);

    public boolean isEditBeforeRun();

    public void setActivateToolWindowBeforeRun(boolean var1);

    public boolean isActivateToolWindowBeforeRun();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    default public boolean isSingleton() {
        return !this.getConfiguration().isAllowRunningInParallel();
    }

    @Deprecated
    default public void setSingleton(boolean value2) {
        this.getConfiguration().setAllowRunningInParallel(!value2);
    }

    public void setFolderName(@Nullable String var1);

    @Nullable
    public String getFolderName();

    @NlsSafe
    public String toString();
}

