/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.BaseVariableAnalyzer;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.util.containers.MultiMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

final class LiveVariablesAnalyzer
extends BaseVariableAnalyzer {
    LiveVariablesAnalyzer(ControlFlow flow) {
        super(flow);
    }

    @Override
    protected boolean isInterestingInstruction(Instruction instruction) {
        if (instruction == this.myInstructions[0]) {
            return true;
        }
        if (!instruction.getRequiredVariables(this.myFactory).isEmpty() || !instruction.getWrittenVariables(this.myFactory).isEmpty()) {
            return true;
        }
        return !instruction.isLinear() || instruction instanceof FinishElementInstruction;
    }

    @Nullable
    private Map<FinishElementInstruction, BitSet> findLiveVars() {
        HashMap<FinishElementInstruction, BitSet> result = new HashMap<FinishElementInstruction, BitSet>();
        boolean ok = this.runDfa(false, (instruction, liveVars) -> {
            List<DfaVariableValue> writtenVariables;
            if (instruction instanceof FinishElementInstruction) {
                BitSet set = (BitSet)result.get(instruction);
                if (set != null) {
                    set.or((BitSet)liveVars);
                    return (BitSet)set.clone();
                }
                if (!liveVars.isEmpty()) {
                    result.put((FinishElementInstruction)instruction, (BitSet)liveVars.clone());
                }
            }
            if (!(writtenVariables = instruction.getWrittenVariables(this.myFactory)).isEmpty()) {
                BitSet newVars = (BitSet)liveVars.clone();
                for (DfaVariableValue written : writtenVariables) {
                    newVars.clear(written.getID());
                    for (DfaVariableValue var : written.getDependentVariables()) {
                        newVars.clear(var.getID());
                    }
                }
                return newVars;
            }
            var processor = new Consumer<DfaVariableValue>((BitSet)liveVars){
                boolean cloned = false;
                BitSet newVars = this.val$liveVars;
                final /* synthetic */ BitSet val$liveVars;
                {
                    this.val$liveVars = bitSet;
                }

                @Override
                public void accept(DfaVariableValue value2) {
                    if (!this.newVars.get(value2.getID())) {
                        if (!this.cloned) {
                            this.newVars = (BitSet)this.newVars.clone();
                            this.cloned = true;
                        }
                        this.newVars.set(value2.getID());
                    }
                }
            };
            ((StreamEx)StreamEx.of(instruction.getRequiredVariables(this.myFactory)).flatMap(v -> StreamEx.of(v.getDependentVariables()).prepend(v)).distinct()).forEach((Consumer)processor);
            return processor.newVars;
        });
        return ok ? result : null;
    }

    void flushDeadVariablesOnStatementFinish() {
        Map<FinishElementInstruction, BitSet> liveVars = this.findLiveVars();
        if (liveVars == null) {
            return;
        }
        MultiMap toFlush = MultiMap.createSet();
        boolean ok = this.runDfa(true, (instruction, prevLiveVars) -> {
            if (instruction instanceof FinishElementInstruction) {
                int setBit;
                BitSet currentlyLive = (BitSet)liveVars.get(instruction);
                if (currentlyLive == null) {
                    currentlyLive = new BitSet();
                }
                int index = 0;
                while ((setBit = prevLiveVars.nextSetBit(index)) >= 0) {
                    if (!currentlyLive.get(setBit)) {
                        toFlush.putValue((Object)((FinishElementInstruction)instruction), (Object)((DfaVariableValue)this.myFactory.getValue(setBit)));
                    }
                    index = setBit + 1;
                }
                return currentlyLive;
            }
            return prevLiveVars;
        });
        if (ok) {
            for (FinishElementInstruction instruction2 : toFlush.keySet()) {
                Collection values = toFlush.get((Object)instruction2);
                values.removeIf(var -> var.getDescriptor().isImplicitReadPossible());
                instruction2.getVarsToFlush().addAll(values);
            }
        }
    }
}

