/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesElementFactory {
    private static final Key<PropertiesFile> SYSTEM_PROPERTIES_KEY = Key.create((String)"system.properties.file");
    private static final UserDataCache<PropertiesFile, Project, Void> PROPERTIES = new UserDataCache<PropertiesFile, Project, Void>("system.properties.file"){

        protected PropertiesFile compute(Project project, Void p) {
            return PropertiesElementFactory.createPropertiesFile(project, System.getProperties(), "system");
        }
    };

    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value, @Nullable Character delimiter) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(1);
        }
        if (value == null) {
            PropertiesElementFactory.$$$reportNull$$$0(2);
        }
        return PropertiesElementFactory.createProperty(project, name, value, delimiter, PropertyKeyValueFormat.PRESENTABLE);
    }

    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value, @Nullable Character delimiter, @NotNull PropertyKeyValueFormat format) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(3);
        }
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(4);
        }
        if (value == null) {
            PropertiesElementFactory.$$$reportNull$$$0(5);
        }
        if (format == null) {
            PropertiesElementFactory.$$$reportNull$$$0(6);
        }
        String text = PropertiesElementFactory.getPropertyText(name, value, delimiter, project, format);
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile(project, text);
        IProperty iProperty = dummyFile.getProperties().get(0);
        if (iProperty == null) {
            PropertiesElementFactory.$$$reportNull$$$0(7);
        }
        return iProperty;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(9);
        }
        if (value == null) {
            PropertiesElementFactory.$$$reportNull$$$0(10);
        }
        return PropertiesElementFactory.createProperty(project, name, value, null);
    }

    @NotNull
    public static String getPropertyText(@NonNls @NotNull String name, @NonNls @NotNull String value, @NonNls @Nullable Character delimiter, @Nullable Project project, @NotNull PropertyKeyValueFormat format) {
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(11);
        }
        if (value == null) {
            PropertiesElementFactory.$$$reportNull$$$0(12);
        }
        if (format == null) {
            PropertiesElementFactory.$$$reportNull$$$0(13);
        }
        if (delimiter == null) {
            delimiter = Character.valueOf(project == null ? (char)'=' : PropertiesCodeStyleSettings.getInstance(project).getDelimiter());
        }
        String string = (format != PropertyKeyValueFormat.FILE ? PropertiesElementFactory.escape(name) : name) + delimiter + PropertiesElementFactory.escapeValue(value, delimiter.charValue(), format);
        if (string == null) {
            PropertiesElementFactory.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(15);
        }
        if (text == null) {
            PropertiesElementFactory.$$$reportNull$$$0(16);
        }
        @NonNls String filename = "dummy." + PropertiesFileType.INSTANCE.getDefaultExtension();
        PropertiesFile propertiesFile = (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)text);
        if (propertiesFile == null) {
            PropertiesElementFactory.$$$reportNull$$$0(17);
        }
        return propertiesFile;
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, Properties properties, String fileName) {
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(18);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            properties.store(stream, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        @NonNls String filename = fileName + "." + PropertiesFileType.INSTANCE.getDefaultExtension();
        PropertiesFile propertiesFile = (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)stream.toString());
        if (propertiesFile == null) {
            PropertiesElementFactory.$$$reportNull$$$0(19);
        }
        return propertiesFile;
    }

    @NotNull
    public static synchronized PropertiesFile getSystemProperties(@NotNull Project project) {
        PropertiesFile systemPropertiesFile;
        if (project == null) {
            PropertiesElementFactory.$$$reportNull$$$0(20);
        }
        if ((systemPropertiesFile = (PropertiesFile)project.getUserData(SYSTEM_PROPERTIES_KEY)) == null) {
            systemPropertiesFile = PropertiesElementFactory.createPropertiesFile(project, System.getProperties(), "system");
            project.putUserData(SYSTEM_PROPERTIES_KEY, (Object)systemPropertiesFile);
        }
        PropertiesFile propertiesFile = systemPropertiesFile;
        if (propertiesFile == null) {
            PropertiesElementFactory.$$$reportNull$$$0(21);
        }
        return propertiesFile;
    }

    @NotNull
    private static String escape(@NotNull String name) {
        if (name == null) {
            PropertiesElementFactory.$$$reportNull$$$0(22);
        }
        if (StringUtil.startsWithChar((CharSequence)name, (char)'#') || StringUtil.startsWithChar((CharSequence)name, (char)'!')) {
            name = "\\" + (String)name;
        }
        String string = StringUtil.escapeChars((String)name, (char[])new char[]{'=', ':', ' ', '\t'});
        if (string == null) {
            PropertiesElementFactory.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static String escapeValue(String value, char delimiter) {
        return PropertiesElementFactory.escapeValue(value, delimiter, PropertyKeyValueFormat.PRESENTABLE);
    }

    public static String escapeValue(String value, char delimiter, PropertyKeyValueFormat format) {
        return PropertiesResourceBundleUtil.convertValueToFileFormat(value, delimiter, format);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/psi/PropertiesElementFactory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/psi/PropertiesElementFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createProperty";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyText";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertiesFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemProperties";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyText";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSystemProperties";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

