/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import libraries.io.HexKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lruntime/utils/SHA1Hasher;", "", "()V", "hasher", "Ljava/security/MessageDigest;", "hashAsString", "", "update", "", "data", "", "platform-runtime"})
final class SHA1Hasher {
    @NotNull
    private final MessageDigest hasher;

    public SHA1Hasher() {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        Intrinsics.checkNotNull((Object)messageDigest);
        this.hasher = messageDigest;
        this.hasher.reset();
    }

    public final void update(@NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string = data2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.hasher.update(byArray);
    }

    public final void update(int data2) {
        int shiftingData = data2;
        int n = 0;
        do {
            int i = n++;
            this.hasher.update((byte)(shiftingData & 0xFF));
            shiftingData >>= 8;
        } while (n <= 3);
    }

    @NotNull
    public final String hashAsString() {
        byte[] byArray = this.hasher.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hasher.digest()");
        return HexKt.toHexString(byArray);
    }
}

