/*
 * Decompiled with CFR 0.152.
 */
package runtime.stringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.stringUtils.Symbols;
import runtime.stringUtils.UnicodeUtilKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0007\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0018\u0010\u0006\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\t\u001a\u00020\u0003\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\u0003\u001a\u0012\u0010\n\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\f\u001a\u0012\u0010\u000f\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\f\u001a\u0012\u0010\u000f\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\u00020\u0003*\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0003\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003\u001a\n\u0010\u0017\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\u0018\u001a\u00020\u0003*\u00020\u0003\u001a\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00032\n\u0010\u001a\u001a\u00020\u001b\"\u00020\u001c\u001a\u001c\u0010\u001d\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020\u0007\u001a\u0015\u0010 \u001a\u00020\u0003*\u00020\u00032\u0006\u0010!\u001a\u00020\fH\u0086\u0002\u001a\n\u0010\"\u001a\u00020\u0003*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"whitespaceRegex", "Lkotlin/text/Regex;", "getPostfix", "", "string", "prefix", "containsIgnoreCase", "", "", "element", "ellipsize", "take", "", "limitedView", "maxLength", "pluralize", "count", "", "quoted", "quotation", "removePrefixOrNull", "removeSuffixOrNull", "suffix", "removeWhitespace", "singularize", "splitByCamelHumpsAndPunctuation", "letterLikeChars", "", "", "surround", "symbols", "reverseSuffix", "times", "n", "withNbsp", "platform-runtime"})
public final class StringUtilsKt {
    @NotNull
    private static final Regex whitespaceRegex = Regex.Companion.fromLiteral("\\s");

    @NotNull
    public static final String getPostfix(@NotNull String string, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        CharSequence charSequence = string;
        String string2 = Intrinsics.stringPlus((String)prefix, (Object)"(.*)");
        boolean bl = false;
        string2 = new Regex(string2);
        String string3 = "$1";
        boolean bl2 = false;
        return string2.replaceFirst(charSequence, string3);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, long count2) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return count2 == 1L ? $this$pluralize : (StringsKt.endsWith$default((String)$this$pluralize, (String)"s", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"ch", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"x", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"z", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)$this$pluralize, (Object)"es") : (StringsKt.endsWith$default((String)$this$pluralize, (String)"y", (boolean)false, (int)2, null) ? (StringsKt.endsWith$default((String)$this$pluralize, (String)"ay", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"ey", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"oy", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"uy", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)$this$pluralize, (Object)"s") : (StringsKt.endsWith$default((String)$this$pluralize, (String)"iy", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)StringsKt.dropLast((String)$this$pluralize, (int)1), (Object)"es") : Intrinsics.stringPlus((String)StringsKt.dropLast((String)$this$pluralize, (int)1), (Object)"ies"))) : Intrinsics.stringPlus((String)$this$pluralize, (Object)"s")));
    }

    @NotNull
    public static final String singularize(@NotNull String $this$singularize) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$singularize, (String)"<this>");
        if (StringsKt.endsWith$default((String)$this$singularize, (String)"ies", (boolean)false, (int)2, null)) {
            string = Intrinsics.stringPlus((String)StringsKt.dropLast((String)$this$singularize, (int)3), (Object)"y");
        } else if (StringsKt.endsWith$default((String)$this$singularize, (String)"es", (boolean)false, (int)2, null)) {
            String string2;
            String string3 = StringsKt.dropLast((String)$this$singularize, (int)2);
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            String string4 = string2 = StringsKt.endsWith$default((CharSequence)it, (char)'s', (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"ch", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)it, (char)'x', (boolean)false, (int)2, null) ? string3 : null;
            string = string2 == null ? StringsKt.dropLast((String)$this$singularize, (int)1) : string2;
        } else {
            string = StringsKt.endsWith$default((CharSequence)$this$singularize, (char)'s', (boolean)false, (int)2, null) ? StringsKt.dropLast((String)$this$singularize, (int)1) : $this$singularize;
        }
        return string;
    }

    @NotNull
    public static final List<String> splitByCamelHumpsAndPunctuation(@NotNull String $this$splitByCamelHumpsAndPunctuation, char ... letterLikeChars) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByCamelHumpsAndPunctuation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)letterLikeChars, (String)"letterLikeChars");
        StringBuilder currentToken = new StringBuilder();
        boolean bl = false;
        List result2 = new ArrayList();
        boolean isPrevUpperCase = false;
        CharSequence $this$forEach$iv = $this$splitByCamelHumpsAndPunctuation;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char c = element$iv = charSequence.charAt(i);
            boolean bl2 = false;
            boolean isUpperCase = UnicodeUtilKt.isUpperCase(c);
            if (!UnicodeUtilKt.isAlphaNumeric(c) && !ArraysKt.contains((char[])letterLikeChars, (char)c)) {
                StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
            } else if (!isPrevUpperCase && isUpperCase) {
                StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
                currentToken.append(c);
            } else {
                currentToken.append(c);
            }
            isPrevUpperCase = isUpperCase;
        }
        StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
        return result2;
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, int count2) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return StringUtilsKt.pluralize($this$pluralize, (long)count2);
    }

    @NotNull
    public static final String surround(@NotNull String $this$surround, @NotNull String symbols, boolean reverseSuffix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$surround, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        StringBuilder stringBuilder = new StringBuilder().append(symbols).append($this$surround);
        if (reverseSuffix) {
            String string2 = symbols;
            boolean bl = false;
            string = ((Object)StringsKt.reversed((CharSequence)string2)).toString();
        } else {
            string = symbols;
        }
        return stringBuilder.append(string).toString();
    }

    public static /* synthetic */ String surround$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringUtilsKt.surround(string, string2, bl);
    }

    @NotNull
    public static final String quoted(@NotNull String $this$quoted, @NotNull String quotation) {
        Intrinsics.checkNotNullParameter((Object)$this$quoted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)quotation, (String)"quotation");
        return StringUtilsKt.surround$default($this$quoted, quotation, false, 2, null);
    }

    public static /* synthetic */ String quoted$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "\"";
        }
        return StringUtilsKt.quoted(string, string2);
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        return Intrinsics.stringPlus((String)$this$ellipsize, (Object)((Object)Symbols.Ellipsis));
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize, int take2) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        return Intrinsics.stringPlus((String)StringsKt.take((String)$this$ellipsize, (int)take2), (Object)($this$ellipsize.length() > take2 + 1 ? Symbols.Ellipsis : ""));
    }

    @NotNull
    public static final String times(@NotNull String $this$times, int n) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = $this$times;
                break;
            }
            default: {
                int i = 0;
                StringBuilder result2 = new StringBuilder($this$times);
                while (++i < n) {
                    result2.append($this$times);
                }
                String string2 = result2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            var i = 0\n            val result = StringBuilder(this)\n            while (++i < n) {\n                result.append(this)\n            }\n            result.toString()\n        }");
                string = string2;
            }
        }
        return string;
    }

    @Nullable
    public static final String removePrefixOrNull(@NotNull String $this$removePrefixOrNull, @NotNull String prefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$removePrefixOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (StringsKt.startsWith$default((String)$this$removePrefixOrNull, (String)prefix, (boolean)false, (int)2, null)) {
            String string2 = $this$removePrefixOrNull;
            int n = prefix.length();
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String removeSuffixOrNull(@NotNull String $this$removeSuffixOrNull, @NotNull String suffix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$removeSuffixOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        if (StringsKt.endsWith$default((String)$this$removeSuffixOrNull, (String)suffix, (boolean)false, (int)2, null)) {
            String string2 = $this$removeSuffixOrNull;
            int n = 0;
            int n2 = $this$removeSuffixOrNull.length() - suffix.length();
            boolean bl = false;
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String withNbsp(@NotNull String $this$withNbsp) {
        Intrinsics.checkNotNullParameter((Object)$this$withNbsp, (String)"<this>");
        return StringsKt.replace$default((String)$this$withNbsp, (String)" ", (String)Symbols.Nbsp.toString(), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String limitedView(@NotNull String $this$limitedView, int maxLength) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$limitedView, (String)"<this>");
        if ($this$limitedView.length() > maxLength) {
            String string2 = $this$limitedView;
            int n = 0;
            int n2 = maxLength - 3;
            boolean bl = false;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = Intrinsics.stringPlus((String)string3, (Object)"...");
        } else {
            string = $this$limitedView;
        }
        return string;
    }

    public static final boolean containsIgnoreCase(@NotNull List<String> $this$containsIgnoreCase, @NotNull String element) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$containsIgnoreCase, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Iterable $this$any$iv = $this$containsIgnoreCase;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)element, (String)it, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final String removeWhitespace(@NotNull String $this$removeWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$removeWhitespace, (String)"<this>");
        CharSequence charSequence = $this$removeWhitespace;
        Regex regex2 = whitespaceRegex;
        String string = "";
        boolean bl = false;
        return regex2.replace(charSequence, string);
    }

    private static final void splitByCamelHumpsAndPunctuation$flushToken(StringBuilder currentToken, List<String> result2) {
        CharSequence charSequence = currentToken;
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = currentToken.toString();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"currentToken.toString()");
            result2.add((String)charSequence);
            StringsKt.clear((StringBuilder)currentToken);
        }
    }
}

