/*
 * Decompiled with CFR 0.152.
 */
package runtime.stringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.stringUtils.FullName;
import runtime.stringUtils.FullNameUtilsKt;
import runtime.stringUtils.StringUtilsKt;
import runtime.stringUtils.UnicodeUtilKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002\u001a\u0014\u0010\b\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0002H\u0002\u001a\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0002H\u0002\u001a\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0002H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"prefixes", "", "", "sufficesMap", "", "extractFullNameFromEmail", "Lruntime/stringUtils/FullName;", "email", "parseFullName", "fullName", "words", "", "fixCase", "isCompoundLastName", "", "isInitial", "isMixedCase", "normalize", "safeUCFirst", "separator", "takeIfSalutation", "takeIfSuffix", "platform-runtime"})
public final class FullNameUtilsKt {
    @NotNull
    private static final Map<String, String> sufficesMap;
    @NotNull
    private static final Set<String> prefixes;

    @NotNull
    public static final FullName extractFullNameFromEmail(@NotNull String email) {
        List list;
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        String username = StringsKt.substringBefore$default((String)email, (char)'@', null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)username, (char)'.', (boolean)false, (int)2, null)) {
            cArray = new char[]{'.'};
            list = StringsKt.split$default((CharSequence)username, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        } else {
            cArray = new char[]{'-'};
            list = StringUtilsKt.splitByCamelHumpsAndPunctuation(username, cArray);
        }
        List nameParts = list;
        return FullNameUtilsKt.parseFullName(nameParts);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FullName parseFullName(@NotNull String fullName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        int openIndex = StringsKt.indexOf$default((CharSequence)fullName, (char)'(', (int)0, (boolean)false, (int)6, null);
        int closeIndex = StringsKt.indexOf$default((CharSequence)fullName, (char)')', (int)0, (boolean)false, (int)6, null);
        if (openIndex >= 0 && closeIndex >= 0) {
            object = fullName;
            int n = closeIndex + 1;
            boolean bl = false;
            string = ((Object)StringsKt.removeRange((CharSequence)((CharSequence)object), (int)openIndex, (int)n)).toString();
        } else {
            string = fullName;
        }
        object = new char[1];
        object[0] = 32;
        object = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)charSequence);
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nameParts = (List)destination$iv$iv;
        return FullNameUtilsKt.parseFullName(nameParts);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FullName parseFullName(@NotNull List<String> words) {
        void it;
        void $this$mapTo$iv$iv;
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Intrinsics.checkNotNullParameter(words, (String)"words");
        List nameParts = null;
        nameParts = words;
        if (nameParts.isEmpty()) {
            return FullName.Companion.getEMPTY();
        }
        String string = (String)CollectionsKt.firstOrNull(nameParts);
        String salutation = string == null ? null : FullNameUtilsKt.takeIfSalutation(string);
        nameParts = CollectionsKt.drop((Iterable)nameParts, (int)(salutation != null ? 1 : 0));
        String string2 = (String)CollectionsKt.lastOrNull((List)nameParts);
        String suffix = string2 == null ? null : FullNameUtilsKt.takeIfSuffix(string2);
        nameParts = CollectionsKt.dropLast((List)nameParts, (int)(suffix != null ? 1 : 0));
        boolean bl3 = false;
        List firstName = new ArrayList();
        boolean bl4 = false;
        List initials = new ArrayList();
        String string3 = (String)CollectionsKt.firstOrNull((List)nameParts);
        if (string3 != null) {
            boolean bl5;
            String string4;
            object2 = string3;
            bl2 = false;
            bl = false;
            String firstNamePart = object2;
            boolean bl6 = false;
            if (FullNameUtilsKt.isInitial(firstNamePart)) {
                object = (String)CollectionsKt.getOrNull((List)nameParts, (int)1);
                if (Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(FullNameUtilsKt.isInitial((String)object))), (Object)true)) {
                    object = firstName;
                    string4 = firstNamePart;
                    bl5 = false;
                    String string5 = string4.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
                    string4 = string5;
                    bl5 = false;
                    object.add(string4);
                } else {
                    object = initials;
                    string4 = firstNamePart;
                    bl5 = false;
                    String string6 = string4.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
                    string4 = string6;
                    bl5 = false;
                    object.add(string4);
                }
            } else {
                object = firstName;
                string4 = FullNameUtilsKt.fixCase(firstNamePart);
                bl5 = false;
                object.add(string4);
            }
            nameParts = CollectionsKt.drop((Iterable)nameParts, (int)1);
        }
        while (nameParts.size() > 1) {
            String string7;
            String word = (String)CollectionsKt.first((List)nameParts);
            if (FullNameUtilsKt.isCompoundLastName(word)) {
                if (!FullNameUtilsKt.isInitial(word)) break;
                object2 = word;
                bl2 = false;
                Object object3 = object2;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = ((String)object3).toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toUpperCase()");
                if (!Intrinsics.areEqual((Object)word, (Object)string8)) break;
            }
            if (FullNameUtilsKt.isInitial(word)) {
                object2 = initials;
                string7 = word;
                bl = false;
                String string9 = string7;
                if (string9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toUpperCase()");
                string7 = string10;
                bl = false;
                object2.add(string7);
            } else {
                object2 = firstName;
                string7 = FullNameUtilsKt.fixCase(word);
                bl = false;
                object2.add(string7);
            }
            nameParts = CollectionsKt.drop((Iterable)nameParts, (int)1);
        }
        Iterable $this$map$iv = nameParts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string11 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            String string12 = FullNameUtilsKt.fixCase((String)it2);
            collection.add(string12);
        }
        List lastName = (List)destination$iv$iv;
        object2 = CollectionsKt.joinToString$default((Iterable)firstName, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        bl2 = false;
        Object object4 = object2;
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        object2 = CollectionsKt.joinToString$default((Iterable)initials, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        bl2 = false;
        Object object5 = object2;
        if (object5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        object2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object5))).toString();
        bl2 = false;
        boolean bl8 = false;
        destination$iv$iv = object2;
        String string13 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object4))).toString();
        String string14 = salutation;
        boolean bl9 = false;
        object = (CharSequence)it;
        boolean bl10 = false;
        boolean bl11 = object.length() > 0;
        Object object6 = bl11 ? object2 : null;
        object2 = CollectionsKt.joinToString$default((Iterable)lastName, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        bl2 = false;
        Object object7 = object2;
        if (object7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string15 = suffix;
        String string16 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object7))).toString();
        Object object8 = object6;
        String string17 = string13;
        String string18 = string14;
        return new FullName(string18, string17, (String)object8, string16, string15);
    }

    private static final String normalize(String $this$normalize) {
        String string = StringsKt.replace$default((String)$this$normalize, (String)".", (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return string3;
    }

    private static final String takeIfSalutation(String $this$takeIfSalutation) {
        String string;
        switch (FullNameUtilsKt.normalize($this$takeIfSalutation)) {
            case "mr": 
            case "mister": 
            case "master": {
                string = "Mr.";
                break;
            }
            case "mrs": {
                string = "Mrs.";
                break;
            }
            case "ms": 
            case "miss": {
                string = "Ms.";
                break;
            }
            case "dr": {
                string = "Dr.";
                break;
            }
            case "rev": {
                string = "Rev.";
                break;
            }
            case "fr": {
                string = "Fr.";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private static final String takeIfSuffix(String $this$takeIfSuffix) {
        String string = StringsKt.replace$default((String)$this$takeIfSuffix, (String)".", (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String normalized = string3;
        return sufficesMap.get(normalized);
    }

    private static final boolean isInitial(String $this$isInitial) {
        return FullNameUtilsKt.normalize($this$isInitial).length() == 1;
    }

    private static final String fixCase(String $this$fixCase) {
        return FullNameUtilsKt.safeUCFirst(FullNameUtilsKt.safeUCFirst($this$fixCase, "-"), ".");
    }

    private static final String safeUCFirst(String $this$safeUCFirst, String separator) {
        String[] stringArray = new String[]{separator};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$safeUCFirst, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)separator, null, null, (int)0, null, (Function1)safeUCFirst.1.INSTANCE, (int)30, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMixedCase(String $this$isMixedCase) {
        char it;
        char element$iv;
        int n;
        CharSequence charSequence;
        boolean $i$f$any;
        CharSequence $this$any$iv;
        block5: {
            $this$any$iv = $this$isMixedCase;
            $i$f$any = false;
            charSequence = $this$any$iv;
            n = 0;
            while (n < charSequence.length()) {
                it = element$iv = charSequence.charAt(n);
                boolean bl = false;
                if (!(UnicodeUtilKt.isAlpha(it) && UnicodeUtilKt.isUpperCase(it))) {
                    ++n;
                    continue;
                }
                break block5;
            }
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        $this$any$iv = $this$isMixedCase;
        $i$f$any = false;
        charSequence = $this$any$iv;
        n = 0;
        while (n < charSequence.length()) {
            it = element$iv = charSequence.charAt(n);
            boolean bl2 = false;
            if (UnicodeUtilKt.isAlpha(it) && UnicodeUtilKt.isLowerCase(it)) {
                return true;
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean isCompoundLastName(String $this$isCompoundLastName) {
        String string = $this$isCompoundLastName;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return prefixes.contains(string3);
    }

    public static final /* synthetic */ boolean access$isMixedCase(String $receiver) {
        return FullNameUtilsKt.isMixedCase($receiver);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Object[] objectArray = new String[]{"I", "II", "III", "IV", "V", "Senior", "Junior", "Jr", "Sr", "PhD", "APR", "RPh", "PE", "MD", "MA", "DMD", "CME", "BVM", "CFRE", "CLU", "CPA", "CSC", "CSJ", "DC", "DD", "DDS", "DO", "DVM", "EdD", "Esq", "JD", "LLD", "OD", "OSB", "PC", "Ret", "RGS", "RN", "RNC", "SHCJ", "SJ", "SNJM", "SSMO", "USA", "USAF", "USAFR", "USAR", "USCG", "USMC", "USMCR", "USN", "USNR"};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string;
            void it;
            String string2 = (String)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            void var10_10 = it;
            boolean bl2 = false;
            void v0 = var10_10;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)v0.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            map2.put(string, element$iv$iv);
        }
        sufficesMap = destination$iv$iv;
        objectArray = new String[]{"vere", "von", "van", "de", "del", "della", "di", "da", "pietro", "vanden", "du", "st.", "st", "la", "lo", "ter", "o", "o", "mac", "fitz"};
        prefixes = SetsKt.setOf((Object[])objectArray);
    }
}

