/*
 * Decompiled with CFR 0.152.
 */
package runtime.net;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import runtime.net.CircletURLDecodeException;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t\u001a\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a,\u0010\u0012\u001a\u00020\t*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u001c\u0010\u0019\u001a\u00020\t*\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u001a\f\u0010\u001a\u001a\u00020\t*\u00020\u0002H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"OAUTH_SYMBOLS", "", "", "URL_ALPHABET", "charToHexDigit", "", "c2", "", "doURLEncode", "", "value", "spaceToPlus", "", "hexDigitToChar", "digit", "urlDecode", "encoded", "urlEncode", "decodeImpl", "", "start", "end", "prefixEnd", "charset", "Ljava/nio/charset/Charset;", "decodeScan", "percentEncode", "platform-runtime"})
public final class EncodingKt {
    @NotNull
    private static final List<Byte> URL_ALPHABET;
    @NotNull
    private static final List<Byte> OAUTH_SYMBOLS;

    @NotNull
    public static final String urlEncode(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return EncodingKt.doURLEncode(value2, false);
    }

    @NotNull
    public static final String doURLEncode(@NotNull String value2, boolean spaceToPlus) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            ByteBuffer bytes = Charsets.UTF_8.newEncoder().encode(CharBuffer.wrap(value2));
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$doURLEncode_u24lambda_u2d2 = stringBuilder;
            boolean bl5 = false;
            while (bytes.hasRemaining()) {
                byte by = bytes.get();
                if (URL_ALPHABET.contains(by) || OAUTH_SYMBOLS.contains(by)) {
                    $this$doURLEncode_u24lambda_u2d2.append((char)by);
                    continue;
                }
                if (spaceToPlus) {
                    int n = 32;
                    boolean bl6 = false;
                    if (by == (byte)n) {
                        $this$doURLEncode_u24lambda_u2d2.append('+');
                        continue;
                    }
                }
                $this$doURLEncode_u24lambda_u2d2.append(EncodingKt.percentEncode(by));
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            string = string2;
        }
        catch (Exception e) {
            string = value2;
        }
        return string;
    }

    public static /* synthetic */ String doURLEncode$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return EncodingKt.doURLEncode(string, bl);
    }

    private static final String percentEncode(byte $this$percentEncode) {
        int n = 3;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$percentEncode_u24lambda_u2d3 = stringBuilder;
        boolean bl5 = false;
        int code = $this$percentEncode & 0xFF;
        $this$percentEncode_u24lambda_u2d3.append('%');
        $this$percentEncode_u24lambda_u2d3.append(EncodingKt.hexDigitToChar(code >> 4));
        $this$percentEncode_u24lambda_u2d3.append(EncodingKt.hexDigitToChar(code & 0xF));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    private static final int charToHexDigit(char c2) {
        int n;
        block1: {
            char c;
            block0: {
                c = c2;
                boolean bl = '0' <= c ? c <= '9' : false;
                if (!bl) break block0;
                n = c2 - 48;
                break block1;
            }
            n = ('A' <= c ? c <= 'F' : false) ? c2 - 65 + 10 : (('a' <= c ? c <= 'f' : false) ? c2 - 97 + 10 : -1);
        }
        return n;
    }

    private static final char hexDigitToChar(int digit) {
        int n = digit;
        return (0 <= n ? n <= 9 : false) ? (char)(48 + digit) : (char)((char)(65 + digit) - 10);
    }

    @NotNull
    public static final String urlDecode(@NotNull String encoded) {
        String string;
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        try {
            string = EncodingKt.decodeScan(encoded, 0, encoded.length());
        }
        catch (Exception e) {
            string = encoded;
        }
        return string;
    }

    private static final String decodeScan(String $this$decodeScan, int start2, int end) {
        String string;
        int n = start2;
        if (n < end) {
            do {
                int index;
                char ch;
                if ((ch = $this$decodeScan.charAt(index = n++)) != '%') continue;
                CharSequence charSequence = $this$decodeScan;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                return EncodingKt.decodeImpl(charSequence, start2, end, index, charset);
            } while (n < end);
        }
        if (start2 == 0 && end == $this$decodeScan.length()) {
            string = $this$decodeScan.toString();
        } else {
            String string2 = $this$decodeScan;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(start2, end);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    private static final String decodeImpl(CharSequence $this$decodeImpl, int start2, int end, int prefixEnd, Charset charset) {
        int length = end - start2;
        int sbSize = length > 255 ? length / 3 : length;
        StringBuilder sb = new StringBuilder(sbSize);
        if (prefixEnd > start2) {
            sb.append($this$decodeImpl, start2, prefixEnd);
        }
        int index = prefixEnd;
        byte[] bytes = null;
        while (index < end) {
            char c = $this$decodeImpl.charAt(index);
            if (c == '%') {
                int n;
                if (bytes == null) {
                    bytes = new byte[(end - index) / 3];
                }
                int count2 = 0;
                while (index < end && $this$decodeImpl.charAt(index) == '%') {
                    int n2;
                    if (index + 2 >= end) {
                        CharSequence charSequence = $this$decodeImpl;
                        n = charSequence.length();
                        n2 = 0;
                        throw new CircletURLDecodeException("Incomplete trailing HEX escape: " + ((Object)charSequence.subSequence(index, n)).toString() + ", in " + $this$decodeImpl + " at " + index);
                    }
                    int digit1 = EncodingKt.charToHexDigit($this$decodeImpl.charAt(index + 1));
                    int digit2 = EncodingKt.charToHexDigit($this$decodeImpl.charAt(index + 2));
                    if (digit1 == -1 || digit2 == -1) {
                        throw new CircletURLDecodeException("Wrong HEX escape: %" + $this$decodeImpl.charAt(index + 1) + $this$decodeImpl.charAt(index + 2) + ", in " + $this$decodeImpl + ", at " + index);
                    }
                    n2 = count2;
                    count2 = n2 + 1;
                    bytes[n2] = (byte)(digit1 * 16 + digit2);
                    index += 3;
                }
                int n3 = 0;
                n = 0;
                sb.append(new String(bytes, n3, count2, charset));
                continue;
            }
            sb.append(c);
            int n = index;
            index = n + 1;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Byte by;
        boolean bl;
        char c;
        char it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = (Object[])CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            char c2 = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            c = it;
            bl = false;
            by = (byte)c;
            collection.add(by);
        }
        URL_ALPHABET = (List)destination$iv$iv;
        $this$map$iv = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl3 = false;
            c = it;
            bl = false;
            by = (byte)c;
            collection.add(by);
        }
        OAUTH_SYMBOLS = (List)var3_3;
    }
}

