/*
 * Decompiled with CFR 0.152.
 */
package runtime.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.json.JsonArray;
import runtime.json.JsonArrayBuilderContext;
import runtime.json.JsonArrayBuilderContextImpl;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.json.JsonObject;
import runtime.json.JsonValue;
import runtime.json.JsonValueBuilderContext;
import runtime.json.JsonValueBuilderContextImpl;
import runtime.json.RawJsonObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0004J\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0014H\u0096\u0004J\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0096\u0004J\u0017\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0096\u0004J&\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u0017\u00a2\u0006\u0002\b\u0018H\u0096\u0004J\u0017\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0019H\u0096\u0004J&\u0010\u001a\u001a\u00020\u0010*\u00020\u00112\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00100\u0017\u00a2\u0006\u0002\b\u0018H\u0096\u0004J&\u0010\u001c\u001a\u00020\u0010*\u00020\u00112\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00100\u0017\u00a2\u0006\u0002\b\u0018H\u0096\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lruntime/json/JsonBuilderContextImpl;", "Lruntime/json/JsonBuilderContext;", "node", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "factory", "Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getFactory", "()Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getNode", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "put", "", "", "value", "", "", "", "worker", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Lruntime/json/JsonElement;", "putArray", "Lruntime/json/JsonArrayBuilderContext;", "putValue", "Lruntime/json/JsonValueBuilderContext;", "platform-runtime"})
public final class JsonBuilderContextImpl
implements JsonBuilderContext {
    @NotNull
    private final ObjectNode node;
    @NotNull
    private final JsonNodeFactory factory;
    @NotNull
    private final ObjectMapper mapper;

    public JsonBuilderContextImpl(@NotNull ObjectNode node, @NotNull JsonNodeFactory factory, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.node = node;
        this.factory = factory;
        this.mapper = mapper;
    }

    @NotNull
    public final ObjectNode getNode() {
        return this.node;
    }

    @NotNull
    public final JsonNodeFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void put(@NotNull String $this$put, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        this.node.put($this$put, value2);
    }

    @Override
    public void put(@NotNull String $this$put, int value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        this.node.put($this$put, value2);
    }

    @Override
    public void put(@NotNull String $this$put, long value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        this.node.put($this$put, value2);
    }

    @Override
    public void put(@NotNull String $this$put, @Nullable JsonElement value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        JsonElement jsonElement = value2;
        if (jsonElement == null) {
            this.node.set($this$put, null);
        } else if (jsonElement instanceof RawJsonObject) {
            JsonDslKt.putRaw((JsonBuilderContext)this, $this$put, ((RawJsonObject)value2).getSerialized());
        } else if (jsonElement instanceof JsonObject) {
            this.node.set($this$put, (JsonNode)JsonDslKt.node((JsonObject)value2));
        } else if (jsonElement instanceof JsonArray) {
            this.node.set($this$put, (JsonNode)JsonDslKt.node((JsonArray)value2));
        } else if (jsonElement instanceof JsonValue) {
            this.node.set($this$put, (JsonNode)JsonDslKt.node((JsonValue)value2));
        } else {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"unknown JsonElement: ", (Object)value2.getClass().getSimpleName()));
        }
    }

    @Override
    public void put(@NotNull String $this$put, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        JsonNode jsonNode = this.mapper.valueToTree(value2);
        if (jsonNode == null) {
            return;
        }
        JsonNode tree = jsonNode;
        this.node.set($this$put, tree);
    }

    @Override
    public void put(@NotNull String $this$put, @NotNull Function1<? super JsonBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        ObjectNode objNode = this.factory.objectNode();
        Intrinsics.checkNotNullExpressionValue((Object)objNode, (String)"objNode");
        worker.invoke((Object)new JsonBuilderContextImpl(objNode, this.factory, JsonDslKt.getJackson()));
        this.node.set($this$put, (JsonNode)objNode);
    }

    @Override
    public void putValue(@NotNull String $this$putValue, @NotNull Function1<? super JsonValueBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter((Object)$this$putValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        JsonValueBuilderContextImpl context2 = new JsonValueBuilderContextImpl((Function1<? super JsonNode, Unit>)((Function1)new Function1<JsonNode, Unit>(this, $this$putValue){
            final /* synthetic */ JsonBuilderContextImpl this$0;
            final /* synthetic */ String $this_putValue;
            {
                this.this$0 = $receiver;
                this.$this_putValue = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull JsonNode newNode) {
                Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
                this.this$0.getNode().set(this.$this_putValue, newNode);
            }
        }), this.factory, this.mapper);
        worker.invoke((Object)context2);
    }

    @Override
    public void putArray(@NotNull String $this$putArray, @NotNull Function1<? super JsonArrayBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter((Object)$this$putArray, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        ArrayNode arrayNode = this.factory.arrayNode();
        this.node.set($this$putArray, (JsonNode)arrayNode);
        Intrinsics.checkNotNullExpressionValue((Object)arrayNode, (String)"arrayNode");
        worker.invoke((Object)new JsonArrayBuilderContextImpl(arrayNode, this.factory, JsonDslKt.getJackson()));
    }
}

