/*
 * Decompiled with CFR 0.152.
 */
package runtime.date;

import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import runtime.date.DateTimeMode;
import runtime.date.TimeOfDay;
import runtime.stringUtils.Symbols;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010\u001a\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u001a\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e\u001a)\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u001a\u001a\u001e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u001b\u001a\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001b\u001a\u0016\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e\u001a\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b\u001a\u000e\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b\u001a\n\u0010#\u001a\u00020$*\u00020\u001b\u001a\u001e\u0010%\u001a\u00020\u001b*\u00020\u00122\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\t\u001a\u0012\u0010'\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010#\u001a\u00020$\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"dateFormatter", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "dayOnlyDateFormatter", "fullDateTimeFormatter", "fullWithoutYearDateTimeFormatter", "timeOnlyFormatter", "withoutYearDateFormatter", "dateTimeZoneForIdOrNull", "Lorg/joda/time/DateTimeZone;", "id", "", "formatDate", "epochMillis", "", "nowMillis", "(JLjava/lang/Long;)Ljava/lang/String;", "dateTime", "Lorg/joda/time/LocalDate;", "now", "formatDateSpan", "from", "to", "formatDateTime", "mode", "Lruntime/date/DateTimeMode;", "(JLruntime/date/DateTimeMode;Ljava/lang/Long;)Ljava/lang/String;", "Lorg/joda/time/DateTime;", "formatFullDate", "formatFullDateTime", "formatTimeSpan", "setDefaultLocale", "", "name", "setDefaultTimeZone", "timeOfDay", "Lruntime/date/TimeOfDay;", "toDateTime", "timezone", "withTime", "platform-runtime"})
public final class DatesKt {
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)("" + 'd' + (Object)((Object)Symbols.Nbsp) + "MMM" + (Object)((Object)Symbols.Nbsp) + "YYYY"));
    private static final DateTimeFormatter withoutYearDateFormatter = DateTimeFormat.forPattern((String)("" + 'd' + (Object)((Object)Symbols.Nbsp) + "MMM"));
    private static final DateTimeFormatter dayOnlyDateFormatter = DateTimeFormat.forPattern((String)"d");
    private static final DateTimeFormatter fullDateTimeFormatter = DateTimeFormat.forPattern((String)("" + 'd' + (Object)((Object)Symbols.Nbsp) + "MMM" + (Object)((Object)Symbols.Nbsp) + "YYYY HH:mm"));
    private static final DateTimeFormatter timeOnlyFormatter = DateTimeFormat.forPattern((String)"HH:mm");
    private static final DateTimeFormatter fullWithoutYearDateTimeFormatter = DateTimeFormat.forPattern((String)("" + 'd' + (Object)((Object)Symbols.Nbsp) + "MMM HH:mm"));

    @NotNull
    public static final String formatDate(long epochMillis, @Nullable Long nowMillis) {
        DateTime dateTime2;
        Long l = nowMillis;
        if (l == null) {
            dateTime2 = null;
        } else {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            dateTime2 = new DateTime(it);
        }
        DateTime dateTime3 = dateTime2;
        DateTime now = dateTime3 == null ? new DateTime() : dateTime3;
        DateTime dateTime4 = new DateTime(epochMillis);
        l = dateTime4.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"dateTime.toLocalDate()");
        Long l3 = l;
        l = now.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"now.toLocalDate()");
        return DatesKt.formatDate((LocalDate)l3, (LocalDate)l);
    }

    public static /* synthetic */ String formatDate$default(long l, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = null;
        }
        return DatesKt.formatDate(l, l2);
    }

    @NotNull
    public static final String formatDate(@NotNull LocalDate dateTime2, @NotNull LocalDate now) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (dateTime2.getYear() == now.getYear()) {
            String string2 = withoutYearDateFormatter.print((ReadablePartial)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"withoutYearDateFormatter.print(dateTime)");
            string = string2;
        } else {
            string = DatesKt.formatFullDate(dateTime2);
        }
        return string;
    }

    @NotNull
    public static final String formatFullDate(@NotNull LocalDate dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        String string = dateFormatter.print((ReadablePartial)dateTime2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormatter.print(dateTime)");
        return string;
    }

    @NotNull
    public static final String formatDateTime(long epochMillis, @NotNull DateTimeMode mode2, @Nullable Long nowMillis) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Long l = nowMillis;
        if (l == null) {
            dateTime2 = null;
        } else {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            dateTime2 = new DateTime(it);
        }
        DateTime dateTime3 = dateTime2;
        DateTime now = dateTime3 == null ? new DateTime() : dateTime3;
        DateTime dateTime4 = new DateTime(epochMillis);
        return DatesKt.formatDateTime(dateTime4, mode2, now);
    }

    public static /* synthetic */ String formatDateTime$default(long l, DateTimeMode dateTimeMode, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeMode = DateTimeMode.DEFAULT;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        return DatesKt.formatDateTime(l, dateTimeMode, l2);
    }

    @NotNull
    public static final String formatDateTime(@NotNull DateTime dateTime2, @NotNull DateTimeMode mode2, @NotNull DateTime now) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (now.isBefore((ReadableInstant)dateTime2)) {
            String string2 = fullDateTimeFormatter.print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fullDateTimeFormatter.print(dateTime)");
            return string2;
        }
        Duration duration = new Duration((ReadableInstant)dateTime2, (ReadableInstant)now);
        if (mode2.isDefault$platform_runtime() && duration.getStandardMinutes() < 1L) {
            string = "just now";
        } else if (mode2.isDefault$platform_runtime() && duration.getStandardHours() < 1L) {
            string = "" + duration.getStandardMinutes() + 'm' + (Object)((Object)Symbols.Nbsp) + "ago";
        } else if (mode2.isDefault$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.withTimeAtStartOfDay(), (Object)now.withTimeAtStartOfDay())) {
            String string3 = timeOnlyFormatter.print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"timeOnlyFormatter.print(dateTime)");
            string = string3;
        } else if (mode2.isDefault$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string4 = fullWithoutYearDateTimeFormatter.print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fullWithoutYearDateTimeFormatter.print(dateTime)");
            string = string4;
        } else if (mode2.isTable$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string5 = DateTimeFormat.forPattern((String)("dd" + (Object)((Object)Symbols.Nbsp) + "MMM HH:mm")).print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"forPattern(\"dd${Symbols.Nbsp}MMM HH:mm\").print(dateTime)");
            string = string5;
        } else if (mode2.isTable$platform_runtime()) {
            String string6 = DateTimeFormat.forPattern((String)("dd" + (Object)((Object)Symbols.Nbsp) + "MMM" + (Object)((Object)Symbols.Nbsp) + "YYYY HH:mm")).print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"forPattern(\"dd${Symbols.Nbsp}MMM${Symbols.Nbsp}YYYY HH:mm\").print(dateTime)");
            string = string6;
        } else if (mode2.isCompact$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.dayOfYear(), (Object)now.dayOfYear()) && Intrinsics.areEqual((Object)dateTime2.year(), (Object)now.year())) {
            String string7 = DateTimeFormat.forPattern((String)"HH:mm").print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"forPattern(\"HH:mm\").print(dateTime)");
            string = string7;
        } else if (mode2.isCompact$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.weekOfWeekyear(), (Object)now.weekOfWeekyear())) {
            String string8 = DateTimeFormat.forPattern((String)"E").print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"forPattern(\"E\").print(dateTime)");
            string = string8;
        } else if (mode2.isCompact$platform_runtime() && (Intrinsics.areEqual((Object)dateTime2.year(), (Object)now.year()) || duration.getStandardDays() < 120L)) {
            String string9 = DateTimeFormat.forPattern((String)("MMM" + (Object)((Object)Symbols.Nbsp) + "dd")).print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"forPattern(\"MMM${Symbols.Nbsp}dd\").print(dateTime)");
            string = string9;
        } else if (mode2.isCompact$platform_runtime()) {
            String string10 = DateTimeFormat.forPattern((String)"YYYY").print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"forPattern(\"YYYY\").print(dateTime)");
            string = string10;
        } else {
            String string11 = fullDateTimeFormatter.print((ReadableInstant)dateTime2);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"fullDateTimeFormatter.print(dateTime)");
            string = string11;
        }
        return string;
    }

    @NotNull
    public static final String formatFullDateTime(long epochMillis) {
        String string = fullDateTimeFormatter.print(epochMillis);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fullDateTimeFormatter.print(epochMillis)");
        return string;
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull DateTime dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        return DatesKt.formatFullDateTime(dateTime2.getMillis());
    }

    public static final void setDefaultTimeZone(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        TimeZone.setDefault(TimeZone.getTimeZone(name2));
    }

    @NotNull
    public static final String formatTimeSpan(long from, long to) {
        String string;
        LocalDate nowDate = new LocalDate();
        LocalDate fromDate = new LocalDate(from);
        LocalDate toDate = new LocalDate(to);
        DateTimeFormatter mainFormat = nowDate.getYear() != fromDate.getYear() ? dateFormatter : withoutYearDateFormatter;
        if (fromDate.getYear() != toDate.getYear()) {
            string = mainFormat.print((ReadablePartial)fromDate) + "\u2009\u2013\u2009" + mainFormat.print((ReadablePartial)toDate);
        } else if (!Intrinsics.areEqual((Object)fromDate.monthOfYear(), (Object)toDate.monthOfYear())) {
            string = withoutYearDateFormatter.print((ReadablePartial)fromDate) + "\u2009\u2013\u2009" + mainFormat.print((ReadablePartial)toDate);
        } else if (fromDate.getDayOfMonth() != toDate.getDayOfMonth()) {
            string = dayOnlyDateFormatter.print((ReadablePartial)fromDate) + '\u2013' + mainFormat.print((ReadablePartial)toDate);
        } else {
            String string2 = mainFormat.print((ReadablePartial)fromDate);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mainFormat.print(fromDate)");
            string = string2;
        }
        return string;
    }

    public static final void setDefaultLocale(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Nullable
    public static final DateTimeZone dateTimeZoneForIdOrNull(@NotNull String id) {
        DateTimeZone dateTimeZone;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            dateTimeZone = DateTimeZone.forID((String)id);
        }
        catch (Throwable th) {
            dateTimeZone = null;
        }
        return dateTimeZone;
    }

    @NotNull
    public static final String formatDateSpan(long from, long to) {
        String string;
        LocalDate start2 = new LocalDate(from);
        LocalDate end = new LocalDate(to);
        if (start2.getYear() == end.getYear() && start2.getDayOfYear() == end.getDayOfYear()) {
            String string2 = dateFormatter.print((ReadablePartial)start2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormatter.print(start)");
            string = string2;
        } else {
            string = start2.getYear() == end.getYear() && start2.getMonthOfYear() == end.getMonthOfYear() ? dayOnlyDateFormatter.print((ReadablePartial)start2) + "\u2009\u2013\u2009" + dateFormatter.print((ReadablePartial)end) : (start2.getYear() == end.getYear() ? withoutYearDateFormatter.print((ReadablePartial)start2) + "\u2009\u2013\u2009" + dateFormatter.print((ReadablePartial)end) : dateFormatter.print((ReadablePartial)start2) + "\u2009\u2013\u2009" + dateFormatter.print((ReadablePartial)end));
        }
        return string;
    }

    @NotNull
    public static final DateTime toDateTime(@NotNull LocalDate $this$toDateTime, @NotNull TimeOfDay timeOfDay, @Nullable DateTimeZone timezone) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)$this$toDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeOfDay, (String)"timeOfDay");
        if (timeOfDay.getHours() == 24) {
            DateTime dateTime3 = $this$toDateTime.plusDays(1).toDateTimeAtStartOfDay(timezone);
            Intrinsics.checkNotNullExpressionValue((Object)dateTime3, (String)"{\n        this.plusDays(1).toDateTimeAtStartOfDay(timezone)\n    }");
            dateTime2 = dateTime3;
        } else {
            Integer n;
            LocalTime localTime = new LocalTime(timeOfDay.getHours(), timeOfDay.getMinutes(), (n = timeOfDay.getSeconds()) == null ? 0 : n);
            DateTime dateTime4 = $this$toDateTime.toDateTime(localTime, timezone);
            Intrinsics.checkNotNullExpressionValue((Object)dateTime4, (String)"{\n        val localTime = LocalTime(timeOfDay.hours, timeOfDay.minutes, timeOfDay.seconds ?: 0)\n        this.toDateTime(localTime, timezone)\n    }");
            dateTime2 = dateTime4;
        }
        return dateTime2;
    }

    public static /* synthetic */ DateTime toDateTime$default(LocalDate localDate, TimeOfDay timeOfDay, DateTimeZone dateTimeZone, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeZone = null;
        }
        return DatesKt.toDateTime(localDate, timeOfDay, dateTimeZone);
    }

    @NotNull
    public static final DateTime withTime(@NotNull DateTime $this$withTime, @NotNull TimeOfDay timeOfDay) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeOfDay, (String)"timeOfDay");
        if (timeOfDay.getHours() == 24) {
            DateTime dateTime3 = $this$withTime.plusDays(1).withTimeAtStartOfDay();
            Intrinsics.checkNotNullExpressionValue((Object)dateTime3, (String)"{\n        this.plusDays(1).withTimeAtStartOfDay()\n    }");
            dateTime2 = dateTime3;
        } else {
            Integer n;
            LocalTime localTime = new LocalTime(timeOfDay.getHours(), timeOfDay.getMinutes(), (n = timeOfDay.getSeconds()) == null ? 0 : n);
            DateTime dateTime4 = $this$withTime.withTime(localTime);
            Intrinsics.checkNotNullExpressionValue((Object)dateTime4, (String)"{\n        val localTime = LocalTime(timeOfDay.hours, timeOfDay.minutes, timeOfDay.seconds ?: 0)\n        this.withTime(localTime)\n    }");
            dateTime2 = dateTime4;
        }
        return dateTime2;
    }

    @NotNull
    public static final TimeOfDay timeOfDay(@NotNull DateTime $this$timeOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$timeOfDay, (String)"<this>");
        return new TimeOfDay($this$timeOfDay.getHourOfDay(), $this$timeOfDay.getMinuteOfHour(), null, 4, null);
    }
}

