/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import libraries.collections.MultiMap;
import libraries.collections.MultiMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.container.ComponentRegisterEntry;
import runtime.container.JvmTypeBasedComponentDescriptor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lruntime/container/ComponentRegistry;", "", "()V", "registrationMap", "Ljava/util/LinkedHashMap;", "Lruntime/container/ComponentRegisterEntry;", "addAll", "", "descriptors", "", "Lruntime/container/JvmTypeBasedComponentDescriptor;", "buildRegistrationMap", "Llibraries/collections/MultiMap;", "Ljava/lang/reflect/Type;", "copy", "", "tryGetEntry", "request", "platform-runtime"})
public final class ComponentRegistry {
    @NotNull
    private LinkedHashMap<Object, ComponentRegisterEntry> registrationMap = new LinkedHashMap(8);

    @NotNull
    public final MultiMap<Type, JvmTypeBasedComponentDescriptor> buildRegistrationMap(@NotNull Collection<? extends JvmTypeBasedComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        MultiMap registrationMap = MultiMapKt.linkedMultiMap$default(null, 1, null);
        for (JvmTypeBasedComponentDescriptor jvmTypeBasedComponentDescriptor : descriptors) {
            for (Type registration : jvmTypeBasedComponentDescriptor.getRegistrations()) {
                registrationMap.put(registration, jvmTypeBasedComponentDescriptor);
            }
        }
        return registrationMap;
    }

    public final void addAll(@NotNull Collection<? extends JvmTypeBasedComponentDescriptor> descriptors) {
        Object value2;
        Map.Entry<Object, Object> entry;
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        MultiMap<Type, JvmTypeBasedComponentDescriptor> updateMap = this.buildRegistrationMap(descriptors);
        LinkedHashMap<Object, ComponentRegisterEntry> lastMap = this.registrationMap;
        LinkedHashMap newMap = new LinkedHashMap(lastMap.size());
        Map entry22 = lastMap;
        boolean bl = false;
        Iterator<Map.Entry<Object, Object>> iterator2 = entry22.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            Object key2 = entry3.getKey();
            entry = entry2;
            boolean bl3 = false;
            value2 = (ComponentRegisterEntry)entry.getValue();
            newMap.put(key2, new ComponentRegisterEntry((ComponentRegisterEntry)value2));
        }
        for (Map.Entry<Object, Object> entry4 : updateMap) {
            Object object;
            value2 = entry4;
            boolean bl4 = false;
            Type key3 = (Type)value2.getKey();
            entry = entry4;
            boolean bl5 = false;
            List value3 = (List)entry.getValue();
            Map $this$getOrPut$iv = newMap;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key3);
            if (value$iv == null) {
                boolean bl6 = false;
                ComponentRegisterEntry answer$iv = new ComponentRegisterEntry();
                $this$getOrPut$iv.put(key3, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ComponentRegisterEntry entry42 = (ComponentRegisterEntry)object;
            for (JvmTypeBasedComponentDescriptor v : value3) {
                entry42.add(v);
            }
        }
        this.registrationMap = newMap;
    }

    @Nullable
    public final ComponentRegisterEntry tryGetEntry(@NotNull Type request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.registrationMap.get(request);
    }

    @NotNull
    public final Map<Object, ComponentRegisterEntry> copy() {
        return MapsKt.toMutableMap((Map)this.registrationMap);
    }
}

