/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.FailureInfo;
import runtime.RpcException;
import runtime.ValidationError;
import runtime.ValidationResult;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"INTERNAL_SERVER_ERROR_MESSAGE", "", "internalFailure", "Lruntime/FailureInfo;", "getInternalFailure", "(Lruntime/FailureInfo;)Ljava/lang/String;", "getFailureMessage", "", "message", "Lruntime/ValidationResult;", "messageQuick", "Lruntime/ValidationError;", "platform-runtime"})
public final class RpcExceptionKt {
    @NotNull
    public static final String INTERNAL_SERVER_ERROR_MESSAGE = "Internal server error occurred. Please contact the server administrator or see server logs for details.";

    @Nullable
    public static final String getInternalFailure(@NotNull FailureInfo $this$internalFailure) {
        Intrinsics.checkNotNullParameter((Object)$this$internalFailure, (String)"<this>");
        return $this$internalFailure.getAuthenticationError() != null || $this$internalFailure.getValidationError() != null || $this$internalFailure.getSecurityError() != null || $this$internalFailure.getRequestError() != null || $this$internalFailure.getTransportError() != null || $this$internalFailure.getNotFoundError() != null ? null : INTERNAL_SERVER_ERROR_MESSAGE;
    }

    @NotNull
    public static final String message(@NotNull FailureInfo $this$message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"<this>");
        if ($this$message.getAuthenticationError() != null) {
            string = $this$message.getAuthenticationError();
        } else if ($this$message.getSecurityError() != null) {
            string = $this$message.getSecurityError();
        } else if ($this$message.getValidationError() != null) {
            string = RpcExceptionKt.message($this$message.getValidationError());
        } else if ($this$message.getRequestError() != null) {
            string = $this$message.getRequestError();
        } else if ($this$message.getTransportError() != null) {
            string = $this$message.getTransportError();
        } else if ($this$message.getNotFoundError() != null) {
            string = $this$message.getNotFoundError();
        } else {
            String string2 = RpcExceptionKt.getInternalFailure($this$message);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String message(@NotNull ValidationResult $this$message) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"<this>");
        ValidationError validationError = (ValidationError)ArraysKt.firstOrNull((Object[])$this$message.getErrors());
        return validationError == null ? "Validation error" : RpcExceptionKt.messageQuick(validationError);
    }

    @NotNull
    public static final String messageQuick(@NotNull ValidationError $this$messageQuick) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
        String string2 = $this$messageQuick.getParameter();
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string = "Validation of parameter " + it + " failed: " + $this$messageQuick.getMessage();
        }
        String string4 = string;
        return string4 == null ? $this$messageQuick.getMessage() : string4;
    }

    @NotNull
    public static final String messageQuick(@NotNull ValidationResult $this$messageQuick) {
        Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
        ValidationError validationError = (ValidationError)ArraysKt.firstOrNull((Object[])$this$messageQuick.getErrors());
        return validationError == null ? "Validation error" : validationError.getMessage();
    }

    @NotNull
    public static final String messageQuick(@NotNull FailureInfo $this$messageQuick) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
        if ($this$messageQuick.getAuthenticationError() != null) {
            string = $this$messageQuick.getAuthenticationError();
        } else if ($this$messageQuick.getSecurityError() != null) {
            string = $this$messageQuick.getSecurityError();
        } else if ($this$messageQuick.getValidationError() != null) {
            string = RpcExceptionKt.messageQuick($this$messageQuick.getValidationError());
        } else if ($this$messageQuick.getRequestError() != null) {
            string = $this$messageQuick.getRequestError();
        } else if ($this$messageQuick.getTransportError() != null) {
            string = $this$messageQuick.getTransportError();
        } else if ($this$messageQuick.getNotFoundError() != null) {
            string = $this$messageQuick.getNotFoundError();
        } else {
            String string2 = RpcExceptionKt.getInternalFailure($this$messageQuick);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String getFailureMessage(@NotNull Throwable $this$getFailureMessage) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getFailureMessage, (String)"<this>");
        Throwable throwable = $this$getFailureMessage;
        return throwable instanceof RpcException ? RpcExceptionKt.message(((RpcException)$this$getFailureMessage).getFailure()) : ((string = $this$getFailureMessage.getMessage()) == null ? $this$getFailureMessage.toString() : string);
    }
}

