/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo;

import circlet.client.api.TodoItemRecord;
import circlet.permissions.FeatureFlagsVm;
import circlet.platform.api.JodaDate;
import circlet.platform.api.Ref;
import circlet.platform.client.KCircletClient;
import circlet.todo.KnownCategories;
import circlet.todo.TodoEditorProgress;
import circlet.todo.TodoEditorVm;
import circlet.todo.TodoEditorVmInitialized;
import circlet.todo.TodoEditorVmKt;
import circlet.todo.TodoIndicatorVmImpl;
import circlet.todo.TodoListItemVm;
import circlet.todo.TodoListItemsByCategoriesImpl;
import circlet.todo.TodoListVm;
import circlet.todo.TodoTreeItem;
import circlet.todo.TodoTreeItemInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import libraries.coroutines.extra.CoroutineBuildersExtKt;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchKt;
import runtime.reactive.CellableKt;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.SequentialLifetimes;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\"2\u000e\u0010,\u001a\n\u0018\u00010-j\u0004\u0018\u0001`.H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u0010+\u001a\u00020\"H\u0016J\u001c\u00100\u001a\u00020)2\n\u00101\u001a\u00060\"j\u0002`22\u0006\u0010+\u001a\u00020\"H\u0016J\u0010\u00103\u001a\u00020)2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020)2\u0006\u0010+\u001a\u00020\"H\u0016J\u0018\u00107\u001a\u00020)2\u0006\u0010+\u001a\u00020\"2\u0006\u00108\u001a\u00020\u001aH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR,\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0!0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcirclet/todo/TodoListVmImpl;", "Lcirclet/todo/TodoListVm;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "client", "Lcirclet/platform/client/KCircletClient;", "featureFlags", "Lcirclet/permissions/FeatureFlagsVm;", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/platform/client/KCircletClient;Lcirclet/permissions/FeatureFlagsVm;)V", "getClient", "()Lcirclet/platform/client/KCircletClient;", "currentItems", "Lruntime/reactive/MutableProperty;", "", "Lcirclet/todo/TodoListItemVm;", "getCurrentItems", "()Lruntime/reactive/MutableProperty;", "editorVm", "Lcirclet/todo/TodoEditorVm;", "getEditorVm", "()Lcirclet/todo/TodoEditorVm;", "indicatorVm", "Lcirclet/todo/TodoIndicatorVmImpl;", "getIndicatorVm", "()Lcirclet/todo/TodoIndicatorVmImpl;", "initialized", "", "getInitialized", "itemsByCategories", "Lcirclet/todo/TodoListItemsByCategoriesImpl;", "getItemsByCategories", "()Lcirclet/todo/TodoListItemsByCategoriesImpl;", "itemsByLinks", "", "", "getItemsByLinks", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "postponedActions", "", "Lkotlin/Function0;", "", "add", "text", "dueDate", "Lcirclet/platform/api/JodaDate;", "Lcirclet/platform/api/ADate;", "addUnique", "edit", "id", "Lcirclet/platform/api/TID;", "recalculateItemsByCategoriesAndLinks", "modelValue", "Lcirclet/todo/TodoEditorVmInitialized;", "remove", "toggle", "done", "app-state"})
public final class TodoListVmImpl
implements TodoListVm {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final KCircletClient client;
    @NotNull
    private final TodoEditorVm editorVm;
    @NotNull
    private final TodoIndicatorVmImpl indicatorVm;
    @NotNull
    private final MutableProperty<Boolean> initialized;
    @NotNull
    private final MutableProperty<List<TodoListItemVm>> currentItems;
    @NotNull
    private final TodoListItemsByCategoriesImpl itemsByCategories;
    @NotNull
    private final MutableProperty<Map<String, List<TodoListItemVm>>> itemsByLinks;
    @NotNull
    private final List<Function0<Unit>> postponedActions;

    public TodoListVmImpl(@NotNull Lifetime lifetime, @NotNull KCircletClient client, @NotNull FeatureFlagsVm featureFlags2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)featureFlags2, (String)"featureFlags");
        this.lifetime = lifetime;
        this.client = client;
        this.editorVm = new TodoEditorVm(this.lifetime, this.client, CellableKt.mutableProperty(true), null, null, 24, null);
        this.indicatorVm = new TodoIndicatorVmImpl();
        this.initialized = CellableKt.mutableProperty(false);
        this.currentItems = CellableKt.mutableProperty(CollectionsKt.emptyList());
        this.itemsByCategories = new TodoListItemsByCategoriesImpl();
        this.itemsByLinks = CellableKt.mutableProperty(MapsKt.emptyMap());
        boolean bl = false;
        this.postponedActions = new ArrayList();
        final SequentialLifetimes itemsLifetimes = new SequentialLifetimes(this.lifetime);
        SourceKt.view((Source)this.getEditorVm().getModel(), this.lifetime, (Function2)new Function2<Lifetime, TodoEditorVmInitialized, Unit>(){

            public final void invoke(@NotNull Lifetime modelLt, final @Nullable TodoEditorVmInitialized modelValue) {
                Intrinsics.checkNotNullParameter((Object)modelLt, (String)"modelLt");
                if (modelValue != null) {
                    modelValue.getAllItems().forEach(itemsLifetimes.next(), (Function1<List<TodoListItemVm>, Unit>)((Function1)new Function1<List<? extends TodoListItemVm>, Unit>(){

                        public final void invoke(@NotNull List<TodoListItemVm> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            this.getCurrentItems().setValue(it);
                        }
                    }));
                    modelValue.getProgress().forEach(modelLt, (Function1<TodoEditorProgress, Unit>)((Function1)new Function1<TodoEditorProgress, Unit>(){

                        public final void invoke(@NotNull TodoEditorProgress it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.getIndicatorVm().update(it.getTotal() - it.getCompleted());
                        }
                    }));
                    this.getInitialized().setValue(true);
                    this.recalculateItemsByCategoriesAndLinks(modelValue);
                    modelValue.getItemsUpdated().forEach(modelLt, (Function1<Unit, Unit>)((Function1)new Function1<Unit, Unit>(){

                        public final void invoke(@NotNull Unit it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.recalculateItemsByCategoriesAndLinks(modelValue);
                        }
                    }));
                } else {
                    this.getItemsByCategories().clear();
                    this.getItemsByLinks().setValue(MapsKt.emptyMap());
                    this.getCurrentItems().setValue(CollectionsKt.emptyList());
                    this.getInitialized().setValue(false);
                }
            }
        });
        SourceKt.whenTrue(this.getInitialized(), this.lifetime, (Function1<? super Lifetime, Unit>)((Function1)new Function1<Lifetime, Unit>(){

            public final void invoke(@NotNull Lifetime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CoroutineBuildersExtKt.launch$default(this.getLifetime(), DispatchKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ TodoListVmImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                List toExecute = CollectionsKt.toList((Iterable)this.this$0.postponedActions);
                                this.this$0.postponedActions.clear();
                                Iterable $this$forEach$iv = toExecute;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    Function0 it = (Function0)element$iv;
                                    boolean bl = false;
                                    it.invoke();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 6, null);
            }
        }));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final KCircletClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public TodoEditorVm getEditorVm() {
        return this.editorVm;
    }

    @Override
    @NotNull
    public TodoIndicatorVmImpl getIndicatorVm() {
        return this.indicatorVm;
    }

    @NotNull
    public MutableProperty<Boolean> getInitialized() {
        return this.initialized;
    }

    @NotNull
    public MutableProperty<List<TodoListItemVm>> getCurrentItems() {
        return this.currentItems;
    }

    @Override
    @NotNull
    public TodoListItemsByCategoriesImpl getItemsByCategories() {
        return this.itemsByCategories;
    }

    @NotNull
    public MutableProperty<Map<String, List<TodoListItemVm>>> getItemsByLinks() {
        return this.itemsByLinks;
    }

    /*
     * WARNING - void declaration
     */
    private final void recalculateItemsByCategoriesAndLinks(TodoEditorVmInitialized modelValue) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$forEach$iv;
        List<TodoListItemVm> allItems = modelValue.getAllItems().getValue();
        boolean bl = false;
        Map idsForBlogs = new LinkedHashMap();
        boolean bl2 = false;
        Map idsForChats = new LinkedHashMap();
        boolean bl3 = false;
        Map idsForIssues = new LinkedHashMap();
        boolean bl4 = false;
        Map idsForDocuments = new LinkedHashMap();
        boolean bl5 = false;
        Map itemsForBlogs = new LinkedHashMap();
        boolean bl6 = false;
        Map itemsForChats = new LinkedHashMap();
        boolean bl7 = false;
        Map itemsForIssues = new LinkedHashMap();
        boolean bl8 = false;
        Map itemsForDocuments = new LinkedHashMap();
        boolean bl9 = false;
        Map messageItems = new LinkedHashMap();
        Iterable $this$sortedBy$iv = allItems;
        boolean $i$f$sortedBy = false;
        boolean bl10 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TodoListItemVm it = (TodoListItemVm)a;
                boolean bl2 = false;
                Comparable comparable = it.getRecord().getDueDate();
                it = (TodoListItemVm)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                JodaDate jodaDate = it.getRecord().getDueDate();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)jodaDate);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            TodoListItemVm it = (TodoListItemVm)element$iv;
            boolean bl11 = false;
            if (it.getExtId() != null) {
                String string = it.getCategory().getName();
                Object object2 = Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getBlog().getName()) ? idsForBlogs : (Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getChat().getName()) ? idsForChats : (Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getIssue().getName()) ? idsForIssues : (object = Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getDocument().getName()) ? idsForDocuments : null)));
                if (object != null) {
                    object.put(it.getExtId(), it.getRecord().getStatus());
                }
                string = it.getCategory().getName();
                Object object3 = object = Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getChat().getName()) ? messageItems : null;
                if (object != null) {
                    object.put(it.getExtId(), it);
                }
            }
            object = it.getLink();
            boolean bl12 = false;
            if (!(object.length() > 0)) continue;
            String string = it.getCategory().getName();
            Object object4 = Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getBlog().getName()) ? itemsForBlogs : (Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getChat().getName()) ? itemsForChats : (Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getIssue().getName()) ? itemsForIssues : (object = Intrinsics.areEqual((Object)string, (Object)KnownCategories.INSTANCE.getDocument().getName()) ? itemsForDocuments : null)));
            if (object == null) continue;
            object.put(it.getLink(), it.getRecord().getStatus());
        }
        this.getItemsByCategories().setIds(idsForBlogs, idsForChats, idsForIssues, idsForDocuments);
        this.getItemsByCategories().setItems(messageItems);
        $this$forEach$iv = allItems;
        Property property2 = this.getItemsByLinks();
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            TodoListItemVm it = (TodoListItemVm)element$iv$iv;
            boolean bl13 = false;
            String key$iv$iv = it.getLink();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl14 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map2 = destination$iv$iv;
        property2.setValue(map2);
    }

    @Override
    public void add(@NotNull String text2, @Nullable JodaDate dueDate) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (((Boolean)this.getInitialized().getValue()).booleanValue()) {
            TodoEditorVmInitialized todoEditorVmInitialized = this.getEditorVm().getModel().getValue();
            if (todoEditorVmInitialized != null) {
                todoEditorVmInitialized.addTopItem(text2, dueDate);
            }
        } else {
            this.postponedActions.add(new Function0<Unit>(this, text2, dueDate){
                final /* synthetic */ TodoListVmImpl this$0;
                final /* synthetic */ String $text;
                final /* synthetic */ JodaDate $dueDate;
                {
                    this.this$0 = $receiver;
                    this.$text = $text;
                    this.$dueDate = $dueDate;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.add(this.$text, this.$dueDate);
                }
            });
        }
    }

    @Override
    public void addUnique(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (((Boolean)this.getInitialized().getValue()).booleanValue()) {
            boolean alreadyExists;
            block6: {
                boolean bl;
                Iterable $this$any$iv = (Iterable)this.getCurrentItems().getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TodoListItemVm it = (TodoListItemVm)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getRecord().getContent().display(), (Object)text2)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = alreadyExists = false;
                }
            }
            if (!alreadyExists) {
                TodoListVm.DefaultImpls.add$default(this, text2, null, 2, null);
            }
        } else {
            this.postponedActions.add(new Function0<Unit>(this, text2){
                final /* synthetic */ TodoListVmImpl this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = $receiver;
                    this.$text = $text;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.addUnique(this.$text);
                }
            });
        }
    }

    @Override
    public void remove(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (((Boolean)this.getInitialized().getValue()).booleanValue()) {
            Object v0;
            Object object;
            block4: {
                object = (Iterable)this.getCurrentItems().getValue();
                boolean bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    TodoListItemVm it = (TodoListItemVm)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getLink(), (Object)text2)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            TodoListItemVm item2 = v0;
            if (item2 != null && (object = this.getEditorVm().getModel().getValue()) != null) {
                ((TodoEditorVmInitialized)object).deleteItem(item2.getAnchor());
            }
        } else {
            this.postponedActions.add(new Function0<Unit>(this, text2){
                final /* synthetic */ TodoListVmImpl this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = $receiver;
                    this.$text = $text;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.remove(this.$text);
                }
            });
        }
    }

    @Override
    public void edit(@NotNull String id, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (((Boolean)this.getInitialized().getValue()).booleanValue()) {
            Object v0;
            Object object;
            block4: {
                object = (Iterable)this.getCurrentItems().getValue();
                boolean bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    TodoListItemVm it = (TodoListItemVm)t;
                    boolean bl3 = false;
                    if (!(it.getRef() != null && Intrinsics.areEqual((Object)it.getRecord().getId(), (Object)id))) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            TodoListItemVm item2 = v0;
            if (item2 != null && (object = this.getEditorVm().getModel().getValue()) != null) {
                Ref<TodoItemRecord> ref2 = item2.getRef();
                Intrinsics.checkNotNull(ref2);
                TodoTreeItem cfr_ignored_0 = (TodoTreeItem)((TodoEditorVmInitialized)object).editItemText((TodoTreeItemInterface)TodoEditorVmKt.toTreeItem(ref2, item2.getOptimistic(), item2.getCategory()), text2, item2.getRecord().getDueDate());
            }
        } else {
            this.postponedActions.add(new Function0<Unit>(this, id, text2){
                final /* synthetic */ TodoListVmImpl this$0;
                final /* synthetic */ String $id;
                final /* synthetic */ String $text;
                {
                    this.this$0 = $receiver;
                    this.$id = $id;
                    this.$text = $text;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.edit(this.$id, this.$text);
                }
            });
        }
    }

    @Override
    public void toggle(@NotNull String text2, boolean done) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (((Boolean)this.getInitialized().getValue()).booleanValue()) {
            Object v0;
            Object object;
            block4: {
                object = (Iterable)this.getCurrentItems().getValue();
                boolean bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    TodoListItemVm it = (TodoListItemVm)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getRecord().getContent().display(), (Object)text2)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            TodoListItemVm item2 = v0;
            if (item2 != null && (object = this.getEditorVm().getModel().getValue()) != null) {
                ((TodoEditorVmInitialized)object).toggleItemDone(TodoEditorVmKt.toTreeItem(item2.getRef(), item2.getOptimistic(), item2.getCategory()), done);
            }
        } else {
            this.postponedActions.add(new Function0<Unit>(this, text2, done){
                final /* synthetic */ TodoListVmImpl this$0;
                final /* synthetic */ String $text;
                final /* synthetic */ boolean $done;
                {
                    this.this$0 = $receiver;
                    this.$text = $text;
                    this.$done = $done;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.toggle(this.$text, this.$done);
                }
            });
        }
    }
}

