/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo;

import circlet.client.api.TodoAnchor;
import circlet.client.api.TodoContent;
import circlet.client.api.TodoItemContent;
import circlet.client.api.TodoItemRecord;
import circlet.platform.api.Ref;
import circlet.platform.client.RefResolveKt;
import circlet.todo.TodoItemCategory;
import circlet.todo.TodoItemCategoryKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010#\u001a\u00020\u001dH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lcirclet/todo/TodoListItemVm;", "", "ref", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/TodoItemRecord;", "optimistic", "(Lcirclet/platform/api/Ref;Lcirclet/client/api/TodoItemRecord;)V", "anchor", "Lcirclet/client/api/TodoAnchor;", "getAnchor", "()Lcirclet/client/api/TodoAnchor;", "category", "Lcirclet/todo/TodoItemCategory;", "getCategory", "()Lcirclet/todo/TodoItemCategory;", "extId", "", "Lcirclet/platform/api/TID;", "getExtId", "()Ljava/lang/String;", "link", "getLink", "getOptimistic", "()Lcirclet/client/api/TodoItemRecord;", "record", "getRecord", "getRef", "()Lcirclet/platform/api/Ref;", "sortingKey", "", "getSortingKey", "()I", "equals", "", "other", "hashCode", "app-state"})
public final class TodoListItemVm {
    @Nullable
    private final Ref<TodoItemRecord> ref;
    @Nullable
    private final TodoItemRecord optimistic;
    @NotNull
    private final TodoItemRecord record;
    @NotNull
    private final TodoAnchor anchor;
    @NotNull
    private final TodoItemCategory category;
    @NotNull
    private final String link;
    private final int sortingKey;
    @Nullable
    private final String extId;

    public TodoListItemVm(@Nullable Ref<TodoItemRecord> ref2, @Nullable TodoItemRecord optimistic) {
        Object object;
        TodoItemRecord todoItemRecord;
        this.ref = ref2;
        this.optimistic = optimistic;
        Object object2 = this.ref;
        TodoItemRecord todoItemRecord2 = todoItemRecord = object2 == null ? null : RefResolveKt.resolve(object2);
        if (todoItemRecord == null) {
            object2 = this.optimistic;
            if (object2 == null) {
                String string = "wrong TodoListItemVm";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            object = object2;
        } else {
            object = todoItemRecord;
        }
        this.record = object;
        this.anchor = new TodoAnchor(this.record.getId(), this.record.getTemporaryId());
        Triple<TodoItemCategory, String, Integer> res = TodoItemCategoryKt.calcCategoryAndLinkAndSortingKey(this.record);
        this.category = (TodoItemCategory)res.getFirst();
        this.link = (String)res.getSecond();
        this.sortingKey = ((Number)res.getThird()).intValue();
        TodoItemContent todoItemContent = this.record.getContent();
        object2 = todoItemContent instanceof TodoContent ? (TodoContent)todoItemContent : null;
        this.extId = object2 == null ? null : ((TodoContent)object2).getExtId();
    }

    @Nullable
    public final Ref<TodoItemRecord> getRef() {
        return this.ref;
    }

    @Nullable
    public final TodoItemRecord getOptimistic() {
        return this.optimistic;
    }

    @NotNull
    public final TodoItemRecord getRecord() {
        return this.record;
    }

    @NotNull
    public final TodoAnchor getAnchor() {
        return this.anchor;
    }

    @NotNull
    public final TodoItemCategory getCategory() {
        return this.category;
    }

    @NotNull
    public final String getLink() {
        return this.link;
    }

    public final int getSortingKey() {
        return this.sortingKey;
    }

    @Nullable
    public final String getExtId() {
        return this.extId;
    }

    public boolean equals(@Nullable Object other) {
        TodoListItemVm oth;
        if (this == other) {
            return true;
        }
        TodoListItemVm todoListItemVm = oth = other instanceof TodoListItemVm ? (TodoListItemVm)other : null;
        return Intrinsics.areEqual((Object)this.anchor, (Object)(todoListItemVm == null ? null : todoListItemVm.anchor)) && this.record.getStatus() == oth.record.getStatus() && Intrinsics.areEqual((Object)this.record.getContent(), (Object)oth.record.getContent());
    }

    public int hashCode() {
        return this.anchor.hashCode() + this.record.getStatus().hashCode() + this.record.getContent().hashCode();
    }
}

