/*
 * Decompiled with CFR 0.152.
 */
package circlet.electron;

import circlet.electron.DesktopAppDownloadVM;
import circlet.electron.DownloadItemController;
import circlet.electron.DownloadItemInfo;
import circlet.electron.DownloadItemState;
import circlet.electron.DownloadItemVm;
import circlet.electron.DownloadVmKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchJvmKt;
import runtime.reactive.CellableKt;
import runtime.reactive.MutableProperty;
import runtime.reactive.SequentialLifetimes;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\fJ6\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcirclet/electron/DesktopAppDownloadVM;", "", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "controller", "Lcirclet/electron/DownloadItemController;", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/electron/DownloadItemController;)V", "getController", "()Lcirclet/electron/DownloadItemController;", "downloads", "Lruntime/reactive/MutableProperty;", "", "", "Lcirclet/electron/DownloadItemVm;", "addItem", "item", "Lcirclet/electron/DownloadItemInfo;", "onPathDefined", "Lkotlin/Function1;", "", "getItem", "itemId", "onItemDone", "id", "errorMessage", "state", "onItemUpdated", "fileName", "path", "totalBytes", "", "receivedBytes", "removeItem", "app-state"})
public final class DesktopAppDownloadVM {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final DownloadItemController controller;
    @NotNull
    private final MutableProperty<Map<String, DownloadItemVm>> downloads;

    public DesktopAppDownloadVM(@NotNull Lifetime lifetime, @NotNull DownloadItemController controller) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.lifetime = lifetime;
        this.controller = controller;
        boolean bl = false;
        this.downloads = CellableKt.mutableProperty((Map)new LinkedHashMap());
        final SequentialLifetimes debugLifetime = new SequentialLifetimes(this.lifetime);
        this.downloads.forEach(this.lifetime, (Function1<Map<String, DownloadItemVm>, Unit>)((Function1)new Function1<Map<String, DownloadItemVm>, Unit>(){

            public final void invoke(@NotNull Map<String, DownloadItemVm> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Lifetime nestedSeqLt = debugLifetime.next();
                Iterable $this$forEach$iv = it.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DownloadItemVm it2 = (DownloadItemVm)element$iv;
                    boolean bl = false;
                    DownloadVmKt.access$getLog$p().info(Intrinsics.stringPlus((String)"###### Path: ", (Object)it2.getPath().getValue()));
                    it2.getPath().forEach(nestedSeqLt, (Function1<String, Unit>)((Function1)1.1.INSTANCE));
                }
            }
        }));
    }

    @NotNull
    public final DownloadItemController getController() {
        return this.controller;
    }

    @NotNull
    public final DownloadItemVm addItem(@NotNull DownloadItemInfo item2, @NotNull Function1<? super DownloadItemVm, Unit> onPathDefined) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        Intrinsics.checkNotNullParameter(onPathDefined, (String)"onPathDefined");
        DownloadItemVm itemVm = new DownloadItemVm(this.lifetime, this.controller, item2, onPathDefined);
        Map<String, DownloadItemVm> map2 = this.downloads.getValue();
        String string = item2.getId();
        boolean bl = false;
        map2.put(string, itemVm);
        this.downloads.forceNotify();
        return itemVm;
    }

    private final DownloadItemVm getItem(String itemId) {
        return this.downloads.getValue().get(itemId);
    }

    public final void onItemUpdated(@NotNull String id, @NotNull String fileName, @NotNull String path2, long totalBytes, long receivedBytes, @NotNull String state2) {
        DownloadItemVm itemVm;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        DownloadItemVm downloadItemVm = itemVm = this.getItem(id);
        if (downloadItemVm != null) {
            DownloadItemVm downloadItemVm2 = downloadItemVm;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItemVm it = downloadItemVm2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)state2, (Object)"interrupted") && !itemVm.getState().getValue().isTerminal()) {
                itemVm.getState().setValue(DownloadItemState.Paused);
            } else {
                it.getReceivedBytes().setValue(receivedBytes);
                if (((Number)it.getTotalBytes().getValue()).longValue() == 0L && totalBytes != 0L) {
                    it.getTotalBytes().setValue(totalBytes);
                }
                it.getPath().setValue(path2);
                it.getFileName().setValue(fileName);
                if (receivedBytes > 0L && itemVm.getState().getValue() == DownloadItemState.Created) {
                    itemVm.getState().setValue(DownloadItemState.InProgress);
                }
            }
        }
    }

    public final void onItemDone(@NotNull String id, @Nullable String errorMessage, @NotNull String state2) {
        block13: {
            DownloadItemVm itemVm;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            DownloadItemVm downloadItemVm = itemVm = this.getItem(id);
            if (downloadItemVm == null) break block13;
            DownloadItemVm downloadItemVm2 = downloadItemVm;
            boolean bl = false;
            boolean bl2 = false;
            DownloadItemVm vm = downloadItemVm2;
            boolean bl3 = false;
            int n = -1;
            switch (state2.hashCode()) {
                case 476588369: {
                    if (state2.equals("cancelled")) {
                        n = 1;
                    }
                    break;
                }
                case -1947652542: {
                    if (state2.equals("interrupted")) {
                        n = 2;
                    }
                    break;
                }
                case -1402931637: {
                    if (state2.equals("completed")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    vm.getState().setValue(DownloadItemState.Cancelled);
                    vm.getErrorMessage().setValue(errorMessage);
                    break;
                }
                case 2: {
                    vm.getState().setValue(DownloadItemState.Interrupted);
                    vm.getErrorMessage().setValue(errorMessage);
                    break;
                }
                case 3: {
                    vm.getState().setValue(DownloadItemState.Completed);
                    break;
                }
                default: {
                    DownloadVmKt.access$getLog$p().warn(Intrinsics.stringPlus((String)"Unexpected download item state: ", (Object)state2));
                    vm.getState().setValue(DownloadItemState.Completed);
                }
            }
            this.removeItem(id);
        }
    }

    public final void removeItem(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        DownloadItemVm vm = this.downloads.getValue().remove(itemId);
        DispatchJvmKt.getUiDispatch().dispatch(10000, (Function0<Unit>)((Function0)new Function0<Unit>(vm){
            final /* synthetic */ DownloadItemVm $vm;
            {
                this.$vm = $vm;
                super(0);
            }

            public final void invoke() {
                Boolean bl;
                DownloadItemVm downloadItemVm = this.$vm;
                if (downloadItemVm == null) {
                    bl = null;
                } else {
                    LifetimeSource lifetimeSource = downloadItemVm.getAlertLifetime();
                    bl = lifetimeSource.isTerminated();
                }
                if (Intrinsics.areEqual(bl, (Object)false)) {
                    this.$vm.getAlertLifetime().terminate();
                }
            }
        }));
        this.downloads.forceNotify();
    }
}

