/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.code;

import circlet.client.api.GitFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.FileExtensionsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\b"}, d2={"getTypeByExtension", "Lcirclet/client/api/GitFileType;", "path", "", "getTypesByExtension", "", "extension", "getTypesByFileName", "code-common"})
public final class FileContentTypeKt {
    @Nullable
    public static final GitFileType getTypeByExtension(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return (GitFileType)((Object)CollectionsKt.firstOrNull(FileContentTypeKt.getTypesByFileName(path2)));
    }

    @NotNull
    public static final List<GitFileType> getTypesByFileName(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = StringsKt.substringAfterLast((String)path2, (char)'.', (String)"");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String extension = string3;
        return FileContentTypeKt.getTypesByExtension(extension);
    }

    @NotNull
    public static final List<GitFileType> getTypesByExtension(@NotNull String extension) {
        boolean bl;
        GitFileType gitFileType;
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean bl2 = false;
        List types2 = new ArrayList();
        if (FileExtensionsKt.getKNOWN_TEXT_EXTENSIONS().contains(extension)) {
            Collection collection = types2;
            gitFileType = GitFileType.TEXT;
            bl = false;
            collection.add(gitFileType);
        }
        if (FileExtensionsKt.getKNOWN_IMAGE_EXTENSIONS().contains(extension)) {
            Collection collection = types2;
            gitFileType = GitFileType.IMAGE;
            bl = false;
            collection.add(gitFileType);
        }
        if (FileExtensionsKt.getKNOWN_BINARY_EXTENSIONS().contains(extension)) {
            Collection collection = types2;
            gitFileType = GitFileType.BINARY_OTHER;
            bl = false;
            collection.add(gitFileType);
        }
        return types2;
    }
}

