/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.CalendarEventSpec;
import circlet.common.calendar.ClosedTimeInterval;
import circlet.common.calendar.DatesInterval;
import circlet.common.calendar.EventCalculations;
import circlet.common.calendar.EventCalculationsKt;
import circlet.common.calendar.EventCounter;
import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.MeetingStart;
import circlet.common.calendar.RecurrenceRule;
import circlet.common.calendar.RecurrenceRuleEnds;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.RegularEventCounter;
import circlet.common.calendar.RuleParserKt;
import circlet.common.calendar.SpecIntersectsKt;
import circlet.common.calendar.TimeInterval;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.JodaDate;
import circlet.platform.api.JodaDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rH\u0002J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u000b\u001a\u00060\fj\u0002`\rJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006H\u0002J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002JJ\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\u0018\u001a\u00020\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0010\b\u0002\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rJ:\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020 2\u0006\u0010\n\u001a\u00020!H\u0002J&\u0010\"\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u00062\u0006\u0010#\u001a\u00020\u00142\n\u0010$\u001a\u00060\fj\u0002`\rH\u0002J9\u0010%\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r2\"\u0010&\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r0'\"\n\u0018\u00010\fj\u0004\u0018\u0001`\rH\u0002\u00a2\u0006\u0002\u0010(J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006J\f\u0010+\u001a\u00020\u0012*\u00020\tH\u0002J\f\u0010,\u001a\u00020-*\u00020\tH\u0002J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u00072\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001200J\u0012\u00101\u001a\b\u0012\u0004\u0012\u00020\t0\u0006*\u00020\tH\u0002J\u001f\u00102\u001a\u0004\u0018\u0001H3\"\u0004\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H300H\u0002\u00a2\u0006\u0002\u00104J\u001f\u00105\u001a\u0004\u0018\u0001H3\"\u0004\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H300H\u0002\u00a2\u0006\u0002\u00104J\u0014\u00106\u001a\u00020\t*\u00020\t2\u0006\u00107\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcirclet/common/calendar/EventCalculations;", "", "()V", "log", "Llibraries/klogging/KLogger;", "calcIntervalsToCheck", "", "Lcirclet/common/calendar/TimeInterval;", "plannedEvent", "Lcirclet/common/calendar/CalendarEventSpec;", "checkedEvent", "since", "Lcirclet/platform/api/JodaDateTime;", "Lcirclet/platform/api/ADateTime;", "calcLocalStartTimes", "Lcirclet/common/calendar/MeetingStart;", "event", "eventExceptions", "Lcirclet/common/calendar/ClosedTimeInterval;", "localTimezone", "Lcirclet/platform/api/ATimeZone;", "combineIntersectingIntervals", "intervals", "findConflictsBetweenRecurringEvents", "plannedEventSpec", "checkedEventSpec", "timeIntervals", "plannedEventExceptions", "checkedEventExceptions", "getIntersectingMeetingTime", "timeInterval", "targetTimezone", "Lcirclet/common/calendar/EventCounter;", "Lcirclet/common/calendar/RegularEventCounter;", "getNextTransitions", "zone", "from", "minTime", "time", "", "([Lcirclet/platform/api/JodaDateTime;)Lcirclet/platform/api/JodaDateTime;", "removeExceptionalIntervals", "exceptions", "getTimeInterval", "print", "", "remove", "exceptionsIterator", "", "splitByDates", "tryNext", "T", "(Ljava/util/ListIterator;)Ljava/lang/Object;", "tryPrevious", "withDifferentTime", "interval", "common"})
public final class EventCalculations {
    @NotNull
    private final KLogger log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(EventCalculations.class));

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MeetingStart> calcLocalStartTimes(@NotNull CalendarEventSpec event2, @NotNull List<ClosedTimeInterval> eventExceptions, @NotNull ATimeZone localTimezone, @NotNull JodaDateTime since) {
        List<MeetingStart> list;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter(eventExceptions, (String)"eventExceptions");
        Intrinsics.checkNotNullParameter((Object)localTimezone, (String)"localTimezone");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        KLogger $this$catch$iv = this.log;
        boolean $i$f$catch = false;
        KLogger $this$internalCatch_u24default$iv$iv = $this$catch$iv;
        List except$iv$iv = CollectionsKt.emptyList();
        boolean $i$f$internalCatch = false;
        try {
            boolean bl = false;
            if (Intrinsics.areEqual((Object)event2.getTimezone(), (Object)localTimezone) || event2.getRecurrenceRule() == null || EventCountersKt.durationInMinutes(event2) == 0) {
                return CollectionsKt.listOf((Object)EventCountersKt.regularMeetingStart$default(event2, null, 1, null));
            }
            JodaDate localDate = ADateJvmKt.toDate(ADateJvmKt.withZone(event2.getStart(), localTimezone));
            JodaDateTime localDayStartTime = ADateJvmKt.toDateTimeAtStartOfDay(localDate, localTimezone);
            JodaDateTime localDayEndTime = ADateJvmKt.plusMinutes(ADateJvmKt.plusDays(localDayStartTime, 1), -1);
            CalendarEventSpec fakeEvent = new CalendarEventSpec(localDayStartTime, localDayEndTime, new RecurrenceRule(new RecurrenceRuleFreq.Daily(1), new RecurrenceRuleEnds.Never()), false, localTimezone, null, null, null, null, 480, null);
            list = this.findConflictsBetweenRecurringEvents(fakeEvent, CollectionsKt.emptyList(), event2, eventExceptions, since);
        }
        catch (Throwable th$iv$iv) {
            boolean bl;
            block9: {
                boolean $i$f$isCancellationException = false;
                if (th$iv$iv instanceof InterruptedException || th$iv$iv instanceof CancellationException) {
                    throw th$iv$iv;
                }
                Iterable $this$any$iv$iv$iv = except$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv$iv$iv : $this$any$iv$iv$iv) {
                        KClass it$iv$iv = (KClass)element$iv$iv$iv;
                        boolean bl2 = false;
                        if (!it$iv$iv.isInstance((Object)th$iv$iv)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw th$iv$iv;
            }
            Throwable throwable = th$iv$iv;
            KLogger $this$catch_u24lambda_u2d1$iv = $this$internalCatch_u24default$iv$iv;
            boolean bl3 = false;
            KLogger this_$iv$iv = $this$catch_u24lambda_u2d1$iv;
            boolean $i$f$error = false;
            if (this_$iv$iv.isErrorEnabled()) {
                void th$iv;
                void var30_30 = th$iv;
                KLogger kLogger = this_$iv$iv;
                boolean bl4 = false;
                String string = "Error while calculating local start time shifts for " + this.print(event2) + '}';
                kLogger.error((Throwable)var30_30, string);
            }
            list = null;
        }
        List<MeetingStart> list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MeetingStart> findConflictsBetweenRecurringEvents(@NotNull CalendarEventSpec plannedEventSpec, @NotNull List<ClosedTimeInterval> plannedEventExceptions, @NotNull CalendarEventSpec checkedEventSpec, @NotNull List<ClosedTimeInterval> checkedEventExceptions, @Nullable JodaDateTime since) {
        List list;
        Intrinsics.checkNotNullParameter((Object)plannedEventSpec, (String)"plannedEventSpec");
        Intrinsics.checkNotNullParameter(plannedEventExceptions, (String)"plannedEventExceptions");
        Intrinsics.checkNotNullParameter((Object)checkedEventSpec, (String)"checkedEventSpec");
        Intrinsics.checkNotNullParameter(checkedEventExceptions, (String)"checkedEventExceptions");
        KLogger $this$catch$iv = this.log;
        boolean $i$f$catch = false;
        KLogger $this$internalCatch_u24default$iv$iv = $this$catch$iv;
        List except$iv$iv = CollectionsKt.emptyList();
        boolean $i$f$internalCatch = false;
        try {
            void $this$distinctBy$iv;
            void $this$flatMapTo$iv$iv;
            boolean bl = false;
            List<TimeInterval> intervalsByDst = this.calcIntervalsToCheck(plannedEventSpec, checkedEventSpec, since);
            Object[] objectArray = new List[]{plannedEventExceptions, checkedEventExceptions};
            List exceptionalIntervals = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
            List<TimeInterval> intervals = this.removeExceptionalIntervals(intervalsByDst, exceptionalIntervals);
            List<CalendarEventSpec> plannedSpecParts = this.splitByDates(plannedEventSpec);
            Iterable $this$flatMap$iv = plannedSpecParts;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CalendarEventSpec it = (CalendarEventSpec)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = this.findConflictsBetweenRecurringEvents(it, checkedEventSpec, intervals);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<Integer> set$iv = new HashSet<Integer>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                MeetingStart it = (MeetingStart)e$iv;
                boolean bl3 = false;
                Integer key$iv = ADateJvmKt.getMinuteOfDay(ADateJvmKt.withZone(it.getStartTime(), plannedEventSpec.getTimezone()));
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            list = list$iv;
        }
        catch (Throwable th$iv$iv) {
            boolean bl;
            block10: {
                boolean $i$f$isCancellationException = false;
                if (th$iv$iv instanceof InterruptedException || th$iv$iv instanceof CancellationException) {
                    throw th$iv$iv;
                }
                Iterable $this$any$iv$iv$iv = except$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv$iv$iv : $this$any$iv$iv$iv) {
                        KClass it$iv$iv = (KClass)element$iv$iv$iv;
                        boolean bl4 = false;
                        if (!it$iv$iv.isInstance((Object)th$iv$iv)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw th$iv$iv;
            }
            Throwable throwable = th$iv$iv;
            KLogger $this$catch_u24lambda_u2d1$iv = $this$internalCatch_u24default$iv$iv;
            boolean bl5 = false;
            KLogger this_$iv$iv = $this$catch_u24lambda_u2d1$iv;
            boolean $i$f$error = false;
            if (this_$iv$iv.isErrorEnabled()) {
                void th$iv;
                void var41_43 = th$iv;
                KLogger kLogger = this_$iv$iv;
                boolean bl6 = false;
                String string = "Error while checking conflicts between " + this.print(plannedEventSpec) + " and " + this.print(checkedEventSpec);
                kLogger.error((Throwable)var41_43, string);
            }
            list = null;
        }
        List list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    public static /* synthetic */ List findConflictsBetweenRecurringEvents$default(EventCalculations eventCalculations, CalendarEventSpec calendarEventSpec, List list, CalendarEventSpec calendarEventSpec2, List list2, JodaDateTime jodaDateTime, int n, Object object) {
        if ((n & 0x10) != 0) {
            jodaDateTime = null;
        }
        return eventCalculations.findConflictsBetweenRecurringEvents(calendarEventSpec, list, calendarEventSpec2, list2, jodaDateTime);
    }

    @NotNull
    public final List<TimeInterval> removeExceptionalIntervals(@NotNull List<? extends TimeInterval> intervals, @NotNull List<ClosedTimeInterval> exceptions) {
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        if (intervals.isEmpty() || exceptions.isEmpty()) {
            return intervals;
        }
        Iterable $this$sortedBy$iv = intervals;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TimeInterval it = (TimeInterval)a;
                boolean bl2 = false;
                Comparable comparable = it.getStart();
                it = (TimeInterval)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                JodaDateTime jodaDateTime = it.getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)jodaDateTime);
            }
        });
        List<ClosedTimeInterval> preparedExceptions = this.combineIntersectingIntervals(exceptions);
        bl = false;
        List result2 = new ArrayList();
        ListIterator<ClosedTimeInterval> exceptionsIterator = preparedExceptions.listIterator();
        for (TimeInterval interval2 : sorted) {
            result2.addAll((Collection)this.remove(interval2, exceptionsIterator));
            if (exceptionsIterator.hasNext()) continue;
            break;
        }
        return result2;
    }

    @NotNull
    public final List<TimeInterval> remove(@NotNull TimeInterval $this$remove, @NotNull ListIterator<ClosedTimeInterval> exceptionsIterator) {
        Intrinsics.checkNotNullParameter((Object)$this$remove, (String)"<this>");
        Intrinsics.checkNotNullParameter(exceptionsIterator, (String)"exceptionsIterator");
        boolean bl = false;
        List result2 = new ArrayList();
        TimeInterval lastPart = $this$remove;
        ClosedTimeInterval nextException = this.tryNext(exceptionsIterator);
        while (lastPart != null && nextException != null && !lastPart.endsBefore(nextException.getStart())) {
            List<TimeInterval> removalResult = lastPart.remove(nextException);
            if (removalResult.size() > 1) {
                result2.addAll(CollectionsKt.dropLast(removalResult, (int)1));
            }
            lastPart = (TimeInterval)CollectionsKt.lastOrNull(removalResult);
            nextException = this.tryNext(exceptionsIterator);
        }
        if (lastPart != null) {
            result2.add(lastPart);
        }
        this.tryPrevious(exceptionsIterator);
        this.tryPrevious(exceptionsIterator);
        return result2;
    }

    private final <T> T tryNext(ListIterator<? extends T> $this$tryNext) {
        return $this$tryNext.hasNext() ? (T)$this$tryNext.next() : null;
    }

    private final <T> T tryPrevious(ListIterator<? extends T> $this$tryPrevious) {
        return $this$tryPrevious.hasPrevious() ? (T)$this$tryPrevious.previous() : null;
    }

    private final List<ClosedTimeInterval> combineIntersectingIntervals(List<ClosedTimeInterval> intervals) {
        if (intervals.isEmpty()) {
            return intervals;
        }
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$sortedBy$iv = intervals;
        boolean $i$f$sortedBy = false;
        boolean bl2 = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ClosedTimeInterval it = (ClosedTimeInterval)a;
                boolean bl2 = false;
                Comparable comparable = it.getStart();
                it = (ClosedTimeInterval)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                JodaDateTime jodaDateTime = it.getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)jodaDateTime);
            }
        });
        ClosedTimeInterval currentInterval = (ClosedTimeInterval)CollectionsKt.first((List)sorted);
        Iterator iterator2 = sorted.listIterator(1);
        boolean bl3 = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ClosedTimeInterval closedTimeInterval;
            ClosedTimeInterval interval2 = (ClosedTimeInterval)iterator3.next();
            if (currentInterval.intersection(interval2) != null) {
                closedTimeInterval = currentInterval.add(interval2);
            } else {
                result2.add(currentInterval);
                closedTimeInterval = interval2;
            }
            currentInterval = closedTimeInterval;
        }
        result2.add(currentInterval);
        return result2;
    }

    private final String print(CalendarEventSpec $this$print) {
        RecurrenceRule recurrenceRule;
        return $this$print.getStart() + " - " + $this$print.getEnd() + ", " + $this$print.getTimezone().getId() + ", " + ((recurrenceRule = $this$print.getRecurrenceRule()) == null ? null : RuleParserKt.print(recurrenceRule));
    }

    /*
     * WARNING - void declaration
     */
    private final List<MeetingStart> findConflictsBetweenRecurringEvents(CalendarEventSpec plannedEventSpec, CalendarEventSpec checkedEventSpec, List<? extends TimeInterval> timeIntervals) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        if (!EventCalculationsKt.canHappen(plannedEventSpec) || !EventCalculationsKt.canHappen(checkedEventSpec)) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        ATimeZone targetTimezone = checkedEventSpec.getTimezone();
        EventCounter plannedEvent = EventCountersKt.createEventCounterRelativeToTimezone(plannedEventSpec, targetTimezone, this.getTimeInterval(checkedEventSpec));
        Object object = checkedEventSpec.getRecurrenceRule();
        Intrinsics.checkNotNull((Object)object);
        RegularEventCounter checkedEvent = new RegularEventCounter(((RecurrenceRule)object).getFreq(), ADateJvmKt.toDate(ADateJvmKt.withZone(checkedEventSpec.getStart(), targetTimezone)));
        if (plannedEvent == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        object = timeIntervals;
        boolean $i$f$mapNotNull = false;
        void var9_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MeetingStart meetingStart;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TimeInterval it = (TimeInterval)element$iv$iv;
            boolean bl2 = false;
            if (this.getIntersectingMeetingTime(it, targetTimezone, plannedEventSpec, checkedEventSpec, plannedEvent, checkedEvent) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            MeetingStart it$iv$iv = meetingStart;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MeetingStart getIntersectingMeetingTime(TimeInterval timeInterval, ATimeZone targetTimezone, CalendarEventSpec plannedEventSpec, CalendarEventSpec checkedEventSpec, EventCounter plannedEvent, RegularEventCounter checkedEvent) {
        JodaDate jodaDate;
        DatesInterval datesInterval = timeInterval.toDates(targetTimezone);
        JodaDateTime firstEventStartTimeOnInterval = SpecIntersectsKt.startTimeAtDay(checkedEventSpec, datesInterval.getStart());
        if (timeInterval.startsAfter(firstEventStartTimeOnInterval)) {
            JodaDate newStartDate = ADateJvmKt.plusDays(datesInterval.getStart(), 1);
            if (datesInterval.contains(newStartDate)) {
                datesInterval = new DatesInterval(newStartDate, datesInterval.getEndExclusive());
            } else {
                return null;
            }
        }
        if ((jodaDate = EventCountersKt.calcIntersectionDate(plannedEvent, checkedEvent, datesInterval)) == null) {
            return null;
        }
        JodaDate intersectionDate = jodaDate;
        ClosedTimeInterval checkedEventAtDay = SpecIntersectsKt.timeIntervalAtDay(checkedEventSpec, intersectionDate);
        if (!timeInterval.contains(checkedEventAtDay.getStart())) {
            return null;
        }
        JodaDate plannedEventDate = ADateJvmKt.toDate(ADateJvmKt.withZone(checkedEventAtDay.getStart(), plannedEventSpec.getTimezone()));
        ClosedTimeInterval plannedEventAtDay = SpecIntersectsKt.timeIntervalAtDay(plannedEventSpec, plannedEventDate);
        boolean hasTimeIntersection = plannedEventAtDay.intersection(checkedEventAtDay) != null;
        TimeInterval conflictingTimeInterval = new TimeInterval(checkedEventAtDay.getStart(), timeInterval.getEndInclusive());
        return hasTimeIntersection ? new MeetingStart(checkedEventAtDay.getStart(), conflictingTimeInterval) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TimeInterval> calcIntervalsToCheck(CalendarEventSpec plannedEvent, CalendarEventSpec checkedEvent, JodaDateTime since) {
        void $this$sortedBy$iv;
        Iterable $this$distinctBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        ATimeZone firstZone = plannedEvent.getTimezone();
        ATimeZone secondZone = checkedEvent.getTimezone();
        Object object = since;
        JodaDateTime jodaDateTime = object == null ? null : ADateJvmKt.plusMinutes((JodaDateTime)object, -1 * EventCountersKt.durationInMinutes(checkedEvent));
        JodaDateTime checkStart = jodaDateTime == null ? (JodaDateTime)ComparisonsKt.maxOf((Comparable)plannedEvent.getStart(), (Comparable)checkedEvent.getStart()) : jodaDateTime;
        object = new JodaDateTime[]{EventCountersKt.lastOccurrenceEnd(checkedEvent), EventCountersKt.lastOccurrenceEnd(plannedEvent)};
        JodaDateTime checkEnd = this.minTime((JodaDateTime)object);
        if (checkEnd != null && checkEnd.compareTo(checkStart) <= 0) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)firstZone, (Object)secondZone)) {
            object = checkEnd;
            return CollectionsKt.listOf((Object)new TimeInterval(checkStart, object == null ? null : ADateJvmKt.plusMillis((JodaDateTime)object, -1)));
        }
        List<JodaDateTime> firstZoneTransitions = this.getNextTransitions(firstZone, checkStart);
        List<JodaDateTime> secondZoneTransitions = this.getNextTransitions(secondZone, checkStart);
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)firstZoneTransitions, (Iterable)secondZoneTransitions), (Object)checkStart);
        boolean $i$f$mapNotNull = false;
        void var13_14 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JodaDateTime jodaDateTime2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JodaDateTime it = (JodaDateTime)element$iv$iv;
            boolean bl2 = false;
            JodaDateTime[] jodaDateTimeArray = new JodaDateTime[]{it, checkEnd};
            if (this.minTime(jodaDateTimeArray) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            JodaDateTime it$iv$iv = jodaDateTime2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<Long> set$iv = new HashSet<Long>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            JodaDateTime it = (JodaDateTime)e$iv;
            boolean bl = false;
            Long key$iv = ADateJvmKt.getMillis(it);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List timePoints = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                JodaDateTime it = (JodaDateTime)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(ADateJvmKt.getMillis(it));
                it = (JodaDateTime)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = ADateJvmKt.getMillis(it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
        boolean withLastIntervalOpen = checkEnd == null;
        Iterable iterable2 = timePoints;
        bl = false;
        return CollectionsKt.windowed((Iterable)iterable2, (int)2, (int)1, (boolean)withLastIntervalOpen, (Function1)calcIntervalsToCheck.1.INSTANCE);
    }

    static /* synthetic */ List calcIntervalsToCheck$default(EventCalculations eventCalculations, CalendarEventSpec calendarEventSpec, CalendarEventSpec calendarEventSpec2, JodaDateTime jodaDateTime, int n, Object object) {
        if ((n & 4) != 0) {
            jodaDateTime = null;
        }
        return eventCalculations.calcIntervalsToCheck(calendarEventSpec, calendarEventSpec2, jodaDateTime);
    }

    private final JodaDateTime minTime(JodaDateTime ... time) {
        return (JodaDateTime)CollectionsKt.minWithOrNull((Iterable)ArraysKt.filterNotNull((Object[])time), EventCountersKt.getTimeComparator());
    }

    private final List<JodaDateTime> getNextTransitions(ATimeZone zone, JodaDateTime from) {
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)from, (Function1)((Function1)new Function1<JodaDateTime, JodaDateTime>(zone){
            final /* synthetic */ ATimeZone $zone;
            {
                this.$zone = $zone;
                super(1);
            }

            @Nullable
            public final JodaDateTime invoke(@NotNull JodaDateTime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ADateJvmKt.nextTransition(this.$zone, it);
            }
        })), (int)1), (int)2));
    }

    private final ClosedTimeInterval getTimeInterval(CalendarEventSpec $this$getTimeInterval) {
        return new ClosedTimeInterval($this$getTimeInterval.getStart(), $this$getTimeInterval.getEnd());
    }

    private final CalendarEventSpec withDifferentTime(CalendarEventSpec $this$withDifferentTime, TimeInterval interval2) {
        JodaDateTime jodaDateTime = interval2.getStart();
        JodaDateTime jodaDateTime2 = interval2.getEndInclusive();
        Intrinsics.checkNotNull((Object)jodaDateTime2);
        return new CalendarEventSpec(jodaDateTime, jodaDateTime2, $this$withDifferentTime.getRecurrenceRule(), $this$withDifferentTime.getAllDay(), $this$withDifferentTime.getTimezone(), null, null, null, null, 480, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CalendarEventSpec> splitByDates(CalendarEventSpec $this$splitByDates) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getTimeInterval($this$splitByDates).splitByDates($this$splitByDates.getTimezone());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClosedTimeInterval closedTimeInterval = (ClosedTimeInterval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CalendarEventSpec calendarEventSpec = this.withDifferentTime($this$splitByDates, (TimeInterval)it);
            collection.add(calendarEventSpec);
        }
        return (List)destination$iv$iv;
    }
}

