/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.GitMergeMode;
import circlet.client.api.GitRebaseMode;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0002&'B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003JE\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\b\u0010%\u001a\u00020\u000bH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcirclet/client/api/MergeSelectOptions;", "", "operation", "Lcirclet/client/api/MergeSelectOptions$Operation;", "mergeMode", "Lcirclet/client/api/GitMergeMode;", "rebaseMode", "Lcirclet/client/api/GitRebaseMode;", "autoSquash", "", "squashCommitMessage", "", "deleteSourceBranch", "(Lcirclet/client/api/MergeSelectOptions$Operation;Lcirclet/client/api/GitMergeMode;Lcirclet/client/api/GitRebaseMode;ZLjava/lang/String;Z)V", "getAutoSquash", "()Z", "getDeleteSourceBranch", "isRebase", "getMergeMode", "()Lcirclet/client/api/GitMergeMode;", "getOperation", "()Lcirclet/client/api/MergeSelectOptions$Operation;", "getRebaseMode", "()Lcirclet/client/api/GitRebaseMode;", "getSquashCommitMessage", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "Operation", "client-api"})
public final class MergeSelectOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Operation operation;
    @NotNull
    private final GitMergeMode mergeMode;
    @NotNull
    private final GitRebaseMode rebaseMode;
    private final boolean autoSquash;
    @NotNull
    private final String squashCommitMessage;
    private final boolean deleteSourceBranch;
    @NotNull
    private static final MergeSelectOptions Default = new MergeSelectOptions(Operation.Merge, GitMergeMode.FF, GitRebaseMode.FF, true, "", true);

    public MergeSelectOptions(@NotNull Operation operation, @NotNull GitMergeMode mergeMode, @NotNull GitRebaseMode rebaseMode, boolean autoSquash, @NotNull String squashCommitMessage, boolean deleteSourceBranch) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)((Object)mergeMode), (String)"mergeMode");
        Intrinsics.checkNotNullParameter((Object)((Object)rebaseMode), (String)"rebaseMode");
        Intrinsics.checkNotNullParameter((Object)squashCommitMessage, (String)"squashCommitMessage");
        this.operation = operation;
        this.mergeMode = mergeMode;
        this.rebaseMode = rebaseMode;
        this.autoSquash = autoSquash;
        this.squashCommitMessage = squashCommitMessage;
        this.deleteSourceBranch = deleteSourceBranch;
    }

    @NotNull
    public final Operation getOperation() {
        return this.operation;
    }

    @NotNull
    public final GitMergeMode getMergeMode() {
        return this.mergeMode;
    }

    @NotNull
    public final GitRebaseMode getRebaseMode() {
        return this.rebaseMode;
    }

    public final boolean getAutoSquash() {
        return this.autoSquash;
    }

    @NotNull
    public final String getSquashCommitMessage() {
        return this.squashCommitMessage;
    }

    public final boolean getDeleteSourceBranch() {
        return this.deleteSourceBranch;
    }

    public final boolean isRebase() {
        return this.operation == Operation.Rebase || this.operation == Operation.Squash;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d1 = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u2d1;
        Operation operation = this.getOperation();
        int n = WhenMappings.$EnumSwitchMapping$0[operation.ordinal()];
        block0 : switch (n) {
            case 1: {
                GitMergeMode gitMergeMode = this.getMergeMode();
                int n2 = WhenMappings.$EnumSwitchMapping$1[gitMergeMode.ordinal()];
                switch (n2) {
                    case 1: {
                        string = "merge";
                        break block0;
                    }
                    case 2: {
                        string = "merge-ff-only";
                        break block0;
                    }
                    case 3: {
                        string = "merge-no-ff";
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2: {
                void $this$toString_u24lambda_u2d1_u24lambda_u2d0;
                String string2;
                boolean bl6 = false;
                boolean bl7 = false;
                StringBuilder stringBuilder3 = new StringBuilder();
                boolean bl8 = false;
                boolean bl9 = false;
                StringBuilder stringBuilder4 = stringBuilder3;
                StringBuilder stringBuilder5 = stringBuilder2;
                boolean bl10 = false;
                GitRebaseMode gitRebaseMode = this.getRebaseMode();
                int n3 = WhenMappings.$EnumSwitchMapping$2[gitRebaseMode.ordinal()];
                switch (n3) {
                    case 1: {
                        string2 = "rebase";
                        break;
                    }
                    case 2: {
                        string2 = "rebase-no-ff";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $this$toString_u24lambda_u2d1_u24lambda_u2d0.append(string2);
                if (this.getAutoSquash()) {
                    $this$toString_u24lambda_u2d1_u24lambda_u2d0.append(",autosquash");
                }
                Unit unit = Unit.INSTANCE;
                stringBuilder2 = stringBuilder5;
                String string3 = stringBuilder3.toString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                break;
            }
            case 3: {
                string = "squash";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        stringBuilder2.append(string);
        if (this.getDeleteSourceBranch()) {
            $this$toString_u24lambda_u2d1.append(",delete-source-branch");
        }
        $this$toString_u24lambda_u2d1.append(":");
        $this$toString_u24lambda_u2d1.append(this.getSquashCommitMessage());
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    @NotNull
    public final Operation component1() {
        return this.operation;
    }

    @NotNull
    public final GitMergeMode component2() {
        return this.mergeMode;
    }

    @NotNull
    public final GitRebaseMode component3() {
        return this.rebaseMode;
    }

    public final boolean component4() {
        return this.autoSquash;
    }

    @NotNull
    public final String component5() {
        return this.squashCommitMessage;
    }

    public final boolean component6() {
        return this.deleteSourceBranch;
    }

    @NotNull
    public final MergeSelectOptions copy(@NotNull Operation operation, @NotNull GitMergeMode mergeMode, @NotNull GitRebaseMode rebaseMode, boolean autoSquash, @NotNull String squashCommitMessage, boolean deleteSourceBranch) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)((Object)mergeMode), (String)"mergeMode");
        Intrinsics.checkNotNullParameter((Object)((Object)rebaseMode), (String)"rebaseMode");
        Intrinsics.checkNotNullParameter((Object)squashCommitMessage, (String)"squashCommitMessage");
        return new MergeSelectOptions(operation, mergeMode, rebaseMode, autoSquash, squashCommitMessage, deleteSourceBranch);
    }

    public static /* synthetic */ MergeSelectOptions copy$default(MergeSelectOptions mergeSelectOptions, Operation operation, GitMergeMode gitMergeMode, GitRebaseMode gitRebaseMode, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            operation = mergeSelectOptions.operation;
        }
        if ((n & 2) != 0) {
            gitMergeMode = mergeSelectOptions.mergeMode;
        }
        if ((n & 4) != 0) {
            gitRebaseMode = mergeSelectOptions.rebaseMode;
        }
        if ((n & 8) != 0) {
            bl = mergeSelectOptions.autoSquash;
        }
        if ((n & 0x10) != 0) {
            string = mergeSelectOptions.squashCommitMessage;
        }
        if ((n & 0x20) != 0) {
            bl2 = mergeSelectOptions.deleteSourceBranch;
        }
        return mergeSelectOptions.copy(operation, gitMergeMode, gitRebaseMode, bl, string, bl2);
    }

    public int hashCode() {
        int result2 = this.operation.hashCode();
        result2 = result2 * 31 + this.mergeMode.hashCode();
        result2 = result2 * 31 + this.rebaseMode.hashCode();
        int n = this.autoSquash ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        result2 = result2 * 31 + this.squashCommitMessage.hashCode();
        int n2 = this.deleteSourceBranch ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MergeSelectOptions)) {
            return false;
        }
        MergeSelectOptions mergeSelectOptions = (MergeSelectOptions)other;
        if (this.operation != mergeSelectOptions.operation) {
            return false;
        }
        if (this.mergeMode != mergeSelectOptions.mergeMode) {
            return false;
        }
        if (this.rebaseMode != mergeSelectOptions.rebaseMode) {
            return false;
        }
        if (this.autoSquash != mergeSelectOptions.autoSquash) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.squashCommitMessage, (Object)mergeSelectOptions.squashCommitMessage)) {
            return false;
        }
        return this.deleteSourceBranch == mergeSelectOptions.deleteSourceBranch;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcirclet/client/api/MergeSelectOptions$Operation;", "", "(Ljava/lang/String;I)V", "Merge", "Rebase", "Squash", "client-api"})
    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation Merge = new Operation();
        public static final /* enum */ Operation Rebase = new Operation();
        public static final /* enum */ Operation Squash = new Operation();
        private static final /* synthetic */ Operation[] $VALUES;

        public static Operation[] values() {
            Operation[] operationArray = $VALUES;
            return Arrays.copyOf(operationArray, operationArray.length);
        }

        public static Operation valueOf(String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Enum.valueOf(Operation.class, value2);
        }

        static {
            $VALUES = operationArray = new Operation[]{Operation.Merge, Operation.Rebase, Operation.Squash};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcirclet/client/api/MergeSelectOptions$Companion;", "", "()V", "Default", "Lcirclet/client/api/MergeSelectOptions;", "getDefault", "()Lcirclet/client/api/MergeSelectOptions;", "parse", "value", "", "client-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MergeSelectOptions getDefault() {
            return Default;
        }

        @NotNull
        public final MergeSelectOptions parse(@NotNull String value2) {
            Operation operation;
            String operation2;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            CharSequence charSequence2 = StringsKt.substringBefore((String)value2, (String)":", (String)"");
            boolean bl = false;
            CharSequence charSequence3 = charSequence2;
            boolean bl2 = false;
            if (charSequence3.length() == 0) {
                boolean bl3 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            String[] stringArray = (String[])charSequence;
            Object object = stringArray == null ? "merge" : stringArray;
            stringArray = new String[]{","};
            List commands = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String title2 = StringsKt.substringAfter((String)value2, (String)":", (String)"");
            switch (operation2 = (String)CollectionsKt.first((List)commands)) {
                case "merge-ff-only": 
                case "merge": 
                case "merge-no-ff": {
                    operation = Operation.Merge;
                    break;
                }
                case "rebase": 
                case "rebase-no-ff": {
                    operation = Operation.Rebase;
                    break;
                }
                case "squash": {
                    operation = Operation.Squash;
                    break;
                }
                default: {
                    operation = Operation.Merge;
                }
            }
            String string = operation2;
            GitMergeMode gitMergeMode = Intrinsics.areEqual((Object)string, (Object)"merge-ff-only") ? GitMergeMode.FF_ONLY : (Intrinsics.areEqual((Object)string, (Object)"merge-no-ff") ? GitMergeMode.NO_FF : GitMergeMode.FF);
            string = operation2;
            return new MergeSelectOptions(operation, gitMergeMode, Intrinsics.areEqual((Object)string, (Object)"rebase") ? GitRebaseMode.FF : (Intrinsics.areEqual((Object)string, (Object)"rebase-no-ff") ? GitRebaseMode.NO_FF : GitRebaseMode.FF), commands.contains("autosquash"), title2, commands.contains("delete-source-branch"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Operation.values().length];
            nArray[Operation.Merge.ordinal()] = 1;
            nArray[Operation.Rebase.ordinal()] = 2;
            nArray[Operation.Squash.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GitMergeMode.values().length];
            nArray[GitMergeMode.FF.ordinal()] = 1;
            nArray[GitMergeMode.FF_ONLY.ordinal()] = 2;
            nArray[GitMergeMode.NO_FF.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[GitRebaseMode.values().length];
            nArray[GitRebaseMode.FF.ordinal()] = 1;
            nArray[GitRebaseMode.NO_FF.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

