/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcirclet/client/api/Currency;", "", "code", "", "sign", "signAsPrefix", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getCode", "()Ljava/lang/String;", "getSign", "getSignAsPrefix", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "client-api"})
public final class Currency {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String code;
    @Nullable
    private final String sign;
    private final boolean signAsPrefix;
    @NotNull
    private static final Currency USD = new Currency("USD", "$", true);
    @NotNull
    private static final Currency EUR = new Currency("EUR", "\u20ac", true);
    @NotNull
    private static final Currency GBP = new Currency("GBP", "\u00a3", true);
    @NotNull
    private static final Currency CZK = new Currency("CZK", "K\u010d", false);
    @NotNull
    private static final Currency JPY = new Currency("JPY", "\u00a5", true);
    @NotNull
    private static final List<Currency> knownCurrencies;

    public Currency(@NotNull String code, @Nullable String sign, boolean signAsPrefix) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = code;
        this.sign = sign;
        this.signAsPrefix = signAsPrefix;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @Nullable
    public final String getSign() {
        return this.sign;
    }

    public final boolean getSignAsPrefix() {
        return this.signAsPrefix;
    }

    @NotNull
    public final String component1() {
        return this.code;
    }

    @Nullable
    public final String component2() {
        return this.sign;
    }

    public final boolean component3() {
        return this.signAsPrefix;
    }

    @NotNull
    public final Currency copy(@NotNull String code, @Nullable String sign, boolean signAsPrefix) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return new Currency(code, sign, signAsPrefix);
    }

    public static /* synthetic */ Currency copy$default(Currency currency, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = currency.code;
        }
        if ((n & 2) != 0) {
            string2 = currency.sign;
        }
        if ((n & 4) != 0) {
            bl = currency.signAsPrefix;
        }
        return currency.copy(string, string2, bl);
    }

    @NotNull
    public String toString() {
        return "Currency(code=" + this.code + ", sign=" + this.sign + ", signAsPrefix=" + this.signAsPrefix + ')';
    }

    public int hashCode() {
        int result2 = this.code.hashCode();
        result2 = result2 * 31 + (this.sign == null ? 0 : this.sign.hashCode());
        int n = this.signAsPrefix ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Currency)) {
            return false;
        }
        Currency currency = (Currency)other;
        if (!Intrinsics.areEqual((Object)this.code, (Object)currency.code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sign, (Object)currency.sign)) {
            return false;
        }
        return this.signAsPrefix == currency.signAsPrefix;
    }

    static {
        Object[] objectArray = new Currency[]{USD, EUR, GBP, CZK, JPY};
        knownCurrencies = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcirclet/client/api/Currency$Companion;", "", "()V", "CZK", "Lcirclet/client/api/Currency;", "getCZK", "()Lcirclet/client/api/Currency;", "EUR", "getEUR", "GBP", "getGBP", "JPY", "getJPY", "USD", "getUSD", "knownCurrencies", "", "getKnownCurrencies", "()Ljava/util/List;", "resolveCurrency", "code", "", "client-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Currency getUSD() {
            return USD;
        }

        @NotNull
        public final Currency getEUR() {
            return EUR;
        }

        @NotNull
        public final Currency getGBP() {
            return GBP;
        }

        @NotNull
        public final Currency getCZK() {
            return CZK;
        }

        @NotNull
        public final Currency getJPY() {
            return JPY;
        }

        @NotNull
        public final List<Currency> getKnownCurrencies() {
            return knownCurrencies;
        }

        @NotNull
        public final Currency resolveCurrency(@NotNull String code) {
            Currency currency;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                Iterable $this$firstOrNull$iv = this.getKnownCurrencies();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Currency it = (Currency)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.getCode(), (String)code, (boolean)true)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            Currency currency2 = v0;
            if (currency2 == null) {
                String string = code;
                boolean bl = false;
                String string2 = string.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                currency = new Currency(string2, null, false);
            } else {
                currency = currency2;
            }
            return currency;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

