/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.indexing.shared.util.zipFs.Zip64Util;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a-\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\f0\u0011\u00a2\u0006\u0002\u0010\u0012\u001a\u001e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0003\u001a\n\u0010\u0018\u001a\u00020\u000f*\u00020\u0003\u001a\n\u0010\u0018\u001a\u00020\u000f*\u00020\u000f\u001a\n\u0010\u0019\u001a\u00020\u0017*\u00020\u001a\u00a8\u0006\u001b"}, d2={"compressSharedIndex", "", "file", "Ljava/nio/file/Path;", "output", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compressorStream", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "recreateDir", "runAndCatchNotNull", "Y", "", "errorMessage", "", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "uncompressedZip", "dir", "targetFile", "getFileOrDirectorySize", "", "sha256", "totalSize", "Ljava/io/File;", "intellij.indexing.shared"})
public final class UtilKt {
    @NotNull
    public static final String sha256(@NotNull Path $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"$this$sha256");
        MessageDigest digest = DigestUtil.sha256();
        DigestUtil.updateContentHash((MessageDigest)digest, (Path)$this$sha256);
        String string2 = StringUtil.toHexString((byte[])digest.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.toHexString(digest.digest())");
        return string2;
    }

    @NotNull
    public static final String sha256(@NotNull String $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"$this$sha256");
        MessageDigest digest = DigestUtil.sha256();
        String string2 = $this$sha256;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        digest.update(byArray);
        String string3 = StringUtil.toHexString((byte[])digest.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtil.toHexString(digest.digest())");
        return string3;
    }

    @NotNull
    public static final Path recreateDir(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileUtil.delete((Path)file2);
        Files.createDirectories(file2, new FileAttribute[0]);
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long totalSize(@NotNull File $this$totalSize) {
        Intrinsics.checkNotNullParameter((Object)$this$totalSize, (String)"$this$totalSize");
        if ($this$totalSize.isFile()) {
            return $this$totalSize.length();
        }
        if ($this$totalSize.isDirectory()) {
            long l;
            AutoCloseable autoCloseable = Files.walk($this$totalSize.toPath(), new FileVisitOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl3 = false;
                l = stream.mapToLong(totalSize.1.1.INSTANCE).sum();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return l;
        }
        return 0L;
    }

    @NotNull
    public static final <Y> Y runAndCatchNotNull(@NotNull String errorMessage, @NotNull Function0<? extends Y> action) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            Object object = action.invoke();
            if (object == null) {
                String string2 = "<null> was returned!";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return (Y)object;
        }
        catch (Throwable t) {
            throw (Throwable)new Error("Failed to " + errorMessage + ". " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void uncompressedZip(@NotNull Path dir, @NotNull Path targetFile, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.pushState();
        indicator.setText(SharedIndexesBundle.message("progress.text.zipping.index.pack", new Object[0]));
        try {
            Closeable closeable = (Closeable)Zip64Util.openZip64File(targetFile, false);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                List list;
                JBZipFile file2 = (JBZipFile)closeable;
                boolean bl3 = false;
                indicator.setText2(SharedIndexesBundle.message("progress.text2.scanning.files", new Object[0]));
                AutoCloseable autoCloseable = Files.walk(dir, new FileVisitOption[0]);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    Stream stream = (Stream)autoCloseable;
                    boolean bl6 = false;
                    Stream stream2 = stream.filter(uncompressedZip.1.allFiles.1.1.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue(stream2, (String)"stream.filter { !Files.isDirectory(it) }");
                    list = StreamsKt.toList(stream2);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                List allFiles2 = list;
                indicator.setIndeterminate(false);
                double count = 0.0;
                for (Path p : allFiles2) {
                    String relativePath;
                    indicator.checkCanceled();
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)((Object)dir.relativize(p)).toString()), (String)"FileUtil.toSystemIndepen\u2026relativize(p).toString())");
                    try {
                        JBZipEntry entry;
                        double d = count;
                        count = d + 1.0;
                        indicator.setFraction(d / (double)allFiles2.size());
                        JBZipEntry jBZipEntry = entry = file2.getOrCreateEntry(relativePath);
                        Intrinsics.checkNotNullExpressionValue((Object)jBZipEntry, (String)"entry");
                        jBZipEntry.setMethod(0);
                        entry.setDataFromPath(p);
                    }
                    catch (Exception e) {
                        throw (Throwable)new RuntimeException("Failed to add " + relativePath + " entry to the target archive. " + e.getMessage(), e);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            FileUtil.delete((Path)targetFile);
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw (Throwable)new RuntimeException("Failed to generate indexes archive at " + targetFile + ". " + e.getMessage(), e);
        }
        finally {
            indicator.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void compressSharedIndex(@NotNull Path file2, @NotNull Path output, @NotNull ProgressIndicator indicator, @NotNull Function1<? super OutputStream, ? extends OutputStream> compressorStream) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(compressorStream, (String)"compressorStream");
        indicator.pushState();
        int bufferSize = 0x800000;
        indicator.setText(SharedIndexesBundle.message("packing.to.xz", new Object[0]));
        indicator.setIndeterminate(false);
        long total = Files.size(file2);
        long completed = 0L;
        try {
            Closeable closeable = PathKt.outputStream$default((Path)output, (boolean)false, (int)1, null);
            boolean bl = false;
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, bufferSize);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedOutputStream outputStream = (BufferedOutputStream)closeable;
                boolean bl3 = false;
                Closeable closeable2 = (Closeable)compressorStream.invoke((Object)outputStream);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    OutputStream output2 = (OutputStream)closeable2;
                    boolean bl6 = false;
                    Closeable closeable3 = PathKt.inputStream((Path)file2);
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Throwable throwable3 = null;
                    try {
                        int sz;
                        InputStream inputStream = (InputStream)closeable3;
                        boolean bl9 = false;
                        byte[] buffer = new byte[bufferSize];
                        while ((sz = inputStream.read(buffer)) > 0) {
                            output2.write(buffer, 0, sz);
                            indicator.setFraction((double)(completed += (long)sz) / (double)total);
                            indicator.checkCanceled();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            FileUtil.delete((Path)output);
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw (Throwable)new RuntimeException("Failed to generate compressed shared index from " + file2 + " to " + output + ". " + e.getMessage(), e);
        }
        finally {
            indicator.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getFileOrDirectorySize(@NotNull Path $this$getFileOrDirectorySize) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$getFileOrDirectorySize, (String)"$this$getFileOrDirectorySize");
        if (!Files.exists($this$getFileOrDirectorySize, new LinkOption[0])) {
            return 0L;
        }
        if (!Files.isDirectory($this$getFileOrDirectorySize, new LinkOption[0])) {
            l = Files.size($this$getFileOrDirectorySize);
        } else {
            AutoCloseable autoCloseable = Files.walk($this$getFileOrDirectorySize, new FileVisitOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl3 = false;
                long l2 = it.filter(getFileOrDirectorySize.1.1.INSTANCE).mapToLong(getFileOrDirectorySize.1.2.INSTANCE).sum();
                l = l2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return l;
    }
}

