/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.util.ChunkedDownloader;
import com.intellij.indexing.shared.util.ChunkedDownloaderKt;
import com.intellij.indexing.shared.util.CountingInputStream;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001aJ\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0012"}, d2={"decompressAndValidate", "", "compression", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "targetFile", "Ljava/nio/file/Path;", "expectedSize", "", "expectedSha256", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "countingStream", "Lcom/intellij/indexing/shared/util/CountingInputStream;", "downloadUrlWithValidation", "url", "headers", "", "intellij.indexing.shared"})
public final class DownloadUtilKt {
    public static final long downloadUrlWithValidation(@NotNull String url, @NotNull Path targetFile, long expectedSize, @NotNull String expectedSha256, @NotNull Map<String, String> headers, @NotNull SharedIndexCompression compression, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)expectedSha256, (String)"expectedSha256");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        boolean bl = expectedSize > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        try {
            int maxSize = Registry.get((String)"shared.indexes.download.chunk.size").asInteger();
            if (expectedSize > (long)(maxSize * 2) && ChunkedDownloaderKt.rangeAllowed(url, headers, expectedSize)) {
                ChunkedDownloader chunkedDownloader = new ChunkedDownloader(maxSize, Registry.get((String)"shared.indexes.download.chunk.threads").asInteger());
                chunkedDownloader.download(url, headers, expectedSize, indicator, (Function1<? super InputStream, Unit>)((Function1)new Function1<InputStream, Unit>(compression, targetFile, expectedSize, expectedSha256, indicator){
                    final /* synthetic */ SharedIndexCompression $compression;
                    final /* synthetic */ Path $targetFile;
                    final /* synthetic */ long $expectedSize;
                    final /* synthetic */ String $expectedSha256;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final void invoke(@NotNull InputStream it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DownloadUtilKt.access$decompressAndValidate(this.$compression, this.$targetFile, this.$expectedSize, this.$expectedSha256, this.$indicator, new CountingInputStream(it));
                    }
                    {
                        this.$compression = sharedIndexCompression;
                        this.$targetFile = path;
                        this.$expectedSize = l;
                        this.$expectedSha256 = string2;
                        this.$indicator = progressIndicator;
                        super(1);
                    }
                }));
                return Files.size(targetFile);
            }
            HttpRequests.request((String)url).productNameAsUserAgent().tuner(new HttpRequests.ConnectionTuner(headers){
                final /* synthetic */ Map $headers;

                /*
                 * WARNING - void declaration
                 */
                public final void tune(@NotNull URLConnection tuner) {
                    Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
                    Map $this$forEach$iv = this.$headers;
                    boolean $i$f$forEach = false;
                    Map map = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void k;
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> $dstr$k$v = element$iv = iterator.next();
                        boolean bl2 = false;
                        Map.Entry<K, V> entry = $dstr$k$v;
                        boolean bl3 = false;
                        String string2 = (String)entry.getKey();
                        entry = $dstr$k$v;
                        bl3 = false;
                        String v = (String)entry.getValue();
                        tuner.addRequestProperty((String)k, v);
                    }
                }
                {
                    this.$headers = map;
                }
            }).accept("application/octet-stream, application/xz").throwStatusCodeException(true).connect(new HttpRequests.RequestProcessor(compression, targetFile, expectedSize, expectedSha256, indicator){
                final /* synthetic */ SharedIndexCompression $compression;
                final /* synthetic */ Path $targetFile;
                final /* synthetic */ long $expectedSize;
                final /* synthetic */ String $expectedSha256;
                final /* synthetic */ ProgressIndicator $indicator;

                public final void process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    InputStream inputStream = it.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it.inputStream");
                    DownloadUtilKt.access$decompressAndValidate(this.$compression, this.$targetFile, this.$expectedSize, this.$expectedSha256, this.$indicator, new CountingInputStream(inputStream));
                }
                {
                    this.$compression = sharedIndexCompression;
                    this.$targetFile = path;
                    this.$expectedSize = l;
                    this.$expectedSha256 = string2;
                    this.$indicator = progressIndicator;
                }
            });
            return Files.size(targetFile);
        }
        catch (Throwable e) {
            FileUtil.delete((Path)targetFile);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void decompressAndValidate(SharedIndexCompression compression, Path targetFile, long expectedSize, String expectedSha256, ProgressIndicator indicator, CountingInputStream countingStream) {
        Path path = targetFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"targetFile.parent");
        PathKt.createDirectories((Path)path);
        Closeable closeable = compression.createUnpackingStream(countingStream);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = PathKt.outputStream$default((Path)targetFile, (boolean)false, (int)1, null);
            int n = 0x100000;
            boolean bl4 = false;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
            n = 0;
            bl4 = false;
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output = (BufferedOutputStream)closeable2;
                boolean bl5 = false;
                byte[] buff = new byte[0x100000];
                while (true) {
                    indicator.checkCanceled();
                    int off = input.read(buff);
                    if (off < 0) break;
                    if (off <= 0) continue;
                    output.write(buff, 0, off);
                    if (countingStream.getBytesRead() > expectedSize) {
                        throw (Throwable)new RuntimeException("Connection is not closed at byte " + countingStream.getBytesRead() + ". Expected " + expectedSize + " bytes");
                    }
                    double d = 1.0;
                    double d2 = (double)countingStream.getBytesRead() / (double)expectedSize;
                    boolean bl6 = false;
                    indicator.setFraction(Math.min(d, d2));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (countingStream.getBytesRead() < expectedSize) {
            throw (Throwable)new RuntimeException("Connection closed at byte " + countingStream.getBytesRead() + ". Expected " + expectedSize + " bytes");
        }
        String string2 = countingStream.getHasher().hash().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"countingStream.hasher.hash().toString()");
        String actualHashCode = string2;
        if (!StringsKt.equals((String)actualHashCode, (String)expectedSha256, (boolean)true)) {
            throw (Throwable)new RuntimeException("SHA-256 checksums does not match. Actual value is " + actualHashCode + ", expected " + expectedSha256);
        }
    }

    public static final /* synthetic */ void access$decompressAndValidate(SharedIndexCompression compression, Path targetFile, long expectedSize, String expectedSha256, ProgressIndicator indicator, CountingInputStream countingStream) {
        DownloadUtilKt.decompressAndValidate(compression, targetFile, expectedSize, expectedSha256, indicator, countingStream);
    }
}

